/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common;

import java.util.EnumSet;
import java.util.HashSet;
import org.elasticsearch.common.Strings;

public class ParseField {
    private final String camelCaseName;
    private final String underscoreName;
    private final String[] deprecatedNames;
    private String allReplacedWith = null;
    static final EnumSet<Flag> EMPTY_FLAGS = EnumSet.noneOf(Flag.class);
    static final EnumSet<Flag> STRICT_FLAGS = EnumSet.of(Flag.STRICT);

    public ParseField(String value, String ... deprecatedNames) {
        this.camelCaseName = Strings.toCamelCase(value);
        this.underscoreName = Strings.toUnderscoreCase(value);
        if (deprecatedNames == null || deprecatedNames.length == 0) {
            this.deprecatedNames = Strings.EMPTY_ARRAY;
        } else {
            HashSet<String> set = new HashSet<String>();
            for (String depName : deprecatedNames) {
                set.add(Strings.toCamelCase(depName));
                set.add(Strings.toUnderscoreCase(depName));
            }
            this.deprecatedNames = set.toArray(new String[set.size()]);
        }
    }

    public String getPreferredName() {
        return this.underscoreName;
    }

    public String[] getAllNamesIncludedDeprecated() {
        String[] allNames = new String[2 + this.deprecatedNames.length];
        allNames[0] = this.camelCaseName;
        allNames[1] = this.underscoreName;
        for (int i = 0; i < this.deprecatedNames.length; ++i) {
            allNames[i + 2] = this.deprecatedNames[i];
        }
        return allNames;
    }

    public ParseField withDeprecation(String ... deprecatedNames) {
        return new ParseField(this.underscoreName, deprecatedNames);
    }

    public ParseField withAllDeprecated(String allReplacedWith) {
        ParseField parseField = this.withDeprecation(this.getAllNamesIncludedDeprecated());
        parseField.allReplacedWith = allReplacedWith;
        return parseField;
    }

    boolean match(String currentFieldName, EnumSet<Flag> flags) {
        if (this.allReplacedWith == null && (currentFieldName.equals(this.camelCaseName) || currentFieldName.equals(this.underscoreName))) {
            return true;
        }
        for (String depName : this.deprecatedNames) {
            if (!currentFieldName.equals(depName)) continue;
            if (flags.contains((Object)Flag.STRICT)) {
                String msg = "Deprecated field [" + currentFieldName + "] used, expected [" + this.underscoreName + "] instead";
                if (this.allReplacedWith != null) {
                    msg = "Deprecated field [" + currentFieldName + "] used, replaced by [" + this.allReplacedWith + "]";
                }
                throw new IllegalArgumentException(msg);
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getPreferredName();
    }

    static enum Flag {
        STRICT;

    }
}

