/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ngram.EdgeNGramTokenFilter;
import org.apache.lucene.analysis.ngram.Lucene43EdgeNGramTokenFilter;
import org.apache.lucene.analysis.reverse.ReverseStringFilter;
import org.elasticsearch.Version;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.settings.IndexSettingsService;

public class EdgeNGramTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final int minGram;
    private final int maxGram;
    public static final int SIDE_FRONT = 1;
    public static final int SIDE_BACK = 2;
    private final int side;
    private Version esVersion;

    @Inject
    public EdgeNGramTokenFilterFactory(Index index, IndexSettingsService indexSettingsService, @Assisted String name, @Assisted Settings settings) {
        this(index, indexSettingsService.getSettings(), name, settings);
    }

    EdgeNGramTokenFilterFactory(Index index, Settings indexSettings, String name, Settings settings) {
        super(index, indexSettings, name, settings);
        this.minGram = settings.getAsInt("min_gram", (Integer)1);
        this.maxGram = settings.getAsInt("max_gram", (Integer)2);
        this.side = EdgeNGramTokenFilterFactory.parseSide(settings.get("side", "front"));
        this.esVersion = Version.indexCreated(indexSettings);
    }

    static int parseSide(String side) {
        switch (side) {
            case "front": {
                return 1;
            }
            case "back": {
                return 2;
            }
        }
        throw new IllegalArgumentException("invalid side: " + side);
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        Object result = tokenStream;
        if (this.side == 2) {
            result = new ReverseStringFilter(result);
        }
        result = this.version.onOrAfter(org.apache.lucene.util.Version.LUCENE_4_3) && this.esVersion.onOrAfter(Version.V_0_90_2) ? new EdgeNGramTokenFilter(result, this.minGram, this.maxGram) : new Lucene43EdgeNGramTokenFilter(result, this.minGram, this.maxGram);
        if (this.side == 2) {
            result = new ReverseStringFilter(result);
        }
        return result;
    }
}

