/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.search.GeoPointInBBoxQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.geo.BaseGeoPointFieldMapper;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.search.geo.InMemoryGeoBoundingBoxQuery;
import org.elasticsearch.index.search.geo.IndexedGeoBoundingBoxQuery;

public class GeoBoundingBoxQueryParser
implements QueryParser {
    public static final String NAME = "geo_bbox";
    public static final String TOP = "top";
    public static final String LEFT = "left";
    public static final String RIGHT = "right";
    public static final String BOTTOM = "bottom";
    public static final String TOP_LEFT = "top_left";
    public static final String TOP_RIGHT = "top_right";
    public static final String BOTTOM_LEFT = "bottom_left";
    public static final String BOTTOM_RIGHT = "bottom_right";
    public static final String TOPLEFT = "topLeft";
    public static final String TOPRIGHT = "topRight";
    public static final String BOTTOMLEFT = "bottomLeft";
    public static final String BOTTOMRIGHT = "bottomRight";
    public static final String FIELD = "field";

    @Inject
    public GeoBoundingBoxQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, "geoBbox", "geo_bounding_box", "geoBoundingBox"};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        Query query;
        MappedFieldType fieldType;
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        String fieldName = null;
        double top = Double.NaN;
        double bottom = Double.NaN;
        double left = Double.NaN;
        double right = Double.NaN;
        String queryName = null;
        String currentFieldName = null;
        boolean indexCreatedBeforeV2_0 = parseContext.indexVersionCreated().before(Version.V_2_0_0);
        boolean coerce = false;
        boolean ignoreMalformed = false;
        GeoPoint sparse = new GeoPoint();
        String type = "memory";
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                fieldName = currentFieldName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        token = parser.nextToken();
                        if (parseContext.isDeprecatedSetting(currentFieldName)) continue;
                        if (FIELD.equals(currentFieldName)) {
                            fieldName = parser.text();
                            continue;
                        }
                        if (TOP.equals(currentFieldName)) {
                            top = parser.doubleValue();
                            continue;
                        }
                        if (BOTTOM.equals(currentFieldName)) {
                            bottom = parser.doubleValue();
                            continue;
                        }
                        if (LEFT.equals(currentFieldName)) {
                            left = parser.doubleValue();
                            continue;
                        }
                        if (RIGHT.equals(currentFieldName)) {
                            right = parser.doubleValue();
                            continue;
                        }
                        if (TOP_LEFT.equals(currentFieldName) || TOPLEFT.equals(currentFieldName)) {
                            GeoUtils.parseGeoPoint(parser, sparse);
                            top = sparse.getLat();
                            left = sparse.getLon();
                            continue;
                        }
                        if (BOTTOM_RIGHT.equals(currentFieldName) || BOTTOMRIGHT.equals(currentFieldName)) {
                            GeoUtils.parseGeoPoint(parser, sparse);
                            bottom = sparse.getLat();
                            right = sparse.getLon();
                            continue;
                        }
                        if (TOP_RIGHT.equals(currentFieldName) || TOPRIGHT.equals(currentFieldName)) {
                            GeoUtils.parseGeoPoint(parser, sparse);
                            top = sparse.getLat();
                            right = sparse.getLon();
                            continue;
                        }
                        if (BOTTOM_LEFT.equals(currentFieldName) || BOTTOMLEFT.equals(currentFieldName)) {
                            GeoUtils.parseGeoPoint(parser, sparse);
                            bottom = sparse.getLat();
                            left = sparse.getLon();
                            continue;
                        }
                        throw new ElasticsearchParseException("failed to parse [{}] query. unexpected field [{}]", NAME, currentFieldName);
                    }
                    throw new ElasticsearchParseException("failed to parse [{}] query. field name expected but [{}] found", new Object[]{NAME, token});
                }
                continue;
            }
            if (!token.isValue()) continue;
            if ("_name".equals(currentFieldName)) {
                queryName = parser.text();
                continue;
            }
            if ("coerce".equals(currentFieldName) || indexCreatedBeforeV2_0 && "normalize".equals(currentFieldName)) {
                coerce = parser.booleanValue();
                if (!coerce) continue;
                ignoreMalformed = true;
                continue;
            }
            if ("type".equals(currentFieldName)) {
                type = parser.text();
                continue;
            }
            if ("ignore_malformed".equals(currentFieldName) && !coerce) {
                ignoreMalformed = parser.booleanValue();
                continue;
            }
            throw new QueryParsingException(parseContext, "failed to parse [{}] query. unexpected field [{}]", NAME, currentFieldName);
        }
        GeoPoint topLeft = sparse.reset(top, left);
        GeoPoint bottomRight = new GeoPoint(bottom, right);
        if (!indexCreatedBeforeV2_0 && !ignoreMalformed) {
            if (topLeft.lat() > 90.0 || topLeft.lat() < -90.0) {
                throw new QueryParsingException(parseContext, "illegal latitude value [{}] for [{}]", topLeft.lat(), NAME);
            }
            if (topLeft.lon() > 180.0 || topLeft.lon() < -180.0) {
                throw new QueryParsingException(parseContext, "illegal longitude value [{}] for [{}]", topLeft.lon(), NAME);
            }
            if (bottomRight.lat() > 90.0 || bottomRight.lat() < -90.0) {
                throw new QueryParsingException(parseContext, "illegal latitude value [{}] for [{}]", bottomRight.lat(), NAME);
            }
            if (bottomRight.lon() > 180.0 || bottomRight.lon() < -180.0) {
                throw new QueryParsingException(parseContext, "illegal longitude value [{}] for [{}]", bottomRight.lon(), NAME);
            }
        }
        if (coerce) {
            boolean completeLonRange = (right - left) % 360.0 == 0.0 && right > left;
            GeoUtils.normalizePoint(topLeft, true, !completeLonRange);
            GeoUtils.normalizePoint(bottomRight, true, !completeLonRange);
            if (completeLonRange) {
                topLeft.resetLon(-180.0);
                bottomRight.resetLon(180.0);
            }
        }
        if ((fieldType = parseContext.fieldMapper(fieldName)) == null) {
            throw new QueryParsingException(parseContext, "failed to parse [{}] query. could not find [{}] field [{}]", NAME, "geo_point", fieldName);
        }
        if (!(fieldType instanceof BaseGeoPointFieldMapper.GeoPointFieldType)) {
            throw new QueryParsingException(parseContext, "failed to parse [{}] query. field [{}] is expected to be of type [{}], but is of [{}] type instead", NAME, fieldName, "geo_point", fieldType.typeName());
        }
        BaseGeoPointFieldMapper.GeoPointFieldType geoFieldType = (BaseGeoPointFieldMapper.GeoPointFieldType)fieldType;
        if (parseContext.indexVersionCreated().onOrAfter(Version.V_2_2_0)) {
            query = new GeoPointInBBoxQuery(fieldType.names().fullName(), topLeft.lon(), bottomRight.lat(), bottomRight.lon(), topLeft.lat());
        } else if ("indexed".equals(type)) {
            query = IndexedGeoBoundingBoxQuery.create(topLeft, bottomRight, geoFieldType);
        } else if ("memory".equals(type)) {
            IndexGeoPointFieldData indexFieldData = (IndexGeoPointFieldData)parseContext.getForField(fieldType);
            query = new InMemoryGeoBoundingBoxQuery(topLeft, bottomRight, indexFieldData);
        } else {
            throw new QueryParsingException(parseContext, "failed to parse [{}] query. geo bounding box type [{}] is not supported. either [indexed] or [memory] are allowed", NAME, type);
        }
        if (queryName != null) {
            parseContext.addNamedQuery(queryName, query);
        }
        return query;
    }
}

