/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.highlight;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.ExtensionPoint;
import org.elasticsearch.search.highlight.FastVectorHighlighter;
import org.elasticsearch.search.highlight.Highlighter;
import org.elasticsearch.search.highlight.PlainHighlighter;
import org.elasticsearch.search.highlight.PostingsHighlighter;

public class Highlighters
extends ExtensionPoint.ClassMap<Highlighter> {
    @Deprecated
    private static final String FAST_VECTOR_HIGHLIGHTER = "fast-vector-highlighter";
    private static final String FVH = "fvh";
    @Deprecated
    private static final String HIGHLIGHTER = "highlighter";
    private static final String PLAIN = "plain";
    @Deprecated
    private static final String POSTINGS_HIGHLIGHTER = "postings-highlighter";
    private static final String POSTINGS = "postings";
    private final Map<String, Highlighter> parsers;
    private final DeprecationLogger deprecationLogger = new DeprecationLogger(ESLoggerFactory.getLogger(Highlighters.class.getName()));

    public Highlighters() {
        this(Collections.EMPTY_MAP);
    }

    private Highlighters(Map<String, Highlighter> parsers) {
        super(HIGHLIGHTER, Highlighter.class, new HashSet<String>(Arrays.asList(FVH, FAST_VECTOR_HIGHLIGHTER, PLAIN, HIGHLIGHTER, POSTINGS, POSTINGS_HIGHLIGHTER)), Highlighters.class);
        this.parsers = Collections.unmodifiableMap(parsers);
    }

    @Inject
    public Highlighters(Settings settings, Map<String, Highlighter> parsers) {
        this(Highlighters.addBuiltIns(settings, parsers));
    }

    private static Map<String, Highlighter> addBuiltIns(Settings settings, Map<String, Highlighter> parsers) {
        HashMap<String, Highlighter> map = new HashMap<String, Highlighter>();
        map.put(FVH, new FastVectorHighlighter(settings));
        map.put(FAST_VECTOR_HIGHLIGHTER, (Highlighter)map.get(FVH));
        map.put(PLAIN, new PlainHighlighter());
        map.put(HIGHLIGHTER, (Highlighter)map.get(PLAIN));
        map.put(POSTINGS, new PostingsHighlighter());
        map.put(POSTINGS_HIGHLIGHTER, (Highlighter)map.get(POSTINGS));
        map.putAll(parsers);
        return map;
    }

    public Highlighter get(String type) {
        switch (type) {
            case "fast-vector-highlighter": {
                this.deprecationLogger.deprecated("highlighter key [{}] is deprecated and will be removed in 3.x use [{}] instead", FAST_VECTOR_HIGHLIGHTER, FVH);
                break;
            }
            case "highlighter": {
                this.deprecationLogger.deprecated("highlighter key [{}] is deprecated and will be removed in 3.x use [{}] instead", HIGHLIGHTER, PLAIN);
                break;
            }
            case "postings-highlighter": {
                this.deprecationLogger.deprecated("highlighter key [{}] is deprecated and will be removed in 3.x use [{}] instead", POSTINGS_HIGHLIGHTER, POSTINGS);
            }
        }
        return this.parsers.get(type);
    }
}

