/*
 * Decompiled with CFR 0.152.
 */
package com.github.mustachejava.jruby;

import com.github.mustachejava.TemplateFunction;
import com.github.mustachejava.reflect.Guard;
import com.github.mustachejava.reflect.ReflectionObjectHandler;
import com.github.mustachejava.util.Wrapper;
import java.lang.reflect.Method;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyHash;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubySymbol;
import org.jruby.embed.ScriptingContainer;

public class JRubyObjectHandler
extends ReflectionObjectHandler {
    private static final Method CALL_METHOD;
    private static ScriptingContainer sc;

    @Override
    public Object coerce(Object object) {
        if (object instanceof RubyBoolean) {
            RubyBoolean rb = (RubyBoolean)object;
            return rb.toJava(Boolean.class);
        }
        if (object instanceof RubyProc) {
            final RubyProc proc = (RubyProc)object;
            return new TemplateFunction(){

                public String apply(String s) {
                    TemplateFunction fun = (TemplateFunction)sc.getInstance((Object)proc, TemplateFunction.class);
                    return (String)fun.apply(s);
                }
            };
        }
        return object;
    }

    @Override
    protected Wrapper findWrapper(final int scopeIndex, Wrapper[] wrappers, List<Guard> guards, Object scope, final String name) {
        if (scope instanceof RubyHash) {
            RubyHash hash = (RubyHash)scope;
            final RubySymbol rs = RubySymbol.newSymbol((Ruby)hash.getRuntime(), (String)name);
            if (hash.containsKey((Object)rs)) {
                guards.add(new Guard(){

                    @Override
                    public boolean apply(Object[] input) {
                        return ((RubyHash)input[scopeIndex]).containsKey((Object)rs);
                    }
                });
                return this.createWrapper(scopeIndex, wrappers, guards, MAP_METHOD, new Object[]{rs});
            }
            guards.add(new Guard(){

                @Override
                public boolean apply(Object[] input) {
                    return !((RubyHash)input[scopeIndex]).containsKey((Object)rs);
                }
            });
        }
        if (scope instanceof RubyObject) {
            RubyObject ro = (RubyObject)scope;
            if (ro.respondsTo(name)) {
                guards.add(new Guard(){

                    @Override
                    public boolean apply(Object[] objects) {
                        RubyObject scope = (RubyObject)objects[scopeIndex];
                        return scope.respondsTo(name);
                    }
                });
                return this.createWrapper(scopeIndex, wrappers, guards, CALL_METHOD, new Object[]{name});
            }
            guards.add(new Guard(){

                @Override
                public boolean apply(Object[] objects) {
                    RubyObject scope = (RubyObject)objects[scopeIndex];
                    return !scope.respondsTo(name);
                }
            });
        }
        return super.findWrapper(scopeIndex, wrappers, guards, scope, name);
    }

    static {
        sc = new ScriptingContainer();
        try {
            CALL_METHOD = RubyHash.class.getMethod("callMethod", String.class);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }
}

