/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import org.apache.fop.area.LinkResolver;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.BasicLinkArea;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.InlineParent;
import org.apache.fop.datatypes.URISpecification;
import org.apache.fop.fo.flow.BasicLink;
import org.apache.fop.layoutmgr.PageSequenceLayoutManager;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.inline.InlineLayoutManager;

public class BasicLinkLayoutManager
extends InlineLayoutManager {
    public BasicLinkLayoutManager(BasicLink node) {
        super(node);
    }

    protected InlineArea createArea(boolean bInlineParent) {
        InlineArea area = super.createArea(bInlineParent);
        this.setupBasicLinkArea(area);
        return area;
    }

    private void setupBasicLinkArea(InlineArea area) {
        BasicLink fobj = (BasicLink)this.fobj;
        TraitSetter.addStructureTreeElement(area, fobj.getStructureTreeElement());
        if (fobj.hasInternalDestination()) {
            String idref = fobj.getInternalDestination();
            PageSequenceLayoutManager pslm = this.getPSLM();
            LinkResolver res = new LinkResolver(idref, area);
            res.resolveIDRef(idref, pslm.getFirstPVWithID(idref));
            if (!res.isResolved()) {
                pslm.addUnresolvedArea(idref, res);
                if (area instanceof BasicLinkArea) {
                    ((BasicLinkArea)area).setResolver(res);
                }
            }
        } else if (fobj.hasExternalDestination()) {
            boolean newWindow;
            String url = URISpecification.getURL(fobj.getExternalDestination());
            boolean bl = newWindow = fobj.getShowDestination() == 188;
            if (url.length() > 0) {
                area.addTrait(Trait.EXTERNAL_LINK, new Trait.ExternalLink(url, newWindow));
            }
        }
    }

    protected InlineParent createInlineParent() {
        return new BasicLinkArea();
    }
}

