/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.gradle.api.artifacts.Module;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;

public class DefaultModuleVersionIdentifier
implements ModuleVersionIdentifier {
    private final DefaultModuleIdentifier id;
    private final String version;

    public DefaultModuleVersionIdentifier(String group, String name, String version) {
        assert (group != null) : "group cannot be null";
        assert (name != null) : "name cannot be null";
        assert (version != null) : "version cannot be null";
        this.id = new DefaultModuleIdentifier(group, name);
        this.version = version;
    }

    public DefaultModuleVersionIdentifier(ModuleIdentifier id, String version) {
        this.id = new DefaultModuleIdentifier(id.getGroup(), id.getName());
        this.version = version;
    }

    public String getGroup() {
        return this.id.getGroup();
    }

    public String getName() {
        return this.id.getName();
    }

    public String getVersion() {
        return this.version;
    }

    public String toString() {
        String group = this.id.getGroup();
        String module = this.id.getName();
        StringBuilder builder = new StringBuilder(group.length() + module.length() + this.version.length() + 2);
        builder.append(group);
        builder.append(":");
        builder.append(module);
        builder.append(":");
        builder.append(this.version);
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DefaultModuleVersionIdentifier other = (DefaultModuleVersionIdentifier)obj;
        if (!this.id.equals(other.id)) {
            return false;
        }
        return this.version.equals(other.version);
    }

    public int hashCode() {
        return this.id.hashCode() ^ this.version.hashCode();
    }

    public ModuleIdentifier getModule() {
        return this.id;
    }

    public static ModuleVersionIdentifier newId(Module module) {
        return new DefaultModuleVersionIdentifier(module.getGroup(), module.getName(), module.getVersion());
    }

    public static ModuleVersionIdentifier newId(String group, String name, String version) {
        return new DefaultModuleVersionIdentifier(group, name, version);
    }

    public static ModuleVersionIdentifier newId(ModuleRevisionId moduleRevisionId) {
        return new DefaultModuleVersionIdentifier(moduleRevisionId.getOrganisation(), moduleRevisionId.getName(), moduleRevisionId.getRevision());
    }

    public static ModuleVersionIdentifier newId(ModuleComponentIdentifier componentId) {
        return new DefaultModuleVersionIdentifier(componentId.getGroup(), componentId.getModule(), componentId.getVersion());
    }
}

