/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import java.util.Collections;
import java.util.Map;
import org.gradle.api.Nullable;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.IvyArtifactName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultModuleComponentArtifactIdentifier
implements ModuleComponentArtifactIdentifier {
    private final ModuleComponentIdentifier componentIdentifier;
    private final IvyArtifactName name;

    public DefaultModuleComponentArtifactIdentifier(ModuleComponentIdentifier componentIdentifier, String name, String type, @Nullable String extension) {
        this(componentIdentifier, name, type, extension, Collections.emptyMap());
    }

    public DefaultModuleComponentArtifactIdentifier(ModuleComponentIdentifier componentIdentifier, String name, String type, @Nullable String extension, Map<String, String> attributes) {
        this(componentIdentifier, new DefaultIvyArtifactName(name, type, extension, attributes));
    }

    public DefaultModuleComponentArtifactIdentifier(ModuleComponentIdentifier componentIdentifier, IvyArtifactName artifact) {
        this.componentIdentifier = componentIdentifier;
        this.name = artifact;
    }

    public String getDisplayName() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.name.toString());
        builder.append(" (");
        builder.append(this.componentIdentifier.toString());
        builder.append(")");
        return builder.toString();
    }

    public IvyArtifactName getName() {
        return this.name;
    }

    @Override
    public ModuleComponentIdentifier getComponentIdentifier() {
        return this.componentIdentifier;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public int hashCode() {
        return this.componentIdentifier.hashCode() ^ this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DefaultModuleComponentArtifactIdentifier other = (DefaultModuleComponentArtifactIdentifier)obj;
        return other.componentIdentifier.equals(this.componentIdentifier) && other.name.equals(this.name);
    }
}

