/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.client;

import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.id.IdGenerator;
import org.gradle.launcher.daemon.protocol.Cancel;
import org.gradle.messaging.dispatch.Dispatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaemonCancelForwarder
implements Stoppable {
    private static final Logger LOGGER = Logging.getLogger(DaemonCancelForwarder.class);
    private final Runnable cancellationCallback;
    private final BuildCancellationToken cancellationToken;

    public DaemonCancelForwarder(final Dispatch<? super Cancel> dispatch, BuildCancellationToken cancellationToken, final IdGenerator<?> idGenerator) {
        this.cancellationToken = cancellationToken;
        this.cancellationCallback = new Runnable(){

            public void run() {
                LOGGER.info("Request daemon to cancel build...");
                dispatch.dispatch((Object)new Cancel(idGenerator.generateId()));
            }
        };
    }

    public void start() {
        this.cancellationToken.addCallback(this.cancellationCallback);
    }

    @Override
    public void stop() {
        this.cancellationToken.removeCallback(this.cancellationCallback);
    }
}

