/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.client;

import java.util.Collection;
import java.util.HashSet;
import org.gradle.api.GradleException;
import org.gradle.api.internal.specs.ExplainingSpec;
import org.gradle.api.internal.specs.ExplainingSpecs;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.id.IdGenerator;
import org.gradle.launcher.daemon.client.DaemonClient;
import org.gradle.launcher.daemon.client.DaemonClientConnection;
import org.gradle.launcher.daemon.client.DaemonConnector;
import org.gradle.launcher.daemon.client.StopDispatcher;
import org.gradle.launcher.daemon.context.DaemonContext;
import org.gradle.launcher.daemon.context.DaemonInstanceDetails;
import org.gradle.launcher.daemon.protocol.Stop;
import org.gradle.launcher.daemon.protocol.StopWhenIdle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaemonStopClient {
    private static final Logger LOGGER = Logging.getLogger(DaemonClient.class);
    private static final int STOP_TIMEOUT_SECONDS = 30;
    private final DaemonConnector connector;
    private final IdGenerator<?> idGenerator;
    private final ExplainingSpec<DaemonContext> compatibilitySpec = ExplainingSpecs.satisfyAll();
    private final StopDispatcher stopDispatcher;

    public DaemonStopClient(DaemonConnector connector, IdGenerator<?> idGenerator) {
        this.connector = connector;
        this.idGenerator = idGenerator;
        this.stopDispatcher = new StopDispatcher();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gracefulStop(Collection<DaemonInstanceDetails> daemons) {
        for (DaemonInstanceDetails daemon : daemons) {
            DaemonClientConnection connection = this.connector.maybeConnect(daemon);
            if (connection == null) continue;
            try {
                LOGGER.debug("Requesting daemon {} stop when idle", daemon);
                this.stopDispatcher.dispatch(connection, new StopWhenIdle(this.idGenerator.generateId()));
                LOGGER.lifecycle("Gradle daemon stopped.");
            }
            finally {
                connection.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        long start = System.currentTimeMillis();
        long expiry = start + 30000L;
        HashSet<String> stopped = new HashSet<String>();
        DaemonClientConnection connection = this.connector.maybeConnect(this.compatibilitySpec);
        if (connection == null) {
            LOGGER.lifecycle("No Gradle daemons are running.");
            return;
        }
        LOGGER.lifecycle("Stopping daemon(s).");
        while (connection != null && System.currentTimeMillis() < expiry) {
            try {
                if (stopped.add(connection.getDaemon().getUid())) {
                    LOGGER.debug("Requesting daemon {} stop now", connection.getDaemon());
                    this.stopDispatcher.dispatch(connection, new Stop(this.idGenerator.generateId()));
                    LOGGER.lifecycle("Gradle daemon stopped.");
                }
            }
            finally {
                connection.stop();
            }
            connection = this.connector.maybeConnect(this.compatibilitySpec);
        }
        if (connection != null) {
            throw new GradleException(String.format("Timeout waiting for all daemons to stop. Waited %s seconds.", (System.currentTimeMillis() - start) / 1000L));
        }
    }
}

