/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.format.parser;

import com.oracle.truffle.api.nodes.Node;
import java.nio.ByteOrder;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.jruby.truffle.format.nodes.PackNode;
import org.jruby.truffle.format.nodes.SourceNode;
import org.jruby.truffle.format.nodes.control.AtNode;
import org.jruby.truffle.format.nodes.control.BackNode;
import org.jruby.truffle.format.nodes.control.NNode;
import org.jruby.truffle.format.nodes.control.SequenceNode;
import org.jruby.truffle.format.nodes.control.StarNode;
import org.jruby.truffle.format.nodes.read.ReadDoubleNodeGen;
import org.jruby.truffle.format.nodes.read.ReadLongOrBigIntegerNodeGen;
import org.jruby.truffle.format.nodes.read.ReadStringNodeGen;
import org.jruby.truffle.format.nodes.read.ReadValueNodeGen;
import org.jruby.truffle.format.nodes.type.AsSinglePrecisionNodeGen;
import org.jruby.truffle.format.nodes.type.ReinterpretLongNodeGen;
import org.jruby.truffle.format.nodes.type.ToLongNode;
import org.jruby.truffle.format.nodes.type.ToLongNodeGen;
import org.jruby.truffle.format.nodes.write.PNode;
import org.jruby.truffle.format.nodes.write.Write16BigNodeGen;
import org.jruby.truffle.format.nodes.write.Write16LittleNodeGen;
import org.jruby.truffle.format.nodes.write.Write32BigNodeGen;
import org.jruby.truffle.format.nodes.write.Write32LittleNodeGen;
import org.jruby.truffle.format.nodes.write.Write64BigNodeGen;
import org.jruby.truffle.format.nodes.write.Write64LittleNodeGen;
import org.jruby.truffle.format.nodes.write.Write8NodeGen;
import org.jruby.truffle.format.nodes.write.WriteBERNodeGen;
import org.jruby.truffle.format.nodes.write.WriteBase64StringNodeGen;
import org.jruby.truffle.format.nodes.write.WriteBinaryStringNodeGen;
import org.jruby.truffle.format.nodes.write.WriteBitStringNodeGen;
import org.jruby.truffle.format.nodes.write.WriteByteNode;
import org.jruby.truffle.format.nodes.write.WriteHexStringNodeGen;
import org.jruby.truffle.format.nodes.write.WriteMIMEStringNodeGen;
import org.jruby.truffle.format.nodes.write.WriteUTF8CharacterNodeGen;
import org.jruby.truffle.format.nodes.write.WriteUUStringNodeGen;
import org.jruby.truffle.format.parser.PackBaseListener;
import org.jruby.truffle.format.parser.PackParser;
import org.jruby.truffle.format.runtime.PackEncoding;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;

public class PackTreeBuilder
extends PackBaseListener {
    private final RubyContext context;
    private final Node currentNode;
    private PackEncoding encoding = PackEncoding.DEFAULT;
    private final Deque<List<PackNode>> sequenceStack = new ArrayDeque<List<PackNode>>();

    public PackTreeBuilder(RubyContext context, Node currentNode) {
        this.context = context;
        this.currentNode = currentNode;
        this.pushSequence();
    }

    @Override
    public void enterSequence(PackParser.SequenceContext ctx) {
        this.pushSequence();
    }

    @Override
    public void exitSequence(PackParser.SequenceContext ctx) {
        List<PackNode> sequence = this.sequenceStack.pop();
        this.appendNode(new SequenceNode(this.context, sequence.toArray(new PackNode[sequence.size()])));
    }

    @Override
    public void exitInt8(PackParser.Int8Context ctx) {
        this.integer(8, null, ctx.count());
    }

    @Override
    public void exitUint8(PackParser.Uint8Context ctx) {
        this.integer(8, null, ctx.count());
    }

    @Override
    public void exitInt16Little(PackParser.Int16LittleContext ctx) {
        this.integer(16, ByteOrder.LITTLE_ENDIAN, ctx.count());
    }

    @Override
    public void exitInt16Big(PackParser.Int16BigContext ctx) {
        this.integer(16, ByteOrder.BIG_ENDIAN, ctx.count());
    }

    @Override
    public void exitInt16Native(PackParser.Int16NativeContext ctx) {
        this.integer(16, ByteOrder.nativeOrder(), ctx.count());
    }

    @Override
    public void exitUint16Little(PackParser.Uint16LittleContext ctx) {
        this.integer(16, ByteOrder.LITTLE_ENDIAN, ctx.count());
    }

    @Override
    public void exitUint16Big(PackParser.Uint16BigContext ctx) {
        this.integer(16, ByteOrder.BIG_ENDIAN, ctx.count());
    }

    @Override
    public void exitUint16Native(PackParser.Uint16NativeContext ctx) {
        this.integer(16, ByteOrder.nativeOrder(), ctx.count());
    }

    @Override
    public void exitInt32Little(PackParser.Int32LittleContext ctx) {
        this.integer(32, ByteOrder.LITTLE_ENDIAN, ctx.count());
    }

    @Override
    public void exitInt32Big(PackParser.Int32BigContext ctx) {
        this.integer(32, ByteOrder.BIG_ENDIAN, ctx.count());
    }

    @Override
    public void exitInt32Native(PackParser.Int32NativeContext ctx) {
        this.integer(32, ByteOrder.nativeOrder(), ctx.count());
    }

    @Override
    public void exitUint32Little(PackParser.Uint32LittleContext ctx) {
        this.integer(32, ByteOrder.LITTLE_ENDIAN, ctx.count());
    }

    @Override
    public void exitUint32Big(PackParser.Uint32BigContext ctx) {
        this.integer(32, ByteOrder.BIG_ENDIAN, ctx.count());
    }

    @Override
    public void exitUint32Native(PackParser.Uint32NativeContext ctx) {
        this.integer(32, ByteOrder.nativeOrder(), ctx.count());
    }

    @Override
    public void exitInt64Little(PackParser.Int64LittleContext ctx) {
        this.integer(64, ByteOrder.LITTLE_ENDIAN, ctx.count());
    }

    @Override
    public void exitInt64Big(PackParser.Int64BigContext ctx) {
        this.integer(64, ByteOrder.BIG_ENDIAN, ctx.count());
    }

    @Override
    public void exitInt64Native(PackParser.Int64NativeContext ctx) {
        this.integer(64, ByteOrder.nativeOrder(), ctx.count());
    }

    @Override
    public void exitUint64Little(PackParser.Uint64LittleContext ctx) {
        this.integer(64, ByteOrder.LITTLE_ENDIAN, ctx.count());
    }

    @Override
    public void exitUint64Big(PackParser.Uint64BigContext ctx) {
        this.integer(64, ByteOrder.BIG_ENDIAN, ctx.count());
    }

    @Override
    public void exitUint64Native(PackParser.Uint64NativeContext ctx) {
        this.integer(64, ByteOrder.nativeOrder(), ctx.count());
    }

    public void integer(int size, ByteOrder byteOrder, PackParser.CountContext count) {
        this.appendNode(this.applyCount(count, this.writeInteger(size, byteOrder)));
    }

    @Override
    public void exitUtf8Character(PackParser.Utf8CharacterContext ctx) {
        this.unify(PackEncoding.UTF_8);
        this.appendNode(this.applyCount(ctx.count(), WriteUTF8CharacterNodeGen.create(this.context, ToLongNodeGen.create(this.context, ReadValueNodeGen.create(this.context, new SourceNode())))));
    }

    @Override
    public void exitBerInteger(PackParser.BerIntegerContext ctx) {
        this.appendNode(this.applyCount(ctx.count(), WriteBERNodeGen.create(this.context, ReadLongOrBigIntegerNodeGen.create(this.context, new SourceNode()))));
    }

    @Override
    public void exitF64Native(PackParser.F64NativeContext ctx) {
        this.appendNode(this.applyCount(ctx.count(), this.writeInteger(64, ByteOrder.nativeOrder(), ReinterpretLongNodeGen.create(this.context, ReadDoubleNodeGen.create(this.context, new SourceNode())))));
    }

    @Override
    public void exitF32Native(PackParser.F32NativeContext ctx) {
        this.appendNode(this.applyCount(ctx.count(), this.writeInteger(32, ByteOrder.nativeOrder(), ReinterpretLongNodeGen.create(this.context, AsSinglePrecisionNodeGen.create(this.context, ReadDoubleNodeGen.create(this.context, new SourceNode()))))));
    }

    @Override
    public void exitF64Little(PackParser.F64LittleContext ctx) {
        this.appendNode(this.applyCount(ctx.count(), this.writeInteger(64, ByteOrder.LITTLE_ENDIAN, ReinterpretLongNodeGen.create(this.context, ReadDoubleNodeGen.create(this.context, new SourceNode())))));
    }

    @Override
    public void exitF32Little(PackParser.F32LittleContext ctx) {
        this.appendNode(this.applyCount(ctx.count(), this.writeInteger(32, ByteOrder.LITTLE_ENDIAN, ReinterpretLongNodeGen.create(this.context, AsSinglePrecisionNodeGen.create(this.context, ReadDoubleNodeGen.create(this.context, new SourceNode()))))));
    }

    @Override
    public void exitF64Big(PackParser.F64BigContext ctx) {
        this.appendNode(this.applyCount(ctx.count(), this.writeInteger(64, ByteOrder.BIG_ENDIAN, ReinterpretLongNodeGen.create(this.context, ReadDoubleNodeGen.create(this.context, new SourceNode())))));
    }

    @Override
    public void exitF32Big(PackParser.F32BigContext ctx) {
        this.appendNode(this.applyCount(ctx.count(), this.writeInteger(32, ByteOrder.BIG_ENDIAN, ReinterpretLongNodeGen.create(this.context, AsSinglePrecisionNodeGen.create(this.context, ReadDoubleNodeGen.create(this.context, new SourceNode()))))));
    }

    @Override
    public void exitBinaryStringSpacePadded(PackParser.BinaryStringSpacePaddedContext ctx) {
        this.binaryString((byte)32, true, false, ctx.count());
    }

    @Override
    public void exitBinaryStringNullPadded(PackParser.BinaryStringNullPaddedContext ctx) {
        this.binaryString((byte)0, true, false, ctx.count());
    }

    @Override
    public void exitBinaryStringNullStar(PackParser.BinaryStringNullStarContext ctx) {
        this.binaryString((byte)0, true, ctx.count() != null && ctx.count().INT() == null, ctx.count());
    }

    @Override
    public void exitBitStringMSBFirst(PackParser.BitStringMSBFirstContext ctx) {
        this.bitString(ByteOrder.BIG_ENDIAN, ctx.count());
    }

    @Override
    public void exitBitStringMSBLast(PackParser.BitStringMSBLastContext ctx) {
        this.bitString(ByteOrder.LITTLE_ENDIAN, ctx.count());
    }

    @Override
    public void exitHexStringHighFirst(PackParser.HexStringHighFirstContext ctx) {
        this.hexString(ByteOrder.BIG_ENDIAN, ctx.count());
    }

    @Override
    public void exitHexStringLowFirst(PackParser.HexStringLowFirstContext ctx) {
        this.hexString(ByteOrder.LITTLE_ENDIAN, ctx.count());
    }

    @Override
    public void exitUuString(PackParser.UuStringContext ctx) {
        boolean ignoreStar;
        int length;
        this.unify(PackEncoding.US_ASCII);
        if (ctx.count() == null) {
            length = 1;
            ignoreStar = false;
        } else if (ctx.count().INT() == null) {
            length = 0;
            ignoreStar = true;
        } else {
            length = Integer.parseInt(ctx.count().INT().getText());
            ignoreStar = false;
        }
        this.appendNode(WriteUUStringNodeGen.create(this.context, length, ignoreStar, ReadStringNodeGen.create(this.context, false, "to_str", false, this.context.getCoreLibrary().getNilObject(), new SourceNode())));
    }

    @Override
    public void exitMimeString(PackParser.MimeStringContext ctx) {
        int length;
        this.unify(PackEncoding.US_ASCII);
        if (ctx.count() == null || ctx.count().INT() == null) {
            length = 72;
        } else {
            length = Integer.parseInt(ctx.count().INT().getText());
            if (length <= 1) {
                length = 72;
            }
        }
        this.appendNode(WriteMIMEStringNodeGen.create(this.context, length, ReadStringNodeGen.create(this.context, true, "to_s", true, this.context.getCoreLibrary().getNilObject(), new SourceNode())));
    }

    @Override
    public void exitBase64String(PackParser.Base64StringContext ctx) {
        boolean ignoreStar;
        int length;
        this.unify(PackEncoding.US_ASCII);
        if (ctx.count() == null) {
            length = 1;
            ignoreStar = false;
        } else if (ctx.count().INT() == null) {
            length = 0;
            ignoreStar = true;
        } else {
            length = Integer.parseInt(ctx.count().INT().getText());
            ignoreStar = false;
        }
        this.appendNode(WriteBase64StringNodeGen.create(this.context, length, ignoreStar, ReadStringNodeGen.create(this.context, false, "to_str", false, this.context.getCoreLibrary().getNilObject(), new SourceNode())));
    }

    @Override
    public void exitPointer(PackParser.PointerContext ctx) {
        this.appendNode(this.writeInteger(64, ByteOrder.nativeOrder(), new PNode(this.context)));
    }

    @Override
    public void exitAt(PackParser.AtContext ctx) {
        int position;
        if (ctx.count() == null) {
            position = 1;
        } else {
            if (ctx.count() != null && ctx.count().INT() == null) {
                throw new UnsupportedOperationException();
            }
            position = Integer.parseInt(ctx.count().INT().getText());
        }
        this.appendNode(new AtNode(this.context, position));
    }

    @Override
    public void exitBack(PackParser.BackContext ctx) {
        if (ctx.count() == null || ctx.count().INT() != null) {
            this.appendNode(this.applyCount(ctx.count(), new BackNode(this.context)));
        }
    }

    @Override
    public void exitNullByte(PackParser.NullByteContext ctx) {
        this.appendNode(this.applyCount(ctx.count(), new WriteByteNode(this.context, 0)));
    }

    @Override
    public void enterSubSequence(PackParser.SubSequenceContext ctx) {
        this.pushSequence();
    }

    @Override
    public void exitSubSequence(PackParser.SubSequenceContext ctx) {
        List<PackNode> sequence = this.sequenceStack.pop();
        SequenceNode sequenceNode = new SequenceNode(this.context, sequence.toArray(new PackNode[sequence.size()]));
        PackNode resultingNode = ctx.INT() == null ? sequenceNode : new NNode(this.context, Integer.parseInt(ctx.INT().getText()), sequenceNode);
        this.appendNode(resultingNode);
    }

    @Override
    public void exitErrorDisallowedNative(PackParser.ErrorDisallowedNativeContext ctx) {
        throw new RaiseException(this.context.getCoreLibrary().argumentError("'" + ctx.NATIVE().getText() + "' allowed only after types sSiIlLqQ", this.currentNode));
    }

    public PackNode getNode() {
        return this.sequenceStack.peek().get(0);
    }

    public PackEncoding getEncoding() {
        return this.encoding;
    }

    private void pushSequence() {
        this.sequenceStack.push(new ArrayList());
    }

    private void appendNode(PackNode node) {
        this.sequenceStack.peek().add(node);
    }

    private PackNode writeInteger(int size, ByteOrder byteOrder) {
        ToLongNode readNode = ToLongNodeGen.create(this.context, ReadValueNodeGen.create(this.context, new SourceNode()));
        return this.writeInteger(size, byteOrder, readNode);
    }

    private PackNode writeInteger(int size, ByteOrder byteOrder, PackNode readNode) {
        switch (size) {
            case 8: {
                return Write8NodeGen.create(this.context, readNode);
            }
            case 16: {
                if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    return Write16LittleNodeGen.create(this.context, readNode);
                }
                return Write16BigNodeGen.create(this.context, readNode);
            }
            case 32: {
                if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    return Write32LittleNodeGen.create(this.context, readNode);
                }
                return Write32BigNodeGen.create(this.context, readNode);
            }
            case 64: {
                if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    return Write64LittleNodeGen.create(this.context, readNode);
                }
                return Write64BigNodeGen.create(this.context, readNode);
            }
        }
        throw new UnsupportedOperationException();
    }

    private void binaryString(byte padding, boolean padOnNull, boolean appendNull, PackParser.CountContext count) {
        int width;
        boolean pad;
        this.unify(PackEncoding.ASCII_8BIT);
        if (count != null && count.INT() != null) {
            pad = true;
            width = Integer.parseInt(count.INT().getText());
        } else {
            pad = false;
            if (count != null && count.INT() == null) {
                padOnNull = false;
            }
            width = 1;
        }
        boolean takeAll = count != null && count.INT() == null;
        this.appendNode(WriteBinaryStringNodeGen.create(this.context, pad, padOnNull, width, padding, takeAll, appendNull, ReadStringNodeGen.create(this.context, true, "to_str", false, this.context.getCoreLibrary().getNilObject(), new SourceNode())));
    }

    private void bitString(ByteOrder byteOrder, PackParser.CountContext ctx) {
        int length;
        boolean star;
        if (ctx == null) {
            star = false;
            length = 1;
        } else if (ctx.INT() == null) {
            star = true;
            length = 0;
        } else {
            star = false;
            length = Integer.parseInt(ctx.INT().getText());
        }
        this.appendNode(WriteBitStringNodeGen.create(this.context, byteOrder, star, length, ReadStringNodeGen.create(this.context, true, "to_str", false, this.context.getCoreLibrary().getNilObject(), new SourceNode())));
    }

    private void hexString(ByteOrder byteOrder, PackParser.CountContext ctx) {
        int length = ctx == null ? 1 : (ctx.INT() == null ? -1 : Integer.parseInt(ctx.INT().getText()));
        this.appendNode(WriteHexStringNodeGen.create(this.context, byteOrder, length, ReadStringNodeGen.create(this.context, true, "to_str", false, this.context.getCoreLibrary().getNilObject(), new SourceNode())));
    }

    private PackNode applyCount(PackParser.CountContext count, PackNode node) {
        if (count == null) {
            return node;
        }
        if (count.INT() != null) {
            return new NNode(this.context, Integer.parseInt(count.INT().getText()), node);
        }
        return new StarNode(this.context, node);
    }

    private void unify(PackEncoding other) {
        this.encoding = this.encoding.unifyWith(other);
    }
}

