/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.execution;

import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ServerInstanceChooserPanel
extends JPanel {
    private JComboBox jCBServer;
    private JLabel jLabelTitle;

    public ServerInstanceChooserPanel(String[] serverInstances) {
        this.initComponents();
        for (String serverInstanceID : serverInstances) {
            try {
                this.jCBServer.addItem(new ServerInstanceItem(serverInstanceID));
            }
            catch (InstanceRemovedException ex) {
                // empty catch block
            }
        }
    }

    public String getChosenServerInstance() {
        return ((ServerInstanceItem)this.jCBServer.getSelectedItem()).instanceID;
    }

    private void initComponents() {
        this.jCBServer = new JComboBox();
        this.jLabelTitle = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.jLabelTitle, (String)NbBundle.getMessage(ServerInstanceChooserPanel.class, (String)"ServerInstanceChooserPanel.jLabelTitle.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelTitle, -1, 376, Short.MAX_VALUE).addComponent(this.jCBServer, 0, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabelTitle).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCBServer, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private static class ServerInstanceItem
    implements Comparable<ServerInstanceItem> {
        private final String instanceID;
        private final String displayName;

        public ServerInstanceItem(String instanceID) throws InstanceRemovedException {
            this.instanceID = instanceID;
            this.displayName = Deployment.getDefault().getServerInstance(instanceID).getDisplayName();
        }

        public String toString() {
            return this.displayName;
        }

        @Override
        public int compareTo(ServerInstanceItem o) {
            return this.displayName.compareTo(o.displayName);
        }
    }
}

