/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax.gsf;

import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.jsp.lexer.JspTokenId;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.csl.api.KeystrokeHandler;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.modules.web.indent.api.LexUtilities;

public class JspKeystrokeHandler
implements KeystrokeHandler {
    public boolean beforeCharInserted(Document doc, int caretOffset, JTextComponent target, char ch) throws BadLocationException {
        Token token;
        if ('}' != ch) {
            return false;
        }
        TokenSequence ts = LexUtilities.getTokenSequence((BaseDocument)((BaseDocument)doc), (int)caretOffset, (Language)JspTokenId.language());
        if (ts == null) {
            return false;
        }
        ts.move(caretOffset);
        if (!ts.moveNext() && !ts.movePrevious()) {
            return false;
        }
        while ((token = ts.token()).id() != JspTokenId.EOL) {
            if (token.id() == JspTokenId.EL) {
                String elText = CharSequenceUtilities.toString((CharSequence)token.text());
                TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)doc);
                int offset = token.offset(tokenHierarchy) + token.length();
                if (elText.matches("(\\$\\{|\\#\\{).*") && offset > caretOffset) {
                    Caret caret = target.getCaret();
                    caret.setDot(caretOffset + 1);
                    return true;
                }
            }
            if (ts.movePrevious()) continue;
        }
        return false;
    }

    public boolean afterCharInserted(Document doc, int caretOffset, JTextComponent target, char ch) throws BadLocationException {
        final BaseDocument bdoc = (BaseDocument)doc;
        if ('>' != ch) {
            return false;
        }
        TokenSequence ts = LexUtilities.getTokenSequence((BaseDocument)((BaseDocument)doc), (int)caretOffset, (Language)JspTokenId.language());
        if (ts == null) {
            return false;
        }
        ts.move(caretOffset);
        boolean found = false;
        while (ts.movePrevious()) {
            if (ts.token().id() == JspTokenId.SYMBOL && (ts.token().text().toString().equals("<") || ts.token().text().toString().equals("</"))) {
                found = true;
                break;
            }
            if ((ts.token().id() != JspTokenId.SYMBOL || !ts.token().text().toString().equals(">")) && (ts.token().id() == JspTokenId.ATTRIBUTE || ts.token().id() == JspTokenId.ATTR_VALUE || ts.token().id() == JspTokenId.TAG || ts.token().id() == JspTokenId.ENDTAG || ts.token().id() == JspTokenId.SYMBOL || ts.token().id() == JspTokenId.EOL || ts.token().id() == JspTokenId.WHITESPACE)) continue;
        }
        if (found) {
            final Position from = doc.createPosition(Utilities.getRowStart((BaseDocument)bdoc, (int)ts.offset()));
            final Position to = doc.createPosition(Utilities.getRowEnd((BaseDocument)bdoc, (int)ts.offset()));
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    final Indent indent = Indent.get((Document)bdoc);
                    indent.lock();
                    try {
                        bdoc.runAtomic(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    indent.reindent(from.getOffset(), to.getOffset());
                                }
                                catch (BadLocationException badLocationException) {
                                    // empty catch block
                                }
                            }
                        });
                    }
                    finally {
                        indent.unlock();
                    }
                }
            });
        }
        return false;
    }

    public boolean charBackspaced(Document doc, int caretOffset, JTextComponent target, char ch) throws BadLocationException {
        return false;
    }

    public int beforeBreak(Document doc, int caretOffset, JTextComponent target) throws BadLocationException {
        TokenSequence ts = LexUtilities.getTokenSequence((BaseDocument)((BaseDocument)doc), (int)caretOffset, (Language)JspTokenId.language());
        if (ts == null) {
            return -1;
        }
        ts.move(caretOffset);
        String closingTagName = null;
        int end = -1;
        if (ts.moveNext() && ts.token().id() == JspTokenId.SYMBOL && ts.token().text().toString().equals("</") && ts.moveNext() && ts.token().id() == JspTokenId.ENDTAG) {
            closingTagName = ts.token().text().toString();
            end = ts.offset() + ts.token().text().length();
            ts.movePrevious();
            ts.movePrevious();
        }
        if (closingTagName == null) {
            return -1;
        }
        boolean foundOpening = false;
        if (ts.token().id() == JspTokenId.SYMBOL && ts.token().text().toString().equals(">")) {
            while (ts.movePrevious()) {
                if (ts.token().id() != JspTokenId.TAG) continue;
                if (!ts.token().text().toString().equals(closingTagName)) break;
                foundOpening = true;
                break;
            }
        }
        if (foundOpening) {
            Indent indent = Indent.get((Document)doc);
            doc.insertString(caretOffset, "\n", null);
            target.getCaret().setDot(caretOffset);
            indent.reindent(caretOffset + 1, end);
        }
        return -1;
    }

    public OffsetRange findMatching(Document doc, int caretOffset) {
        return OffsetRange.NONE;
    }

    public List<OffsetRange> findLogicalRanges(ParserResult info, int caretOffset) {
        return new ArrayList<OffsetRange>();
    }

    public int getNextWordOffset(Document doc, int caretOffset, boolean reverse) {
        return -1;
    }
}

