/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.phing;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.modules.php.phing.Bundle;
import org.netbeans.modules.php.phing.exec.PhingExecutable;
import org.netbeans.modules.php.phing.file.BuildXml;
import org.netbeans.modules.php.phing.file.PhingTargets;
import org.netbeans.modules.php.phing.preferences.PhingPreferences;
import org.netbeans.modules.php.phing.util.PhingUtils;
import org.netbeans.modules.web.clientproject.spi.build.BuildToolImplementation;
import org.netbeans.spi.project.ui.CustomizerProvider2;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public final class PhingBuildTool
implements BuildToolImplementation {
    private static final Logger LOGGER = Logger.getLogger(PhingBuildTool.class.getName());
    public static final String IDENTIFIER = "Phing";
    private final Project project;
    private final BuildXml buildXml;
    private final PhingTargets phingTargets;
    private final PhingPreferences phingPreferences;

    public PhingBuildTool(Project project) {
        assert (project != null);
        this.project = project;
        this.buildXml = new BuildXml(project.getProjectDirectory());
        this.phingTargets = PhingTargets.create(project, this.buildXml);
        this.phingPreferences = new PhingPreferences(project);
    }

    @NonNull
    public static PhingBuildTool forProject(Project project) {
        PhingBuildTool buildTool = PhingBuildTool.inProject(project);
        assert (buildTool != null) : "PhingBuildTool should be found in project " + project.getClass().getName() + " (lookup: " + project.getLookup() + ")";
        return buildTool;
    }

    @CheckForNull
    public static PhingBuildTool inProject(Project project) {
        assert (project != null);
        return (PhingBuildTool)project.getLookup().lookup(PhingBuildTool.class);
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public String getDisplayName() {
        return Bundle.PhingBuildTool_name();
    }

    public BuildXml getBuildXml() {
        return this.buildXml;
    }

    public PhingTargets getPhingTargets() {
        return this.phingTargets;
    }

    public PhingPreferences getPhingPreferences() {
        return this.phingPreferences;
    }

    public boolean isEnabled() {
        return this.buildXml.exists();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean run(String commandId, boolean waitFinished, boolean warnUser) {
        assert (this.isEnabled()) : this.project.getProjectDirectory().getNameExt();
        assert (this.buildXml.exists()) : this.project.getProjectDirectory().getNameExt();
        String phingBuild = this.phingPreferences.getTarget(commandId);
        if (phingBuild != null) {
            PhingExecutable phing = PhingExecutable.getDefault(this.project, warnUser);
            if (phing == null) return true;
            PhingUtils.logUsagePhingBuild();
            Future<Integer> result = phing.run(phingBuild.split(" "));
            if (!waitFinished) return true;
            try {
                result.get();
                return true;
            }
            catch (InterruptedException ex) {
                LOGGER.log(Level.INFO, null, ex);
                return true;
            }
            catch (CancellationException ex) {
                LOGGER.log(Level.FINE, null, ex);
                return true;
            }
            catch (ExecutionException ex) {
                LOGGER.log(Level.INFO, null, ex);
                if (!warnUser) return true;
            }
            return true;
        } else {
            Object option;
            if (!warnUser || (option = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)Bundle.PhingBuildTool_configure(), 0))) != NotifyDescriptor.YES_OPTION) return true;
            ((CustomizerProvider2)this.project.getLookup().lookup(CustomizerProvider2.class)).showCustomizer(IDENTIFIER, null);
        }
        return true;
    }
}

