/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.javascript.debugger.annotation;

import java.util.concurrent.CancellationException;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.javascript2.debug.tooltip.AbstractJSToolTipAnnotation;
import org.netbeans.modules.web.javascript.debugger.annotation.Bundle;
import org.netbeans.modules.web.javascript.debugger.annotation.WebJSDebuggerTooltipSupport;
import org.netbeans.modules.web.javascript.debugger.eval.Evaluator;
import org.netbeans.modules.web.javascript.debugger.locals.VariablesModel;
import org.netbeans.modules.web.webkit.debugging.api.Debugger;
import org.netbeans.modules.web.webkit.debugging.api.debugger.CallFrame;
import org.netbeans.modules.web.webkit.debugging.api.debugger.RemoteObject;
import org.openide.util.Pair;

public class ToolTipAnnotation
extends AbstractJSToolTipAnnotation<WebJSDebuggerTooltipSupport> {
    protected WebJSDebuggerTooltipSupport getEngineDebugger(Session session, DebuggerEngine engine) {
        Debugger d = (Debugger)engine.lookupFirst(null, Debugger.class);
        if (d == null || !d.isSuspended()) {
            return null;
        }
        CallFrame currentCallFrame = d.getCurrentCallFrame();
        return new WebJSDebuggerTooltipSupport(d, currentCallFrame);
    }

    protected Pair<String, Object> evaluate(String expression, DebuggerEngine engine, WebJSDebuggerTooltipSupport dbg) throws CancellationException {
        String tooltipText;
        VariablesModel.ScopedRemoteObject sv = Evaluator.evaluateExpression(dbg.getFrame(), expression, true);
        VariablesModel.ScopedRemoteObject tooltipVariable = null;
        if (sv != null) {
            RemoteObject var = sv.getRemoteObject();
            String value = var.getValueAsString();
            RemoteObject.Type type = var.getType();
            switch (type) {
                case STRING: {
                    value = "\"" + value + "\"";
                    break;
                }
                case FUNCTION: {
                    value = var.getDescription();
                    break;
                }
                case OBJECT: {
                    String clazz = var.getClassName();
                    if (clazz == null) {
                        clazz = type.getName();
                    }
                    if (value.isEmpty()) {
                        value = var.getDescription();
                    }
                    value = "(" + clazz + ") " + value;
                    tooltipVariable = sv;
                }
            }
            if (type != RemoteObject.Type.UNDEFINED) {
                tooltipText = expression + " = " + value;
            } else {
                tooltipText = var.getDescription();
                if (tooltipText == null) {
                    tooltipText = Bundle.var_undefined(expression);
                }
            }
        } else {
            throw new CancellationException();
        }
        return Pair.of((Object)tooltipText, tooltipVariable);
    }
}

