/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.javascript.debugger.breakpoints.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.web.javascript.debugger.breakpoints.DOMBreakpoint;
import org.netbeans.modules.web.javascript.debugger.breakpoints.DOMNode;
import org.netbeans.modules.web.javascript.debugger.breakpoints.ui.Bundle;
import org.netbeans.modules.web.javascript.debugger.breakpoints.ui.ControllerProvider;
import org.netbeans.modules.web.webkit.debugging.api.dom.Node;
import org.netbeans.spi.debugger.ui.Controller;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class DOMBreakpointCustomizer
extends JPanel
implements ControllerProvider,
HelpCtx.Provider {
    private final DOMBreakpoint db;
    private final String origNodePathNames;
    private boolean createBreakpoint;
    private final CustomizerController controller;
    private JLabel fileLabel;
    private JTextField fileTextField;
    private JLabel jLabel2;
    private JTextField nodeTextField;
    private JCheckBox onAttrModifCheckBox;
    private JCheckBox onNodeRemoveCheckBox;
    private JCheckBox onSubtreeModifCheckBox;

    private static DOMBreakpoint createBreakpoint() {
        URL url;
        DOMNode dn;
        Node node = (Node)Utilities.actionsGlobalContext().lookup(Node.class);
        if (node != null) {
            dn = DOMNode.create(node);
            url = DOMNode.findURL(node);
        } else {
            dn = DOMNode.create("[\u0003-1,]");
            FileObject fo = (FileObject)Utilities.actionsGlobalContext().lookup(FileObject.class);
            if (fo == null) {
                fo = EditorContextDispatcher.getDefault().getMostRecentFile();
            }
            url = fo != null ? fo.toURL() : null;
        }
        DOMBreakpoint b = new DOMBreakpoint(url, dn);
        return b;
    }

    public DOMBreakpointCustomizer() {
        this(DOMBreakpointCustomizer.createBreakpoint());
        this.createBreakpoint = true;
    }

    public DOMBreakpointCustomizer(DOMBreakpoint db) {
        String urlStr;
        this.db = db;
        this.initComponents();
        this.nodeTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                DOMBreakpointCustomizer.this.controller.checkValid();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DOMBreakpointCustomizer.this.controller.checkValid();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                DOMBreakpointCustomizer.this.controller.checkValid();
            }
        });
        this.controller = new CustomizerController();
        DOMNode node = db.getNode();
        this.origNodePathNames = node != null ? node.getNodePathNames() : "";
        this.nodeTextField.setText(this.origNodePathNames);
        URL url = db.getURL();
        if (url != null) {
            urlStr = url.toExternalForm();
            if (urlStr.startsWith("file:")) {
                try {
                    urlStr = Utilities.toFile((URI)url.toURI()).getAbsolutePath();
                }
                catch (URISyntaxException ex) {}
            }
        } else {
            urlStr = "";
        }
        this.fileTextField.setText(urlStr);
        this.onSubtreeModifCheckBox.setSelected(db.isOnSubtreeModification());
        this.onAttrModifCheckBox.setSelected(db.isOnAttributeModification());
        this.onNodeRemoveCheckBox.setSelected(db.isOnNodeRemoval());
    }

    @Override
    public Controller getController() {
        return this.controller;
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.nodeTextField = new JTextField();
        this.onSubtreeModifCheckBox = new JCheckBox();
        this.onAttrModifCheckBox = new JCheckBox();
        this.onNodeRemoveCheckBox = new JCheckBox();
        this.fileLabel = new JLabel();
        this.fileTextField = new JTextField();
        this.jLabel2.setText(NbBundle.getMessage(DOMBreakpointCustomizer.class, (String)"DOMBreakpointCustomizer.jLabel2.text"));
        this.nodeTextField.setText(NbBundle.getMessage(DOMBreakpointCustomizer.class, (String)"DOMBreakpointCustomizer.nodeTextField.text"));
        this.nodeTextField.setToolTipText(NbBundle.getMessage(DOMBreakpointCustomizer.class, (String)"DOMBreakpointCustomizer.nodeTextField.toolTipText"));
        this.onSubtreeModifCheckBox.setText(NbBundle.getMessage(DOMBreakpointCustomizer.class, (String)"DOMBreakpointCustomizer.onSubtreeModifCheckBox.text"));
        this.onSubtreeModifCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DOMBreakpointCustomizer.this.onSubtreeModifCheckBoxActionPerformed(evt);
            }
        });
        this.onAttrModifCheckBox.setText(NbBundle.getMessage(DOMBreakpointCustomizer.class, (String)"DOMBreakpointCustomizer.onAttrModifCheckBox.text"));
        this.onAttrModifCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DOMBreakpointCustomizer.this.onAttrModifCheckBoxActionPerformed(evt);
            }
        });
        this.onNodeRemoveCheckBox.setText(NbBundle.getMessage(DOMBreakpointCustomizer.class, (String)"DOMBreakpointCustomizer.onNodeRemoveCheckBox.text"));
        this.onNodeRemoveCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DOMBreakpointCustomizer.this.onNodeRemoveCheckBoxActionPerformed(evt);
            }
        });
        this.fileLabel.setText(NbBundle.getMessage(DOMBreakpointCustomizer.class, (String)"DOMBreakpointCustomizer.fileLabel.text"));
        this.fileTextField.setText(NbBundle.getMessage(DOMBreakpointCustomizer.class, (String)"DOMBreakpointCustomizer.fileTextField.text"));
        this.fileTextField.setToolTipText(NbBundle.getMessage(DOMBreakpointCustomizer.class, (String)"DOMBreakpointCustomizer.fileTextField.toolTipText"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.onSubtreeModifCheckBox, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.onAttrModifCheckBox, -1, 384, Short.MAX_VALUE).addComponent(this.onNodeRemoveCheckBox, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.fileLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nodeTextField).addComponent(this.fileTextField)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.nodeTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fileLabel).addComponent(this.fileTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.onSubtreeModifCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.onAttrModifCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.onNodeRemoveCheckBox).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void onSubtreeModifCheckBoxActionPerformed(ActionEvent evt) {
        this.controller.checkValid();
    }

    private void onAttrModifCheckBoxActionPerformed(ActionEvent evt) {
        this.controller.checkValid();
    }

    private void onNodeRemoveCheckBoxActionPerformed(ActionEvent evt) {
        this.controller.checkValid();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerDOMBreakpointJavaScript");
    }

    private class CustomizerController
    implements Controller {
        PropertyChangeSupport pchs = new PropertyChangeSupport(this);

        private CustomizerController() {
        }

        public boolean ok() {
            String nodePathNames = DOMBreakpointCustomizer.this.nodeTextField.getText().trim();
            if (!DOMBreakpointCustomizer.this.origNodePathNames.equals(nodePathNames)) {
                DOMNode node = DOMNode.create(nodePathNames);
                DOMBreakpointCustomizer.this.db.setNode(node);
            }
            DOMBreakpointCustomizer.this.db.setOnSubtreeModification(DOMBreakpointCustomizer.this.onSubtreeModifCheckBox.isSelected());
            DOMBreakpointCustomizer.this.db.setOnAttributeModification(DOMBreakpointCustomizer.this.onAttrModifCheckBox.isSelected());
            DOMBreakpointCustomizer.this.db.setOnNodeRemoval(DOMBreakpointCustomizer.this.onNodeRemoveCheckBox.isSelected());
            if (DOMBreakpointCustomizer.this.createBreakpoint) {
                DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)DOMBreakpointCustomizer.this.db);
            }
            return true;
        }

        public boolean cancel() {
            return true;
        }

        public boolean isValid() {
            if (DOMBreakpointCustomizer.this.db.getNode() == null || DOMBreakpointCustomizer.this.nodeTextField.getText().trim().isEmpty()) {
                return false;
            }
            return DOMBreakpointCustomizer.this.onAttrModifCheckBox.isSelected() || DOMBreakpointCustomizer.this.onSubtreeModifCheckBox.isSelected() || DOMBreakpointCustomizer.this.onNodeRemoveCheckBox.isSelected();
        }

        private void checkValid() {
            if (DOMBreakpointCustomizer.this.db.getNode() == null) {
                this.firePropertyChange("errorNotification", null, Bundle.Warning_NoDOMNode());
                this.firePropertyChange("valid", null, Boolean.FALSE);
                return;
            }
            if (DOMBreakpointCustomizer.this.nodeTextField.getText().trim().isEmpty()) {
                this.firePropertyChange("errorNotification", null, Bundle.Warning_NoDOMNode());
                this.firePropertyChange("valid", null, Boolean.FALSE);
                return;
            }
            if (DOMBreakpointCustomizer.this.onAttrModifCheckBox.isSelected() || DOMBreakpointCustomizer.this.onSubtreeModifCheckBox.isSelected() || DOMBreakpointCustomizer.this.onNodeRemoveCheckBox.isSelected()) {
                this.firePropertyChange("errorNotification", null, null);
                this.firePropertyChange("valid", null, Boolean.TRUE);
            } else {
                this.firePropertyChange("errorNotification", null, Bundle.Warning_NoDOMModification());
                this.firePropertyChange("valid", null, Boolean.FALSE);
            }
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.pchs.addPropertyChangeListener(l);
            this.checkValid();
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.pchs.removePropertyChangeListener(l);
        }

        private void firePropertyChange(String propName, Object oldValue, Object newValue) {
            this.pchs.firePropertyChange(propName, oldValue, newValue);
        }
    }
}

