/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.javascript.debugger.watches;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Watch;
import org.netbeans.modules.web.javascript.debugger.locals.VariablesModel;
import org.netbeans.modules.web.webkit.debugging.api.debugger.CallFrame;
import org.netbeans.modules.web.webkit.debugging.api.debugger.RemoteObject;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.TreeModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;

public final class WatchesModel
extends VariablesModel
implements TreeModelFilter {
    public static final String WATCH = "org/netbeans/modules/debugger/resources/watchesView/watch_16.png";
    private static final Logger LOG = Logger.getLogger(WatchesModel.class.getCanonicalName());
    private final Map<Watch, VariablesModel.ScopedRemoteObject> evaluatedWatches = new HashMap<Watch, VariablesModel.ScopedRemoteObject>();
    private CallFrame evaluatedWatchesFrame;
    private WatchesListener listener = new WatchesListener(this);

    public WatchesModel(ContextProvider contextProvider) {
        super(contextProvider);
    }

    @Override
    public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
        throw new IllegalStateException("TreeModelFilter.getChildren() should be called instead!");
    }

    public Object[] getChildren(TreeModel original, Object parent, int from, int to) throws UnknownTypeException {
        CallFrame frame = this.getCurrentStack();
        if (parent == "Root") {
            this.evaluateWatches(frame);
            return original.getChildren(parent, from, to);
        }
        if (parent instanceof Watch && frame != null) {
            VariablesModel.ScopedRemoteObject var = this.evaluateWatch(frame, (Watch)parent);
            if (var == null) {
                return new Object[0];
            }
            return super.getChildren(var, from, to);
        }
        return super.getChildren(parent, from, to);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evaluateWatches(CallFrame frame) throws UnknownTypeException {
        Watch[] watches;
        if (frame == null) {
            Map<Watch, VariablesModel.ScopedRemoteObject> map = this.evaluatedWatches;
            synchronized (map) {
                this.evaluatedWatches.clear();
            }
            return;
        }
        HashMap<Watch, VariablesModel.ScopedRemoteObject> watchesMap = null;
        if (frame != null && (watches = DebuggerManager.getDebuggerManager().getWatches()).length > 0) {
            watchesMap = new HashMap<Watch, VariablesModel.ScopedRemoteObject>();
            for (Watch w : watches) {
                VariablesModel.ScopedRemoteObject sro = this.evaluateWatch(frame, w);
                watchesMap.put(w, sro);
            }
        }
        Map<Watch, VariablesModel.ScopedRemoteObject> map = this.evaluatedWatches;
        synchronized (map) {
            this.evaluatedWatches.clear();
            if (watchesMap != null) {
                this.evaluatedWatches.putAll(watchesMap);
            }
            this.evaluatedWatchesFrame = frame;
        }
    }

    public VariablesModel.ScopedRemoteObject evaluateWatch(CallFrame frame, Watch watch) {
        return this.evaluator.evaluateExpression(frame, watch.getExpression(), true);
    }

    @Override
    public boolean isLeaf(Object node) throws UnknownTypeException {
        throw new IllegalStateException("TreeModelFilter.isLeaf() should be called instead!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLeaf(TreeModel original, Object node) throws UnknownTypeException {
        CallFrame frame = this.getCurrentStack();
        if (node instanceof Watch) {
            RemoteObject var;
            if (frame == null) {
                return true;
            }
            VariablesModel.ScopedRemoteObject sro = null;
            Map<Watch, VariablesModel.ScopedRemoteObject> map = this.evaluatedWatches;
            synchronized (map) {
                if (frame == this.evaluatedWatchesFrame) {
                    sro = this.evaluatedWatches.get((Watch)node);
                }
            }
            if (sro != null && (var = sro.getRemoteObject()).getType() == RemoteObject.Type.OBJECT) {
                if (var.hasFetchedProperties()) {
                    return var.getProperties().isEmpty();
                }
                this.updateNodeOnBackground(node, var);
                return false;
            }
            return true;
        }
        if (node instanceof VariablesModel.ScopedRemoteObject) {
            return super.isLeaf(node);
        }
        return original.isLeaf(node);
    }

    @Override
    public int getChildrenCount(Object node) throws UnknownTypeException {
        throw new IllegalStateException("TreeModelFilter.getChildrenCount() should be called instead!");
    }

    public int getChildrenCount(TreeModel original, Object node) throws UnknownTypeException {
        if (node == "Root") {
            return original.getChildrenCount(node);
        }
        if (node instanceof Watch) {
            CallFrame frame = this.getCurrentStack();
            if (frame == null) {
                return 0;
            }
            VariablesModel.ScopedRemoteObject var = this.evaluateWatch(frame, (Watch)node);
            if (var == null) {
                return 0;
            }
            return super.getChildrenCount(var);
        }
        return super.getChildrenCount(node);
    }

    public Object getRoot(TreeModel original) {
        return super.getRoot();
    }

    @Override
    public String getDisplayName(Object node) throws UnknownTypeException {
        if (node instanceof Watch) {
            return ((Watch)node).getExpression();
        }
        return super.getDisplayName(node);
    }

    @Override
    public String getIconBaseWithExtension(Object node) throws UnknownTypeException {
        if (node == "Root" || node instanceof Watch) {
            return WATCH;
        }
        return super.getIconBaseWithExtension(node);
    }

    @Override
    public String getShortDescription(Object node) throws UnknownTypeException {
        if (node instanceof Watch) {
            return "";
        }
        return super.getShortDescription(node);
    }

    @Override
    public Object getValueAt(Object node, String columnID) throws UnknownTypeException {
        if (node instanceof Watch) {
            CallFrame frame = this.getCurrentStack();
            VariablesModel.ScopedRemoteObject var = null;
            if (frame != null) {
                var = this.evaluateWatch(frame, (Watch)node);
            }
            if (var != null) {
                return this.getValueAt(var, columnID);
            }
            if ("WatchValue".equals(columnID)) {
                return "";
            }
            if ("WatchType".equals(columnID)) {
                return "";
            }
            if ("WatchToString".equals(columnID)) {
                return "";
            }
        } else {
            if ("WatchValue".equals(columnID)) {
                return super.getValueAt(node, "LocalsValue");
            }
            if ("WatchType".equals(columnID)) {
                return super.getValueAt(node, "LocalsType");
            }
            if ("WatchToString".equals(columnID) || "LocalsToString".equals(columnID)) {
                return super.getValueAt(node, "LocalsToString");
            }
        }
        throw new UnknownTypeException(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReadOnly(Object node, String columnID) throws UnknownTypeException {
        if ("WatchValue".equals(columnID) && node instanceof Watch) {
            CallFrame frame = this.getCurrentStack();
            VariablesModel.ScopedRemoteObject var = null;
            if (frame != null) {
                Map<Watch, VariablesModel.ScopedRemoteObject> map = this.evaluatedWatches;
                synchronized (map) {
                    if (frame == this.evaluatedWatchesFrame) {
                        var = this.evaluatedWatches.get((Watch)node);
                    }
                }
            }
            if (var == null) {
                return false;
            }
            return super.isReadOnly(var, columnID);
        }
        return true;
    }

    @Override
    public void setValueAt(Object node, String columnID, Object value) throws UnknownTypeException {
        if ("WatchValue".equals(columnID) && node instanceof Watch) {
            CallFrame frame = this.getCurrentStack();
            if (frame == null) {
                return;
            }
            VariablesModel.ScopedRemoteObject var = this.evaluateWatch(frame, (Watch)node);
            assert (var != null);
            super.setValueAt(var, columnID, value);
        }
        throw new UnknownTypeException(node);
    }

    private static class WatchesListener
    extends DebuggerManagerAdapter
    implements PropertyChangeListener {
        private WatchesModel model;

        public WatchesListener(WatchesModel watchesModel) {
            Watch[] watches;
            this.model = watchesModel;
            DebuggerManager.getDebuggerManager().addDebuggerListener("watches", (DebuggerManagerListener)this);
            for (Watch watch : watches = DebuggerManager.getDebuggerManager().getWatches()) {
                watch.addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        public void watchAdded(Watch watch) {
            watch.addPropertyChangeListener((PropertyChangeListener)this);
            this.model.refresh();
        }

        public void watchRemoved(Watch watch) {
            watch.removePropertyChangeListener((PropertyChangeListener)this);
            this.model.refresh();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!(evt.getSource() instanceof Watch)) {
                return;
            }
            Watch w = (Watch)evt.getSource();
            this.model.fireChangeEvent((ModelEvent)new ModelEvent.NodeChanged((Object)this, (Object)w));
        }
    }
}

