/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.js.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.javascript2.debug.breakpoints.JSBreakpointsInfo;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.filesystems.FileObject;

public class JSBreakpointsInfoImpl
implements JSBreakpointsInfo {
    private volatile boolean active = true;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public JSBreakpointsInfoImpl() {
        SessionActiveListener sal = new SessionActiveListener();
        DebuggerManager.getDebuggerManager().addDebuggerListener("currentSession", (DebuggerManagerListener)sal);
    }

    public boolean isDefault() {
        FileObject mostRecentFile = EditorContextDispatcher.getDefault().getMostRecentFile();
        if (mostRecentFile == null) {
            return false;
        }
        String mimeType = mostRecentFile.getMIMEType();
        return "text/javascript".equals(mimeType);
    }

    public boolean isAnnotatable(FileObject fo) {
        String mimeType = fo.getMIMEType();
        return "text/javascript".equals(mimeType);
    }

    public boolean isTransientURL(URL url) {
        return "js-scripts".equals(url.getProtocol());
    }

    public boolean areBreakpointsActivated() {
        return this.active;
    }

    private void setActive(boolean active) {
        if (this.active != active) {
            this.active = active;
            this.pcs.firePropertyChange("breakpointsActive", !active, active);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    private class SessionActiveListener
    extends DebuggerManagerAdapter {
        private JPDADebugger currentDebugger = this.getCurrentDebugger();

        public SessionActiveListener() {
            if (this.currentDebugger != null) {
                JSBreakpointsInfoImpl.this.active = this.currentDebugger.getBreakpointsActive();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if ("currentSession".equals(propertyName)) {
                JPDADebugger newDebugger = this.getCurrentDebugger();
                SessionActiveListener sessionActiveListener = this;
                synchronized (sessionActiveListener) {
                    if (this.currentDebugger != null) {
                        this.currentDebugger.removePropertyChangeListener("breakpointsActive", (PropertyChangeListener)((Object)this));
                    }
                    this.currentDebugger = newDebugger;
                }
                if (newDebugger != null) {
                    JSBreakpointsInfoImpl.this.setActive(newDebugger.getBreakpointsActive());
                } else {
                    JSBreakpointsInfoImpl.this.setActive(true);
                }
            }
            if ("breakpointsActive".equals(propertyName)) {
                JSBreakpointsInfoImpl.this.setActive(((JPDADebugger)evt.getSource()).getBreakpointsActive());
            }
        }

        private JPDADebugger getCurrentDebugger() {
            Session s = DebuggerManager.getDebuggerManager().getCurrentSession();
            if (s != null) {
                JPDADebugger debugger = (JPDADebugger)s.lookupFirst(null, JPDADebugger.class);
                if (debugger != null) {
                    debugger.addPropertyChangeListener("breakpointsActive", (PropertyChangeListener)((Object)this));
                }
                return debugger;
            }
            return null;
        }
    }
}

