/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.js.vars.models;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.debugger.jpda.ClassVariable;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAWatch;
import org.netbeans.api.debugger.jpda.LocalVariable;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.This;
import org.netbeans.modules.debugger.jpda.js.vars.JSThis;
import org.netbeans.modules.debugger.jpda.js.vars.JSVariable;
import org.netbeans.modules.debugger.jpda.js.vars.ScopeVariable;
import org.netbeans.modules.debugger.jpda.js.vars.models.JSWatchVar;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.TreeModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;

public class VariablesJSTreeModel
implements TreeModelFilter {
    private final JPDADebugger debugger;

    public VariablesJSTreeModel(ContextProvider lookupProvider) {
        this.debugger = (JPDADebugger)lookupProvider.lookupFirst(null, JPDADebugger.class);
    }

    public Object getRoot(TreeModel original) {
        return original.getRoot();
    }

    public Object[] getChildren(TreeModel original, Object parent, int from, int to) throws UnknownTypeException {
        JSVariable jsVar;
        if (parent instanceof JSWatchVar) {
            jsVar = ((JSWatchVar)parent).getJSVar();
            parent = jsVar != null ? jsVar : ((JSWatchVar)parent).getWatch();
        }
        if (parent instanceof JSVariable) {
            jsVar = (JSVariable)parent;
            ObjectVariable valueObject = jsVar.getValueObject();
            if (valueObject != null) {
                return original.getChildren((Object)valueObject, from, to);
            }
            return jsVar.getChildren();
        }
        if (parent instanceof ScopeVariable) {
            return ((ScopeVariable)parent).getScopeVars();
        }
        Object[] children = original.getChildren(parent, from, to);
        ArrayList<Object> newChildren = new ArrayList<Object>();
        ArrayList<ScopeVariable> scopeVars = null;
        HashMap<String, LocalVariable> localVarsByName = new HashMap<String, LocalVariable>();
        JSVariable thiz = null;
        This jthis = null;
        for (int i = 0; i < children.length; ++i) {
            Object ch = children[i];
            if (ch instanceof LocalVariable) {
                LocalVariable lv = (LocalVariable)ch;
                String name = lv.getName();
                if (":this".equals(name)) {
                    ch = this.createThisVar(lv);
                    thiz = (JSVariable)ch;
                    continue;
                }
                if (":scope".equals(name)) {
                    if (scopeVars == null) {
                        scopeVars = new ArrayList<ScopeVariable>();
                    }
                    scopeVars.add(ScopeVariable.create(this.debugger, lv));
                    continue;
                }
                if (name.startsWith(":")) continue;
                localVarsByName.put(name, lv);
                continue;
            }
            if (ch instanceof JPDAClassType || ch instanceof ClassVariable) continue;
            if (ch instanceof This) {
                jthis = (This)ch;
            }
            if (JSWatchVar.is(ch)) {
                ch = new JSWatchVar(this.debugger, (JPDAWatch)ch);
            }
            newChildren.add(ch);
        }
        for (Map.Entry entry : localVarsByName.entrySet()) {
            JSVariable jsv = JSVariable.create(this.debugger, (LocalVariable)entry.getValue());
            if (jsv == null) continue;
            newChildren.add(0, jsv);
        }
        if (scopeVars != null) {
            int index = Math.min(localVarsByName.size(), newChildren.size());
            for (ScopeVariable sv : scopeVars) {
                newChildren.add(index, sv);
            }
        }
        if (thiz != null) {
            newChildren.remove(jthis);
            newChildren.add(0, thiz);
        }
        return newChildren.toArray();
    }

    public int getChildrenCount(TreeModel original, Object node) throws UnknownTypeException {
        return Integer.MAX_VALUE;
    }

    public boolean isLeaf(TreeModel original, Object node) throws UnknownTypeException {
        if (node instanceof JSWatchVar) {
            JSWatchVar jswv = (JSWatchVar)node;
            JSVariable jsVar = jswv.getJSVarIfExists();
            node = jsVar != null ? jsVar : jswv.getWatch();
        }
        if (node instanceof JSVariable) {
            JSVariable jsVar = (JSVariable)node;
            ObjectVariable valueObject = jsVar.getValueObject();
            if (valueObject != null) {
                return original.isLeaf((Object)valueObject);
            }
            return !jsVar.isExpandable();
        }
        if (node instanceof ScopeVariable) {
            return false;
        }
        return original.isLeaf(node);
    }

    public void addModelListener(ModelListener l) {
    }

    public void removeModelListener(ModelListener l) {
    }

    private JSVariable createThisVar(LocalVariable lv) {
        return JSThis.create(this.debugger, lv);
    }
}

