/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.doctrine2.ui.options;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.doctrine2.commands.Doctrine2Script;
import org.netbeans.modules.php.doctrine2.ui.options.Bundle;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class Doctrine2OptionsPanel
extends JPanel {
    private static final long serialVersionUID = 67643468774654L;
    private static final String SCRIPT_LAST_FOLDER_SUFFIX = ".script";
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JLabel errorLabel;
    private JLabel installationInstructionsLabel;
    private JLabel learnMoreLabel;
    private JLabel noteLabel;
    private JButton scriptBrowseButton;
    private JLabel scriptInfoLabel;
    private JLabel scriptLabel;
    private JButton scriptSearchButton;
    private JTextField scriptTextField;

    public Doctrine2OptionsPanel() {
        this.initComponents();
        this.errorLabel.setText(" ");
        this.init();
    }

    private void init() {
        this.scriptInfoLabel.setText(Bundle.Doctrine2OptionsPanel_script_hint("doctrine", Doctrine2Script.SCRIPT_NAME_LONG));
        this.errorLabel.setText(" ");
        this.initListeners();
    }

    private void initListeners() {
        this.scriptTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            private void processUpdate() {
                Doctrine2OptionsPanel.this.fireChange();
            }
        });
    }

    public String getScript() {
        return this.scriptTextField.getText();
    }

    public void setScript(String script) {
        this.scriptTextField.setText(script);
    }

    public void setError(String message) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.errorForeground"));
        this.errorLabel.setText(message);
    }

    public void setWarning(String message) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.warningForeground"));
        this.errorLabel.setText(message);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    private void initComponents() {
        this.scriptLabel = new JLabel();
        this.scriptTextField = new JTextField();
        this.scriptBrowseButton = new JButton();
        this.scriptSearchButton = new JButton();
        this.scriptInfoLabel = new JLabel();
        this.noteLabel = new JLabel();
        this.errorLabel = new JLabel();
        this.installationInstructionsLabel = new JLabel();
        this.learnMoreLabel = new JLabel();
        this.scriptLabel.setLabelFor(this.scriptTextField);
        Mnemonics.setLocalizedText((JLabel)this.scriptLabel, (String)NbBundle.getMessage(Doctrine2OptionsPanel.class, (String)"Doctrine2OptionsPanel.scriptLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.scriptBrowseButton, (String)NbBundle.getMessage(Doctrine2OptionsPanel.class, (String)"Doctrine2OptionsPanel.scriptBrowseButton.text"));
        this.scriptBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Doctrine2OptionsPanel.this.scriptBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.scriptSearchButton, (String)NbBundle.getMessage(Doctrine2OptionsPanel.class, (String)"Doctrine2OptionsPanel.scriptSearchButton.text"));
        this.scriptSearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Doctrine2OptionsPanel.this.scriptSearchButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.scriptInfoLabel, (String)"HINT");
        Mnemonics.setLocalizedText((JLabel)this.noteLabel, (String)NbBundle.getMessage(Doctrine2OptionsPanel.class, (String)"Doctrine2OptionsPanel.noteLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.errorLabel, (String)"ERROR");
        Mnemonics.setLocalizedText((JLabel)this.installationInstructionsLabel, (String)NbBundle.getMessage(Doctrine2OptionsPanel.class, (String)"Doctrine2OptionsPanel.installationInstructionsLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.learnMoreLabel, (String)NbBundle.getMessage(Doctrine2OptionsPanel.class, (String)"Doctrine2OptionsPanel.learnMoreLabel.text"));
        this.learnMoreLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                Doctrine2OptionsPanel.this.learnMoreLabelMouseEntered(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                Doctrine2OptionsPanel.this.learnMoreLabelMousePressed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.scriptLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.scriptInfoLabel).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.scriptTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scriptBrowseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scriptSearchButton)))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.errorLabel).addComponent(this.noteLabel, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.installationInstructionsLabel).addComponent(this.learnMoreLabel, -2, -1, -2)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.scriptLabel).addComponent(this.scriptTextField, -2, -1, -2).addComponent(this.scriptBrowseButton).addComponent(this.scriptSearchButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scriptInfoLabel).addGap(18, 18, 18).addComponent(this.noteLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.installationInstructionsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.learnMoreLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.errorLabel)));
    }

    private void scriptBrowseButtonActionPerformed(ActionEvent evt) {
        File script = new FileChooserBuilder(Doctrine2OptionsPanel.class.getName() + SCRIPT_LAST_FOLDER_SUFFIX).setTitle(Bundle.LBL_SelectScript()).setFilesOnly(true).showOpenDialog();
        if (script != null) {
            script = FileUtil.normalizeFile((File)script);
            this.scriptTextField.setText(script.getAbsolutePath());
        }
    }

    private void learnMoreLabelMouseEntered(MouseEvent evt) {
        evt.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void learnMoreLabelMousePressed(MouseEvent evt) {
        try {
            HtmlBrowser.URLDisplayer.getDefault().showURL(new URL("http://www.doctrine-project.org/"));
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void scriptSearchButtonActionPerformed(ActionEvent evt) {
        String script = UiUtils.SearchWindow.search((UiUtils.SearchWindow.SearchWindowSupport)new UiUtils.SearchWindow.SearchWindowSupport(){

            public List<String> detect() {
                return FileUtils.findFileOnUsersPath((String[])new String[]{"doctrine", Doctrine2Script.SCRIPT_NAME_LONG});
            }

            public String getWindowTitle() {
                return Bundle.Doctrine2OptionsPanel_search_scripts_title();
            }

            public String getListTitle() {
                return Bundle.Doctrine2OptionsPanel_search_scripts();
            }

            public String getPleaseWaitPart() {
                return Bundle.Doctrine2OptionsPanel_search_scripts_pleaseWaitPart();
            }

            public String getNoItemsFound() {
                return Bundle.Doctrine2OptionsPanel_search_scripts_notFound();
            }
        });
        if (script != null) {
            this.scriptTextField.setText(script);
        }
    }
}

