/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fileoperations.spi;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.netbeans.api.extexecution.ProcessBuilder;
import org.netbeans.modules.dlight.libs.common.PathUtilities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.FileInfoProvider;
import org.netbeans.modules.nativeexecution.api.util.MacroMap;
import org.netbeans.modules.remote.impl.RemoteLogger;
import org.netbeans.modules.remote.impl.fileoperations.spi.RemoteVcsSupportUtil;
import org.netbeans.modules.remote.impl.fs.DirEntry;
import org.netbeans.modules.remote.impl.fs.RemoteDirectory;
import org.netbeans.modules.remote.impl.fs.RemoteExceptions;
import org.netbeans.modules.remote.impl.fs.RemoteFileObject;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectBase;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystem;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemManager;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemTransport;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemUtils;
import org.netbeans.modules.remote.impl.fs.RemoteFileUrlMapper;
import org.netbeans.modules.remote.impl.fs.RemotePlainFile;
import org.netbeans.spi.extexecution.ProcessBuilderFactory;
import org.netbeans.spi.extexecution.ProcessBuilderImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.Lookup;

public abstract class FileOperationsProvider {
    public static final String ATTRIBUTE = "FileProxyOperations";
    private static FileOperationsProvider defaultProvider;

    protected FileOperationsProvider() {
    }

    public abstract FileOperations getFileOperations(FileSystem var1);

    public static FileProxyO toFileProxy(String path) {
        return new FileProxyOImpl(path);
    }

    public static FileOperationsProvider getDefault() {
        if (defaultProvider != null) {
            return defaultProvider;
        }
        defaultProvider = (FileOperationsProvider)Lookup.getDefault().lookup(FileOperationsProvider.class);
        return defaultProvider;
    }

    private static final class FileProxyOImpl
    implements FileProxyO {
        private final String path;

        private FileProxyOImpl(String path) {
            this.path = path;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        public String toString() {
            return this.path;
        }

        public int hashCode() {
            return this.path.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FileProxyOImpl other = (FileProxyOImpl)obj;
            return !(this.path == null ? other.path != null : !this.path.equals(other.path));
        }
    }

    public static interface FileProxyO {
        public String getPath();
    }

    private static final class ProcessBuilderImplementationImpl
    implements ProcessBuilderImplementation {
        private final ExecutionEnvironment env;

        private ProcessBuilderImplementationImpl(ExecutionEnvironment env) {
            this.env = env;
        }

        public Process createProcess(String executable, String workingDirectory, List<String> arguments, List<String> paths, Map<String, String> environment, boolean redirectErrorStream) throws ConnectException, IOException {
            if (!ConnectionManager.getInstance().isConnectedTo(this.env)) {
                throw RemoteExceptions.createConnectException(RemoteFileSystemUtils.getConnectExceptionMessage(this.env));
            }
            NativeProcessBuilder pb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)this.env);
            pb.setExecutable(executable).setWorkingDirectory(workingDirectory).setArguments(arguments.toArray(new String[arguments.size()]));
            MacroMap mm = MacroMap.forExecEnv((ExecutionEnvironment)this.env);
            mm.putAll(environment);
            pb.getEnvironment().putAll(mm);
            for (String path : paths) {
                pb.getEnvironment().appendPathVariable("PATH", path);
            }
            if (redirectErrorStream) {
                pb.redirectError();
            }
            return pb.call();
        }

        public String toString() {
            return this.env.getDisplayName();
        }
    }

    public static abstract class FileOperations {
        private final ExecutionEnvironment env;
        private final RemoteFileSystem fileSystem;
        private static final boolean USE_CACHE;

        protected FileOperations(FileSystem fs) {
            FileObject root = fs.getRoot();
            if (!(root instanceof RemoteFileObject)) {
                throw new IllegalArgumentException();
            }
            this.env = ((RemoteFileObject)root).getExecutionEnvironment();
            this.fileSystem = (RemoteFileSystem)fs;
        }

        protected String getName(FileProxyO file) {
            return PathUtilities.getBaseName((String)file.getPath());
        }

        protected String getDir(FileProxyO file) {
            return PathUtilities.getDirName((String)file.getPath());
        }

        protected String normalizeUnixPath(FileProxyO file) {
            String path = PathUtilities.normalizeUnixPath((String)file.getPath());
            if (path.isEmpty() && file.getPath().startsWith("/") || path.equals("/..")) {
                return "/";
            }
            return path;
        }

        private RemoteFileObject getFileObject(FileProxyO file) {
            String path = PathUtilities.normalizeUnixPath((String)file.getPath());
            RemoteFileObjectBase cached = this.fileSystem.getFactory().getCachedFileObject(path);
            RemoteFileObject fo = cached != null && cached.isValid() ? cached.getOwnerFileObject() : this.fileSystem.findResource(path);
            return fo;
        }

        protected boolean isDirectory(FileProxyO file) {
            Boolean res;
            if (RemoteVcsSupportUtil.USE_FS && !this.fileSystem.isInsideVCS()) {
                RemoteFileObject fo = this.getFileObject(file);
                return fo == null || !fo.isValid() ? false : fo.isFolder();
            }
            if (USE_CACHE && (res = this.fileSystem.vcsSafeIsDirectory(file.getPath())) != null) {
                return res;
            }
            RemoteFileObjectBase beingCreated = this.fileSystem.getBeingCreated();
            if (beingCreated != null && beingCreated.getPath().equals(file.getPath())) {
                if (beingCreated instanceof RemotePlainFile) {
                    return false;
                }
                if (beingCreated instanceof RemoteDirectory) {
                    return true;
                }
            }
            if (!ConnectionManager.getInstance().isConnectedTo(this.getExecutionEnvironment())) {
                return false;
            }
            try {
                DirEntry entry = RemoteFileSystemTransport.stat(this.env, file.getPath());
                return entry.isDirectory();
            }
            catch (ConnectException ex) {
                RemoteLogger.finest(ex);
            }
            catch (IOException | InterruptedException ex) {
                RemoteLogger.finest(ex);
            }
            catch (ExecutionException ex) {
                if (RemoteFileSystemUtils.isFileNotFoundException(ex)) {
                    return false;
                }
                ex.printStackTrace(System.err);
            }
            return false;
        }

        protected long lastModified(FileProxyO file) {
            Long res;
            if (RemoteVcsSupportUtil.USE_FS && !this.fileSystem.isInsideVCS()) {
                RemoteFileObject fo = this.getFileObject(file);
                return fo == null || !fo.isValid() ? -1L : fo.lastModified().getTime();
            }
            if (USE_CACHE && (res = this.fileSystem.vcsSafeLastModified(file.getPath())) != null) {
                return res;
            }
            if (!ConnectionManager.getInstance().isConnectedTo(this.getExecutionEnvironment())) {
                return -1L;
            }
            try {
                DirEntry entry = RemoteFileSystemTransport.stat(this.env, file.getPath());
                return entry.getLastModified().getTime();
            }
            catch (ConnectException ex) {
                RemoteLogger.finest(ex);
            }
            catch (IOException | InterruptedException ex) {
                RemoteLogger.finest(ex);
            }
            catch (ExecutionException ex) {
                if (RemoteFileSystemUtils.isFileNotFoundException(ex)) {
                    return -1L;
                }
                ex.printStackTrace(System.err);
            }
            return -1L;
        }

        protected boolean isFile(FileProxyO file) {
            Boolean res;
            if (RemoteVcsSupportUtil.USE_FS && !this.fileSystem.isInsideVCS()) {
                RemoteFileObject fo = this.getFileObject(file);
                return fo == null || !fo.isValid() ? false : fo.isData();
            }
            if (USE_CACHE && (res = this.fileSystem.vcsSafeIsFile(file.getPath())) != null) {
                return res;
            }
            if (!ConnectionManager.getInstance().isConnectedTo(this.getExecutionEnvironment())) {
                return false;
            }
            try {
                DirEntry entry = RemoteFileSystemTransport.stat(this.env, file.getPath());
                return entry.isPlainFile();
            }
            catch (ConnectException ex) {
                RemoteLogger.finest(ex);
            }
            catch (IOException | InterruptedException ex) {
                RemoteLogger.finest(ex);
            }
            catch (ExecutionException ex) {
                if (RemoteFileSystemUtils.isFileNotFoundException(ex)) {
                    return false;
                }
                ex.printStackTrace(System.err);
            }
            return false;
        }

        protected boolean canWrite(FileProxyO file) {
            if (RemoteVcsSupportUtil.USE_FS && !this.fileSystem.isInsideVCS()) {
                RemoteFileObject fo = this.getFileObject(file);
                return fo == null || !fo.isValid() ? false : fo.canWrite();
            }
            if (!ConnectionManager.getInstance().isConnectedTo(this.getExecutionEnvironment())) {
                return false;
            }
            try {
                DirEntry entry = RemoteFileSystemTransport.stat(this.env, file.getPath());
                return entry.canWrite();
            }
            catch (ConnectException ex) {
                RemoteLogger.finest(ex);
            }
            catch (IOException | InterruptedException ex) {
                RemoteLogger.finest(ex);
            }
            catch (ExecutionException ex) {
                if (RemoteFileSystemUtils.isFileNotFoundException(ex)) {
                    return false;
                }
                ex.printStackTrace(System.err);
            }
            return false;
        }

        protected FileObject getRoot() {
            RemoteFileSystem fs = this.getFileSystem();
            return fs.getRoot();
        }

        protected RemoteFileSystem getFileSystem() {
            return RemoteFileSystemManager.getInstance().getFileSystem(this.env);
        }

        protected String getPath(FileProxyO file) {
            return file.getPath();
        }

        protected URI toURI(String path, boolean folder) throws URISyntaxException {
            return RemoteFileUrlMapper.toURI(this.env, path, folder);
        }

        protected boolean exists(FileProxyO file) {
            Boolean res;
            if (RemoteVcsSupportUtil.USE_FS && !this.fileSystem.isInsideVCS()) {
                RemoteFileObject fo = this.getFileObject(file);
                return fo != null && fo.isValid();
            }
            if (USE_CACHE && (res = this.fileSystem.vcsSafeExists(file.getPath())) != null) {
                return res;
            }
            return this.existsSafe(file);
        }

        protected boolean existsSafe(FileProxyO file) {
            if (!ConnectionManager.getInstance().isConnectedTo(this.getExecutionEnvironment())) {
                return false;
            }
            try {
                DirEntry entry = RemoteFileSystemTransport.lstat(this.getExecutionEnvironment(), file.getPath());
                return entry != null;
            }
            catch (ConnectException ex) {
                RemoteLogger.finest(ex);
            }
            catch (IOException | InterruptedException ex) {
                RemoteLogger.finest(ex);
            }
            catch (ExecutionException ex) {
                if (RemoteFileSystemUtils.isFileNotFoundException(ex)) {
                    return false;
                }
                RemoteLogger.finest(ex);
            }
            return false;
        }

        protected FileObject toFileObject(FileProxyO path) {
            RemoteFileObjectBase cachedFileObject = this.fileSystem.getFactory().getCachedFileObject(path.getPath());
            if (cachedFileObject != null && cachedFileObject.isValid()) {
                return cachedFileObject.getOwnerFileObject();
            }
            FileObject root = this.getRoot();
            FileObject fo = root.getFileObject(path.getPath());
            if (fo == null && this.existsSafe(path)) {
                FileObject parentFO;
                String parent = path.getPath();
                LinkedList<String> stack = new LinkedList<String>();
                do {
                    if ((parent = PathUtilities.getDirName((String)parent)) == null) {
                        return null;
                    }
                    stack.addLast(parent);
                } while ((parentFO = root.getFileObject(parent)) == null || !parentFO.isValid());
                while (!stack.isEmpty()) {
                    parent = (String)stack.removeLast();
                    parentFO = root.getFileObject(parent);
                    if (parentFO != null && parentFO.isValid()) {
                        parentFO.refresh();
                        continue;
                    }
                    return null;
                }
                fo = root.getFileObject(path.getPath());
            }
            return fo;
        }

        protected InputStream getInputStream(FileObject fo, boolean checkLock) throws FileNotFoundException {
            if (fo instanceof RemoteFileObject) {
                return ((RemoteFileObject)fo).getImplementor().getInputStream(checkLock);
            }
            return fo.getInputStream();
        }

        protected String[] list(FileProxyO file) {
            if (this.isDirectory(file)) {
                if (RemoteVcsSupportUtil.USE_FS && !this.fileSystem.isInsideVCS()) {
                    RemoteFileObject fo = this.getFileObject(file);
                    if (fo == null) {
                        return null;
                    }
                    RemoteFileObject[] children = fo.getImplementor().getChildren();
                    String[] names = new String[children.length];
                    for (int i = 0; i < children.length; ++i) {
                        names[i] = children[i].getNameExt();
                    }
                    return names;
                }
                Future stat = FileInfoProvider.ls((ExecutionEnvironment)this.env, (String)file.getPath());
                try {
                    FileInfoProvider.StatInfo[] statInfo = (FileInfoProvider.StatInfo[])stat.get();
                    if (statInfo != null) {
                        String[] res = new String[statInfo.length];
                        for (int i = 0; i < statInfo.length; ++i) {
                            res[i] = statInfo[i].getName();
                        }
                        return res;
                    }
                }
                catch (InterruptedException ex) {
                }
                catch (ExecutionException ex) {
                    if (RemoteFileSystemUtils.isFileNotFoundException(ex)) {
                        return null;
                    }
                    ex.printStackTrace(System.err);
                }
            }
            return null;
        }

        protected ProcessBuilder createProcessBuilder(FileProxyO file) {
            return ProcessBuilderFactory.createProcessBuilder((ProcessBuilderImplementation)new ProcessBuilderImplementationImpl(this.env), (String)"RFS Process Builder");
        }

        protected void refreshFor(FileProxyO ... files) {
            ArrayList<RemoteFileObjectBase> roots = new ArrayList<RemoteFileObjectBase>();
            for (FileProxyO f : files) {
                RemoteFileObjectBase fo = this.findExistingParent(f.getPath());
                if (fo == null || !fo.isValid()) continue;
                roots.add(fo);
            }
            if (!roots.isEmpty()) {
                RemoteFileSystem fs = ((RemoteFileObjectBase)roots.iterator().next()).getFileSystem();
                String[] paths = new String[roots.size()];
                for (int i = 0; i < roots.size(); ++i) {
                    paths[i] = ((RemoteFileObjectBase)roots.get(i)).getPath();
                }
                try {
                    RemoteVcsSupportUtil.refreshFor(fs, paths);
                }
                catch (IOException ex) {
                    RemoteLogger.fine(ex);
                }
            }
        }

        private RemoteFileObjectBase findExistingParent(String path) {
            do {
                RemoteFileObject fo;
                if ((fo = this.getFileSystem().findResource(path)) == null) continue;
                return fo.getImplementor();
            } while ((path = PathUtilities.getDirName((String)path)) != null);
            return null;
        }

        private ExecutionEnvironment getExecutionEnvironment() {
            return this.env;
        }

        public String toString() {
            return this.env.getDisplayName();
        }

        public int hashCode() {
            int hash = 7;
            hash = 17 * hash + (this.env != null ? this.env.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FileOperations other = (FileOperations)obj;
            return this.env == other.env || this.env != null && this.env.equals((Object)other.env);
        }

        static {
            String text = System.getProperty("rfs.vcs.cache");
            USE_CACHE = false;
        }
    }
}

