/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.angular.index;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.html.angular.index.AngularJsController;
import org.netbeans.modules.javascript2.editor.index.JsIndexer;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexer;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.netbeans.modules.parsing.spi.indexing.support.IndexDocument;
import org.netbeans.modules.parsing.spi.indexing.support.IndexingSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

public class AngularJsIndexer
extends EmbeddingIndexer {
    public static final String FIELD_CONTROLLER = "cont";
    public static final String FIELD_TEMPLATE_CONTROLLER = "tc";
    public static final String FIELD_COMPONENT = "comp";
    private static final Logger LOG = Logger.getLogger(AngularJsIndexer.class.getName());
    private static final ThreadLocal<Map<URI, Collection<AngularJsController>>> controllers = new ThreadLocal();
    private static final ThreadLocal<Map<URI, Map<String, AngularJsController.ModuleConfigRegistration>>> templateControllers = new ThreadLocal();
    private static final ThreadLocal<Map<URI, Collection<String>>> components = new ThreadLocal();
    private static final ThreadLocal<Boolean> addedToJsIndexPost = new ThreadLocal();

    public static void addController(@NonNull URI uri, @NonNull AngularJsController controller) {
        Map<URI, Collection<AngularJsController>> map = controllers.get();
        if (map == null) {
            throw new IllegalStateException("AngularJsIndexer.addControllers can be called only from scanner thread.");
        }
        Collection<AngularJsController> cons = map.get(uri);
        if (cons == null) {
            cons = new ArrayList<AngularJsController>();
            cons.add(controller);
            map.put(uri, cons);
        } else {
            cons.add(controller);
        }
    }

    public static void addTemplateController(@NonNull URI uri, @NonNull String template, @NonNull String controller, @NullAllowed String controllerAs) {
        Map<URI, Map<String, AngularJsController.ModuleConfigRegistration>> map = templateControllers.get();
        if (map == null) {
            throw new IllegalStateException("AngularJsIndexer.addTemplateControllers can be called only from scanner thread.");
        }
        Map<String, AngularJsController.ModuleConfigRegistration> templates = map.get(uri);
        if (templates == null) {
            templates = new HashMap<String, AngularJsController.ModuleConfigRegistration>();
            templates.put(template, new AngularJsController.ModuleConfigRegistration(controller, controllerAs));
            map.put(uri, templates);
        } else {
            templates.put(template, new AngularJsController.ModuleConfigRegistration(controller, controllerAs));
        }
    }

    public static void addComponent(@NonNull URI uri, @NonNull String component) {
        Map<URI, Collection<String>> map = components.get();
        if (map == null) {
            throw new IllegalStateException("AngularJsIndexer.addComponent can be called only from scanner thread.");
        }
        Collection<String> cons = map.get(uri);
        if (cons == null) {
            cons = new ArrayList<String>();
            cons.add(component);
            map.put(uri, cons);
        } else {
            cons.add(component);
        }
    }

    private static void removeControllers(@NonNull URI uri) {
        Map<URI, Collection<AngularJsController>> map = controllers.get();
        if (map == null) {
            throw new IllegalStateException("AngularJsIndexer.addControllers can be called only from scanner thread.");
        }
        map.remove(uri);
    }

    private static void removeTemplateControllers(@NonNull URI uri) {
        Map<URI, Map<String, AngularJsController.ModuleConfigRegistration>> map = templateControllers.get();
        if (map == null) {
            throw new IllegalStateException("AngularJsIndexer.addControllers can be called only from scanner thread.");
        }
        map.remove(uri);
    }

    private static Collection<AngularJsController> getControllers(@NonNull URI uri) {
        Map<URI, Collection<AngularJsController>> map = controllers.get();
        if (map == null) {
            throw new IllegalStateException("AngularJsIndexer.getControllers can be called only from scanner thread.");
        }
        return map.get(uri);
    }

    private static Map<String, AngularJsController.ModuleConfigRegistration> getTemplateControllers(@NonNull URI uri) {
        Map<URI, Map<String, AngularJsController.ModuleConfigRegistration>> map = templateControllers.get();
        if (map == null) {
            throw new IllegalStateException("AngularJsIndexer.getControllers can be called only from scanner thread.");
        }
        return map.get(uri);
    }

    public static boolean isScannerThread() {
        return controllers.get() != null;
    }

    protected void index(Indexable indexable, Parser.Result parserResult, Context context) {
        if (!addedToJsIndexPost.get().booleanValue()) {
            addedToJsIndexPost.set(Boolean.TRUE);
            JsIndexer.Factory.addPostScanTask((Runnable)new SaveToIndex(context));
        }
    }

    private static class SaveToIndex
    implements Runnable {
        private final Context context;

        public SaveToIndex(Context context) {
            this.context = context;
        }

        @Override
        public void run() {
            Map templates = (Map)templateControllers.get();
            Map controls = (Map)controllers.get();
            Map comps = (Map)components.get();
            if (templates != null && !templates.isEmpty() || controls != null && !controls.isEmpty()) {
                Collection collection;
                IndexDocument elementDocument;
                FileObject fo;
                File file;
                URI uri;
                IndexingSupport support;
                try {
                    support = IndexingSupport.getInstance((Context)this.context);
                }
                catch (IOException ioe) {
                    LOG.log(Level.WARNING, null, ioe);
                    return;
                }
                if (templates != null && !templates.isEmpty()) {
                    for (Map.Entry entry : templates.entrySet()) {
                        Collection cons;
                        StringBuilder sb;
                        uri = (URI)entry.getKey();
                        Map map = (Map)entry.getValue();
                        file = Utilities.toFile((URI)uri);
                        fo = FileUtil.toFileObject((File)file);
                        if (fo == null) continue;
                        elementDocument = support.createDocument(fo);
                        for (String template : map.keySet()) {
                            Object controller = (AngularJsController.ModuleConfigRegistration)map.get(template);
                            sb = new StringBuilder();
                            sb.append(template).append(":").append(((AngularJsController.ModuleConfigRegistration)controller).getControllerName());
                            if (((AngularJsController.ModuleConfigRegistration)controller).getControllerAsName() != null) {
                                sb.append(":").append(((AngularJsController.ModuleConfigRegistration)controller).getControllerAsName());
                            }
                            elementDocument.addPair(AngularJsIndexer.FIELD_TEMPLATE_CONTROLLER, sb.toString(), true, true);
                        }
                        if (controls != null && (cons = (Collection)controls.get(uri)) != null) {
                            for (Object controller : cons) {
                                sb = new StringBuilder();
                                sb.append(((AngularJsController)controller).getName()).append(":");
                                sb.append(((AngularJsController)controller).getFqn()).append(":");
                                sb.append(((AngularJsController)controller).getOffset());
                                elementDocument.addPair(AngularJsIndexer.FIELD_CONTROLLER, sb.toString(), true, true);
                            }
                            controls.remove(uri);
                        }
                        support.addDocument(elementDocument);
                    }
                }
                if (controls != null && !controls.isEmpty()) {
                    for (Map.Entry entry : controls.entrySet()) {
                        uri = (URI)entry.getKey();
                        collection = (Collection)entry.getValue();
                        file = Utilities.toFile((URI)uri);
                        fo = FileUtil.toFileObject((File)file);
                        if (fo == null) continue;
                        elementDocument = support.createDocument(fo);
                        for (AngularJsController controller : collection) {
                            StringBuilder sb = new StringBuilder();
                            sb.append(controller.getName()).append(":");
                            sb.append(controller.getFqn()).append(":");
                            sb.append(controller.getOffset());
                            elementDocument.addPair(AngularJsIndexer.FIELD_CONTROLLER, sb.toString(), true, true);
                        }
                        support.addDocument(elementDocument);
                    }
                }
                if (comps != null && !comps.isEmpty()) {
                    for (Map.Entry entry : comps.entrySet()) {
                        uri = (URI)entry.getKey();
                        collection = (Collection)entry.getValue();
                        file = Utilities.toFile((URI)uri);
                        fo = FileUtil.toFileObject((File)file);
                        if (fo == null) continue;
                        elementDocument = support.createDocument(fo);
                        for (String componentName : collection) {
                            elementDocument.addPair(AngularJsIndexer.FIELD_COMPONENT, componentName, true, true);
                        }
                        support.addDocument(elementDocument);
                    }
                }
            }
        }
    }

    public static final class Factory
    extends EmbeddingIndexerFactory {
        public static final String NAME = "angular";
        public static final int VERSION = 3;
        private static final int PRIORITY = 200;
        private static final ThreadLocal<Collection<Runnable>> postScanTasks = new ThreadLocal();

        public EmbeddingIndexer createIndexer(Indexable indexable, Snapshot snapshot) {
            if (this.isIndexable(indexable, snapshot)) {
                return new AngularJsIndexer();
            }
            return null;
        }

        public void filesDeleted(Iterable<? extends Indexable> deleted, Context context) {
            try {
                IndexingSupport is = IndexingSupport.getInstance((Context)context);
                for (Indexable indexable : deleted) {
                    is.removeDocuments(indexable);
                }
            }
            catch (IOException ioe) {
                LOG.log(Level.WARNING, null, ioe);
            }
        }

        public void filesDirty(Iterable<? extends Indexable> dirty, Context context) {
        }

        public String getIndexerName() {
            return NAME;
        }

        public int getIndexVersion() {
            return 3;
        }

        private boolean isIndexable(Indexable indexable, Snapshot snapshot) {
            return "text/javascript".equals(snapshot.getMimeType());
        }

        public boolean scanStarted(Context context) {
            postScanTasks.set(new LinkedList());
            controllers.set(new HashMap());
            templateControllers.set(new HashMap());
            components.set(new HashMap());
            addedToJsIndexPost.set(Boolean.FALSE);
            return super.scanStarted(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scanFinished(Context context) {
            try {
                for (Runnable task : postScanTasks.get()) {
                    task.run();
                }
            }
            finally {
                postScanTasks.remove();
                super.scanFinished(context);
            }
        }

        public static boolean isScannerThread() {
            return postScanTasks.get() != null;
        }

        public static void addPostScanTask(@NonNull Runnable task) {
            Parameters.notNull((CharSequence)"task", (Object)task);
            Collection<Runnable> tasks = postScanTasks.get();
            if (tasks == null) {
                throw new IllegalStateException("JsIndexer.postScanTask can be called only from scanner thread.");
            }
            tasks.add(task);
        }

        public int getPriority() {
            return 200;
        }
    }
}

