/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.overrides;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.navigation.overrides.AnnotationsHolder;
import org.netbeans.modules.cnd.navigation.overrides.BaseAnnotation;
import org.netbeans.modules.cnd.navigation.overrides.ComputeAnnotations;
import org.netbeans.modules.cnd.utils.ui.NamedOption;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.IndexingAwareParserResultTask;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;
import org.netbeans.modules.parsing.spi.TaskIndexingMode;
import org.netbeans.modules.parsing.spi.support.CancelSupport;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class OverrideTaskFactory
extends IndexingAwareParserResultTask<Parser.Result> {
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.cnd.model.tasks");
    private static final RequestProcessor RP = new RequestProcessor("OverrideTaskFactory runner", 1);
    private static final int TASK_DELAY = OverrideTaskFactory.getInt("cnd.overrides.delay", 500);
    private final CancelSupport cancel = CancelSupport.create((SchedulerTask)this);
    private AtomicBoolean canceled = new AtomicBoolean(false);
    private Parser.Result lastParserResult;

    public OverrideTaskFactory(String mimeType) {
        super(TaskIndexingMode.ALLOWED_DURING_SCAN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Parser.Result result, SchedulerEvent event) {
        OverrideTaskFactory overrideTaskFactory = this;
        synchronized (overrideTaskFactory) {
            if (this.lastParserResult == result) {
                return;
            }
            this.canceled.set(true);
            this.canceled = new AtomicBoolean(false);
            if (this.cancel.isCancelled()) {
                this.lastParserResult = null;
                return;
            }
            this.lastParserResult = result;
        }
        FileObject fo = result.getSnapshot().getSource().getFileObject();
        if (fo == null) {
            return;
        }
        Document doc = result.getSnapshot().getSource().getDocument(false);
        if (!(doc instanceof StyledDocument)) {
            return;
        }
        if (doc.getProperty("macro-expansion-view-document") != null) {
            return;
        }
        CsmFile csmFile = CsmFileInfoQuery.getDefault().getCsmFile(result);
        if (csmFile == null) {
            return;
        }
        DataObject dobj = null;
        try {
            dobj = DataObject.find((FileObject)fo);
        }
        catch (DataObjectNotFoundException ex) {
            ex.printStackTrace(System.err);
        }
        if (dobj == null) {
            return;
        }
        if (this.canceled.get()) {
            return;
        }
        long time = 0L;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "OverrideTaskFactory started");
            time = System.currentTimeMillis();
        }
        RP.post((Runnable)new RunnerImpl(dobj, csmFile, (StyledDocument)doc, this.canceled, time + (long)TASK_DELAY), TASK_DELAY);
    }

    public int getPriority() {
        return 2000;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.EDITOR_SENSITIVE_TASK_SCHEDULER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancel() {
        OverrideTaskFactory overrideTaskFactory = this;
        synchronized (overrideTaskFactory) {
            this.canceled.set(true);
            this.lastParserResult = null;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "OverrideTaskFactory cancelled");
        }
    }

    private static boolean isEnabled() {
        return NamedOption.getAccessor().getBoolean("overrides-annotations");
    }

    private static int getInt(String name, int result) {
        String text = System.getProperty(name);
        if (text != null) {
            try {
                result = Integer.parseInt(text);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    public static final class OverrideTaskFactoryImpl
    extends TaskFactory {
        public Collection<? extends SchedulerTask> create(Snapshot snapshot) {
            return Collections.singletonList(new OverrideTaskFactory(snapshot.getMimeType()));
        }
    }

    public static final class OverrideOptions
    extends NamedOption {
        private static final String NAME = "overrides-annotations";

        public String getName() {
            return NAME;
        }

        public NamedOption.OptionKind getKind() {
            return NamedOption.OptionKind.Boolean;
        }

        public Object getDefaultValue() {
            return true;
        }

        public String getDisplayName() {
            return NbBundle.getMessage(OverrideTaskFactory.class, (String)"Show-overrides-annotations");
        }

        public String getDescription() {
            return NbBundle.getMessage(OverrideTaskFactory.class, (String)"Show-overrides-annotations-AD");
        }
    }

    private static final class RunnerImpl
    implements Runnable {
        private final DataObject dobj;
        private final CsmFile file;
        private final Reference<StyledDocument> weakDoc;
        private final AtomicBoolean canceled;
        private final long time;

        private RunnerImpl(DataObject dobj, CsmFile file, StyledDocument doc, AtomicBoolean canceled, long time) {
            this.dobj = dobj;
            this.file = file;
            this.weakDoc = new WeakReference<StyledDocument>(doc);
            this.canceled = canceled;
            this.time = time;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (!OverrideTaskFactory.isEnabled()) {
                    AnnotationsHolder.clearIfNeed(this.dobj);
                    return;
                }
                if (this.canceled.get()) {
                    return;
                }
                StyledDocument doc = this.weakDoc.get();
                if (doc != null) {
                    this.addAnnotations(this.file, doc, this.dobj, this.canceled);
                }
            }
            finally {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "OverrideTaskFactory finished for {0}ms", System.currentTimeMillis() - this.time);
                }
            }
        }

        private void addAnnotations(CsmFile file, StyledDocument doc, DataObject dobj, AtomicBoolean canceled) {
            ArrayList<BaseAnnotation> toAdd = new ArrayList<BaseAnnotation>();
            BaseAnnotation.LOGGER.log(Level.FINE, ">> Computing annotations for {0}", file);
            long time = System.currentTimeMillis();
            ComputeAnnotations.getInstance(file, doc, canceled).computeAnnotations(toAdd);
            time = System.currentTimeMillis() - time;
            BaseAnnotation.LOGGER.log(Level.FINE, "<< Computed annotations for {0} in {1} ms", new Object[]{file, time});
            if (canceled.get()) {
                return;
            }
            AnnotationsHolder.get(dobj).setNewAnnotations(toAdd);
        }

        public String toString() {
            if (this.file == null) {
                return "OverrideTaskFactory runner";
            }
            return "OverrideTaskFactory runner for " + this.file.getAbsolutePath();
        }
    }
}

