/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.core.parser.html;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.mylyn.internal.wikitext.core.parser.html.DocumentProcessor;
import org.eclipse.mylyn.internal.wikitext.core.util.css.CssParser;
import org.eclipse.mylyn.internal.wikitext.core.util.css.CssRule;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Selector;

public class RemoveExcessiveStylesProcessor
extends DocumentProcessor {
    @Override
    public void process(Document document) {
        Element body = document.body();
        CssParser cssParser = new CssParser();
        for (Element element : Selector.select((String)"[style], font, span", (Element)body)) {
            String color;
            String style = element.attr("style");
            String newStyle = "";
            List<CssRule> rules = null;
            if (style != null && style.length() > 0) {
                rules = cssParser.parseBlockContent(style);
                Iterator<CssRule> ruleIt = rules.iterator();
                while (ruleIt.hasNext()) {
                    CssRule rule = ruleIt.next();
                    if ("color".equals(rule.name) ? !rule.value.equalsIgnoreCase("black") && !rule.value.equals("#010101") : ("font-weight".equals(rule.name) ? rule.value.equalsIgnoreCase("bold") || rule.value.equalsIgnoreCase("bolder") : "font-style".equals(rule.name) && (rule.value.equalsIgnoreCase("bold") || rule.value.equalsIgnoreCase("italic")))) continue;
                    ruleIt.remove();
                }
            }
            if ("font".equalsIgnoreCase(element.nodeName()) && (color = element.attr("color")) != null && color.trim().length() > 0) {
                if (rules == null) {
                    rules = new ArrayList<CssRule>(1);
                }
                rules.add(new CssRule("color", color.trim(), 0, 0, 0, 0));
            }
            if (rules != null) {
                for (CssRule rule : rules) {
                    newStyle = String.valueOf(newStyle) + rule.name + ": " + rule.value + ";";
                }
            }
            if (newStyle.length() > 0) {
                if ("font".equalsIgnoreCase(element.nodeName())) {
                    Element spanElement = document.createElement("span");
                    for (Node child : new ArrayList(element.childNodes())) {
                        child.remove();
                        spanElement.appendChild(child);
                    }
                    element.before((Node)spanElement);
                    element.remove();
                    element = spanElement;
                }
                element.attr("style", newStyle);
                continue;
            }
            element.removeAttr("style");
            if (!"span".equalsIgnoreCase(element.nodeName()) && !"font".equalsIgnoreCase(element.nodeName())) continue;
            this.removeElementPreserveChildren(element);
        }
    }

    private void removeElementPreserveChildren(Element element) {
        Element parent = element.parent();
        for (Node child : new ArrayList(element.childNodes())) {
            child.remove();
            element.before(child);
        }
        element.remove();
        if (parent != null) {
            RemoveExcessiveStylesProcessor.normalizeTextNodes(parent);
        }
    }
}

