/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.util;

import java.awt.Color;
import java.awt.EventQueue;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JEditorPane;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.OutputLogger;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SubversionVCS;
import org.netbeans.modules.subversion.SvnFileNode;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.VersionsCache;
import org.netbeans.modules.subversion.WorkingCopyAttributesCache;
import org.netbeans.modules.subversion.client.PropertiesClient;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.options.AnnotationExpression;
import org.netbeans.modules.subversion.ui.blame.BlameAction;
import org.netbeans.modules.subversion.ui.commit.CommitOptions;
import org.netbeans.modules.subversion.ui.history.SearchHistoryAction;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.util.FileSelector;
import org.netbeans.modules.versioning.util.IndexingBridge;
import org.netbeans.modules.versioning.util.ProjectUtilities;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNInfoUnversioned;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNStatusUnversioned;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.utils.SVNUrlUtils;

public class SvnUtils {
    public static final String SVN_ADMIN_DIR;
    public static final String SVN_ENTRIES_DIR;
    public static final String SVN_WC_DB;
    private static final Pattern metadataPattern;
    public static final HashSet<Character> autoEscapedCharacters;
    private static Reference<Context> contextCached;
    private static Reference<Node[]> contextNodesCached;
    private static final FileFilter svnFileFilter;
    private static final ThreadLocal<Map<File, ISVNInfo>> infoCache;
    private static final ThreadLocal<Map<File, ISVNStatus>> statusCache;
    private static final int STATUS_RECURSIVELY_TRAVERSIBLE = -4;
    private static Logger TY9_LOG;
    static ThreadLocal<Set<File>> indexingFiles;

    public static String createAnnotationFormat(String format) {
        String string = format;
        string = Utils.skipUnsupportedVariables((String)string, (String[])new String[]{"{status}", "{lock}", "{folder}", "{revision}", "{mime_type}", "{commit_revision}", "{date}", "{author}"});
        string = string.replaceAll("\\{revision\\}", "\\{0\\}");
        string = string.replaceAll("\\{status\\}", "\\{1\\}");
        string = string.replaceAll("\\{folder\\}", "\\{2\\}");
        string = string.replaceAll("\\{lock\\}", "\\{3\\}");
        string = string.replaceAll("\\{mime_type\\}", "\\{4\\}");
        string = string.replaceAll("\\{commit_revision\\}", "\\{5\\}");
        string = string.replaceAll("\\{date\\}", "\\{6\\}");
        string = string.replaceAll("\\{author\\}", "\\{7\\}");
        return string;
    }

    public static SVNUrl decodeAndEncodeUrl(SVNUrl url) throws MalformedURLException {
        return SvnUtils.encodeUrl(SvnUtils.decodeToString(url));
    }

    private static SVNUrl encodeUrl(String url) throws MalformedURLException {
        url = url.replace("%20", " ");
        StringBuilder sb = new StringBuilder(url.length());
        for (int i = 0; i < url.length(); ++i) {
            Character c = Character.valueOf(url.charAt(i));
            if (autoEscapedCharacters.contains(c)) {
                char[] chars = Character.toChars(c.charValue());
                for (int j = 0; j < chars.length; ++j) {
                    sb.append('%');
                    sb.append(Integer.toHexString(chars[j]).toUpperCase());
                }
                continue;
            }
            sb.append(c);
        }
        return new SVNUrl(sb.toString());
    }

    public static Context getCurrentContext(Node[] nodes) {
        Context ctx;
        if (nodes == null) {
            nodes = TopComponent.getRegistry().getActivatedNodes();
        }
        if (Arrays.equals(contextNodesCached.get(), nodes) && (ctx = contextCached.get()) != null) {
            return ctx;
        }
        VCSContext vcsCtx = VCSContext.forNodes((Node[])nodes);
        Context ctx2 = new Context(new ArrayList<File>(vcsCtx.computeFiles(svnFileFilter)), new ArrayList<File>(vcsCtx.getRootFiles()), new ArrayList<File>(vcsCtx.getExclusions()));
        contextCached = new WeakReference<Context>(ctx2);
        contextNodesCached = new WeakReference<Node[]>(nodes);
        return ctx2;
    }

    public static Context getCurrentContext(Node[] nodes, int includingFileStatus, int includingFolderStatus, boolean fromCache) {
        Context context = SvnUtils.getCurrentContext(nodes);
        FileStatusCache cache = Subversion.getInstance().getStatusCache();
        File[] files = context.getRootFiles();
        for (int i = 0; i < files.length; ++i) {
            int status;
            File file = files[i];
            FileInformation fi = fromCache ? cache.getCachedStatus(file) : cache.getStatus(file);
            Boolean isDirectory = null;
            if (fi != null) {
                status = fi.getStatus();
                isDirectory = fi.isDirectory();
            } else {
                status = 8;
            }
            if (!(Boolean.TRUE.equals(isDirectory) || isDirectory == null && file.isDirectory() ? (status & includingFolderStatus) == 0 : (status & includingFileStatus) == 0)) continue;
            return Context.Empty;
        }
        return context;
    }

    public static Context getCurrentContext(Node[] nodes, int includingFileStatus, int includingFolderStatus) {
        return SvnUtils.getCurrentContext(nodes, includingFileStatus, includingFolderStatus, false);
    }

    public static boolean isAnnotationFormatValid(String format) {
        boolean retval = true;
        if (format != null) {
            try {
                new MessageFormat(format);
            }
            catch (IllegalArgumentException ex) {
                Subversion.LOG.log(Level.FINER, "Bad user input - annotation format", ex);
                retval = false;
            }
        }
        return retval;
    }

    public static boolean isVersionedProject(Node node, boolean checkStatus) {
        Lookup lookup = node.getLookup();
        Project project = (Project)lookup.lookup(Project.class);
        return SvnUtils.isVersionedProject(project, checkStatus);
    }

    public static boolean isVersionedProject(Project project, boolean checkStatus) {
        if (project != null) {
            FileStatusCache cache = Subversion.getInstance().getStatusCache();
            Sources sources = ProjectUtils.getSources((Project)project);
            SourceGroup[] sourceGroups = sources.getSourceGroups("generic");
            for (int j = 0; j < sourceGroups.length; ++j) {
                SourceGroup sourceGroup = sourceGroups[j];
                File f = FileUtil.toFile((FileObject)sourceGroup.getRootFolder());
                if (f == null) continue;
                if (checkStatus && (cache.getStatus(f).getStatus() & 0xFFFFFFFE) != 0) {
                    return true;
                }
                if (checkStatus || !SvnUtils.isManaged(f)) continue;
                return true;
            }
        }
        return false;
    }

    public static void addProjectFiles(Collection<File> filteredFiles, Collection<File> rootFiles, Collection<File> rootFilesExclusions, Project project) {
        FileStatusCache cache = Subversion.getInstance().getStatusCache();
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroups = sources.getSourceGroups("generic");
        for (int j = 0; j < sourceGroups.length; ++j) {
            SourceGroup sourceGroup = sourceGroups[j];
            FileObject srcRootFo = sourceGroup.getRootFolder();
            File rootFile = FileUtil.toFile((FileObject)srcRootFo);
            if (rootFile == null || (cache.getStatus(rootFile).getStatus() & 0xFFFFFFFE) == 0) continue;
            rootFiles.add(rootFile);
            boolean containsSubprojects = false;
            FileObject[] rootChildren = srcRootFo.getChildren();
            HashSet<File> projectFiles = new HashSet<File>(rootChildren.length);
            for (int i = 0; i < rootChildren.length; ++i) {
                File child;
                FileObject rootChildFo = rootChildren[i];
                if (SvnUtils.isAdministrative(rootChildFo.getNameExt()) || (child = FileUtil.toFile((FileObject)rootChildFo)) == null) continue;
                if (sourceGroup.contains(rootChildFo)) {
                    projectFiles.add(child);
                    continue;
                }
                int status = cache.getStatus(child).getStatus();
                if (status == 2) continue;
                rootFilesExclusions.add(child);
                containsSubprojects = true;
            }
            if (containsSubprojects) {
                filteredFiles.addAll(projectFiles);
                continue;
            }
            filteredFiles.add(rootFile);
        }
    }

    public static Context getProjectsContext(Project[] projects) {
        ArrayList<File> filtered = new ArrayList<File>();
        ArrayList<File> roots = new ArrayList<File>();
        ArrayList<File> exclusions = new ArrayList<File>();
        for (int i = 0; i < projects.length; ++i) {
            SvnUtils.addProjectFiles(filtered, roots, exclusions, projects[i]);
        }
        return new Context(filtered, roots, exclusions);
    }

    public static File[] toFileArray(Collection<FileObject> fileObjects) {
        HashSet<File> files = new HashSet<File>(fileObjects.size() * 4 / 3 + 1);
        Iterator<FileObject> i = fileObjects.iterator();
        while (i.hasNext()) {
            File f = FileUtil.toFile((FileObject)i.next());
            if (f == null) continue;
            files.add(f);
        }
        files.remove(null);
        return files.toArray(new File[files.size()]);
    }

    public static boolean isParentOrEqual(File parent, File file) {
        while (file != null) {
            if (file.equals(parent)) {
                return true;
            }
            file = file.getParentFile();
        }
        return false;
    }

    public static boolean isAdministrative(File file) {
        String name = file.getName();
        boolean administrative = SvnUtils.isAdministrative(name);
        return administrative && !file.exists() || administrative && file.exists() && file.isDirectory();
    }

    public static boolean isAdministrative(String fileName) {
        return fileName.equals(SVN_ADMIN_DIR);
    }

    public static boolean isManaged(File file) {
        return VersioningSupport.getOwner((File)file) instanceof SubversionVCS && !SvnUtils.isPartOfSubversionMetadata(file);
    }

    public static String previousRevision(String revision) {
        return revision == null ? null : Long.toString(Long.parseLong(revision) - 1L);
    }

    public static String getRelativePath(File file) throws SVNClientException {
        String repositoryPath = null;
        ArrayList<String> path = new ArrayList<String>();
        SVNUrl repositoryURL = null;
        boolean fileIsManaged = false;
        File lastManaged = file;
        SvnClient client = Subversion.getInstance().getClient(false);
        while (SvnUtils.isManaged(file)) {
            ISVNInfo info;
            block12: {
                fileIsManaged = true;
                info = null;
                try {
                    info = SvnUtils.getInfoFromWorkingCopy(client, file, true);
                }
                catch (SVNClientException ex) {
                    if (SvnClientExceptionHandler.isUnversionedResource(ex.getMessage())) break block12;
                    if (WorkingCopyAttributesCache.getInstance().isSuppressed(ex)) {
                        WorkingCopyAttributesCache.getInstance().logSuppressed(ex, file);
                    }
                    SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
                }
            }
            if (info != null && info.getUrl() != null) {
                String fileLink = SvnUtils.decodeToString(info.getUrl());
                repositoryURL = info.getRepository();
                String repositoryLink = SvnUtils.decodeToString(repositoryURL);
                if (fileLink != null && repositoryLink != null) {
                    try {
                        repositoryPath = fileLink.substring(repositoryLink.length());
                    }
                    catch (StringIndexOutOfBoundsException ex) {
                        Subversion.LOG.log(Level.INFO, "repoUrl: " + repositoryURL.toString() + "\nfileURL: " + fileLink, ex);
                        throw ex;
                    }
                    Iterator it = path.iterator();
                    StringBuilder sb = new StringBuilder();
                    while (it.hasNext()) {
                        String segment = (String)it.next();
                        sb.append("/");
                        sb.append(segment);
                    }
                    repositoryPath = repositoryPath + sb.toString();
                    break;
                }
            }
            path.add(0, file.getName());
            File parent = file.getParentFile();
            lastManaged = file;
            if (parent == null) break;
            file = parent;
        }
        if (repositoryURL == null && fileIsManaged) {
            Subversion.LOG.log(Level.WARNING, "no repository url found for managed file {0}", new Object[]{lastManaged});
            if (new File(lastManaged, SVN_WC_DB).canRead()) {
                throw new SVNClientException(NbBundle.getMessage(SvnUtils.class, (String)"MSG_too_old_client", (Object)lastManaged));
            }
            throw new SVNClientException(NbBundle.getMessage(SvnUtils.class, (String)"MSG_too_old_WC"));
        }
        if (!fileIsManaged) {
            Subversion.LOG.log(Level.INFO, "no repository url found for not managed file {0}", new Object[]{lastManaged});
        }
        return repositoryPath;
    }

    public static SVNUrl getRepositoryRootUrl(File file) throws SVNClientException {
        SvnClient client = Subversion.getInstance().getClient(false);
        SVNUrl repositoryURL = null;
        boolean fileIsManaged = false;
        File lastManaged = file;
        SVNClientException e = null;
        while (SvnUtils.isManaged(file)) {
            ISVNInfo info;
            block9: {
                fileIsManaged = true;
                info = null;
                try {
                    e = null;
                    info = SvnUtils.getInfoFromWorkingCopy(client, file, true);
                }
                catch (SVNClientException ex) {
                    if (SvnClientExceptionHandler.isUnversionedResource(ex.getMessage())) break block9;
                    if (WorkingCopyAttributesCache.getInstance().isSuppressed(ex)) {
                        WorkingCopyAttributesCache.getInstance().logSuppressed(ex, file);
                    }
                    SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
                    e = ex;
                }
            }
            if (info != null && (repositoryURL = SvnUtils.decode(info.getRepository())) != null) break;
            File parent = file.getParentFile();
            lastManaged = file;
            if (parent == null) break;
            file = parent;
        }
        if (repositoryURL == null && fileIsManaged) {
            if (e != null) {
                throw e;
            }
            Subversion.LOG.log(Level.WARNING, "no repository url found for managed file {0}", new Object[]{lastManaged});
            if (new File(lastManaged, SVN_WC_DB).canRead()) {
                throw new SVNClientException(NbBundle.getMessage(SvnUtils.class, (String)"MSG_too_old_client", (Object)lastManaged));
            }
            throw new SVNClientException(NbBundle.getMessage(SvnUtils.class, (String)"MSG_too_old_WC"));
        }
        if (!fileIsManaged) {
            Subversion.LOG.log(Level.INFO, "no repository url found for not managed file {0}", new Object[]{lastManaged});
            Level oldLevel = Subversion.LOG.getLevel();
            Subversion.LOG.setLevel(Level.FINE);
            Subversion.LOG.log(Level.INFO, "getRepositoryRootUrl: file {0} {1}", new Object[]{lastManaged, VersioningSupport.getOwner((File)lastManaged)});
            Subversion.LOG.setLevel(oldLevel);
            if (!lastManaged.exists()) {
                Subversion.LOG.log(Level.INFO, "getRepositoryRootUrl: file {0} does not exist", new Object[]{lastManaged});
            }
        }
        return repositoryURL;
    }

    public static SVNUrl getRepositoryUrl(File file) throws SVNClientException {
        StringBuilder path = new StringBuilder();
        SVNUrl fileURL = null;
        SvnClient client = null;
        try {
            client = Subversion.getInstance().getClient(false);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
            return null;
        }
        boolean fileIsManaged = false;
        File lastManaged = file;
        SVNClientException e = null;
        while (SvnUtils.isManaged(file)) {
            ISVNInfo info;
            block15: {
                block14: {
                    fileIsManaged = true;
                    e = null;
                    try {
                        ISVNStatus status = SvnUtils.getSingleStatus(client, file);
                        if (status != null && (fileURL = SvnUtils.decode(status.getUrl())) != null) {
                            break;
                        }
                    }
                    catch (SVNClientException ex) {
                        if (SvnClientExceptionHandler.isUnversionedResource(ex.getMessage())) break block14;
                        if (WorkingCopyAttributesCache.getInstance().isSuppressed(ex)) {
                            WorkingCopyAttributesCache.getInstance().logSuppressed(ex, file);
                        }
                        SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
                        e = ex;
                    }
                }
                info = null;
                try {
                    info = SvnUtils.getInfoFromWorkingCopy(client, file, true);
                }
                catch (SVNClientException ex) {
                    if (SvnClientExceptionHandler.isUnversionedResource(ex.getMessage())) break block15;
                    SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
                }
            }
            if (info != null && (fileURL = SvnUtils.decode(info.getUrl())) != null) break;
            path.insert(0, file.getName()).insert(0, "/");
            File parent = file.getParentFile();
            lastManaged = file;
            if (parent == null) break;
            file = parent;
        }
        if (fileURL == null && fileIsManaged) {
            if (e != null) {
                throw e;
            }
            Subversion.LOG.log(Level.WARNING, "no repository url found for managed file {0}", new Object[]{lastManaged});
            if (new File(lastManaged, SVN_WC_DB).canRead()) {
                throw new SVNClientException(NbBundle.getMessage(SvnUtils.class, (String)"MSG_too_old_client", (Object)lastManaged));
            }
            throw new SVNClientException(NbBundle.getMessage(SvnUtils.class, (String)"MSG_too_old_WC"));
        }
        if (!fileIsManaged) {
            Subversion.LOG.log(Level.INFO, "no repository url found for not managed file {0}", new Object[]{lastManaged});
        }
        if (path.length() > 0) {
            fileURL = fileURL.appendPath(path.toString());
        }
        return fileURL;
    }

    public static Map<File, SVNUrl> getRepositoryUrls(File root) throws SVNClientException {
        HashMap<File, SVNUrl> ret;
        block6: {
            SVNUrl fileURL = null;
            SvnClient client = null;
            try {
                client = Subversion.getInstance().getClient(false);
            }
            catch (SVNClientException ex) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
                return null;
            }
            ret = new HashMap<File, SVNUrl>();
            try {
                ISVNStatus[] statuses;
                for (ISVNStatus status : statuses = client.getStatus(root, true, true)) {
                    if (status == null || (fileURL = SvnUtils.decode(status.getUrl())) == null) continue;
                    ret.put(status.getFile(), fileURL);
                }
            }
            catch (SVNClientException ex) {
                if (SvnClientExceptionHandler.isUnversionedResource(ex.getMessage())) break block6;
                if (WorkingCopyAttributesCache.getInstance().isSuppressed(ex)) {
                    WorkingCopyAttributesCache.getInstance().logSuppressed(ex, root);
                }
                SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
            }
        }
        return ret;
    }

    public static ISVNStatus getSingleStatus(SvnClient client, File file) throws SVNClientException {
        ISVNStatus status = null;
        Map<File, ISVNStatus> cache = statusCache.get();
        if (cache != null && (status = cache.get(file)) != null) {
            return status;
        }
        try {
            status = client.getSingleStatus(file);
        }
        catch (SVNClientException ex) {
            if (SvnClientExceptionHandler.isUnversionedResource(ex.getMessage())) {
                status = new SVNStatusUnversioned(file);
            }
            throw ex;
        }
        if (cache != null) {
            cache.put(file, status);
        }
        return status;
    }

    public static SVNUrl decode(SVNUrl url) {
        try {
            String decoded = SvnUtils.decodeToString(url);
            return decoded == null ? null : new SVNUrl(decoded);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static String decodeToString(SVNUrl url) {
        if (url == null) {
            return null;
        }
        return SvnUtils.decodeToString(url.toString());
    }

    public static String decodeToString(String url) {
        if (url == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(url.length());
        boolean inQuery = false;
        for (int i = 0; i < url.length(); ++i) {
            char c = url.charAt(i);
            if (c == '?') {
                inQuery = true;
                continue;
            }
            if (c == '+' && inQuery) {
                sb.append(' ');
                continue;
            }
            if (SvnUtils.isEncodedByte(c, url, i)) {
                ArrayList<Byte> byteList = new ArrayList<Byte>();
                do {
                    byteList.add((byte)Integer.parseInt(url.substring(i + 1, i + 3), 16));
                } while ((i += 3) < url.length() && SvnUtils.isEncodedByte(c = url.charAt(i), url, i));
                if (byteList.size() <= 0) continue;
                byte[] bytes = new byte[byteList.size()];
                for (int ib = 0; ib < byteList.size(); ++ib) {
                    bytes[ib] = (Byte)byteList.get(ib);
                }
                try {
                    sb.append(new String(bytes, "UTF8"));
                }
                catch (Exception e) {
                    Subversion.LOG.log(Level.INFO, null, e);
                }
                --i;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static boolean isEncodedByte(char c, String s, int i) {
        return c == '%' && i + 2 < s.length() && SvnUtils.isHexDigit(s.charAt(i + 1)) && SvnUtils.isHexDigit(s.charAt(i + 2));
    }

    private static boolean isHexDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    public static String getRepositoryPath(File file) throws SVNClientException {
        SVNUrl url = SvnUtils.getRepositoryUrl(file);
        SVNUrl rootUrl = SvnUtils.getRepositoryRootUrl(file);
        return SvnUtils.decodeToString(SVNUrlUtils.getRelativePath((SVNUrl)rootUrl, (SVNUrl)url, (boolean)true));
    }

    public static boolean isBinary(byte[] buffer) {
        for (int i = 0; i < buffer.length; ++i) {
            byte ch = buffer[i];
            if (ch >= 32 || ch == 9 || ch == 10 || ch == 13) continue;
            return true;
        }
        return false;
    }

    public static SVNUrl getCopiedUrl(File f) {
        block3: {
            try {
                ISVNInfo info = SvnUtils.getInfoFromWorkingCopy(Subversion.getInstance().getClient(false), f);
                if (info != null) {
                    return info.getCopyUrl();
                }
            }
            catch (SVNClientException e) {
                if (WorkingCopyAttributesCache.getInstance().isSuppressed(e)) break block3;
                Subversion.LOG.log(Level.INFO, null, e);
            }
        }
        return null;
    }

    public static String fixLineEndings(String text) {
        return text.replaceAll("\r\n", "\n").replace('\r', '\n');
    }

    public static boolean hasMetadata(File file) {
        return new File(file, SVN_ENTRIES_DIR).canRead() || new File(file, SVN_WC_DB).canRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runWithInfoCache(Runnable runnable) {
        Map<File, ISVNInfo> infos = infoCache.get();
        Map<File, ISVNStatus> statuses = statusCache.get();
        if (infos == null || statuses == null) {
            infos = new HashMap<File, ISVNInfo>();
            infoCache.set(infos);
            statuses = new HashMap<File, ISVNStatus>();
            statusCache.set(statuses);
            try {
                runnable.run();
            }
            finally {
                infoCache.remove();
                statusCache.remove();
            }
        } else {
            runnable.run();
        }
    }

    public static ISVNInfo getInfoFromWorkingCopy(SvnClient client, File file) throws SVNClientException {
        return SvnUtils.getInfoFromWorkingCopy(client, file, false);
    }

    private static ISVNInfo getInfoFromWorkingCopy(SvnClient client, File file, boolean cannonicalize) throws SVNClientException {
        ISVNInfo info = null;
        Map<File, ISVNInfo> cache = infoCache.get();
        if (cache != null && (info = cache.get(file)) != null) {
            return info;
        }
        try {
            info = client.getInfoFromWorkingCopy(file);
        }
        catch (SVNClientException ex) {
            if (SvnClientExceptionHandler.isUnversionedResource(ex.getMessage())) {
                if (!cannonicalize) {
                    info = new SVNInfoUnversioned(file);
                }
            }
            throw ex;
        }
        if (info == null) {
            try {
                info = client.getInfoFromWorkingCopy(file.getCanonicalFile());
            }
            catch (IOException ex) {
                Subversion.LOG.log(Level.INFO, "getInfoFromWorkingCopy", ex);
            }
            catch (SVNClientException ex) {
                if (SvnClientExceptionHandler.isUnversionedResource(ex.getMessage())) {
                    info = new SVNInfoUnversioned(file);
                }
                throw ex;
            }
        }
        if (cache != null && info != null) {
            cache.put(file, info);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rollback(File file, SVNUrl repoUrl, SVNUrl fileUrl, SVNRevision revision, boolean wasDeleted, OutputLogger logger) {
        if (wasDeleted) {
            if (file.exists()) {
                try {
                    SvnClient client = Subversion.getInstance().getClient(false);
                    client.remove(new File[]{file}, true);
                }
                catch (SVNClientException ex) {
                    Subversion.LOG.log(Level.SEVERE, null, ex);
                }
                Subversion.getInstance().getStatusCache().refresh(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
            }
            return;
        }
        File parent = file.getParentFile();
        parent.mkdirs();
        OutputStream os = null;
        InputStream is = null;
        try {
            File oldFile = VersionsCache.getInstance().getFileRevision(repoUrl, fileUrl, revision.toString(), file.getName());
            FileObject fo = FileUtil.toFileObject((File)file);
            if (fo == null) {
                fo = FileUtil.toFileObject((File)parent).createData(file.getName());
            } else {
                SvnUtils.saveIfModified(fo);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            os = fo.getOutputStream();
            is = FileUtil.toFileObject((File)oldFile).getInputStream();
            FileUtil.copy((InputStream)is, (OutputStream)os);
        }
        catch (IOException e) {
            if (SvnUtils.refersToDirectory(e)) {
                Subversion.LOG.log(Level.FINE, null, e);
                logger.logError(NbBundle.getMessage(SearchHistoryAction.class, (String)"MSG_SummaryView.refersToDirectory", (Object)fileUrl));
            } else {
                Subversion.LOG.log(Level.SEVERE, null, e);
            }
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException ex) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    public static void saveIfModified(FileObject fo) {
        block5: {
            try {
                DataObject reqDO = DataObject.find((FileObject)fo);
                Set modifs = DataObject.getRegistry().getModifiedSet();
                if (!modifs.contains(reqDO)) break block5;
                try {
                    SaveCookie sc = (SaveCookie)reqDO.getLookup().lookup(SaveCookie.class);
                    if (sc != null) {
                        sc.save();
                    }
                }
                catch (IOException ex) {
                    Subversion.LOG.log(Level.WARNING, null, ex);
                }
            }
            catch (DataObjectNotFoundException ex) {
                Subversion.LOG.log(Level.FINE, null, ex);
            }
        }
    }

    private static boolean refersToDirectory(Exception ex) {
        boolean dir = false;
        for (Throwable t = ex; t != null && !(dir = t.getMessage().contains("refers to a directory")); t = t.getCause()) {
        }
        return dir;
    }

    public static File[] flatten(File[] files, int status) {
        LinkedList<File> ret = new LinkedList<File>();
        FileStatusCache cache = Subversion.getInstance().getStatusCache();
        for (int i = 0; i < files.length; ++i) {
            File dir = files[i];
            FileInformation info = cache.getStatus(dir);
            if ((status & info.getStatus()) != 0) {
                ret.add(dir);
            }
            File[] entries = cache.listFiles(dir);
            for (int e = 0; e < entries.length; ++e) {
                File entry = entries[e];
                info = cache.getStatus(entry);
                if ((status & info.getStatus()) == 0) continue;
                ret.add(entry);
            }
        }
        return ret.toArray(new File[ret.size()]);
    }

    public static File[] getModifiedFiles(Context context, int includeStatus) {
        File[] all = Subversion.getInstance().getStatusCache().listFiles(context, includeStatus);
        ArrayList<File> files = new ArrayList<File>();
        for (int i = 0; i < all.length; ++i) {
            File file = all[i];
            String path = file.getAbsolutePath();
            if (SvnModuleConfig.getDefault().isExcludedFromCommit(path)) continue;
            files.add(file);
        }
        FileStatusCache cache = Subversion.getInstance().getStatusCache();
        File[] rootFiles = context.getRootFiles();
        for (int i = 0; i < rootFiles.length; ++i) {
            File file = rootFiles[i];
            if (!file.isFile() || (cache.getStatus(file).getStatus() & includeStatus) == 0 || files.contains(file)) continue;
            files.add(file);
        }
        return files.toArray(new File[files.size()]);
    }

    public static boolean isPartOfSubversionMetadata(File file) {
        return metadataPattern.matcher(file.getAbsolutePath()).matches();
    }

    public static int getComparableStatus(int status) {
        if (0 != (status & 0x4040)) {
            return 0;
        }
        if (0 != (status & 0x80)) {
            return 1;
        }
        if (0 != (status & 0x800)) {
            return 10;
        }
        if (0 != (status & 0x100)) {
            return 11;
        }
        if (0 != (status & 4)) {
            return 12;
        }
        if (0 != (status & 0x1000)) {
            return 13;
        }
        if (0 != (status & 0x10010)) {
            return 14;
        }
        if (0 != (status & 0x400)) {
            return 30;
        }
        if (0 != (status & 0x200)) {
            return 31;
        }
        if (0 != (status & 0x20)) {
            return 32;
        }
        if (0 != (status & 8)) {
            return 50;
        }
        if (0 != (status & 2)) {
            return 100;
        }
        if (0 != (status & 1)) {
            return 101;
        }
        if (status == 0) {
            return 102;
        }
        throw new IllegalArgumentException("Uncomparable status: " + status);
    }

    public static String getCopy(File file) {
        SVNUrl url;
        try {
            url = SvnUtils.getRepositoryUrl(file);
        }
        catch (SVNClientException ex) {
            if (!WorkingCopyAttributesCache.getInstance().isSuppressed(ex)) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
            }
            return null;
        }
        return SvnUtils.getCopy(url, SvnModuleConfig.getDefault().getAnnotationExpresions());
    }

    public static String getCopy(SVNUrl url) {
        return SvnUtils.getCopy(url, SvnModuleConfig.getDefault().getAnnotationExpresions());
    }

    private static String getCopy(SVNUrl url, List<AnnotationExpression> annotationExpressions) {
        if (url != null && SvnModuleConfig.getDefault().isDetermineBranchesEnabled()) {
            String urlString = SvnUtils.decodeToString(url);
            Iterator<AnnotationExpression> it = annotationExpressions.iterator();
            while (it.hasNext()) {
                String name = it.next().getCopyName(urlString);
                if (name == null) continue;
                return name;
            }
        }
        return null;
    }

    public static void refreshParents(File folder) {
        if (folder == null) {
            return;
        }
        SvnUtils.refreshParents(folder.getParentFile());
        Subversion.getInstance().getStatusCache().refresh(folder, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
    }

    public static String ripUserFromHost(String host) {
        int idx = host.indexOf(64);
        if (idx < 0) {
            return host;
        }
        return host.substring(idx + 1);
    }

    public static SVNRevision getSVNRevision(String revisionString) {
        try {
            return SVNRevision.getRevision((String)revisionString);
        }
        catch (ParseException ex) {
            return new SVNRevision.Number(Long.parseLong(revisionString));
        }
    }

    public static List<String> getMatchinIgnoreParterns(List<String> patterns, String value, boolean onlyFirstMatch) {
        ArrayList<String> ret = new ArrayList<String>();
        if (patterns == null) {
            return ret;
        }
        Iterator<String> i = patterns.iterator();
        while (i.hasNext()) {
            try {
                String patternString = i.next();
                String shellPatternString = SvnUtils.regExpToFilePatterns(patternString);
                Pattern pattern = Pattern.compile(shellPatternString);
                if (!pattern.matcher(value).matches()) continue;
                ret.add(patternString);
                if (!onlyFirstMatch) continue;
                return ret;
            }
            catch (PatternSyntaxException e) {
                Subversion.LOG.log(Level.INFO, null, e);
            }
        }
        return ret;
    }

    private static String regExpToFilePatterns(String exp) {
        exp = exp.replaceAll("\\.", "\\\\.");
        exp = exp.replaceAll("\\*", ".*");
        exp = exp.replaceAll("\\?", ".");
        exp = exp.replaceAll("\\$", "\\\\\\$");
        exp = exp.replaceAll("\\^", "\\\\^");
        exp = exp.replaceAll("\\<", "\\\\<");
        exp = exp.replaceAll("\\>", "\\\\>");
        exp = SvnUtils.patchRegExpClassCharacters(exp);
        exp = exp.replaceAll("\\{", "\\\\{");
        exp = exp.replaceAll("\\}", "\\\\}");
        exp = exp.replaceAll("\\(", "\\\\(");
        exp = exp.replaceAll("\\)", "\\\\)");
        exp = exp.replaceAll("\\+", "\\\\+");
        exp = exp.replaceAll("\\|", "\\\\|");
        return exp;
    }

    private static String patchRegExpClassCharacters(String exp) {
        LinkedList<Integer> indexes = new LinkedList<Integer>();
        StringBuilder builder = new StringBuilder(exp.length());
        int index = 0;
        int builderIndex = 0;
        while (index < exp.length()) {
            char ch = exp.charAt(index);
            if (ch == '\\') {
                builder.append(ch);
                if (++index < exp.length()) {
                    ++builderIndex;
                    builder.append(exp.charAt(index));
                }
            } else if (ch == '[') {
                builder.append(ch);
                indexes.add(builderIndex);
            } else {
                if (ch == ']') {
                    if (indexes.isEmpty()) {
                        builder.append("\\");
                        ++builderIndex;
                    } else {
                        indexes.removeLast();
                    }
                }
                builder.append(ch);
            }
            ++index;
            ++builderIndex;
        }
        for (Integer index2 : indexes) {
            builder.insert((int)index2, "\\");
        }
        return builder.toString();
    }

    public static String getMimeType(File file) {
        FileObject fo = FileUtil.toFileObject((File)file);
        String foMime = fo == null ? "content/unknown" : fo.getMIMEType();
        FileStatusCache cache = Subversion.getInstance().getStatusCache();
        if ((cache.getStatus(file).getStatus() & 0x15DF8) == 0) {
            if (foMime.startsWith("text/")) {
                return foMime;
            }
            return Utils.isFileContentText((File)file) ? "text/plain" : "application/octet-stream";
        }
        PropertiesClient client = new PropertiesClient(file);
        try {
            String mimePath;
            int pos;
            byte[] mimeProperty = client.getProperties().get("svn:mime-type");
            if (mimeProperty != null && (pos = (mimePath = new String(mimeProperty)).indexOf(47)) > 0) {
                while (pos < mimePath.length()) {
                    try {
                        return MimePath.parse((String)mimePath).getPath();
                    }
                    catch (IllegalArgumentException ex) {
                        mimePath = mimePath.substring(0, mimePath.length() - 1);
                    }
                }
            }
            return Utils.isFileContentText((File)file) ? foMime : "application/octet-stream";
        }
        catch (IOException e) {
            return foMime;
        }
    }

    public static <T> boolean equals(List<T> l1, List<T> l2) {
        if (l1 == null && l2 == null) {
            return true;
        }
        if (l1 == null && l2 != null && l2.size() > 0 || l2 == null && l1 != null && l1.size() > 0) {
            return false;
        }
        if (l1.size() != l2.size()) {
            return false;
        }
        for (T t : l1) {
            if (l2.contains(t)) continue;
            return false;
        }
        return true;
    }

    public static List<File> listManagedRecursively(File root) {
        ArrayList<File> ret = new ArrayList<File>();
        if (root == null) {
            return ret;
        }
        ret.add(root);
        File[] files = root.listFiles();
        if (files != null) {
            FileStatusCache cache = Subversion.getInstance().getStatusCache();
            for (File file : files) {
                FileInformation info = cache.getCachedStatus(file);
                if (SvnUtils.isPartOfSubversionMetadata(file) || SvnUtils.isAdministrative(file) || info != null && (info.getStatus() & 0xFFFFFFFC) == 0) continue;
                if (file.isDirectory()) {
                    ret.addAll(SvnUtils.listManagedRecursively(file));
                    continue;
                }
                ret.add(file);
            }
        }
        return ret;
    }

    public static List<File> listChildren(File root) {
        ArrayList<File> ret = new ArrayList<File>();
        if (root == null) {
            return ret;
        }
        File[] files = root.listFiles();
        if (files != null) {
            for (File file : files) {
                if (SvnUtils.isPartOfSubversionMetadata(file) || SvnUtils.isAdministrative(file)) continue;
                ret.add(file);
            }
        }
        return ret;
    }

    public static SVNRevision toSvnRevision(String revision) {
        Object svnrevision = "HEAD".equals(revision) || SVNRevision.HEAD.toString().equals(revision) ? SVNRevision.HEAD : (SVNRevision.BASE.toString().equals(revision) ? SVNRevision.BASE : new SVNRevision.Number(Long.parseLong(revision)));
        return svnrevision;
    }

    public static ISVNLogMessage[] getLogMessages(ISVNClientAdapter client, SVNUrl rootUrl, String[] paths, Map<String, SVNRevision> pegRevisions, SVNRevision fromRevision, SVNRevision toRevision, boolean stopOnCopy, boolean fetchChangePath, long limit) throws SVNClientException {
        HashSet<Long> alreadyHere = new HashSet<Long>();
        ArrayList<ISVNLogMessage> ret = new ArrayList<ISVNLogMessage>();
        boolean sorted = true;
        long lastRevNum = -1L;
        for (String path : paths) {
            ISVNLogMessage[] logs;
            SVNRevision pegRevision;
            if (pegRevisions == null) {
                pegRevision = null;
            } else {
                pegRevision = pegRevisions.get(path);
                if (pegRevision == null) continue;
            }
            for (ISVNLogMessage log : logs = client.getLogMessages(rootUrl.appendPath(path), pegRevision, fromRevision, toRevision, stopOnCopy, fetchChangePath, limit)) {
                long revNum = log.getRevision().getNumber();
                if (alreadyHere.contains(revNum)) continue;
                ret.add(log);
                alreadyHere.add(revNum);
                sorted &= revNum > lastRevNum;
                lastRevNum = revNum;
            }
        }
        if (!sorted) {
            Collections.sort(ret, new Comparator<ISVNLogMessage>(){

                @Override
                public int compare(ISVNLogMessage m1, ISVNLogMessage m2) {
                    long revNum2;
                    long revNum1 = m1.getRevision().getNumber();
                    return revNum1 == (revNum2 = m2.getRevision().getNumber()) ? 0 : (revNum1 > revNum2 ? 1 : -1);
                }
            });
        }
        return ret.toArray(new ISVNLogMessage[ret.size()]);
    }

    public static void logT9Y(String msg) {
        if (TY9_LOG == null) {
            TY9_LOG = Logger.getLogger("org.netbeans.modules.subversion.t9y");
        }
        TY9_LOG.log(Level.FINEST, msg);
    }

    public static File[] getActionRoots(Context ctx) {
        return SvnUtils.getActionRoots(ctx, true);
    }

    public static File[] getActionRoots(Context ctx, boolean showSelector) {
        File[] roots = ctx.getRootFiles();
        ArrayList<File> l = new ArrayList<File>();
        for (File file : roots) {
            if (!SvnUtils.isManaged(file)) continue;
            l.add(file);
        }
        roots = l.toArray(new File[l.size()]);
        if (Utils.shareCommonDataObject((File[])roots)) {
            return roots;
        }
        if (roots.length > 1) {
            FileSelector fs = new FileSelector(NbBundle.getMessage(SvnUtils.class, (String)"LBL_FileSelector_Title"), NbBundle.getMessage(SvnUtils.class, (String)"FileSelector.jLabel1.text"), new HelpCtx("org.netbeans.modules.subversion.FileSelector"), SvnModuleConfig.getDefault().getPreferences());
            if (showSelector && fs.show(roots)) {
                return new File[]{fs.getSelectedFile()};
            }
            return null;
        }
        return new File[]{roots[0]};
    }

    public static File getPrimaryFile(File file) {
        File primaryFile = null;
        FileObject fo = FileUtil.toFileObject((File)file);
        if (fo != null) {
            DataObject dao = null;
            try {
                dao = DataObject.find((FileObject)fo);
            }
            catch (DataObjectNotFoundException ex) {
                Subversion.LOG.log(Level.INFO, "No DataObject found for " + file, ex);
            }
            if (dao != null) {
                primaryFile = FileUtil.toFile((FileObject)dao.getPrimaryFile());
            }
        }
        if (primaryFile == null) {
            primaryFile = file;
        }
        return primaryFile;
    }

    public static boolean isJava64() {
        String javaVMName = System.getProperty("java.vm.name");
        if (javaVMName == null) {
            return false;
        }
        return javaVMName.toLowerCase().contains("64-bit");
    }

    public static CommitOptions[] createDefaultCommitOptions(SvnFileNode[] nodes, boolean excludeNew) {
        CommitOptions[] commitOptions = new CommitOptions[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            SvnFileNode node = nodes[i];
            File file = node.getFile();
            commitOptions[i] = SvnModuleConfig.getDefault().isExcludedFromCommit(file.getAbsolutePath()) ? CommitOptions.EXCLUDE : SvnUtils.getDefaultCommitOptions(node, excludeNew);
        }
        return commitOptions;
    }

    public static String getTunnelName(String urlString) {
        assert (urlString.startsWith("svn+"));
        int idx = urlString.indexOf(":", 4);
        if (idx < 0) {
            idx = urlString.length();
        }
        return urlString.substring(4, idx);
    }

    public static void openInRevision(final File originalFile, SVNUrl repoUrl, SVNUrl fileUrl, final SVNRevision svnRevision, SVNRevision pegRevision, boolean showAnnotations) {
        File file;
        String rev = svnRevision.toString();
        try {
            file = VersionsCache.getInstance().getFileRevision(repoUrl, fileUrl, rev, pegRevision.toString(), originalFile.getName());
        }
        catch (IOException e) {
            SvnClientExceptionHandler.notifyException(e, true, true);
            return;
        }
        FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        EditorCookie ec = null;
        OpenCookie oc = null;
        try {
            DataObject dobj = DataObject.find((FileObject)fo);
            ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
            oc = (OpenCookie)dobj.getCookie(OpenCookie.class);
        }
        catch (DataObjectNotFoundException ex) {
            Subversion.LOG.log(Level.FINE, null, ex);
        }
        CloneableEditorSupport ces = null;
        if (ec == null && oc != null) {
            oc.open();
        } else {
            ces = Utils.openFile((FileObject)fo, (String)rev);
        }
        if (showAnnotations) {
            if (ces == null) {
                return;
            }
            final CloneableEditorSupport support = ces;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JEditorPane[] panes = support.getOpenedPanes();
                    if (panes != null) {
                        BlameAction.showAnnotations(panes[0], originalFile, svnRevision);
                    }
                }
            });
        }
    }

    public static CommitOptions getDefaultCommitOptions(SvnFileNode node, boolean excludeNew) {
        CommitOptions commitOptions;
        switch (node.getInformation().getStatus()) {
            case 4: {
                commitOptions = excludeNew ? CommitOptions.EXCLUDE : SvnUtils.getDefaultCommitOptions(node);
                break;
            }
            case 256: 
            case 2048: {
                commitOptions = CommitOptions.COMMIT_REMOVE;
                break;
            }
            default: {
                commitOptions = CommitOptions.COMMIT;
            }
        }
        return commitOptions;
    }

    private static CommitOptions getDefaultCommitOptions(SvnFileNode node) {
        if (node.isFile()) {
            if (node.getMimeType().startsWith("text")) {
                return CommitOptions.ADD_TEXT;
            }
            return CommitOptions.ADD_BINARY;
        }
        return CommitOptions.ADD_DIRECTORY;
    }

    public void scanForProjects(File workingFolder, String[] checkedOutFolders, SvnProgressSupport support) {
        HashMap checkedOutProjects = new HashMap();
        checkedOutProjects.put(null, new HashSet());
        File normalizedWorkingFolder = FileUtil.normalizeFile((File)workingFolder);
        SvnUtils.refreshParents(normalizedWorkingFolder);
        FileObject fo = FileUtil.toFileObject((File)normalizedWorkingFolder);
        if (fo != null) {
            for (int i = 0; i < checkedOutFolders.length; ++i) {
                if (support != null && support.isCanceled()) {
                    return;
                }
                String module = checkedOutFolders[i];
                if (".".equals(module)) {
                    ProjectUtilities.scanForProjects((FileObject)fo, checkedOutProjects);
                    break;
                }
                FileObject subfolder = fo.getFileObject(module);
                if (subfolder == null) continue;
                ProjectUtilities.scanForProjects((FileObject)subfolder, checkedOutProjects);
            }
        }
        ProjectUtilities.openCheckedOutProjects(checkedOutProjects, (File)workingFolder);
    }

    public static void refreshFS(File ... files) {
        final HashSet<File> parents = new HashSet<File>();
        for (File f : files) {
            File parent = f.getParentFile();
            if (parent == null) continue;
            parents.add(parent);
            Subversion.LOG.log(Level.FINE, "scheduling for fs refresh: [{0}]", parent);
        }
        if (parents.size() > 0) {
            Subversion.getInstance().getParallelRequestProcessor().post(new Runnable(){

                @Override
                public void run() {
                    FileUtil.refreshFor((File[])parents.toArray(new File[parents.size()]));
                }
            }, 100);
        }
    }

    public static <T> T runWithoutIndexing(Callable<T> callable, List<File> files) throws SVNClientException {
        return SvnUtils.runWithoutIndexing(callable, files.toArray(new File[files.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T runWithoutIndexing(Callable<T> callable, File ... files) throws SVNClientException {
        try {
            Set<File> recursiveRoots = indexingFiles.get();
            if (recursiveRoots != null) {
                if ($assertionsDisabled) return callable.call();
                if (SvnUtils.indexingFilesSubtree(recursiveRoots, files)) return callable.call();
                throw new AssertionError((Object)("Recursive call does not permit different roots: " + recursiveRoots + " vs. " + Arrays.asList(files)));
            }
            try {
                if (Subversion.LOG.isLoggable(Level.FINER)) {
                    Subversion.LOG.log(Level.FINER, "Running block with disabled indexing: on {0}", Arrays.asList(files));
                }
                indexingFiles.set(new HashSet<File>(Arrays.asList(files)));
                Object object = IndexingBridge.getInstance().runWithoutIndexing(callable, files);
                return (T)object;
            }
            finally {
                indexingFiles.remove();
            }
        }
        catch (SVNClientException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SVNClientException("Cannot run without indexing due to: " + ex.getMessage(), (Throwable)ex);
        }
    }

    private static boolean indexingFilesSubtree(Set<File> recursiveRoots, File[] files) {
        for (File f : files) {
            if (recursiveRoots.contains(f)) continue;
            boolean contained = false;
            for (File root : recursiveRoots) {
                if (!Utils.isAncestorOrEqual((File)root, (File)f)) continue;
                contained = true;
                break;
            }
            if (contained) continue;
            return false;
        }
        return true;
    }

    public static String getColorString(Color c) {
        return "#" + SvnUtils.getHex(c.getRed()) + SvnUtils.getHex(c.getGreen()) + SvnUtils.getHex(c.getBlue());
    }

    private static String getHex(int i) {
        String hex = Integer.toHexString(i & 0xFF);
        if (hex.length() == 1) {
            hex = "0" + hex;
        }
        return hex;
    }

    static {
        String env;
        autoEscapedCharacters = new HashSet(6);
        autoEscapedCharacters.add(Character.valueOf(';'));
        autoEscapedCharacters.add(Character.valueOf('?'));
        autoEscapedCharacters.add(Character.valueOf('#'));
        autoEscapedCharacters.add(Character.valueOf('%'));
        autoEscapedCharacters.add(Character.valueOf('['));
        autoEscapedCharacters.add(Character.valueOf(']'));
        autoEscapedCharacters.add(Character.valueOf(' '));
        SVN_ADMIN_DIR = Utilities.isWindows() ? ((env = System.getenv("SVN_ASP_DOT_NET_HACK")) != null ? "_svn" : ".svn") : ".svn";
        SVN_ENTRIES_DIR = SVN_ADMIN_DIR + "/entries";
        SVN_WC_DB = SVN_ADMIN_DIR + "/wc.db";
        metadataPattern = Pattern.compile(".*\\" + File.separatorChar + SVN_ADMIN_DIR.replace(".", "\\.") + "(\\" + File.separatorChar + ".*|$)");
        contextCached = new WeakReference<Object>(null);
        contextNodesCached = new WeakReference<Object>(null);
        svnFileFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (SvnUtils.isAdministrative(pathname)) {
                    return false;
                }
                return SharabilityQuery.getSharability((File)pathname) != 2;
            }
        };
        infoCache = new ThreadLocal();
        statusCache = new ThreadLocal();
        TY9_LOG = null;
        indexingFiles = new ThreadLocal();
    }

    public static class ByImportanceComparator<T>
    implements Comparator<FileInformation> {
        @Override
        public int compare(FileInformation i1, FileInformation i2) {
            return SvnUtils.getComparableStatus(i1.getStatus()) - SvnUtils.getComparableStatus(i2.getStatus());
        }
    }
}

