/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.php.rename;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.refactoring.php.PhpRefactoringOptions;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class RenamePanel
extends JPanel
implements CustomRefactoringPanel {
    private final transient String oldName;
    private final transient ChangeListener parent;
    private boolean initialized;
    private final PhpElementKind phpKind;
    private JPanel jPanel1;
    private JLabel label;
    private JCheckBox lowerCaseFileNameCheckBox;
    private JTextField nameField;
    private JCheckBox refactorAllCheckBox;
    private JCheckBox renameFileCheckBox;
    private JCheckBox textCheckBox;
    private JCheckBox updateReferencesCheckBox;
    private JLabel warningLabel;

    public RenamePanel(String oldName, PhpElementKind phpKind, ChangeListener parent, String name, boolean editable, boolean showUpdateReferences) {
        this.setName(name);
        this.oldName = oldName;
        this.phpKind = phpKind;
        this.parent = parent;
        this.initComponents();
        this.updateReferencesCheckBox.setVisible(showUpdateReferences);
        this.nameField.setEnabled(editable);
        this.nameField.requestFocus();
        this.nameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent event) {
                RenamePanel.this.parent.stateChanged(null);
            }

            @Override
            public void insertUpdate(DocumentEvent event) {
                RenamePanel.this.parent.stateChanged(null);
            }

            @Override
            public void removeUpdate(DocumentEvent event) {
                RenamePanel.this.parent.stateChanged(null);
            }
        });
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        this.textCheckBox.setVisible(false);
        this.refactorAllCheckBox.setVisible(false);
        this.updateReferencesCheckBox.setVisible(false);
        if (this.isTypeKind(this.phpKind)) {
            this.renameFileCheckBox.setSelected(PhpRefactoringOptions.getInstance().getRenameFile());
            this.lowerCaseFileNameCheckBox.setSelected(PhpRefactoringOptions.getInstance().getLowerCaseFileName());
        } else {
            this.renameFileCheckBox.setEnabled(false);
            this.lowerCaseFileNameCheckBox.setEnabled(false);
            this.renameFileCheckBox.setVisible(false);
            this.lowerCaseFileNameCheckBox.setVisible(false);
        }
        this.renameFileCheckBox.addChangeListener(new RenameFileListener(this.lowerCaseFileNameCheckBox));
        this.initialized = true;
    }

    private boolean isTypeKind(PhpElementKind phpKind) {
        return phpKind != null && (phpKind.equals((Object)PhpElementKind.CLASS) || phpKind.equals((Object)PhpElementKind.IFACE) || phpKind.equals((Object)PhpElementKind.TRAIT));
    }

    @Override
    public void requestFocus() {
        this.nameField.requestFocus();
    }

    private void initComponents() {
        this.label = new JLabel();
        this.nameField = new JTextField();
        this.jPanel1 = new JPanel();
        this.warningLabel = new JLabel();
        this.renameFileCheckBox = new JCheckBox();
        this.updateReferencesCheckBox = new JCheckBox();
        this.lowerCaseFileNameCheckBox = new JCheckBox();
        this.textCheckBox = new JCheckBox();
        this.refactorAllCheckBox = new JCheckBox();
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        this.label.setHorizontalAlignment(2);
        this.label.setLabelFor(this.nameField);
        Mnemonics.setLocalizedText((JLabel)this.label, (String)NbBundle.getMessage(RenamePanel.class, (String)"LBL_NewName"));
        this.nameField.setText(this.oldName);
        this.nameField.selectAll();
        this.jPanel1.setMinimumSize(new Dimension(0, 0));
        this.jPanel1.setPreferredSize(new Dimension(0, 0));
        Mnemonics.setLocalizedText((JLabel)this.warningLabel, (String)NbBundle.getMessage(RenamePanel.class, (String)"LBL_NonAccurateRefactoringWarning"));
        Mnemonics.setLocalizedText((AbstractButton)this.renameFileCheckBox, (String)"Rename Also &File With the Declaration.");
        this.renameFileCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RenamePanel.this.renameFileCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.updateReferencesCheckBox, (String)NbBundle.getBundle(RenamePanel.class).getString("LBL_RenameWithoutRefactoring"));
        this.updateReferencesCheckBox.setEnabled(false);
        this.updateReferencesCheckBox.setMargin(new Insets(2, 2, 0, 2));
        this.updateReferencesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RenamePanel.this.updateReferencesCheckBoxActionPerformed(evt);
            }
        });
        this.lowerCaseFileNameCheckBox.setMnemonic('l');
        Mnemonics.setLocalizedText((AbstractButton)this.lowerCaseFileNameCheckBox, (String)"Use Lower Cases for a File Name");
        this.lowerCaseFileNameCheckBox.setEnabled(false);
        this.lowerCaseFileNameCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RenamePanel.this.lowerCaseFileNameCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.warningLabel, -2, 338, -2).addComponent(this.updateReferencesCheckBox).addComponent(this.renameFileCheckBox, -2, 338, -2).addGroup(jPanel1Layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.lowerCaseFileNameCheckBox)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.warningLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.updateReferencesCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.renameFileCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lowerCaseFileNameCheckBox).addContainerGap()));
        this.warningLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RenamePanel.class, (String)"LBL_NonAccurateRefactoringWarning"));
        Mnemonics.setLocalizedText((AbstractButton)this.textCheckBox, (String)NbBundle.getBundle(RenamePanel.class).getString("LBL_RenameComments"));
        this.textCheckBox.setActionCommand(NbBundle.getMessage(RenamePanel.class, (String)"LBL_RenameComments"));
        this.textCheckBox.setEnabled(false);
        this.textCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                RenamePanel.this.textCheckBoxItemStateChanged(evt);
            }
        });
        this.textCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RenamePanel.this.textCheckBoxActionPerformed(evt);
            }
        });
        this.refactorAllCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.refactorAllCheckBox, (String)NbBundle.getMessage(RenamePanel.class, (String)"refactorAllCheckBoxText"));
        this.refactorAllCheckBox.setEnabled(false);
        this.refactorAllCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RenamePanel.this.refactorAllCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nameField)).addComponent(this.textCheckBox).addComponent(this.refactorAllCheckBox, -2, 338, -2).addComponent(this.jPanel1, -2, 338, -2));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(2, 2, 2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.label).addComponent(this.nameField, -2, -1, -2)).addGap(2, 2, 2).addComponent(this.textCheckBox).addGap(0, 0, 0).addComponent(this.refactorAllCheckBox).addGap(12, 12, 12).addComponent(this.jPanel1, -2, 92, -2).addContainerGap()));
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/refactoring/php/rename/Bundle");
        this.nameField.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_nameField"));
        this.textCheckBox.getAccessibleContext().setAccessibleDescription(this.textCheckBox.getText());
    }

    private void textCheckBoxItemStateChanged(ItemEvent evt) {
    }

    private void textCheckBoxActionPerformed(ActionEvent evt) {
    }

    private void refactorAllCheckBoxActionPerformed(ActionEvent evt) {
    }

    private void updateReferencesCheckBoxActionPerformed(ActionEvent evt) {
        this.textCheckBox.setEnabled(!this.updateReferencesCheckBox.isSelected());
    }

    private void renameFileCheckBoxActionPerformed(ActionEvent evt) {
        PhpRefactoringOptions.getInstance().setRenameFile(this.renameFileCheckBox.isSelected());
    }

    private void lowerCaseFileNameCheckBoxActionPerformed(ActionEvent evt) {
        PhpRefactoringOptions.getInstance().setLowerCaseFileName(this.lowerCaseFileNameCheckBox.isSelected());
    }

    public String getNameValue() {
        return this.nameField.getText();
    }

    public boolean isRefactorAllOccurances() {
        return this.refactorAllCheckBox.isSelected();
    }

    public boolean searchJavadoc() {
        return this.textCheckBox.isSelected();
    }

    public boolean isUpdateReferences() {
        return !this.updateReferencesCheckBox.isVisible() || !this.updateReferencesCheckBox.isSelected();
    }

    public boolean renameDeclarationFile() {
        return this.renameFileCheckBox.isSelected();
    }

    public boolean lowerCaseFileName() {
        return this.renameDeclarationFile() && this.lowerCaseFileNameCheckBox.isSelected();
    }

    public Component getComponent() {
        return this;
    }

    private final class RenameFileListener
    implements ChangeListener {
        private final JCheckBox lowerCaseFileNameCheckBox;

        public RenameFileListener(JCheckBox lowerCaseFileNameCheckBox) {
            this.lowerCaseFileNameCheckBox = lowerCaseFileNameCheckBox;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JCheckBox source = (JCheckBox)e.getSource();
            this.lowerCaseFileNameCheckBox.setEnabled(source.isVisible() && source.isSelected());
            RenamePanel.this.parent.stateChanged(null);
        }
    }
}

