/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.diff;

import java.awt.Component;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.diff.DiffController;
import org.openide.util.WeakListeners;

public final class DiffViewModeSwitcher
implements ChangeListener {
    private static final Map<Object, DiffViewModeSwitcher> INSTANCES = new WeakHashMap<Object, DiffViewModeSwitcher>();
    private int diffViewMode = 0;
    private final Map<JComponent, ChangeListener> handledViews = new WeakHashMap<JComponent, ChangeListener>();

    public static synchronized DiffViewModeSwitcher get(Object holder) {
        DiffViewModeSwitcher instance = INSTANCES.get(holder);
        if (instance == null) {
            instance = new DiffViewModeSwitcher();
            INSTANCES.put(holder, instance);
        }
        return instance;
    }

    public void setupMode(DiffController view) {
        JTabbedPane tabPane = DiffViewModeSwitcher.findTabbedPane(view.getJComponent());
        if (tabPane != null) {
            if (!this.handledViews.containsKey(tabPane)) {
                ChangeListener list = WeakListeners.change((ChangeListener)this, (Object)tabPane);
                this.handledViews.put(tabPane, list);
                tabPane.addChangeListener(list);
            }
            if (tabPane.getTabCount() > this.diffViewMode) {
                tabPane.setSelectedIndex(this.diffViewMode);
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JTabbedPane tabPane;
        Object source = e.getSource();
        if (source instanceof JTabbedPane && this.handledViews.containsKey(tabPane = (JTabbedPane)source)) {
            this.diffViewMode = tabPane.getSelectedIndex();
        }
    }

    private static JTabbedPane findTabbedPane(JComponent component) {
        JTabbedPane pane = null;
        if (component instanceof JTabbedPane && Boolean.TRUE.equals(component.getClientProperty("diff-view-mode-switcher"))) {
            pane = (JTabbedPane)component;
        } else {
            Component c;
            Component[] arr$ = component.getComponents();
            int len$ = arr$.length;
            for (int i$ = 0; !(i$ >= len$ || (c = arr$[i$]) instanceof JComponent && (pane = DiffViewModeSwitcher.findTabbedPane((JComponent)c)) != null); ++i$) {
            }
        }
        return pane;
    }

    public static synchronized void release(Object holder) {
        INSTANCES.remove(holder);
    }
}

