/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.shelve.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.modules.versioning.shelve.impl.ShelveChangesMenu;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileUtil;
import org.openide.modules.Places;
import org.openide.util.NbPreferences;

public final class PatchStorage {
    private static PatchStorage instance;
    private static final Logger LOG;
    private static final String SEP = "<==>";
    private static final String PROP_EXPLICIT_LOCATION = "versioning.shelve.patchStorage";

    public static synchronized PatchStorage getInstance() {
        if (instance == null) {
            instance = new PatchStorage();
        }
        return instance;
    }

    public void savePatchInfo(String patchName, File patchFile, File patchContext) {
        Preferences prefs = NbPreferences.forModule(ShelveChangesMenu.class);
        List<String> list = Utils.getStringList(prefs, "shelvedPatches");
        this.removeRecord(list, patchName, false);
        list.add(0, new Patch(patchName, patchFile, patchContext).pack());
        Utils.put(prefs, "shelvedPatches", list);
    }

    public File reservePatchFile(String patchName) {
        patchName = patchName.replace(SEP, "");
        File storageLocation = PatchStorage.getStorageLocation();
        storageLocation.mkdirs();
        int i = 0;
        File patchFile = this.getPatchFile(storageLocation, patchName);
        try {
            while (!patchFile.createNewFile()) {
                patchFile = this.getPatchFile(storageLocation, patchName + "-" + ++i);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {}
            }
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, null, ex);
        }
        return patchFile;
    }

    public void dismissPatchFile(File patchFile) {
        patchFile.delete();
    }

    private static File getStorageLocation() {
        String explicitLocation = System.getProperty(PROP_EXPLICIT_LOCATION, "");
        if (explicitLocation.isEmpty()) {
            File userDir = Places.getUserDirectory();
            return new File(new File(new File(userDir, "var"), "versioning"), "patch-storage");
        }
        return new File(explicitLocation);
    }

    private File getPatchFile(File storageLocation, String patchName) {
        return new File(storageLocation, patchName + ".patch");
    }

    void removePatch(String patchName, boolean removePatchFile) {
        Preferences prefs = NbPreferences.forModule(ShelveChangesMenu.class);
        List<String> list = Utils.getStringList(prefs, "shelvedPatches");
        this.removeRecord(list, patchName, removePatchFile);
        Utils.put(prefs, "shelvedPatches", list);
    }

    private void removeRecord(List<String> list, String patchName, boolean removePatchFile) {
        ListIterator<String> it = list.listIterator();
        while (it.hasNext()) {
            Patch patch;
            String savedPatch = it.next();
            if (!savedPatch.startsWith(patchName + SEP)) continue;
            it.remove();
            if (!removePatchFile || (patch = Patch.unpack(savedPatch)) == null) continue;
            File f = patch.getPatchFile();
            f.delete();
            FileUtil.refreshFor((File[])new File[]{f});
        }
    }

    Patch getPatch(String patchName) {
        Preferences prefs = NbPreferences.forModule(ShelveChangesMenu.class);
        List<String> list = Utils.getStringList(prefs, "shelvedPatches");
        ListIterator<String> it = list.listIterator();
        while (it.hasNext()) {
            String savedPatch = it.next();
            if (!savedPatch.startsWith(patchName + SEP)) continue;
            return Patch.unpack(savedPatch);
        }
        return null;
    }

    public boolean containsPatch(String patchName) {
        return this.getPatch(patchName) != null;
    }

    List<Patch> getPatches() {
        List<String> list = Utils.getStringList(NbPreferences.forModule(ShelveChangesMenu.class), "shelvedPatches");
        LinkedList<Patch> patches = new LinkedList<Patch>();
        ListIterator<String> it = list.listIterator();
        while (it.hasNext()) {
            String savedPatch = it.next();
            Patch patch = Patch.unpack(savedPatch);
            if (patch == null) continue;
            patches.add(patch);
        }
        return patches;
    }

    public List<String> getPatchNames() {
        List<Patch> patches = this.getPatches();
        ArrayList<String> patchNames = new ArrayList<String>(patches.size());
        for (Patch p : patches) {
            patchNames.add(p.getPatchName());
        }
        return patchNames;
    }

    static {
        LOG = Logger.getLogger(PatchStorage.class.getName());
    }

    static class Patch {
        private final File context;
        private final String name;
        private final File file;

        private Patch(String patchName, File patchFile, File patchContext) {
            this.name = patchName;
            this.file = patchFile;
            this.context = patchContext;
        }

        private String pack() {
            return this.name.replace(PatchStorage.SEP, "") + PatchStorage.SEP + this.file.getName() + PatchStorage.SEP + this.context.getAbsolutePath();
        }

        private static Patch unpack(String savedPatch) {
            String[] unpacked = savedPatch.split(PatchStorage.SEP);
            if (unpacked.length < 3) {
                return null;
            }
            String name = unpacked[0];
            String fileName = unpacked[1];
            StringBuilder sb = new StringBuilder(unpacked[2]);
            for (int i = 3; i < unpacked.length; ++i) {
                sb.append(PatchStorage.SEP).append(unpacked[i]);
            }
            return new Patch(name, new File(PatchStorage.getStorageLocation(), fileName), new File(sb.toString()));
        }

        File getPatchFile() {
            return this.file;
        }

        File getPatchContext() {
            return this.context;
        }

        String getPatchName() {
            return this.name;
        }
    }
}

