/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven;

import java.io.File;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.model.License;
import org.apache.maven.model.Organization;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.web.common.spi.ProjectWebRootQuery;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.netbeans.spi.queries.FileEncodingQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.CreateFromTemplateAttributesProvider;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

public class TemplateAttrProvider
implements CreateFromTemplateAttributesProvider {
    private static final Logger LOG = Logger.getLogger(TemplateAttrProvider.class.getName());
    private final Project project;

    public TemplateAttrProvider(Project prj) {
        this.project = prj;
    }

    public Map<String, ?> attributesFor(DataObject template, DataFolder target, String name) {
        FileEncodingQueryImplementation enc;
        Charset charset;
        String encoding;
        String organizationName;
        Organization organization;
        TreeMap<String, Object> values = new TreeMap<String, Object>();
        AuxiliaryProperties auxProps = (AuxiliaryProperties)this.project.getLookup().lookup(AuxiliaryProperties.class);
        String licensePath = auxProps.get("netbeans.hint.licensePath", true);
        if (licensePath != null) {
            ExpressionEvaluator eval = PluginPropertyUtils.createEvaluator(this.project);
            try {
                Object no = eval.evaluate(licensePath);
                if (no != null) {
                    licensePath = no.toString();
                }
            }
            catch (ExpressionEvaluationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            File path = FileUtil.normalizeFile((File)FileUtilities.resolveFilePath(FileUtil.toFile((FileObject)this.project.getProjectDirectory()), licensePath));
            if (path.exists() && path.isAbsolute()) {
                URI uri = Utilities.toURI((File)path);
                licensePath = uri.toString();
                values.put("licensePath", licensePath);
            } else {
                LOG.log(Level.INFO, "project.licensePath value not accepted - " + licensePath);
            }
        }
        String license = auxProps.get("netbeans.hint.license", true);
        NbMavenProject nbMavenProject = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        assert (nbMavenProject != null);
        MavenProject mp = nbMavenProject.getMavenProject();
        if (license == null) {
            license = TemplateAttrProvider.findLicenseByMavenProjectContent(mp);
        }
        if (license != null) {
            values.put("license", license);
        }
        if ((organization = mp.getOrganization()) != null && (organizationName = organization.getName()) != null) {
            values.put("organization", organizationName);
        }
        String string = encoding = (charset = (enc = (FileEncodingQueryImplementation)this.project.getLookup().lookup(FileEncodingQueryImplementation.class)).getEncoding(target.getPrimaryFile())) != null ? charset.name() : null;
        if (encoding != null) {
            values.put("encoding", encoding);
        }
        ProjectInformation pi = ProjectUtils.getInformation((Project)this.project);
        values.put("name", mp.getArtifactId());
        values.put("displayName", pi.getDisplayName());
        if (mp.getProperties() != null) {
            HashMap<String, Object> props = new HashMap<String, Object>();
            for (String prop : mp.getProperties().stringPropertyNames()) {
                String[] split = prop.split("\\.");
                String value = mp.getProperties().getProperty(prop);
                this.putProp(split, props, value);
            }
            if (props.size() > 0) {
                values.put("property", props);
            }
        }
        if ("war".equalsIgnoreCase(nbMavenProject.getPackagingType())) {
            values.put("webRootPath", TemplateAttrProvider.getWebRootPath(this.project));
        }
        if (values.size() > 0) {
            return Collections.singletonMap("project", values);
        }
        return null;
    }

    @CheckForNull
    private static String getWebRootPath(Project project) {
        Iterator i$ = ProjectWebRootQuery.getWebRoots((Project)project).iterator();
        if (i$.hasNext()) {
            FileObject webRoot = (FileObject)i$.next();
            return FileUtil.getRelativePath((FileObject)project.getProjectDirectory(), (FileObject)webRoot);
        }
        return null;
    }

    private void putProp(String[] split, Map<String, Object> props, String value) {
        if (split.length > 0) {
            if (split.length == 1) {
                props.put(split[0], value);
            } else {
                HashMap<String, Object> childProp;
                Object valu = props.get(split[0]);
                if (valu == null) {
                    childProp = new HashMap();
                    props.put(split[0], childProp);
                } else if (valu instanceof Map) {
                    childProp = (Map)valu;
                } else {
                    return;
                }
                this.putProp(Arrays.copyOfRange(split, 1, split.length), childProp, value);
            }
        }
    }

    public static String findLicenseByMavenProjectContent(MavenProject mp) {
        FileObject licensesFO = FileUtil.getConfigFile((String)"Templates/Licenses");
        if (licensesFO == null) {
            return null;
        }
        FileObject[] licenseFiles = licensesFO.getChildren();
        block0: for (License license : mp.getLicenses()) {
            String url = license.getUrl();
            if (url == null) continue;
            for (FileObject fo : licenseFiles) {
                String str = (String)fo.getAttribute("mavenLicenseURL");
                if (str == null || !Arrays.asList(str.split(" ")).contains(url)) continue;
                if (fo.getName().startsWith("license-")) {
                    return fo.getName().substring("license-".length());
                }
                Logger.getLogger(TemplateAttrProvider.class.getName()).log(Level.WARNING, "Bad license file name {0} (expected to start with ''license-'' prefix)", fo.getName());
                continue block0;
            }
        }
        return null;
    }
}

