/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.ui;

import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.groovy.grailsproject.GrailsProject;
import org.netbeans.modules.groovy.grailsproject.SourceCategory;
import org.netbeans.modules.groovy.grailsproject.ui.wizards.impl.GrailsArtifacts;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.RecommendedTemplates;
import org.openide.filesystems.FileObject;

public class TemplatesImpl
implements PrivilegedTemplates,
RecommendedTemplates {
    public static final String GROOVY_CLASS = "Templates/Groovy/GroovyClass.groovy";
    public static final String GROOVY_SCRIPT = "Templates/Groovy/GroovyScript.groovy";
    public static final String GSP = "Templates/Groovy/_view.gsp";
    public static final String DOMAIN_CLASS = "Templates/Groovy/DomainClass";
    public static final String CONTROLLER = "Templates/Groovy/Controller";
    public static final String INTEGRATION_TEST = "Templates/Groovy/IntegrationTest";
    public static final String GANT_SCRIPT = "Templates/Groovy/GantScript";
    public static final String SERVICE = "Templates/Groovy/Service";
    public static final String TAG_LIB = "Templates/Groovy/TagLib";
    public static final String UNIT_TEST = "Templates/Groovy/UnitTest";
    private static final String FOLDER = "Templates/Other/Folder";
    private static final String PROPERTIES = "Templates/Other/properties.properties";
    private static final String SIMPLE_FILES = "simple-files";
    private static final String[] GENERAL_TEMPLATES = new String[]{"Templates/Groovy/GroovyClass.groovy", "Templates/Groovy/GroovyScript.groovy", "Templates/Other/Folder", "Templates/Other/properties.properties"};
    private static final String[] SCRIPTS_TEMPLATES = new String[]{"Templates/Groovy/GantScript", "Templates/Groovy/GroovyScript.groovy", "Templates/Other/Folder", "Templates/Other/properties.properties"};
    private static final String[] DOMAIN_TEMPLATES = new String[]{"Templates/Groovy/DomainClass", "Templates/Groovy/GroovyClass.groovy", "Templates/Groovy/GroovyScript.groovy", "Templates/Other/Folder", "Templates/Other/properties.properties"};
    private static final String[] CONTROLLER_TEMPLATES = new String[]{"Templates/Groovy/Controller", "Templates/Groovy/GroovyClass.groovy", "Templates/Groovy/GroovyScript.groovy", "Templates/Other/Folder", "Templates/Other/properties.properties"};
    private static final String[] TAGLIB_TEMPLATES = new String[]{"Templates/Groovy/TagLib", "Templates/Groovy/GroovyClass.groovy", "Templates/Groovy/GroovyScript.groovy", "Templates/Other/Folder", "Templates/Other/properties.properties"};
    private static final String[] INTEGRATION_TEST_TEMPLATES = new String[]{"Templates/Groovy/IntegrationTest", "Templates/Groovy/GroovyClass.groovy", "Templates/Groovy/GroovyScript.groovy", "Templates/Other/Folder", "Templates/Other/properties.properties"};
    private static final String[] UNIT_TEST_TEMPLATES = new String[]{"Templates/Groovy/UnitTest", "Templates/Groovy/GroovyClass.groovy", "Templates/Groovy/GroovyScript.groovy", "Templates/Other/Folder", "Templates/Other/properties.properties"};
    private static final String[] SERVICE_TEMPLATES = new String[]{"Templates/Groovy/Service", "Templates/Groovy/GroovyClass.groovy", "Templates/Groovy/GroovyScript.groovy", "Templates/Other/Folder", "Templates/Other/properties.properties"};
    private static final String[] GSP_TEMPLATES = new String[]{"Templates/Groovy/_view.gsp", "Templates/Other/Folder", "Templates/Other/properties.properties"};
    private static final String[] I18N_TEMPLATES = new String[]{"Templates/Other/properties.properties"};
    private final SourceCategory sourceCategory;

    public TemplatesImpl(GrailsProject project, SourceGroup sourceGroup) {
        FileObject projectDir = project.getProjectDirectory();
        FileObject rootFolder = sourceGroup.getRootFolder();
        this.sourceCategory = GrailsArtifacts.getCategoryForFolder(projectDir, rootFolder);
    }

    public String[] getPrivilegedTemplates() {
        if (this.sourceCategory != null) {
            switch (this.sourceCategory) {
                case GRAILSAPP_CONTROLLERS: {
                    return CONTROLLER_TEMPLATES;
                }
                case GRAILSAPP_DOMAIN: {
                    return DOMAIN_TEMPLATES;
                }
                case GRAILSAPP_I18N: {
                    return I18N_TEMPLATES;
                }
                case GRAILSAPP_SERVICES: {
                    return SERVICE_TEMPLATES;
                }
                case GRAILSAPP_TAGLIB: {
                    return TAGLIB_TEMPLATES;
                }
                case TEST_INTEGRATION: {
                    return INTEGRATION_TEST_TEMPLATES;
                }
                case TEST_UNIT: {
                    return UNIT_TEST_TEMPLATES;
                }
                case SCRIPTS: {
                    return SCRIPTS_TEMPLATES;
                }
                case GRAILSAPP_UTILS: 
                case GRAILSAPP_CONF: 
                case SRC_GROOVY: {
                    return GENERAL_TEMPLATES;
                }
                case GRAILSAPP_VIEWS: 
                case WEBAPP: {
                    return GSP_TEMPLATES;
                }
                case SRC_JAVA: {
                    return new String[]{"Templates/Classes/Class.java", "Templates/Classes/Interface.java", "Templates/Classes/Enum.java", "Templates/Classes/AnnotationType.java", "Templates/Classes/Exception.java", "Templates/Classes/Package.java"};
                }
            }
        }
        return new String[0];
    }

    public String[] getRecommendedTypes() {
        return new String[]{SIMPLE_FILES};
    }
}

