/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.bugs;

import com.sun.source.tree.CatchTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.UnionType;
import javax.swing.JComponent;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.bugs.BroadCatchCustomizer;
import org.netbeans.modules.java.hints.bugs.Bundle;
import org.netbeans.modules.java.hints.jdk.UseSpecificCatch;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.CustomizerProvider;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;

public class BroadCatchBlock {
    public static final String OPTION_EXCLUDE_UMBRELLA = "catch.umbrella";
    public static final String OPTION_UMBRELLA_LIST = "catch.umbrella.types";
    public static final String OPTION_EXCLUDE_COMMON = "catch.common";
    static final boolean DEFAULT_EXCLUDE_COMMON = true;
    static final boolean DEFAULT_EXCLUDE_UMBRELLA = false;
    static final boolean DEFAULT_ONLY_GENERIC = false;
    static final String DEFAULT_GENERIC_LIST = "";
    static final String DEFAULT_UMBRELLA_LIST = "java.io.IOException, java.sql.SqlException";
    private static final Set<String> HARDCODED_GENERAL_EXCEPTIONS = new HashSet<String>();

    public static List<ErrorDescription> broadCatch(HintContext ctx) {
        if (ctx.getPath().getLeaf().getKind() != Tree.Kind.TRY) {
            return null;
        }
        TryTree tt = (TryTree)ctx.getPath().getLeaf();
        Set realExceptions = ctx.getInfo().getTreeUtilities().getUncaughtExceptions(new TreePath(ctx.getPath(), tt.getBlock()));
        CatchClauseProcessor processor = new CatchClauseProcessor(ctx.getInfo(), ctx, realExceptions);
        if (ctx.getPreferences().getBoolean(OPTION_EXCLUDE_COMMON, true)) {
            processor.excludeCommons();
        }
        if (ctx.getPreferences().getBoolean(OPTION_EXCLUDE_UMBRELLA, false)) {
            processor.suppressUmbrellas(ctx.getPreferences().get(OPTION_UMBRELLA_LIST, DEFAULT_UMBRELLA_LIST));
        }
        processor.process((Collection)ctx.getMultiVariables().get("$catches$"));
        return processor.errors;
    }

    static {
        HARDCODED_GENERAL_EXCEPTIONS.add("java.lang.RuntimeException");
        HARDCODED_GENERAL_EXCEPTIONS.add("java.lang.Throwable");
        HARDCODED_GENERAL_EXCEPTIONS.add("java.lang.Exception");
        HARDCODED_GENERAL_EXCEPTIONS.add("java.lang.Error");
    }

    private static class ReplaceCatchType
    extends JavaFix {
        private final TypeMirrorHandle newCatchType;

        public ReplaceCatchType(CompilationInfo info, TreePath tp, TypeMirrorHandle newCatchType) {
            super(info, tp);
            this.newCatchType = newCatchType;
        }

        protected String getText() {
            return Bundle.FIX_BroadCatchNarrowCatch();
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            CatchTree oldTree = (CatchTree)ctx.getPath().getLeaf();
            WorkingCopy wcopy = ctx.getWorkingCopy();
            Tree varType = oldTree.getParameter().getType();
            Tree newVarType = wcopy.getTreeMaker().Type(this.newCatchType.resolve((CompilationInfo)wcopy));
            wcopy.rewrite(varType, newVarType);
        }
    }

    public static class CF
    implements CustomizerProvider {
        public JComponent getCustomizer(Preferences prefs) {
            return new BroadCatchCustomizer(prefs);
        }
    }

    private static class CatchClauseProcessor {
        private final CompilationInfo info;
        private final Collection<TypeMirror> exceptionList;
        private final HintContext ctx;
        private boolean excludeCommons;
        private Set<String> genericQNames = Collections.emptySet();
        private Set<String> umbrellas = Collections.emptySet();
        private List<ErrorDescription> errors = Collections.emptyList();
        private TreePath catchPath;
        private final Set<TypeMirror> otherCatchedExceptions = new HashSet<TypeMirror>();

        public CatchClauseProcessor(CompilationInfo info, HintContext ctx, Collection<TypeMirror> exceptionList) {
            this.info = info;
            this.ctx = ctx;
            this.exceptionList = exceptionList;
            this.initGenericQNames(ctx.getPreferences().get("specificCatch.exceptions", BroadCatchBlock.DEFAULT_GENERIC_LIST));
        }

        private void addErrorDescription(ErrorDescription desc) {
            if (desc == null) {
                return;
            }
            if (this.errors.isEmpty()) {
                this.errors = new ArrayList<ErrorDescription>(3);
            }
            this.errors.add(desc);
        }

        public CatchClauseProcessor excludeCommons() {
            this.excludeCommons = true;
            return this;
        }

        private CatchClauseProcessor initGenericQNames(String names) {
            StringTokenizer tukac = new StringTokenizer(names, ", ");
            this.genericQNames = new HashSet<String>(5);
            while (tukac.hasMoreTokens()) {
                this.genericQNames.add(tukac.nextToken());
            }
            this.genericQNames.addAll(HARDCODED_GENERAL_EXCEPTIONS);
            return this;
        }

        public CatchClauseProcessor suppressUmbrellas(String names) {
            StringTokenizer tukac = new StringTokenizer(names, ", ");
            this.umbrellas = new HashSet<String>(5);
            while (tukac.hasMoreTokens()) {
                this.umbrellas.add(tukac.nextToken());
            }
            return this;
        }

        private TreePath getCurrentPath() {
            return this.catchPath;
        }

        public void process(Collection<? extends TreePath> catches) {
            TypeMirror ex;
            CatchTree node;
            for (TreePath treePath : catches) {
                if (treePath.getLeaf().getKind() != Tree.Kind.CATCH) continue;
                this.catchPath = treePath;
                node = (CatchTree)treePath.getLeaf();
                ex = this.info.getTrees().getTypeMirror(new TreePath(this.getCurrentPath(), node.getParameter().getType()));
                if (ex == null) continue;
                switch (ex.getKind()) {
                    case DECLARED: {
                        if (this.shouldReportException(ex)) break;
                        this.otherCatchedExceptions.add(ex);
                        break;
                    }
                    case UNION: {
                        for (TypeMirror typeMirror : ((UnionType)ex).getAlternatives()) {
                            if (this.shouldReportException(typeMirror)) continue;
                            this.otherCatchedExceptions.add(typeMirror);
                        }
                        break;
                    }
                }
            }
            for (TreePath treePath : catches) {
                if (treePath.getLeaf().getKind() != Tree.Kind.CATCH) continue;
                this.catchPath = treePath;
                node = (CatchTree)treePath.getLeaf();
                ex = this.info.getTrees().getTypeMirror(new TreePath(this.getCurrentPath(), node.getParameter().getType()));
                if (ex == null) continue;
                switch (ex.getKind()) {
                    case DECLARED: {
                        if (!this.shouldReportException(ex)) break;
                        this.addErrorDescription(this.processCaughtException(ex, null));
                        break;
                    }
                    case UNION: {
                        for (TypeMirror typeMirror : ((UnionType)ex).getAlternatives()) {
                            if (!this.shouldReportException(ex)) continue;
                            this.addErrorDescription(this.processCaughtException(typeMirror, ((UnionType)ex).getAlternatives()));
                        }
                        break;
                    }
                }
            }
        }

        private boolean shouldReportException(TypeMirror excType) {
            if (this.exceptionList.contains(excType)) {
                return false;
            }
            TypeElement excElement = (TypeElement)this.info.getTypes().asElement(excType);
            if (excElement == null) {
                return false;
            }
            String fqn = excElement.getQualifiedName().toString();
            ArrayList<TypeMirror> masked = new ArrayList<TypeMirror>(3);
            for (TypeMirror t : this.exceptionList) {
                if (!this.info.getTypes().isSubtype(t, excType)) continue;
                masked.add(t);
            }
            if (masked.isEmpty()) {
                return false;
            }
            if (masked.size() > 1) {
                if (this.umbrellas.contains(fqn)) {
                    return false;
                }
                if (this.excludeCommons && !this.genericQNames.contains(fqn)) {
                    return false;
                }
            } else {
                TypeElement e = this.info.getElements().getTypeElement("java.lang.RuntimeException");
                if (e == null) {
                    return false;
                }
                TypeMirror rtt = e.asType();
                if (this.info.getTypes().isSubtype(excElement.asType(), rtt) && !this.info.getTypes().isSameType(excElement.asType(), rtt)) {
                    return false;
                }
            }
            if (masked.size() == 1) {
                TypeMirror one = (TypeMirror)masked.iterator().next();
                TypeElement oneElement = (TypeElement)this.info.getTypes().asElement(one);
                if (oneElement == null) {
                    return false;
                }
            }
            return true;
        }

        private ErrorDescription processCaughtException(TypeMirror excType, List<? extends TypeMirror> alternatives) {
            TypeElement excElement = (TypeElement)this.info.getTypes().asElement(excType);
            if (excElement == null) {
                return null;
            }
            String fqn = excElement.getQualifiedName().toString();
            ArrayList<TypeMirror> masked = new ArrayList<TypeMirror>(3);
            for (TypeMirror t : this.exceptionList) {
                if (this.otherCatchedExceptions.contains(t) || !this.info.getTypes().isSubtype(t, excType)) continue;
                masked.add(t);
            }
            CatchTree catchTree = (CatchTree)this.getCurrentPath().getLeaf();
            TreePath varPath = new TreePath(this.getCurrentPath(), catchTree.getParameter());
            if (masked.size() == 1) {
                TypeMirror one = (TypeMirror)masked.iterator().next();
                TypeElement oneElement = (TypeElement)this.info.getTypes().asElement(one);
                if (oneElement != null) {
                    return ErrorDescriptionFactory.forTree((HintContext)this.ctx, (TreePath)varPath, (String)Bundle.TEXT_BroadCatchMoreSpecificException(fqn, oneElement.getQualifiedName().toString()), (Fix[])new Fix[]{new ReplaceCatchType(this.info, this.getCurrentPath(), TypeMirrorHandle.create((TypeMirror)one)).toEditorFix()});
                }
                return null;
            }
            LinkedHashSet<TypeMirrorHandle<TypeMirror>> handles = new LinkedHashSet<TypeMirrorHandle<TypeMirror>>(masked.size());
            String stringList = null;
            int cnt = 0;
            ArrayList<String> sortedFqns = new ArrayList<String>(masked.size());
            HashMap<String, TypeMirror> pickup = new HashMap<String, TypeMirror>(masked.size());
            for (TypeMirror m : masked) {
                TypeElement typeElement = (TypeElement)this.info.getTypes().asElement(m);
                if (typeElement == null) continue;
                String teqn = typeElement.getQualifiedName().toString();
                sortedFqns.add(teqn);
                pickup.put(teqn, m);
            }
            Collections.sort(sortedFqns);
            for (String teqn : sortedFqns) {
                TypeMirror typeMirror = (TypeMirror)pickup.get(teqn);
                stringList = cnt == 0 ? Bundle.TEXT_BroadCatchExceptionListStart(teqn) : (cnt < masked.size() - 1 ? Bundle.TEXT_BroadCatchExceptionListMiddle(stringList, teqn) : Bundle.TEXT_BroadCatchExceptionListEnd(stringList, teqn));
                ++cnt;
                handles.add(TypeMirrorHandle.create((TypeMirror)typeMirror));
            }
            if (alternatives != null) {
                LinkedHashSet<Object> extHandles = new LinkedHashSet<Object>(handles.size());
                for (TypeMirror typeMirror : alternatives) {
                    if (!typeMirror.equals(excType)) {
                        extHandles.add(TypeMirrorHandle.create((TypeMirror)typeMirror));
                        continue;
                    }
                    extHandles.addAll(handles);
                }
                handles = extHandles;
            }
            Fix[] fixes = new Fix[]{};
            if (!UseSpecificCatch.assignsTo(this.ctx, varPath, Collections.singletonList(new TreePath(this.getCurrentPath(), catchTree.getBlock())))) {
                fixes = this.info.getSourceVersion().compareTo(SourceVersion.RELEASE_7) >= 0 ? (alternatives != null ? new Fix[]{new UseSpecificCatch.FixImpl(this.info, this.getCurrentPath(), handles).toEditorFix()} : new Fix[]{new UseSpecificCatch.FixImpl(this.info, this.getCurrentPath(), handles).toEditorFix(), new UseSpecificCatch.SplitExceptionInCatches(this.info, this.getCurrentPath(), handles).toEditorFix()}) : new Fix[]{new UseSpecificCatch.SplitExceptionInCatches(this.info, this.getCurrentPath(), handles).toEditorFix()};
            }
            return ErrorDescriptionFactory.forTree((HintContext)this.ctx, (TreePath)varPath, (String)Bundle.TEXT_BroadCatchMaskedExceptions(fqn, stringList), (Fix[])fixes);
        }
    }
}

