/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.bugs;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.util.Collections;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.bugs.Bundle;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;

public class CloneAndCloneable {
    public static ErrorDescription cloneWithoutSuperClone(HintContext ctx) {
        ExecutableElement me = (ExecutableElement)ctx.getInfo().getTrees().getElement(ctx.getPath());
        if (me == null) {
            return null;
        }
        ExecutableElement sup = ctx.getInfo().getElementUtilities().getOverriddenMethod(me);
        if (sup == null) {
            return null;
        }
        SuperCloneFinder f = new SuperCloneFinder(ctx.getInfo(), sup);
        if (f.scan(ctx.getPath(), null) == Boolean.TRUE) {
            return null;
        }
        return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)Bundle.TEXT_CloneWithoutSuperClone(), (Fix[])new Fix[0]);
    }

    public static ErrorDescription cloneWithoutThrows(HintContext ctx) {
        CompilationInfo info = ctx.getInfo();
        ExecutableElement cloneMethod = (ExecutableElement)info.getTrees().getElement(ctx.getPath());
        if (cloneMethod == null || cloneMethod.getModifiers().contains((Object)Modifier.FINAL)) {
            return null;
        }
        TypeElement declaringClass = info.getElementUtilities().enclosingTypeElement((Element)cloneMethod);
        if (declaringClass == null || declaringClass.getModifiers().contains((Object)Modifier.FINAL)) {
            return null;
        }
        TypeElement e = info.getElements().getTypeElement("java.lang.CloneNotSupportedException");
        if (e == null) {
            return null;
        }
        TypeMirror cnse = e.asType();
        for (TypeMirror typeMirror : cloneMethod.getThrownTypes()) {
            if (!info.getTypes().isSameType(cnse, typeMirror)) continue;
            return null;
        }
        return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)Bundle.TEXT_CloneWithoutCloneNotSupported(), (Fix[])new Fix[]{new AddCNSExceptionFix(info, ctx.getPath()).toEditorFix()});
    }

    public static ErrorDescription cloneInNonCloneableClass(HintContext ctx) {
        CompilationInfo info = ctx.getInfo();
        ExecutableElement cloneMethod = (ExecutableElement)info.getTrees().getElement(ctx.getPath());
        if (cloneMethod == null) {
            return null;
        }
        if (!cloneMethod.getModifiers().contains((Object)Modifier.PUBLIC)) {
            return null;
        }
        TypeElement declaringClass = info.getElementUtilities().enclosingTypeElement((Element)cloneMethod);
        if (declaringClass == null) {
            return null;
        }
        TypeElement cloneableIface = info.getElements().getTypeElement("java.lang.Cloneable");
        if (cloneableIface == null) {
            return null;
        }
        if (info.getTypes().isSubtype(declaringClass.asType(), cloneableIface.asType())) {
            return null;
        }
        Fix fix = new CloneableInsertFix(info, info.getTrees().getPath(declaringClass)).toEditorFix();
        return ErrorDescriptionFactory.forName((HintContext)ctx, (Tree)info.getTrees().getTree(declaringClass), (String)Bundle.TEXT_CloneWithoutCloneable(), (Fix[])new Fix[]{fix});
    }

    private static boolean isCloneMethod(ExecutableElement ee) {
        return ee.getParameters().isEmpty() && ee.getSimpleName().contentEquals("clone");
    }

    public static ErrorDescription cloneableWithoutClone(HintContext ctx) {
        CompilationInfo info = ctx.getInfo();
        TypeElement cloneableIface = info.getElements().getTypeElement("java.lang.Cloneable");
        if (cloneableIface == null) {
            return null;
        }
        TypeElement clazz = (TypeElement)info.getTrees().getElement(ctx.getPath());
        if (clazz == null || !info.getTypes().isSubtype(clazz.asType(), cloneableIface.asType())) {
            return null;
        }
        for (ExecutableElement exec : ElementFilter.methodsIn(clazz.getEnclosedElements())) {
            if (!CloneAndCloneable.isCloneMethod(exec)) continue;
            return null;
        }
        return ErrorDescriptionFactory.forName((HintContext)ctx, (Tree)info.getTrees().getTree(clazz), (String)Bundle.TEXT_CloneableWithoutClone(), (Fix[])new Fix[]{new AddCloneFix(info, ctx.getPath()).toEditorFix()});
    }

    private static class AddCloneFix
    extends JavaFix {
        public AddCloneFix(CompilationInfo info, TreePath tp) {
            super(info, tp);
        }

        protected String getText() {
            return Bundle.FIX_AddCloneMethod();
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            MethodTree mt;
            TreePath path = ctx.getPath();
            TreeMaker make = ctx.getWorkingCopy().getTreeMaker();
            ClassTree clazz = (ClassTree)path.getLeaf();
            TypeElement clazzType = (TypeElement)ctx.getWorkingCopy().getTrees().getElement(path);
            if (clazzType == null) {
                return;
            }
            ExecutableElement superClone = null;
            for (ExecutableElement ee : ElementFilter.methodsIn(ctx.getWorkingCopy().getElements().getAllMembers(clazzType))) {
                if (!CloneAndCloneable.isCloneMethod(ee)) continue;
                superClone = ee;
                break;
            }
            GeneratorUtilities gen = GeneratorUtilities.get((WorkingCopy)ctx.getWorkingCopy());
            if (superClone != null) {
                mt = gen.createOverridingMethod(clazzType, superClone);
                if (!mt.getModifiers().getFlags().contains((Object)Modifier.PUBLIC)) {
                    ctx.getWorkingCopy().rewrite((Tree)mt.getModifiers(), (Tree)make.Modifiers(Collections.singleton(Modifier.PUBLIC), Collections.singletonList(make.Annotation(make.Type("java.lang.Override"), Collections.emptyList()))));
                }
            } else {
                mt = make.Method(make.Modifiers(Collections.singleton(Modifier.PUBLIC)), (CharSequence)"clone", (Tree)clazz, Collections.emptyList(), Collections.emptyList(), Collections.singletonList(make.QualIdent("java.lang.CloneNotSupportedException")), "", null);
            }
            ClassTree changedClazz = gen.insertClassMember(clazz, (Tree)mt);
            ctx.getWorkingCopy().rewrite((Tree)clazz, (Tree)changedClazz);
        }
    }

    private static class CloneableInsertFix
    extends JavaFix {
        public CloneableInsertFix(CompilationInfo info, TreePath tp) {
            super(info, tp);
        }

        protected String getText() {
            return Bundle.FIX_ImplementCloneableInterface();
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            TreePath clazz = ctx.getPath();
            TreeMaker make = ctx.getWorkingCopy().getTreeMaker();
            ClassTree original = (ClassTree)clazz.getLeaf();
            ClassTree changed = make.addClassImplementsClause(original, make.Type("java.lang.Cloneable"));
            ctx.getWorkingCopy().rewrite((Tree)original, (Tree)changed);
        }
    }

    private static class AddCNSExceptionFix
    extends JavaFix {
        public AddCNSExceptionFix(CompilationInfo info, TreePath tp) {
            super(info, tp);
        }

        protected String getText() {
            return Bundle.FIX_AddCloneNotSupportedException();
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            TreePath methodPath = ctx.getPath();
            TreeMaker make = ctx.getWorkingCopy().getTreeMaker();
            MethodTree orig = (MethodTree)methodPath.getLeaf();
            MethodTree changed = make.addMethodThrows(orig, (ExpressionTree)make.Type("java.lang.CloneNotSupportedException"));
            ctx.getWorkingCopy().rewrite((Tree)orig, (Tree)changed);
        }
    }

    private static final class SuperCloneFinder
    extends TreePathScanner<Boolean, Void> {
        private final CompilationInfo info;
        private final ExecutableElement superClone;

        @Override
        public Boolean reduce(Boolean r1, Boolean r2) {
            return r1 == Boolean.TRUE || r2 == Boolean.TRUE ? Boolean.TRUE : null;
        }

        public SuperCloneFinder(CompilationInfo info, ExecutableElement superClone) {
            this.info = info;
            this.superClone = superClone;
        }

        @Override
        public Boolean visitMethodInvocation(MethodInvocationTree node, Void p) {
            if (super.visitMethodInvocation(node, p) == Boolean.TRUE) {
                return Boolean.TRUE;
            }
            Element invoked = this.info.getTrees().getElement(this.getCurrentPath());
            if (invoked == this.superClone) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
    }
}

