/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jdk;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.util.TreePath;
import javax.lang.model.SourceVersion;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.jdk.Bundle;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFixUtilities;

public class UnnecessaryUnboxing {
    public static ErrorDescription run(HintContext ctx) {
        CompilationInfo ci = ctx.getInfo();
        if (ci.getSourceVersion().compareTo(SourceVersion.RELEASE_5) < 0 || ctx.getPath().getLeaf().getKind() != Tree.Kind.METHOD_INVOCATION) {
            return null;
        }
        MethodInvocationTree mit = (MethodInvocationTree)ctx.getPath().getLeaf();
        if (mit.getMethodSelect().getKind() != Tree.Kind.MEMBER_SELECT) {
            return null;
        }
        String mn = ((MemberSelectTree)mit.getMethodSelect()).getIdentifier().toString();
        TreePath unboxPath = ctx.getPath();
        TreePath vPath = (TreePath)ctx.getVariables().get("$v");
        Tree followed = unboxPath.getLeaf();
        TreePath parentPath = unboxPath.getParentPath();
        while (parentPath.getLeaf().getKind() == Tree.Kind.PARENTHESIZED) {
            followed = parentPath.getLeaf();
            parentPath = parentPath.getParentPath();
        }
        Tree t = parentPath.getLeaf();
        TreePath otherPath = null;
        switch (t.getKind()) {
            case TYPE_CAST: {
                TypeCastTree castTree = (TypeCastTree)t;
                TreePath toTypePath = new TreePath(parentPath, castTree.getType());
                TypeMirror m = ci.getTrees().getTypeMirror(toTypePath);
                TypeMirror vt = ci.getTrees().getTypeMirror(vPath);
                if (Utilities.isValidType(m) && (!m.getKind().isPrimitive() || ci.getTypes().isAssignable(ci.getTypes().unboxedType(vt), m))) break;
                return null;
            }
            case CONDITIONAL_EXPRESSION: {
                ExpressionTree other;
                ConditionalExpressionTree cte = (ConditionalExpressionTree)t;
                if (cte.getTrueExpression() == followed) {
                    other = cte.getFalseExpression();
                } else {
                    if (cte.getFalseExpression() != followed) break;
                    other = cte.getTrueExpression();
                }
                otherPath = new TreePath(parentPath, other);
                TypeMirror m = ci.getTrees().getTypeMirror(otherPath);
                if (m != null && m.getKind().isPrimitive()) break;
                return null;
            }
            case EQUAL_TO: 
            case NOT_EQUAL_TO: {
                BinaryTree bt = (BinaryTree)t;
                ExpressionTree other = followed == bt.getLeftOperand() ? bt.getRightOperand() : bt.getLeftOperand();
                otherPath = new TreePath(parentPath, other);
                TypeMirror m = ci.getTrees().getTypeMirror(otherPath);
                if (m != null && m.getKind().isPrimitive()) break;
                return null;
            }
            case METHOD_INVOCATION: {
                if (Utilities.checkAlternativeInvocation(ci, parentPath, ctx.getPath(), vPath, null)) break;
                return null;
            }
        }
        if (otherPath != null) {
            ExpressionTree selTree;
            while (otherPath.getLeaf().getKind() == Tree.Kind.PARENTHESIZED) {
                otherPath = new TreePath(otherPath, ((ParenthesizedTree)otherPath.getLeaf()).getExpression());
            }
            Tree other = otherPath.getLeaf();
            if (other.getKind() == Tree.Kind.METHOD_INVOCATION && (selTree = (mit = (MethodInvocationTree)other).getMethodSelect()).getKind() == Tree.Kind.MEMBER_SELECT) {
                MemberSelectTree mst = (MemberSelectTree)selTree;
                TypeMirror x = ctx.getInfo().getTrees().getTypeMirror(new TreePath(otherPath, mst.getExpression()));
                if (Utilities.isPrimitiveWrapperType(x) && mst.getIdentifier().toString().endsWith("Value")) {
                    return null;
                }
            }
        }
        return ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)ctx.getPath(), (String)Bundle.TEXT_UnnecessaryUnboxing(), (Fix[])new Fix[]{JavaFixUtilities.rewriteFix((HintContext)ctx, (String)Bundle.FIX_UnnecessaryUnboxing(mn), (TreePath)ctx.getPath(), (String)"$v")});
    }
}

