/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.perf;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.ArithmeticUtilities;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.perf.Bundle;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;

public class ReplaceBufferByString {
    private static final Set<String> INCOMPATIBLE_METHOD_NAMES = new HashSet<String>(Arrays.asList("append", "delete", "insert", "replace", "reverse", "setCharAt", "setLength", "capacity", "ensureCapacity", "trimToSize"));

    public static ErrorDescription checkReplace(HintContext ctx) {
        CompilationInfo ci = ctx.getInfo();
        TreePath vp = (TreePath)ctx.getVariables().get("$x");
        TreePath initP = (TreePath)ctx.getVariables().get("$expr");
        Element el = ci.getTrees().getElement(vp);
        if (el == null || el.getKind() != ElementKind.LOCAL_VARIABLE) {
            return null;
        }
        StringBufferUsageScanner scanner = new StringBufferUsageScanner(ci, (VariableElement)el);
        TreePath declRoot = ctx.getPath().getParentPath();
        scanner.scan(declRoot, null);
        if (scanner.isIncompatible()) {
            return null;
        }
        NewAppendScanner newScan = new NewAppendScanner(ci);
        if (newScan.scan(initP, null) != Boolean.TRUE || !newScan.hasContents) {
            return null;
        }
        return ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)ctx.getPath(), (String)Bundle.TEXT_ReplaceStringBufferByString(), (Fix[])new Fix[]{new RewriteToStringFix(TreePathHandle.create((TreePath)vp, (CompilationInfo)ci), TreePathHandle.create((TreePath)declRoot, (CompilationInfo)ci)).toEditorFix()});
    }

    private static boolean isPrimitiveType(TypeMirror tm) {
        if (tm == null) {
            return false;
        }
        switch (tm.getKind()) {
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case SHORT: {
                return true;
            }
        }
        return false;
    }

    private static class StringBufferUsageScanner
    extends TreePathScanner<Boolean, Void> {
        private final CompilationInfo ci;
        private final VariableElement var;
        private boolean assignedFromVar;
        private boolean assignedToVar;
        private boolean assignedToArray;
        private boolean returned;
        private boolean incompatibleMethodCalled;
        private boolean passedToMethod;

        public StringBufferUsageScanner(CompilationInfo ci, VariableElement var) {
            this.ci = ci;
            this.var = var;
        }

        public boolean isIncompatible() {
            return this.assignedFromVar || this.assignedToArray || this.assignedToVar || this.returned || this.incompatibleMethodCalled || this.passedToMethod;
        }

        @Override
        public Boolean scan(Tree tree, Void p) {
            boolean stop = this.isIncompatible();
            if (stop) {
                return false;
            }
            return (Boolean)super.scan(tree, p);
        }

        @Override
        public Boolean visitIdentifier(IdentifierTree node, Void p) {
            Element el = this.ci.getTrees().getElement(this.getCurrentPath());
            if (el == this.var) {
                return true;
            }
            return (Boolean)super.visitIdentifier(node, p);
        }

        @Override
        public Boolean visitAssignment(AssignmentTree node, Void p) {
            Boolean lval = this.scan((Tree)node.getVariable(), p);
            if (lval == Boolean.TRUE) {
                this.assignedFromVar = true;
                return true;
            }
            Boolean res = this.scan((Tree)node.getExpression(), p);
            if (res == Boolean.TRUE) {
                this.assignedToVar = true;
            }
            return false;
        }

        @Override
        public Boolean visitNewArray(NewArrayTree node, Void p) {
            if (node.getInitializers() != null) {
                for (ExpressionTree expressionTree : node.getInitializers()) {
                    if (this.scan((Tree)expressionTree, p) != Boolean.TRUE) continue;
                    this.assignedToArray = true;
                    break;
                }
            }
            return false;
        }

        @Override
        public Boolean visitNewClass(NewClassTree node, Void p) {
            this.scan((Tree)node.getEnclosingExpression(), p);
            for (ExpressionTree expressionTree : node.getArguments()) {
                Boolean used = this.scan((Tree)expressionTree, p);
                if (used != Boolean.TRUE) continue;
                this.passedToMethod = true;
            }
            return false;
        }

        @Override
        public Boolean visitMemberSelect(MemberSelectTree node, Void p) {
            Boolean expr = this.scan((Tree)node.getExpression(), p);
            if (expr != Boolean.TRUE) {
                return false;
            }
            String n = node.getIdentifier().toString();
            return INCOMPATIBLE_METHOD_NAMES.contains(n);
        }

        @Override
        public Boolean visitMethodInvocation(MethodInvocationTree node, Void p) {
            Boolean expr = this.scan((Tree)node.getMethodSelect(), p);
            if (expr == Boolean.TRUE) {
                this.incompatibleMethodCalled = true;
                return expr;
            }
            for (ExpressionTree expressionTree : node.getArguments()) {
                Boolean used = this.scan((Tree)expressionTree, p);
                if (used != Boolean.TRUE) continue;
                this.passedToMethod = true;
            }
            return false;
        }

        @Override
        public Boolean visitReturn(ReturnTree node, Void p) {
            if (this.scan((Tree)node.getExpression(), p) == Boolean.TRUE) {
                this.returned = true;
            }
            return false;
        }
    }

    private static class ToStringTranslator
    extends TreePathScanner {
        private final WorkingCopy wc;
        private final Element varElement;
        private final GeneratorUtilities gu;

        public ToStringTranslator(WorkingCopy wc, Element varElement) {
            this.wc = wc;
            this.varElement = varElement;
            this.gu = GeneratorUtilities.get((WorkingCopy)wc);
        }

        @Override
        public Object visitMemberSelect(MemberSelectTree node, Object p) {
            Tree x;
            Tree.Kind k;
            if (this.wc.getTrees().getElement(new TreePath(this.getCurrentPath(), node.getExpression())) != this.varElement) {
                return super.visitMemberSelect(node, p);
            }
            Element target = this.wc.getTrees().getElement(this.getCurrentPath());
            if (target != null && target.getKind() == ElementKind.METHOD && (k = (x = this.getCurrentPath().getParentPath().getLeaf()).getKind()) == Tree.Kind.METHOD_INVOCATION && node.getIdentifier().contentEquals("toString")) {
                this.gu.copyComments(x, (Tree)node.getExpression(), true);
                this.gu.copyComments(x, (Tree)node.getExpression(), false);
                this.wc.rewrite(x, (Tree)node.getExpression());
            }
            return super.visitMemberSelect(node, p);
        }
    }

    private static class RewriteToStringFix
    extends JavaFix {
        private final TreePathHandle initPath;
        private WorkingCopy wc;
        private TreeMaker mk;
        private DeclaredType stringType;
        private GeneratorUtilities gu;

        public RewriteToStringFix(TreePathHandle initPath, TreePathHandle handle) {
            super(handle);
            this.initPath = initPath;
        }

        protected String getText() {
            return Bundle.FIX_ReplaceStringBufferByString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            TreePath p = this.initPath.resolve((CompilationInfo)ctx.getWorkingCopy());
            if (p == null) {
                return;
            }
            this.wc = ctx.getWorkingCopy();
            this.mk = this.wc.getTreeMaker();
            Element el = this.wc.getTrees().getElement(p);
            if (el == null) {
                return;
            }
            this.gu = GeneratorUtilities.get((WorkingCopy)this.wc);
            this.gu.importComments(p.getLeaf(), this.wc.getCompilationUnit());
            try {
                TypeElement stringEl = this.wc.getElements().getTypeElement("java.lang.String");
                if (stringEl == null) {
                    return;
                }
                this.stringType = (DeclaredType)stringEl.asType();
                VariableTree vt = (VariableTree)p.getLeaf();
                this.rewriteAppends(new TreePath(p, vt.getInitializer()));
                ToStringTranslator tst = new ToStringTranslator(this.wc, el);
                tst.scan(ctx.getPath(), tst);
                Tree t = this.mk.Type((TypeMirror)this.stringType);
                this.gu.copyComments(vt.getType(), t, true);
                this.gu.copyComments(vt.getType(), t, false);
                this.wc.rewrite(vt.getType(), t);
            }
            finally {
                this.wc = null;
                this.mk = null;
                this.stringType = null;
            }
        }

        private ExpressionTree rewriteNewClass(TreePath p) {
            ExpressionTree expr = (ExpressionTree)p.getLeaf();
            NewClassTree nct = (NewClassTree)expr;
            Element el = this.wc.getTrees().getElement(p);
            if (el != null && el.getKind() == ElementKind.CONSTRUCTOR) {
                ExecutableElement ee = (ExecutableElement)el;
                if (ee.getParameters().isEmpty()) {
                    return null;
                }
                TypeMirror argType = ee.getParameters().get(0).asType();
                if (argType.getKind() == TypeKind.DECLARED) {
                    ExpressionTree a = nct.getArguments().get(0);
                    this.gu.copyComments((Tree)expr, (Tree)a, true);
                    this.gu.copyComments((Tree)expr, (Tree)a, false);
                    this.wc.rewrite((Tree)expr, (Tree)a);
                    return a;
                }
                return null;
            }
            return expr;
        }

        private ExpressionTree rewriteAppends(TreePath p) {
            ExpressionTree expr = (ExpressionTree)p.getLeaf();
            if (expr.getKind() == Tree.Kind.NEW_CLASS) {
                return this.rewriteNewClass(p);
            }
            if (expr.getKind() != Tree.Kind.METHOD_INVOCATION) {
                return expr;
            }
            MethodInvocationTree mit = (MethodInvocationTree)expr;
            if (mit.getMethodSelect().getKind() != Tree.Kind.MEMBER_SELECT) {
                return expr;
            }
            MemberSelectTree select = (MemberSelectTree)mit.getMethodSelect();
            if (!select.getIdentifier().contentEquals("append")) {
                return expr;
            }
            ExpressionTree selector = this.rewriteAppends(new TreePath(new TreePath(p, mit.getMethodSelect()), select.getExpression()));
            if (mit.getArguments().size() != 1) {
                if (selector == null) {
                    return null;
                }
                this.gu.copyComments((Tree)select.getExpression(), (Tree)mit, true);
                this.gu.copyComments((Tree)select.getExpression(), (Tree)mit, false);
                this.wc.rewrite((Tree)mit, (Tree)select.getExpression());
                return expr;
            }
            ExpressionTree arg = mit.getArguments().get(0);
            TreePath argPath = new TreePath(p, arg);
            TypeMirror tm1 = this.wc.getTrees().getTypeMirror(argPath);
            boolean b1 = this.wc.getTypes().isSameType(tm1, this.stringType);
            if (selector != null) {
                TreePath selectPath = new TreePath(p, selector);
                this.wc.getTreeUtilities().attributeTree((Tree)selector, this.wc.getTrees().getScope(selectPath));
                TypeMirror tm2 = this.wc.getTrees().getTypeMirror(selectPath);
                boolean b2 = this.wc.getTypes().isSameType(tm2, this.stringType);
                if (b1 || b2) {
                    arg = this.makeParenthesis(arg);
                } else {
                    arg = this.makeToString(argPath);
                    selector = this.makeToString(selectPath);
                }
                arg = this.mk.Binary(Tree.Kind.PLUS, selector, this.makeParenthesis(arg));
                TreePath resPath = new TreePath(p, arg);
                Object o = ArithmeticUtilities.compute((CompilationInfo)this.wc, resPath, true, true);
                if (o instanceof String) {
                    arg = this.mk.Literal(o);
                }
            } else {
                Object o = ArithmeticUtilities.compute((CompilationInfo)this.wc, argPath, true, true);
                if (ArithmeticUtilities.isRealValue(o)) {
                    arg = this.mk.Literal((Object)o.toString());
                } else if (!b1) {
                    arg = this.makeToString(argPath);
                }
            }
            this.gu.copyComments((Tree)mit, (Tree)arg, true);
            this.gu.copyComments((Tree)mit, (Tree)arg, false);
            this.wc.rewrite((Tree)mit, (Tree)arg);
            return arg;
        }

        private ExpressionTree makeParenthesis(ExpressionTree arg) {
            Class<? extends Tree> c = arg.getKind().asInterface();
            if (c == BinaryTree.class || c == UnaryTree.class || c == CompoundAssignmentTree.class || c == AssignmentTree.class || c == ConditionalExpressionTree.class) {
                return this.mk.Parenthesized(arg);
            }
            return arg;
        }

        private ExpressionTree makeToString(TreePath argPath) {
            ExpressionTree arg = (ExpressionTree)argPath.getLeaf();
            TypeMirror tm = this.wc.getTrees().getTypeMirror(argPath);
            arg = ReplaceBufferByString.isPrimitiveType(tm) ? this.mk.MethodInvocation(Collections.emptyList(), (ExpressionTree)this.mk.MemberSelect(this.mk.QualIdent((Element)this.wc.getTypes().boxedClass((PrimitiveType)tm)), (CharSequence)"toString"), Collections.singletonList(arg)) : this.mk.MethodInvocation(Collections.emptyList(), (ExpressionTree)this.mk.MemberSelect(this.mk.QualIdent(this.stringType.asElement()), (CharSequence)"valueOf"), Collections.singletonList(arg));
            return arg;
        }
    }

    private static class NewAppendScanner
    extends TreePathScanner<Boolean, Void> {
        private final CompilationInfo ci;
        private boolean hasContents;

        public NewAppendScanner(CompilationInfo ci) {
            this.ci = ci;
        }

        @Override
        public Boolean reduce(Boolean r1, Boolean r2) {
            return false;
        }

        @Override
        public Boolean visitMemberSelect(MemberSelectTree node, Void p) {
            Boolean r = (Boolean)this.scan(node.getExpression(), p);
            if (r != Boolean.TRUE) {
                return false;
            }
            boolean appended = node.getIdentifier().contentEquals("append");
            this.hasContents |= appended;
            return appended;
        }

        @Override
        public Boolean visitNewClass(NewClassTree node, Void p) {
            boolean res;
            TypeMirror tm = this.ci.getTrees().getTypeMirror(this.getCurrentPath());
            if (tm == null || tm.getKind() != TypeKind.DECLARED) {
                return false;
            }
            TypeElement el = (TypeElement)((DeclaredType)tm).asElement();
            if (el == null) {
                return false;
            }
            Name n = el.getQualifiedName();
            boolean bl = res = n.contentEquals("java.lang.StringBuilder") || n.contentEquals("java.lang.StringBuffer");
            if (node.getArguments().size() == 1 && Utilities.isJavaString(this.ci, this.ci.getTrees().getTypeMirror(new TreePath(this.getCurrentPath(), node.getArguments().get(0))))) {
                this.hasContents = true;
            }
            return res;
        }

        @Override
        public Boolean visitMethodInvocation(MethodInvocationTree node, Void p) {
            return (Boolean)this.scan(node.getMethodSelect(), p);
        }
    }
}

