/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import jdk.nashorn.internal.ir.CallNode;
import jdk.nashorn.internal.ir.FunctionNode;
import jdk.nashorn.internal.ir.LiteralNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.ReferenceNode;
import jdk.nashorn.internal.ir.VarNode;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.KeystrokeHandler;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.javascript2.editor.api.lexer.JsTokenId;
import org.netbeans.modules.javascript2.editor.api.lexer.LexUtilities;
import org.netbeans.modules.javascript2.editor.parser.JsParserResult;

class JsKeyStrokeHandler
implements KeystrokeHandler {
    public boolean beforeCharInserted(Document doc, int caretOffset, JTextComponent target, char ch) throws BadLocationException {
        return false;
    }

    public boolean afterCharInserted(Document doc, int caretOffset, JTextComponent target, char ch) throws BadLocationException {
        return false;
    }

    public boolean charBackspaced(Document doc, int caretOffset, JTextComponent target, char ch) throws BadLocationException {
        return false;
    }

    public int beforeBreak(Document doc, int caretOffset, JTextComponent target) throws BadLocationException {
        return -1;
    }

    public OffsetRange findMatching(Document doc, int caretOffset) {
        return OffsetRange.NONE;
    }

    public List<OffsetRange> findLogicalRanges(ParserResult info, final int caretOffset) {
        final LinkedHashSet ranges = new LinkedHashSet();
        if (info instanceof JsParserResult) {
            final JsParserResult jsParserResult = (JsParserResult)info;
            FunctionNode root = jsParserResult.getRoot();
            final TokenSequence<? extends JsTokenId> ts = LexUtilities.getJsTokenSequence(jsParserResult.getSnapshot(), caretOffset);
            if (root != null && ts != null) {
                root.accept(new NodeVisitor(){
                    final HashSet<String> referencedFunction = new HashSet();

                    protected Node enterDefault(Node node) {
                        if (node != null && node.getStart() <= caretOffset && caretOffset <= node.getFinish()) {
                            ranges.add(new OffsetRange(node.getStart(), node.getFinish()));
                            return super.enterDefault(node);
                        }
                        return null;
                    }

                    public Node enter(FunctionNode node) {
                        if (node.isScript()) {
                            ranges.add(new OffsetRange(0, jsParserResult.getSnapshot().getText().length()));
                            if (node.getStart() <= caretOffset && caretOffset <= node.getFinish()) {
                                ranges.add(new OffsetRange(node.getStart(), node.getFinish()));
                            }
                            this.processFunction(node);
                            return null;
                        }
                        ts.move(node.getStart());
                        Token<? extends JsTokenId> token = LexUtilities.findPreviousIncluding((TokenSequence<? extends JsTokenId>)ts, Arrays.asList(JsTokenId.KEYWORD_FUNCTION));
                        if (token != null && ts.offset() <= caretOffset && caretOffset <= node.getFinish()) {
                            ranges.add(new OffsetRange(ts.offset(), node.getFinish()));
                            int firstParamOffset = node.getFinish();
                            int lastParamOffset = -1;
                            for (Node param : node.getParameters()) {
                                if (param.getStart() < firstParamOffset) {
                                    firstParamOffset = param.getStart();
                                }
                                if (param.getFinish() <= lastParamOffset) continue;
                                lastParamOffset = param.getFinish();
                            }
                            if (node.getParameters().size() > 1 && firstParamOffset < lastParamOffset && firstParamOffset <= caretOffset && caretOffset <= lastParamOffset) {
                                ranges.add(new OffsetRange(firstParamOffset, lastParamOffset));
                                for (Node param : node.getParameters()) {
                                    param.accept((NodeVisitor)this);
                                }
                            }
                            if (node.getStart() <= caretOffset && caretOffset <= node.getFinish()) {
                                ranges.add(new OffsetRange(node.getStart(), node.getFinish()));
                                this.processFunction(node);
                            }
                        }
                        return null;
                    }

                    private void processFunction(FunctionNode node) {
                        for (Node statement : node.getStatements()) {
                            statement.accept((NodeVisitor)this);
                        }
                        for (Node declaration : node.getDeclarations()) {
                            declaration.accept((NodeVisitor)this);
                        }
                        for (FunctionNode function : node.getFunctions()) {
                            if (this.referencedFunction.contains(function.getName())) continue;
                            function.accept((NodeVisitor)this);
                        }
                    }

                    public Node enter(ReferenceNode node) {
                        FunctionNode fun = node.getReference();
                        this.referencedFunction.add(fun.getName());
                        fun.accept((NodeVisitor)this);
                        return null;
                    }

                    public Node enter(VarNode node) {
                        ts.move(node.getStart());
                        Token<? extends JsTokenId> token = LexUtilities.findPreviousIncluding((TokenSequence<? extends JsTokenId>)ts, Arrays.asList(JsTokenId.KEYWORD_VAR));
                        if (token != null && ts.offset() <= caretOffset && caretOffset <= node.getFinish()) {
                            ranges.add(new OffsetRange(ts.offset(), node.getFinish()));
                            return this.enterDefault((Node)node);
                        }
                        return null;
                    }

                    public Node enter(LiteralNode node) {
                        if (node.isString() && node.getStart() <= caretOffset && caretOffset <= node.getFinish()) {
                            ranges.add(new OffsetRange(node.getStart() - 1, node.getFinish() + 1));
                        }
                        return super.enter(node);
                    }

                    public Node enter(CallNode node) {
                        if (node.getArgs().size() > 1) {
                            if (node.getStart() <= caretOffset && caretOffset <= node.getFinish()) {
                                ranges.add(new OffsetRange(node.getStart(), node.getFinish()));
                                int firstArgOffset = node.getFinish();
                                int lastArgOffset = -1;
                                for (Node arg : node.getArgs()) {
                                    if (arg.getStart() < firstArgOffset) {
                                        firstArgOffset = arg.getStart();
                                        if (arg instanceof LiteralNode && ((LiteralNode)arg).isString()) {
                                            --firstArgOffset;
                                        }
                                    }
                                    if (arg.getFinish() <= lastArgOffset) continue;
                                    lastArgOffset = arg.getFinish();
                                    if (!(arg instanceof LiteralNode) || !((LiteralNode)arg).isString()) continue;
                                    ++lastArgOffset;
                                }
                                if (firstArgOffset <= caretOffset && caretOffset <= lastArgOffset) {
                                    ranges.add(new OffsetRange(firstArgOffset, lastArgOffset));
                                }
                                for (Node arg : node.getArgs()) {
                                    arg.accept((NodeVisitor)this);
                                }
                            }
                            return null;
                        }
                        return super.enter(node);
                    }
                });
            }
        }
        ArrayList<OffsetRange> retval = new ArrayList<OffsetRange>(ranges);
        Collections.reverse(retval);
        return retval;
    }

    public int getNextWordOffset(Document doc, int caretOffset, boolean reverse) {
        return -1;
    }
}

