/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.cldcplatform.wizard;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.mobility.cldcplatform.J2MEPlatform;
import org.netbeans.spi.mobility.cldcplatform.CustomCLDCPlatformConfigurator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class SearchRunnable
implements Runnable {
    protected volatile boolean stop = false;
    protected Notifier notifier;
    private Set<File> roots;
    SearchPanel panel;
    protected ProgressHandle progress;
    private int maxLevel;
    private Collection<? extends CustomCLDCPlatformConfigurator> customConfigurators;

    public SearchRunnable(Notifier notifier, Set<File> rts, int maxLevel) {
        this.notifier = notifier;
        this.roots = new HashSet<File>();
        for (File f : rts) {
            this.roots.add(FileUtil.normalizeFile((File)f));
        }
        this.maxLevel = maxLevel;
        this.customConfigurators = Lookup.getDefault().lookup(new Lookup.Template(CustomCLDCPlatformConfigurator.class)).allInstances();
    }

    public SearchRunnable(Notifier notifier, File root, int maxLevel) {
        this(notifier, Collections.singleton(root), maxLevel);
    }

    public void stop() {
        this.stop = true;
    }

    @Override
    public void run() {
        final String titleString = NbBundle.getMessage(SearchRunnable.class, (String)"Title_SearchRunnable_Searching");
        this.progress = ProgressHandleFactory.createHandle((String)titleString);
        this.panel = new SearchPanel(ProgressHandleFactory.createProgressComponent((ProgressHandle)this.progress));
        this.progress.start();
        this.progress.switchToIndeterminate();
        final Dialog[] dialog = new Dialog[1];
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    dialog[0] = DialogDisplayer.getDefault().createDialog(new DialogDescriptor((Object)SearchRunnable.this.panel, titleString, true, new Object[]{NotifyDescriptor.CANCEL_OPTION}, NotifyDescriptor.CANCEL_OPTION, 0, new HelpCtx(SearchPanel.class), new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            SearchRunnable.this.stop();
                        }
                    }));
                    if (dialog[0] != null) {
                        dialog[0].getAccessibleContext().setAccessibleName(NbBundle.getMessage(SearchRunnable.class, (String)"ACSN_searchingPlatform"));
                        dialog[0].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SearchRunnable.class, (String)"ACSD_searchingPlatform"));
                    }
                }
            });
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!SearchRunnable.this.stop) {
                        dialog[0].setVisible(true);
                    }
                }
            });
            for (File f : this.roots) {
                this.checkDirectory(f, this.maxLevel);
            }
            this.stop();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SearchRunnable.this.progress.finish();
                    dialog[0].setVisible(false);
                    SearchRunnable.this.notifier.notifySearchFinished();
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private void checkDirectory(File directory, int maxLevel) {
        LinkedList<File> list = new LinkedList<File>();
        list.addLast(directory);
        int current = 0;
        int counter = 1;
        while (!this.stop && !list.isEmpty() && maxLevel != 0) {
            File[] files;
            File file = (File)list.removeFirst();
            this.checkForPlatform(file);
            if (maxLevel != 1 && (files = file.listFiles()) != null) {
                for (int i = 0; i < files.length; ++i) {
                    File subfile = files[i];
                    if (this.filter(subfile)) continue;
                    list.addLast(subfile);
                }
            }
            if (++current % 100 == 0) {
                final File finalFile = file;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SearchRunnable.this.panel.setCurrentPath(finalFile);
                    }
                });
            }
            if (--counter != 0) continue;
            --maxLevel;
            counter = list.size();
        }
    }

    private boolean filter(File file) {
        return !file.isDirectory();
    }

    public boolean isPossibleJ2MEPlatform(File directory) {
        for (CustomCLDCPlatformConfigurator customCLDCPlatformConfigurator : this.customConfigurators) {
            if (!customCLDCPlatformConfigurator.isPossiblePlatform(directory)) continue;
            return true;
        }
        FileObject dir = FileUtil.toFileObject((File)directory);
        return dir != null && (J2MEPlatform.isJavaME3Platform(dir) || J2MEPlatform.isJavaME8Platform(dir));
    }

    private void checkForPlatform(final File directory) {
        if (directory == null || !directory.isDirectory()) {
            return;
        }
        if (this.isPossibleJ2MEPlatform(directory)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SearchRunnable.this.panel.increment();
                    SearchRunnable.this.notifier.notifyPossiblePlatformFound(directory);
                }
            });
        }
    }

    static class SearchPanel
    extends JPanel {
        private int count = 0;
        private final JLabel searchLabel;
        private final JLabel foundLabel;

        public SearchPanel(JComponent progressComponent) {
            this.setLayout(new GridBagLayout());
            this.searchLabel = new JLabel();
            GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(12, 12, 6, 12), 0, 0);
            this.add((Component)this.searchLabel, gbc);
            gbc = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 12, 6, 12), 0, 0);
            this.add((Component)progressComponent, gbc);
            this.foundLabel = new JLabel();
            gbc = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 12, 0, 12), 0, 0);
            this.add((Component)this.foundLabel, gbc);
            this.updateMessageLabel();
            this.setPreferredSize(new Dimension(400, 70));
        }

        private void updateMessageLabel() {
            int c = this.count;
            if (c <= 0) {
                this.foundLabel.setText(NbBundle.getMessage(SearchRunnable.class, (String)"LBL_SearchRunnable_No_platform_found"));
            } else {
                this.foundLabel.setText(NbBundle.getMessage(SearchRunnable.class, (String)"LBL_SearchRunnable_Found_platforms", (Object)String.valueOf(this.count)));
            }
        }

        public void increment() {
            ++this.count;
            this.updateMessageLabel();
        }

        public void setCurrentPath(File finalFile) {
            this.searchLabel.setText(NbBundle.getMessage(SearchRunnable.class, (String)"LBL_SearchingPath", (Object)finalFile.getAbsolutePath()));
        }
    }

    public static interface Notifier {
        public void notifyPossiblePlatformFound(File var1);

        public void notifySearchFinished();
    }
}

