/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.codegen.objects;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import jdk.nashorn.internal.codegen.objects.ObjectClassGenerator;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.Symbol;
import jdk.nashorn.internal.runtime.AccessorProperty;
import jdk.nashorn.internal.runtime.Property;
import jdk.nashorn.internal.runtime.PropertyMap;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.arrays.ArrayIndex;
import jdk.nashorn.internal.runtime.linker.Lookup;

public class MapCreator {
    private final Class<?> structure;
    private final String[] keys;
    private final Symbol[] symbols;

    public MapCreator(Class<?> structure, List<String> keys, List<Symbol> symbols) {
        int size = keys.size();
        this.structure = structure;
        this.keys = keys.toArray(new String[size]);
        this.symbols = symbols.toArray(new Symbol[size]);
    }

    public PropertyMap makeMap(boolean isVarArg) {
        ArrayList<Property> properties = new ArrayList<Property>();
        assert (this.keys != null);
        for (int i = 0; i < this.keys.length; ++i) {
            String key = this.keys[i];
            Symbol symbol = this.symbols[i];
            if (symbol == null || ArrayIndex.isIndexKey(key)) continue;
            Property property = this.initHandle(key, symbol.getFieldIndex(), symbol, isVarArg);
            properties.add(property);
        }
        return PropertyMap.newMap(this.structure, properties);
    }

    private Property initHandle(String key, int fieldIndex, Symbol symbol, boolean isVarArg) {
        MethodHandle objectSetter;
        MethodHandle objectGetter;
        assert (symbol != null);
        boolean isParam = symbol.isParam();
        String fieldNameObject = ObjectClassGenerator.getFieldName(fieldIndex, Type.OBJECT);
        String fieldNamePrimitive = ObjectClassGenerator.getFieldName(fieldIndex, ObjectClassGenerator.PRIMITIVE_TYPE);
        MethodHandle primitiveGetter = null;
        MethodHandle primitiveSetter = null;
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        if (isParam && isVarArg) {
            MethodHandle arguments = Lookup.MH.getter(MethodHandles.lookup(), this.structure, "arguments", Object.class);
            MethodHandle argumentsSO = Lookup.MH.asType(arguments, arguments.type().changeReturnType(ScriptObject.class));
            objectGetter = Lookup.MH.insertArguments(Lookup.MH.filterArguments(ScriptObject.GET_ARGUMENT.methodHandle(), 0, argumentsSO), 1, fieldIndex);
            objectSetter = Lookup.MH.insertArguments(Lookup.MH.filterArguments(ScriptObject.SET_ARGUMENT.methodHandle(), 0, argumentsSO), 1, fieldIndex);
        } else {
            objectGetter = Lookup.MH.getter(lookup, this.structure, fieldNameObject, Type.OBJECT.getTypeClass());
            objectSetter = Lookup.MH.setter(lookup, this.structure, fieldNameObject, Type.OBJECT.getTypeClass());
            if (!ObjectClassGenerator.OBJECT_FIELDS_ONLY) {
                primitiveGetter = Lookup.MH.getter(lookup, this.structure, fieldNamePrimitive, ObjectClassGenerator.PRIMITIVE_TYPE.getTypeClass());
                primitiveSetter = Lookup.MH.setter(lookup, this.structure, fieldNamePrimitive, ObjectClassGenerator.PRIMITIVE_TYPE.getTypeClass());
            }
        }
        return new AccessorProperty(key, this.getPropertyFlags(symbol, isVarArg), objectGetter, objectSetter, primitiveGetter, primitiveSetter);
    }

    protected int getPropertyFlags(Symbol symbol, boolean isVarArg) {
        boolean isParam = symbol.isParam();
        int flags = 0;
        if (isParam || isVarArg) {
            flags |= 0x40;
            if (isParam) {
                flags |= 0x20;
            }
        }
        if (symbol.isScope()) {
            flags |= 4;
        }
        if (symbol.canBePrimitive()) {
            flags |= 0x80;
        }
        if (symbol.canBeUndefined()) {
            flags |= 0x100;
        }
        return flags;
    }
}

