/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.objects;

import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import jdk.nashorn.internal.objects.Global;
import jdk.nashorn.internal.objects.NativeRegExpExecResult;
import jdk.nashorn.internal.objects.annotations.Constructor;
import jdk.nashorn.internal.objects.annotations.Function;
import jdk.nashorn.internal.objects.annotations.Getter;
import jdk.nashorn.internal.objects.annotations.ScriptClass;
import jdk.nashorn.internal.objects.annotations.Setter;
import jdk.nashorn.internal.objects.annotations.SpecializedConstructor;
import jdk.nashorn.internal.objects.annotations.Where;
import jdk.nashorn.internal.runtime.ECMAErrors;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.PropertyDescriptor;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.Undefined;
import jdk.nashorn.internal.runtime.arrays.ArrayData;
import jdk.nashorn.internal.runtime.arrays.ArrayIndex;
import jdk.nashorn.internal.runtime.arrays.ArrayLikeIterator;
import jdk.nashorn.internal.runtime.arrays.IteratorAction;
import jdk.nashorn.internal.runtime.linker.Bootstrap;
import jdk.nashorn.internal.runtime.linker.InvokeByName;

@ScriptClass(value="Array")
public final class NativeArray
extends ScriptObject {
    private static final InvokeByName JOIN = new InvokeByName("join", ScriptObject.class);
    private static final MethodHandle EVERY_CALLBACK_INVOKER = NativeArray.createIteratorCallbackInvoker(Boolean.TYPE);
    private static final MethodHandle SOME_CALLBACK_INVOKER = NativeArray.createIteratorCallbackInvoker(Boolean.TYPE);
    private static final MethodHandle FOREACH_CALLBACK_INVOKER = NativeArray.createIteratorCallbackInvoker(Void.TYPE);
    private static final MethodHandle MAP_CALLBACK_INVOKER = NativeArray.createIteratorCallbackInvoker(Object.class);
    private static final MethodHandle FILTER_CALLBACK_INVOKER = NativeArray.createIteratorCallbackInvoker(Boolean.TYPE);
    private static final MethodHandle REDUCE_CALLBACK_INVOKER = Bootstrap.createDynamicInvoker("dyn:call", Object.class, Object.class, Undefined.class, Object.class, Object.class, Integer.TYPE, Object.class);
    private static final MethodHandle CALL_CMP = Bootstrap.createDynamicInvoker("dyn:call", Integer.TYPE, ScriptFunction.class, Object.class, Object.class, Object.class);
    private static final InvokeByName TO_LOCALE_STRING = new InvokeByName("toLocaleString", ScriptObject.class, String.class, new Class[0]);

    NativeArray() {
        this(ArrayData.initialArray());
    }

    NativeArray(long length) {
        this(ArrayData.allocate((int)length));
    }

    NativeArray(int[] array) {
        this(ArrayData.allocate(array));
    }

    NativeArray(long[] array) {
        this(ArrayData.allocate(array));
    }

    NativeArray(double[] array) {
        this(ArrayData.allocate(array));
    }

    NativeArray(Object[] array) {
        this(ArrayData.allocate(array.length));
        ArrayData arrayData = this.getArray();
        arrayData.ensure(array.length - 1);
        for (int index = 0; index < array.length; ++index) {
            Object value = array[index];
            arrayData = value == ScriptRuntime.EMPTY ? arrayData.delete(index) : arrayData.set(index, value, this.getContext()._strict);
        }
        this.setArray(arrayData);
    }

    private NativeArray(ArrayData arrayData) {
        this.setProto(Global.instance().getArrayPrototype());
        this.setArray(arrayData);
        this.setIsArray();
    }

    @Override
    public String getClassName() {
        return "Array";
    }

    @Override
    public Object getLength() {
        return this.getArray().length() & 0xFFFFFFFFL;
    }

    @Override
    public boolean defineOwnProperty(String key, Object propertyDesc, boolean reject) {
        PropertyDescriptor desc = NativeArray.toPropertyDescriptor(Global.instance(), propertyDesc);
        PropertyDescriptor oldLenDesc = (PropertyDescriptor)super.getOwnPropertyDescriptor("length");
        long oldLen = NativeArray.validLength(oldLenDesc.getValue(), true);
        if ("length".equals(key)) {
            boolean succeeded;
            boolean newWritable;
            if (!desc.has("value")) {
                return super.defineOwnProperty("length", propertyDesc, reject);
            }
            PropertyDescriptor newLenDesc = desc;
            long newLen = NativeArray.validLength(newLenDesc.getValue(), true);
            newLenDesc.setValue(newLen);
            if (newLen >= oldLen) {
                return super.defineOwnProperty("length", newLenDesc, reject);
            }
            if (!oldLenDesc.isWritable()) {
                if (reject) {
                    ECMAErrors.typeError("property.not.writable", "length", ScriptRuntime.safeToString(this));
                }
                return false;
            }
            boolean bl = newWritable = !newLenDesc.has("writable") || newLenDesc.isWritable();
            if (!newWritable) {
                newLenDesc.setWritable(true);
            }
            if (!(succeeded = super.defineOwnProperty("length", newLenDesc, reject))) {
                return false;
            }
            while (newLen < oldLen) {
                boolean deleteSucceeded;
                if (deleteSucceeded = this.delete(--oldLen, false)) continue;
                newLenDesc.setValue(oldLen + 1L);
                if (!newWritable) {
                    newLenDesc.setWritable(false);
                }
                super.defineOwnProperty("length", newLenDesc, false);
                if (reject) {
                    ECMAErrors.typeError("property.not.writable", "length", ScriptRuntime.safeToString(this));
                }
                return false;
            }
            if (!newWritable) {
                ScriptObject newDesc = Global.newEmptyInstance();
                newDesc.set((Object)"writable", (Object)false, false);
                return super.defineOwnProperty("length", newDesc, false);
            }
            return true;
        }
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        if (ArrayIndex.isValidArrayIndex(index)) {
            long longIndex = ArrayIndex.toLongIndex(index);
            if (longIndex >= oldLen && !oldLenDesc.isWritable()) {
                if (reject) {
                    ECMAErrors.typeError("property.not.writable", Long.toString(longIndex), ScriptRuntime.safeToString(this));
                }
                return false;
            }
            boolean succeeded = super.defineOwnProperty(key, propertyDesc, false);
            if (!succeeded) {
                if (reject) {
                    ECMAErrors.typeError("cant.redefine.property", key, ScriptRuntime.safeToString(this));
                }
                return false;
            }
            if (longIndex >= oldLen) {
                oldLenDesc.setValue(longIndex + 1L);
                super.defineOwnProperty("length", oldLenDesc, false);
            }
            return true;
        }
        return super.defineOwnProperty(key, propertyDesc, reject);
    }

    public Object[] asObjectArray() {
        return this.getArray().asObjectArray();
    }

    @Function(attributes=2, where=Where.CONSTRUCTOR)
    public static Object isArray(Object self, Object arg) {
        return NativeArray.isArray(arg) || arg == Global.instance().getArrayPrototype() || arg instanceof NativeRegExpExecResult;
    }

    @Getter(attributes=6)
    public static Object length(Object self) {
        if (NativeArray.isArray(self)) {
            return ((NativeArray)self).getArray().length() & 0xFFFFFFFFL;
        }
        return 0;
    }

    @Setter(attributes=6)
    public static void length(Object self, Object length) {
        if (NativeArray.isArray(self)) {
            ((NativeArray)self).setLength(NativeArray.validLength(length, true));
        }
    }

    static long validLength(Object length, boolean reject) {
        long len;
        double doubleLength = JSType.toNumber(length);
        if (!Double.isNaN(doubleLength) && JSType.isRepresentableAsLong(doubleLength) && (len = (long)doubleLength) >= 0L && len <= 0xFFFFFFFFL) {
            return len;
        }
        if (reject) {
            ECMAErrors.rangeError("inappropriate.array.length", ScriptRuntime.safeToString(length));
        }
        return -1L;
    }

    @Function(attributes=2)
    public static Object toString(Object self) {
        if (self instanceof ScriptObject) {
            ScriptObject sobj = (ScriptObject)self;
            try {
                Object join = JOIN.getGetter().invokeExact(sobj);
                if (join instanceof ScriptFunction) {
                    return JOIN.getInvoker().invokeExact(join, sobj);
                }
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        return ScriptRuntime.builtinObjectToString(self);
    }

    @Function(attributes=2)
    public static Object toLocaleString(Object self) {
        StringBuilder sb = new StringBuilder();
        ArrayLikeIterator<Object> iter = ArrayLikeIterator.arrayLikeIterator(self, true);
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj != null && obj != ScriptRuntime.UNDEFINED) {
                Object val = JSType.toScriptObject(obj);
                try {
                    if (val instanceof ScriptObject) {
                        ScriptObject sobj = (ScriptObject)val;
                        Object toLocaleString = TO_LOCALE_STRING.getGetter().invokeExact(sobj);
                        if (toLocaleString instanceof ScriptFunction) {
                            sb.append(TO_LOCALE_STRING.getInvoker().invokeExact(toLocaleString, sobj));
                        } else {
                            ECMAErrors.typeError("not.a.function", "toLocaleString");
                        }
                    }
                }
                catch (Error | RuntimeException t) {
                    throw t;
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    @Constructor(arity=1)
    public static Object construct(boolean newObj, Object self, Object ... args) {
        switch (args.length) {
            case 0: {
                return new NativeArray(0L);
            }
            case 1: {
                Object len = args[0];
                if (len instanceof Number) {
                    double numberLength;
                    long length;
                    if ((len instanceof Integer || len instanceof Long) && (length = ((Number)len).longValue()) >= 0L && length < 0xFFFFFFFFL) {
                        return new NativeArray(length);
                    }
                    length = JSType.toUint32(len);
                    if ((double)length != (numberLength = ((Number)len).doubleValue())) {
                        ECMAErrors.rangeError("inappropriate.array.length", JSType.toString(numberLength));
                    }
                    return new NativeArray(length);
                }
                return new NativeArray(new Object[]{args[0]});
            }
        }
        return new NativeArray(args);
    }

    @SpecializedConstructor
    public static Object construct(boolean newObj, Object self) {
        return new NativeArray(0L);
    }

    @SpecializedConstructor
    public static Object construct(boolean newObj, Object self, int length) {
        if (length >= 0) {
            return new NativeArray(length);
        }
        return NativeArray.construct(newObj, self, new Object[]{length});
    }

    @SpecializedConstructor
    public static Object construct(boolean newObj, Object self, long length) {
        if (length >= 0L && length <= 0xFFFFFFFFL) {
            return new NativeArray(length);
        }
        return NativeArray.construct(newObj, self, new Object[]{length});
    }

    @SpecializedConstructor
    public static Object construct(boolean newObj, Object self, double length) {
        long uint32length = JSType.toUint32(length);
        if ((double)uint32length == length) {
            return new NativeArray(uint32length);
        }
        return NativeArray.construct(newObj, self, new Object[]{length});
    }

    @Function(attributes=2, arity=1)
    public static Object concat(Object self, Object ... args) {
        ArrayList<Object> list = new ArrayList<Object>();
        Object selfToObject = Global.toObject(self);
        if (NativeArray.isArray(selfToObject)) {
            ArrayLikeIterator<Object> iter = ArrayLikeIterator.arrayLikeIterator(selfToObject, true);
            while (iter.hasNext()) {
                list.add(iter.next());
            }
        } else {
            list.add(selfToObject);
        }
        for (Object obj : args) {
            if (NativeArray.isArray(obj) || obj instanceof Iterable || obj != null && obj.getClass().isArray()) {
                ArrayLikeIterator<Object> iter = ArrayLikeIterator.arrayLikeIterator(obj, true);
                if (iter.hasNext()) {
                    while (iter.hasNext()) {
                        list.add(iter.next());
                    }
                    continue;
                }
                if (NativeArray.isArray(obj)) continue;
                list.add(obj);
                continue;
            }
            list.add(obj);
        }
        return new NativeArray(list.toArray());
    }

    @Function(attributes=2)
    public static Object join(Object self, Object separator) {
        String sep = separator == ScriptRuntime.UNDEFINED ? "," : JSType.toString(separator);
        StringBuilder sb = new StringBuilder();
        ArrayLikeIterator<Object> iter = ArrayLikeIterator.arrayLikeIterator(self, true);
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj != null && obj != ScriptRuntime.UNDEFINED) {
                sb.append(JSType.toString(obj));
            }
            if (!iter.hasNext()) continue;
            sb.append(sep);
        }
        return sb.toString();
    }

    @Function(attributes=2)
    public static Object pop(Object self) {
        try {
            ScriptObject sobj = (ScriptObject)self;
            boolean strict = sobj.isStrictContext();
            if (NativeArray.bulkable(sobj)) {
                return ((NativeArray)sobj).getArray().pop();
            }
            long len = JSType.toUint32(sobj.getLength());
            if (len == 0L) {
                sobj.set((Object)"length", 0, strict);
                return ScriptRuntime.UNDEFINED;
            }
            long index = len - 1L;
            Object element = sobj.get(index);
            sobj.delete(index, strict);
            sobj.set((Object)"length", index, strict);
            return element;
        }
        catch (ClassCastException | NullPointerException e) {
            ECMAErrors.typeError("not.an.object", ScriptRuntime.safeToString(self));
            return ScriptRuntime.UNDEFINED;
        }
    }

    @Function(attributes=2, arity=1)
    public static Object push(Object self, Object ... args) {
        try {
            NativeArray nativeArray;
            ScriptObject sobj = (ScriptObject)self;
            boolean strict = sobj.isStrictContext();
            if (NativeArray.bulkable(sobj) && (nativeArray = (NativeArray)sobj).getArray().length() + (long)args.length <= 0xFFFFFFFFL) {
                ArrayData newData = nativeArray.getArray().push(nativeArray.getContext()._strict, args);
                nativeArray.setArray(newData);
                return newData.length();
            }
            long len = JSType.toUint32(sobj.getLength());
            for (Object element : args) {
                sobj.set(len++, element, strict);
            }
            sobj.set((Object)"length", len, strict);
            return len;
        }
        catch (ClassCastException | NullPointerException e) {
            ECMAErrors.typeError("not.an.object", ScriptRuntime.safeToString(self));
            return ScriptRuntime.UNDEFINED;
        }
    }

    @Function(attributes=2)
    public static Object reverse(Object self) {
        try {
            ScriptObject sobj = (ScriptObject)self;
            boolean strict = sobj.isStrictContext();
            long len = JSType.toUint32(sobj.getLength());
            long middle = len / 2L;
            for (long lower = 0L; lower != middle; ++lower) {
                long upper = len - lower - 1L;
                Object lowerValue = sobj.get(lower);
                Object upperValue = sobj.get(upper);
                boolean lowerExists = sobj.has(lower);
                boolean upperExists = sobj.has(upper);
                if (lowerExists && upperExists) {
                    sobj.set(lower, upperValue, strict);
                    sobj.set(upper, lowerValue, strict);
                    continue;
                }
                if (!lowerExists && upperExists) {
                    sobj.set(lower, upperValue, strict);
                    sobj.delete(upper, strict);
                    continue;
                }
                if (!lowerExists || upperExists) continue;
                sobj.delete(lower, strict);
                sobj.set(upper, lowerValue, strict);
            }
            return sobj;
        }
        catch (ClassCastException | NullPointerException e) {
            ECMAErrors.typeError("not.an.object", ScriptRuntime.safeToString(self));
            return ScriptRuntime.UNDEFINED;
        }
    }

    @Function(attributes=2)
    public static Object shift(Object self) {
        Object obj = Global.toObject(self);
        Object first = ScriptRuntime.UNDEFINED;
        if (!(obj instanceof ScriptObject)) {
            return first;
        }
        ScriptObject sobj = (ScriptObject)obj;
        boolean strict = Global.isStrict();
        long len = JSType.toUint32(sobj.getLength());
        if (len > 0L) {
            first = sobj.get(0);
            if (NativeArray.bulkable(sobj)) {
                ((NativeArray)sobj).getArray().shiftLeft(1);
            } else {
                for (long k = 1L; k < len; ++k) {
                    sobj.set(k - 1L, sobj.get(k), strict);
                }
            }
            sobj.delete(--len, strict);
        } else {
            len = 0L;
        }
        sobj.set((Object)"length", len, strict);
        return first;
    }

    @Function(attributes=2)
    public static Object slice(Object self, Object start, Object end) {
        long k;
        long finale;
        Object obj = Global.toObject(self);
        ScriptObject sobj = (ScriptObject)obj;
        long len = JSType.toUint32(sobj.getLength());
        long relativeStartUint32 = JSType.toUint32(start);
        long relativeEndUint32 = end == ScriptRuntime.UNDEFINED ? len : JSType.toUint32(end);
        long relativeEnd = end == ScriptRuntime.UNDEFINED ? len : (long)JSType.toInteger(end);
        long l = finale = relativeEnd < 0L ? Math.max(len + relativeEnd, 0L) : Math.min(Math.max(relativeEndUint32, relativeEnd), len);
        if (k >= finale) {
            return new NativeArray(0L);
        }
        if (NativeArray.bulkable(sobj)) {
            NativeArray narray = (NativeArray)sobj;
            return new NativeArray(narray.getArray().slice(k, finale));
        }
        NativeArray copy = new NativeArray(0L);
        long n = 0L;
        for (k = (relativeStart = (long)JSType.toInteger(start)) < 0L ? Math.max(len + relativeStart, 0L) : Math.min(Math.max(relativeStartUint32, relativeStart), len); k < finale; ++k) {
            copy.defineOwnProperty((int)n, sobj.get(k));
            ++n;
        }
        return copy;
    }

    private static ScriptFunction compareFunction(Object comparefn) {
        try {
            return (ScriptFunction)comparefn;
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    private static Object[] sort(Object[] array, Object comparefn) {
        final ScriptFunction cmp = NativeArray.compareFunction(comparefn);
        List<Object> list = Arrays.asList(array);
        final Undefined cmpThis = cmp == null || cmp.isStrict() ? ScriptRuntime.UNDEFINED : Global.instance();
        Collections.sort(list, new Comparator<Object>(){

            @Override
            public int compare(Object x, Object y) {
                if (x == ScriptRuntime.UNDEFINED && y == ScriptRuntime.UNDEFINED) {
                    return 0;
                }
                if (x == ScriptRuntime.UNDEFINED) {
                    return 1;
                }
                if (y == ScriptRuntime.UNDEFINED) {
                    return -1;
                }
                if (cmp != null) {
                    try {
                        return CALL_CMP.invokeExact(cmp, cmpThis, x, y);
                    }
                    catch (Error | RuntimeException e) {
                        throw e;
                    }
                    catch (Throwable t) {
                        throw new RuntimeException(t);
                    }
                }
                return JSType.toString(x).compareTo(JSType.toString(y));
            }
        });
        return list.toArray(new Object[array.length]);
    }

    @Function(attributes=2)
    public static Object sort(Object self, Object comparefn) {
        try {
            ScriptObject sobj = (ScriptObject)self;
            boolean strict = sobj.isStrictContext();
            long len = JSType.toUint32(sobj.getLength());
            if (len > 1L) {
                Object[] src = new Object[(int)len];
                for (int i = 0; i < src.length; ++i) {
                    src[i] = sobj.get(i);
                }
                Object[] sorted = NativeArray.sort(src, comparefn);
                assert (sorted.length == src.length);
                for (int i = 0; i < sorted.length; ++i) {
                    sobj.set(i, sorted[i], strict);
                }
            }
            return sobj;
        }
        catch (ClassCastException | NullPointerException e) {
            ECMAErrors.typeError("not.an.object", ScriptRuntime.safeToString(self));
            return ScriptRuntime.UNDEFINED;
        }
    }

    @Function(attributes=2, arity=2)
    public static Object splice(Object self, Object ... args) {
        long to;
        long from;
        long k;
        Object[] items;
        Undefined deleteCount;
        Object obj = Global.toObject(self);
        if (!(obj instanceof ScriptObject)) {
            return ScriptRuntime.UNDEFINED;
        }
        Undefined start = args.length > 0 ? args[0] : ScriptRuntime.UNDEFINED;
        Undefined undefined = deleteCount = args.length > 1 ? args[1] : ScriptRuntime.UNDEFINED;
        if (args.length > 2) {
            items = new Object[args.length - 2];
            System.arraycopy(args, 2, items, 0, items.length);
        } else {
            items = ScriptRuntime.EMPTY_ARRAY;
        }
        ScriptObject sobj = (ScriptObject)obj;
        boolean strict = Global.isStrict();
        long len = JSType.toUint32(sobj.getLength());
        long relativeStartUint32 = JSType.toUint32(start);
        long relativeStart = JSType.toInteger(start);
        long actualStart = relativeStart < 0L ? Math.max(len + relativeStart, 0L) : Math.min(Math.max(relativeStartUint32, relativeStart), len);
        long actualDeleteCount = Math.min((long)Math.max(JSType.toInteger(deleteCount), 0), len - actualStart);
        NativeArray array = new NativeArray(actualDeleteCount);
        for (k = 0L; k < actualDeleteCount; ++k) {
            from = actualStart + k;
            if (!sobj.has(from)) continue;
            array.defineOwnProperty((int)k, sobj.get(from));
        }
        if ((long)items.length < actualDeleteCount) {
            for (k = actualStart; k < len - actualDeleteCount; ++k) {
                from = k + actualDeleteCount;
                to = k + (long)items.length;
                if (sobj.has(from)) {
                    sobj.set(to, sobj.get(from), strict);
                    continue;
                }
                sobj.delete(to, strict);
            }
            for (k = len; k > len - actualDeleteCount + (long)items.length; --k) {
                sobj.delete(k - 1L, strict);
            }
        } else if ((long)items.length > actualDeleteCount) {
            for (k = len - actualDeleteCount; k > actualStart; --k) {
                from = k + actualDeleteCount - 1L;
                to = k + (long)items.length - 1L;
                if (sobj.has(from)) {
                    Object fromValue = sobj.get(from);
                    sobj.set(to, fromValue, strict);
                    continue;
                }
                sobj.delete(to, strict);
            }
        }
        k = actualStart;
        int i = 0;
        while (i < items.length) {
            sobj.set(k, items[i], strict);
            ++i;
            ++k;
        }
        long newLength = len - actualDeleteCount + (long)items.length;
        sobj.set((Object)"length", newLength, strict);
        return array;
    }

    @Function(attributes=2, arity=1)
    public static Object unshift(Object self, Object ... items) {
        Object obj = Global.toObject(self);
        if (!(obj instanceof ScriptObject)) {
            return ScriptRuntime.UNDEFINED;
        }
        ScriptObject sobj = (ScriptObject)obj;
        boolean strict = Global.isStrict();
        long len = JSType.toUint32(sobj.getLength());
        if (items == null) {
            return ScriptRuntime.UNDEFINED;
        }
        if (NativeArray.bulkable(sobj)) {
            NativeArray nativeArray = (NativeArray)sobj;
            nativeArray.getArray().shiftRight(items.length);
            for (int j = 0; j < items.length; ++j) {
                nativeArray.setArray(nativeArray.getArray().set(j, items[j], sobj.isStrictContext()));
            }
        } else {
            for (long k = len; k > 0L; --k) {
                long from = k - 1L;
                long to = k + (long)items.length - 1L;
                if (sobj.has(from)) {
                    Object fromValue = sobj.get(from);
                    sobj.set(to, fromValue, strict);
                    continue;
                }
                sobj.delete(to, strict);
            }
            for (int j = 0; j < items.length; ++j) {
                sobj.set(j, items[j], strict);
            }
        }
        long newLength = len + (long)items.length;
        sobj.set((Object)"length", newLength, strict);
        return newLength;
    }

    @Function(attributes=2, arity=1)
    public static Object indexOf(Object self, Object searchElement, Object fromIndex) {
        try {
            ScriptObject sobj = (ScriptObject)Global.toObject(self);
            long len = JSType.toUint32(sobj.getLength());
            long n = JSType.toLong(fromIndex);
            if (len == 0L || n >= len) {
                return -1;
            }
            for (long k = Math.max(0L, n < 0L ? len - Math.abs(n) : n); k < len; ++k) {
                if (!sobj.has(k) || !ScriptRuntime.EQ_STRICT(sobj.get(k), searchElement)) continue;
                return k;
            }
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            // empty catch block
        }
        return -1;
    }

    @Function(attributes=2, arity=1)
    public static Object lastIndexOf(Object self, Object ... args) {
        try {
            long k;
            ScriptObject sobj = (ScriptObject)Global.toObject(self);
            long len = JSType.toUint32(sobj.getLength());
            if (len == 0L) {
                return -1;
            }
            Undefined searchElement = args.length > 0 ? args[0] : ScriptRuntime.UNDEFINED;
            long n = args.length > 1 ? JSType.toLong(args[1]) : len - 1L;
            long l = k = n < 0L ? len - Math.abs(n) : Math.min(n, len - 1L);
            while (k >= 0L) {
                if (sobj.has(k) && ScriptRuntime.EQ_STRICT(sobj.get(k), searchElement)) {
                    return k;
                }
                --k;
            }
        }
        catch (ClassCastException | NullPointerException e) {
            ECMAErrors.typeError("not.an.object", ScriptRuntime.safeToString(self));
        }
        return -1;
    }

    @Function(attributes=2, arity=1)
    public static Object every(Object self, Object callbackfn, Object thisArg) {
        return NativeArray.applyEvery(Global.toObject(self), callbackfn, thisArg);
    }

    private static boolean applyEvery(Object self, Object callbackfn, Object thisArg) {
        return (Boolean)new IteratorAction<Boolean>(Global.toObject(self), callbackfn, thisArg, Boolean.valueOf(true)){

            @Override
            protected boolean forEach(Object val, int i) throws Throwable {
                this.result = EVERY_CALLBACK_INVOKER.invokeExact(this.callbackfn, this.thisArg, val, i, this.self);
                return (Boolean)this.result;
            }
        }.apply();
    }

    @Function(attributes=2, arity=1)
    public static Object some(Object self, Object callbackfn, Object thisArg) {
        return new IteratorAction<Boolean>(Global.toObject(self), callbackfn, thisArg, Boolean.valueOf(false)){

            @Override
            protected boolean forEach(Object val, int i) throws Throwable {
                this.result = SOME_CALLBACK_INVOKER.invokeExact(this.callbackfn, this.thisArg, val, i, this.self);
                return !((Boolean)this.result).booleanValue();
            }
        }.apply();
    }

    @Function(attributes=2, arity=1)
    public static Object forEach(Object self, Object callbackfn, Object thisArg) {
        return new IteratorAction<Object>(Global.toObject(self), callbackfn, thisArg, (Object)ScriptRuntime.UNDEFINED){

            @Override
            protected boolean forEach(Object val, int i) throws Throwable {
                FOREACH_CALLBACK_INVOKER.invokeExact(this.callbackfn, this.thisArg, val, i, this.self);
                return true;
            }
        }.apply();
    }

    @Function(attributes=2, arity=1)
    public static Object map(Object self, Object callbackfn, Object thisArg) {
        return new IteratorAction<NativeArray>(Global.toObject(self), callbackfn, thisArg, null){

            @Override
            protected boolean forEach(Object val, int i) throws Throwable {
                Object r = MAP_CALLBACK_INVOKER.invokeExact(this.callbackfn, this.thisArg, val, i, this.self);
                ((NativeArray)this.result).defineOwnProperty(this.index, r);
                return true;
            }

            @Override
            public void applyLoopBegin(ArrayLikeIterator<Object> iter0) {
                this.result = new NativeArray(iter0.getLength());
            }
        }.apply();
    }

    @Function(attributes=2, arity=1)
    public static Object filter(Object self, Object callbackfn, Object thisArg) {
        return new IteratorAction<NativeArray>(Global.toObject(self), callbackfn, thisArg, new NativeArray()){
            private int to = 0;

            @Override
            protected boolean forEach(Object val, int i) throws Throwable {
                if (FILTER_CALLBACK_INVOKER.invokeExact(this.callbackfn, this.thisArg, val, i, this.self)) {
                    ((NativeArray)this.result).defineOwnProperty(this.to++, val);
                }
                return true;
            }
        }.apply();
    }

    private static Object reduceInner(ArrayLikeIterator<Object> iter, Object self, Object ... args) {
        Undefined initialValue;
        Undefined callbackfn = args.length > 0 ? args[0] : ScriptRuntime.UNDEFINED;
        boolean initialValuePresent = args.length > 1;
        Undefined undefined = initialValue = initialValuePresent ? args[1] : ScriptRuntime.UNDEFINED;
        if (callbackfn == ScriptRuntime.UNDEFINED) {
            ECMAErrors.typeError("not.a.function", "undefined");
        }
        if (!initialValuePresent) {
            if (iter.hasNext()) {
                initialValue = iter.next();
            } else {
                ECMAErrors.typeError("array.reduce.invalid.init", new String[0]);
            }
        }
        return new IteratorAction<Object>(Global.toObject(self), (Object)callbackfn, (Object)ScriptRuntime.UNDEFINED, (Object)initialValue, iter){

            @Override
            protected boolean forEach(Object val, int i) throws Throwable {
                this.result = REDUCE_CALLBACK_INVOKER.invokeExact(this.callbackfn, ScriptRuntime.UNDEFINED, this.result, val, i, this.self);
                return true;
            }
        }.apply();
    }

    @Function(attributes=2, arity=1)
    public static Object reduce(Object self, Object ... args) {
        return NativeArray.reduceInner(ArrayLikeIterator.arrayLikeIterator(self), self, args);
    }

    @Function(attributes=2, arity=1)
    public static Object reduceRight(Object self, Object ... args) {
        return NativeArray.reduceInner(ArrayLikeIterator.reverseArrayLikeIterator(self), self, args);
    }

    private static boolean bulkable(ScriptObject self) {
        return self.isArray() && !NativeArray.hasInheritedArrayEntries(self);
    }

    private static boolean hasInheritedArrayEntries(ScriptObject self) {
        for (ScriptObject proto = self.getProto(); proto != null; proto = proto.getProto()) {
            if (!proto.hasArrayEntries()) continue;
            return true;
        }
        return false;
    }

    private static MethodHandle createIteratorCallbackInvoker(Class<?> rtype) {
        return Bootstrap.createDynamicInvoker("dyn:call", rtype, Object.class, Object.class, Object.class, Integer.TYPE, Object.class);
    }
}

