/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.objects;

import java.util.Arrays;
import jdk.nashorn.internal.objects.Global;
import jdk.nashorn.internal.objects.annotations.Constructor;
import jdk.nashorn.internal.objects.annotations.Function;
import jdk.nashorn.internal.objects.annotations.Getter;
import jdk.nashorn.internal.objects.annotations.ScriptClass;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;

@ScriptClass(value="ArrayBuffer")
class NativeArrayBuffer
extends ScriptObject {
    private final byte[] buffer;

    @Constructor(arity=1)
    public static Object constructor(boolean newObj, Object self, Object ... args) {
        if (args.length == 0) {
            throw new RuntimeException("missing length argument");
        }
        return new NativeArrayBuffer(JSType.toInt32(args[0]));
    }

    protected NativeArrayBuffer(byte[] byteArray) {
        this.buffer = byteArray;
        this.setProto(Global.instance().getArrayBufferPrototype());
    }

    protected NativeArrayBuffer(int byteLength) {
        this(new byte[byteLength]);
    }

    protected NativeArrayBuffer(NativeArrayBuffer other, int begin, int end) {
        this(Arrays.copyOfRange(other.buffer, begin, end));
    }

    @Getter(attributes=7)
    public static Object byteLength(Object self) {
        return ((NativeArrayBuffer)self).buffer.length;
    }

    @Function(attributes=2)
    public static Object slice(Object self, Object begin0, Object end0) {
        NativeArrayBuffer arrayBuffer = (NativeArrayBuffer)self;
        int begin = JSType.toInt32(begin0);
        int end = end0 != ScriptRuntime.UNDEFINED ? JSType.toInt32(end0) : arrayBuffer.getByteLength();
        begin = NativeArrayBuffer.adjustIndex(begin, arrayBuffer.getByteLength());
        end = NativeArrayBuffer.adjustIndex(end, arrayBuffer.getByteLength());
        return new NativeArrayBuffer((NativeArrayBuffer)self, begin, Math.max(end, begin));
    }

    static int adjustIndex(int index, int length) {
        if (index < 0) {
            return NativeArrayBuffer.clamp(index + length, length);
        }
        return NativeArrayBuffer.clamp(index, length);
    }

    private static int clamp(int index, int length) {
        if (index < 0) {
            return 0;
        }
        if (index > length) {
            return length;
        }
        return index;
    }

    public byte[] getByteArray() {
        return this.buffer;
    }

    public int getByteLength() {
        return this.buffer.length;
    }
}

