/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.objects;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import jdk.nashorn.internal.objects.Global;
import jdk.nashorn.internal.objects.annotations.Constructor;
import jdk.nashorn.internal.objects.annotations.Function;
import jdk.nashorn.internal.objects.annotations.ScriptClass;
import jdk.nashorn.internal.runtime.ECMAErrors;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.linker.Lookup;
import jdk.nashorn.internal.runtime.linker.MethodHandleFactory;
import jdk.nashorn.internal.runtime.linker.PrimitiveLookup;
import org.dynalang.dynalink.linker.GuardedInvocation;
import org.dynalang.dynalink.linker.LinkRequest;

@ScriptClass(value="Boolean")
public final class NativeBoolean
extends ScriptObject {
    private final boolean value;
    static final MethodHandle WRAPFILTER = NativeBoolean.findWrapFilter();

    NativeBoolean(boolean value) {
        this(value, Global.instance().getBooleanPrototype());
    }

    private NativeBoolean(boolean value, ScriptObject proto) {
        this.value = value;
        this.setProto(proto);
    }

    @Override
    public String safeToString() {
        return "[Boolean " + this.toString() + "]";
    }

    public String toString() {
        return Boolean.toString(this.getValue());
    }

    public boolean getValue() {
        return this.booleanValue();
    }

    public boolean booleanValue() {
        return this.value;
    }

    @Override
    public String getClassName() {
        return "Boolean";
    }

    @Function(attributes=2)
    public static Object toString(Object self) {
        return NativeBoolean.getBoolean(self).toString();
    }

    @Function(attributes=2)
    public static Object valueOf(Object self) {
        return NativeBoolean.getBoolean(self);
    }

    @Constructor(arity=1)
    public static Object constructor(boolean newObj, Object self, Object value) {
        boolean flag = JSType.toBoolean(value);
        if (newObj) {
            ScriptObject proto = self instanceof ScriptObject ? ((ScriptObject)self).getProto() : Global.instance().getBooleanPrototype();
            return new NativeBoolean(flag, proto);
        }
        return flag;
    }

    private static Boolean getBoolean(Object self) {
        if (self instanceof Boolean) {
            return (Boolean)self;
        }
        if (self instanceof NativeBoolean) {
            return ((NativeBoolean)self).getValue();
        }
        if (self != null && self == Global.instance().getBooleanPrototype()) {
            return false;
        }
        ECMAErrors.typeError("not.a.boolean", ScriptRuntime.safeToString(self));
        return false;
    }

    public static GuardedInvocation lookupPrimitive(LinkRequest request, Object receiver) {
        return PrimitiveLookup.lookupPrimitive(request, Boolean.class, (ScriptObject)new NativeBoolean((Boolean)receiver), WRAPFILTER);
    }

    private static NativeBoolean wrapFilter(Object receiver) {
        return new NativeBoolean((Boolean)receiver);
    }

    private static MethodHandle findWrapFilter() {
        try {
            return MethodHandles.lookup().findStatic(NativeBoolean.class, "wrapFilter", Lookup.MH.type(NativeBoolean.class, Object.class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new MethodHandleFactory.LookupException(e);
        }
    }
}

