/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.lang.invoke.MethodHandle;
import jdk.nashorn.internal.runtime.Property;
import jdk.nashorn.internal.runtime.PropertyMap;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.UserAccessorProperty;
import jdk.nashorn.internal.runtime.linker.Lookup;

public final class FindProperty {
    private final ScriptObject self;
    private final ScriptObject prototype;
    private final PropertyMap map;
    private final Property property;
    private final int depth;
    private final boolean isScope;

    public FindProperty(ScriptObject self, ScriptObject prototype, PropertyMap map, Property property, int depth) {
        this.self = self;
        this.prototype = prototype;
        this.map = map;
        this.property = property;
        this.depth = depth;
        this.isScope = prototype.isScope();
    }

    public ScriptObject getSelf() {
        return this.self;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getFlags() {
        return this.property.getFlags();
    }

    public MethodHandle getGetter(Class<?> type) {
        MethodHandle getter = this.property.getGetter(type);
        if (this.property instanceof UserAccessorProperty) {
            UserAccessorProperty uc = (UserAccessorProperty)this.property;
            getter = Lookup.MH.insertArguments(getter, 0, this.isInherited() ? this.getOwner() : null, uc.getGetterSlot());
        }
        return getter;
    }

    public ScriptFunction getGetterFunction() {
        return this.property.getGetterFunction(this.getOwner());
    }

    public PropertyMap getMap() {
        return this.map;
    }

    public Property getProperty() {
        return this.property;
    }

    public boolean isInherited() {
        return this.self != this.prototype;
    }

    public boolean isSelf() {
        return this.self == this.prototype;
    }

    public boolean isScope() {
        return this.isScope;
    }

    public ScriptObject getOwner() {
        return this.prototype;
    }

    public MethodHandle getSetter(Class<?> type, boolean strict) {
        MethodHandle setter = this.property.getSetter(type, this.getOwner().getMap());
        if (this.property instanceof UserAccessorProperty) {
            UserAccessorProperty uc = (UserAccessorProperty)this.property;
            setter = Lookup.MH.insertArguments(setter, 0, this.isInherited() ? this.getOwner() : null, uc.getSetterSlot(), strict ? this.property.getKey() : null);
        }
        return setter;
    }

    public ScriptFunction getSetterFunction() {
        return this.property.getSetterFunction(this.getOwner());
    }

    public boolean isConfigurable() {
        return this.property.isConfigurable();
    }

    public boolean isWritable() {
        return this.property.isWritable();
    }
}

