/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.cplusplus.ext;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.Preferences;
import javax.swing.JList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassForwardDeclaration;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmEnumForwardDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceAlias;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameter;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.deep.CsmLabel;
import org.netbeans.modules.cnd.api.model.services.CsmClassifierResolver;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.services.CsmIncludeResolver;
import org.netbeans.modules.cnd.api.model.services.CsmInstantiationProvider;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.completion.cplusplus.CsmCompletionUtils;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmCompletionExpression;
import org.netbeans.modules.cnd.editor.api.CodeStyle;
import org.netbeans.modules.cnd.modelutil.CsmPaintComponent;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.modelutil.ExceptionStr;
import org.netbeans.modules.cnd.modelutil.ParamStr;
import org.netbeans.modules.cnd.spi.model.services.CsmDocProvider;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.swing.plaf.LFCustoms;
import org.openide.util.Lookup;

public abstract class CsmResultItem
implements CompletionItem {
    private static boolean enableInstantSubstitution = true;
    protected int selectionStartOffset = -1;
    protected int selectionEndOffset = -1;
    protected int substituteOffset = -1;
    CsmObject associatedObject;
    private static final Color KEYWORD_COLOR = Color.lightGray;
    private int priority;
    private SubstitutionHint hint;
    public static final String COMPLETION_SUBSTITUTE_TEXT = "completion-substitute-text";
    private String toAdd;

    protected CsmResultItem(CsmObject associatedObject, int priority) {
        this.associatedObject = associatedObject;
        this.priority = priority;
    }

    public abstract String getItemText();

    public Object getAssociatedObject() {
        return this.associatedObject;
    }

    void setHint(SubstitutionHint hint) {
        this.hint = hint;
    }

    protected SubstitutionHint getHint() {
        return this.hint;
    }

    protected static Color getTypeColor(CsmType type) {
        return type.isBuiltInBased(false) ? LFCustoms.shiftColor((Color)KEYWORD_COLOR) : LFCustoms.getTextFgColor();
    }

    public void setSubstituteOffset(int substituteOffset) {
        this.substituteOffset = substituteOffset;
    }

    public boolean substituteCommonText(JTextComponent c, int offset, int len, int subLen) {
        return false;
    }

    public boolean substituteText(final JTextComponent c, final int offset, final int len, boolean shift) {
        final BaseDocument doc = (BaseDocument)c.getDocument();
        final String text = this.getReplaceText();
        final boolean[] res = new boolean[]{true};
        if (text != null) {
            doc.runAtomic(new Runnable(){

                @Override
                public void run() {
                    try {
                        CharSequence textToReplace = DocumentUtilities.getText((Document)doc, (int)offset, (int)len);
                        if (CharSequenceUtilities.textEquals((CharSequence)text, (CharSequence)textToReplace)) {
                            res[0] = false;
                            return;
                        }
                        int insertOffset = offset;
                        int removeLength = len;
                        String insertText = text;
                        if (CsmResultItem.this.hint == SubstitutionHint.DOT_TO_ARROW && doc.getChars(insertOffset - 1, 1)[0] == '.') {
                            --insertOffset;
                            ++removeLength;
                            insertText = "->" + insertText;
                            if (CsmResultItem.this.selectionStartOffset >= 0) {
                                CsmResultItem.this.selectionStartOffset += 2;
                                CsmResultItem.this.selectionEndOffset += 2;
                            }
                        }
                        doc.remove(insertOffset, removeLength);
                        doc.insertString(insertOffset, insertText, null);
                        if (CsmResultItem.this.selectionStartOffset >= 0) {
                            c.select(insertOffset + CsmResultItem.this.selectionStartOffset, insertOffset + CsmResultItem.this.selectionEndOffset);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            });
        }
        return res[0];
    }

    public Component getPaintComponent(JList list, boolean isSelected, boolean cellHasFocus) {
        Component ret = this.getPaintComponent(isSelected);
        if (ret == null) {
            return null;
        }
        if (isSelected) {
            ret.setBackground(list.getSelectionBackground());
            ret.setForeground(list.getSelectionForeground());
        } else {
            ret.setBackground(list.getBackground());
            ret.setForeground(list.getForeground());
        }
        ret.getAccessibleContext().setAccessibleName(this.getItemText());
        ret.getAccessibleContext().setAccessibleDescription(this.getItemText());
        return ret;
    }

    protected abstract Component getPaintComponent(boolean var1);

    public int getPreferredWidth(Graphics g, Font defaultFont) {
        Component renderComponent = this.getPaintComponent(false);
        renderComponent.setFont(defaultFont);
        int width = renderComponent.getPreferredSize().width;
        return width;
    }

    public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
        Component renderComponent = this.getPaintComponent(selected);
        renderComponent.setFont(defaultFont);
        renderComponent.setForeground(defaultColor);
        renderComponent.setBackground(backgroundColor);
        renderComponent.setBounds(0, 0, width, height);
        ((CsmPaintComponent)renderComponent).paintComponent(g);
    }

    protected static String getTypeName(CsmType type, boolean instantiateTypes) {
        CharSequence text = instantiateTypes ? CsmInstantiationProvider.getDefault().getInstantiatedText(type) : type.getText();
        return text.toString();
    }

    public final String toString() {
        return this.getStringPresentation();
    }

    public String getStringPresentation() {
        Component comp = this.getPaintComponent(false);
        return comp != null ? comp.toString() : "";
    }

    protected int convertCsmModifiers(CsmObject obj) {
        return CsmUtilities.getModifiers((CsmObject)obj);
    }

    public void processKeyEvent(KeyEvent evt) {
        if (evt.getID() == 400) {
            Completion completion = Completion.get();
            switch (evt.getKeyChar()) {
                case ' ': {
                    if (evt.getModifiers() != 0) break;
                    completion.hideCompletion();
                    completion.hideDocumentation();
                    break;
                }
                case '%': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '/': 
                case ':': 
                case ';': 
                case '=': {
                    completion.hideCompletion();
                    completion.hideDocumentation();
                }
            }
        }
    }

    public CharSequence getSortText() {
        return this.getItemText();
    }

    public CharSequence getInsertPrefix() {
        return this.getItemText();
    }

    public CompletionTask createDocumentationTask() {
        CsmDocProvider p = (CsmDocProvider)Lookup.getDefault().lookup(CsmDocProvider.class);
        Object obj = this.getAssociatedObject();
        if (p != null && obj instanceof CsmObject) {
            return p.createDocumentationTask((CsmObject)obj);
        }
        return null;
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public static void setEnableInstantSubstitution(boolean enable) {
        enableInstantSubstitution = enable;
    }

    public boolean instantSubstitution(JTextComponent c) {
        if (enableInstantSubstitution) {
            Completion completion = Completion.get();
            completion.hideCompletion();
            completion.hideDocumentation();
            this.defaultAction(c);
            return true;
        }
        return false;
    }

    public void defaultAction(JTextComponent component) {
        Completion completion = Completion.get();
        completion.hideCompletion();
        completion.hideDocumentation();
        this.defaultAction(component, "");
    }

    boolean defaultAction(JTextComponent component, String addText) {
        int substOffset = this.substituteOffset;
        if (substOffset == -1) {
            substOffset = component.getCaret().getDot();
        }
        this.toAdd = addText;
        if (this.substituteText(component, substOffset, component.getCaret().getDot() - substOffset, false)) {
            if (CsmCompletionUtils.isAutoInsertIncludeDirectives()) {
                CsmIncludeResolver inclResolver = CsmIncludeResolver.getDefault();
                BaseDocument doc = (BaseDocument)component.getDocument();
                Object ob = this.getAssociatedObject();
                if (CsmKindUtilities.isCsmObject((Object)ob)) {
                    String include;
                    CsmFile currentFile;
                    if (!(CsmClassifierResolver.getDefault().isForwardClassifier((CsmObject)ob) || (currentFile = CsmUtilities.getCsmFile((Document)doc, (boolean)false, (boolean)false)) == null || inclResolver.isObjectVisible(currentFile, (CsmObject)ob) || (include = inclResolver.getIncludeDirective(currentFile, (CsmObject)ob)).length() == 0 || this.isForwardDeclaration(component) || this.isAlreadyIncluded(component, include))) {
                        this.insertInclude(component, currentFile, include, include.charAt(include.length() - 1) == '>', substOffset);
                    }
                } else {
                    System.err.println("not yet handled object " + ob);
                }
            }
            return true;
        }
        return false;
    }

    private boolean isAlreadyIncluded(JTextComponent component, String include) {
        TokenSequence ts = CndLexerUtilities.getCppTokenSequence((JTextComponent)component, (int)0, (boolean)false, (boolean)false);
        ts.moveStart();
        while (ts.moveNext()) {
            StringBuilder buf;
            if (!ts.token().id().equals(CppTokenId.PREPROCESSOR_DIRECTIVE) || !this.isIncludesEqual(include, (buf = new StringBuilder(ts.token().text())).toString())) continue;
            return true;
        }
        return false;
    }

    private boolean isIncludesEqual(String inc1, String inc2) {
        inc1 = this.normalizeInclude(inc1);
        inc2 = this.normalizeInclude(inc2);
        return inc1.equals(inc2);
    }

    private String normalizeInclude(String inc) {
        inc = inc.toLowerCase(Locale.getDefault());
        inc = inc.replaceAll("[\\s\n]+", " ");
        inc = inc.replaceAll("[<>\"]", "\"");
        inc = inc.trim();
        return inc;
    }

    private boolean isForwardDeclaration(JTextComponent component) {
        TokenSequence ts = CndLexerUtilities.getCppTokenSequence((JTextComponent)component, (int)0, (boolean)false, (boolean)false);
        ts.moveStart();
        if (!ts.moveNext()) {
            return false;
        }
        TokenId lastID = ts.token().id();
        while (ts.offset() < this.substituteOffset) {
            TokenId id = ts.token().id();
            if (!(id instanceof CppTokenId)) continue;
            switch ((CppTokenId)id) {
                case BLOCK_COMMENT: 
                case DOXYGEN_COMMENT: 
                case NEW_LINE: 
                case LINE_COMMENT: 
                case DOXYGEN_LINE_COMMENT: 
                case WHITESPACE: {
                    break;
                }
                default: {
                    lastID = ts.token().id();
                }
            }
            if (ts.moveNext()) continue;
            return false;
        }
        if (lastID instanceof CppTokenId) {
            switch ((CppTokenId)lastID) {
                case CLASS: 
                case STRUCT: 
                case UNION: {
                    return true;
                }
            }
        }
        return false;
    }

    private void insertInclude(final JTextComponent component, final CsmFile currentFile, final String include, final boolean isSystem, int substOffset) {
        final BaseDocument doc = (BaseDocument)component.getDocument();
        CsmInclude lastInclude = null;
        boolean isLastIncludeTypeMatch = false;
        for (CsmInclude inc : currentFile.getIncludes()) {
            if (inc.getEndOffset() > substOffset) continue;
            if (inc.isSystem() == isSystem) {
                lastInclude = inc;
                isLastIncludeTypeMatch = true;
                continue;
            }
            if (lastInclude != null && (isLastIncludeTypeMatch || isSystem)) continue;
            lastInclude = inc;
        }
        final CsmInclude lastInclude2 = lastInclude;
        final boolean isLastIncludeTypeMatch2 = isLastIncludeTypeMatch;
        doc.runAtomic(new Runnable(){

            @Override
            public void run() {
                try {
                    if (lastInclude2 != null) {
                        if (isLastIncludeTypeMatch2) {
                            doc.insertString(lastInclude2.getEndOffset(), "\n" + include, null);
                        } else if (!isSystem) {
                            doc.insertString(lastInclude2.getEndOffset(), "\n\n" + include, null);
                        } else {
                            doc.insertString(lastInclude2.getStartOffset(), include + "\n\n", null);
                        }
                    } else {
                        TokenSequence ts;
                        CsmFileInfoQuery fiq = CsmFileInfoQuery.getDefault();
                        CsmOffsetable guardOffset = fiq.getGuardOffset(currentFile);
                        if (guardOffset != null) {
                            ts = CndLexerUtilities.getCppTokenSequence((JTextComponent)component, (int)guardOffset.getStartOffset(), (boolean)false, (boolean)false);
                        } else {
                            ts = CndLexerUtilities.getCppTokenSequence((JTextComponent)component, (int)0, (boolean)false, (boolean)false);
                            if (ts != null) {
                                ts.moveStart();
                            }
                        }
                        if (ts != null) {
                            int offset = CsmResultItem.this.getIncludeOffsetFromTokenSequence((TokenSequence<TokenId>)ts);
                            if (offset == 0 || guardOffset != null) {
                                doc.insertString(offset, "\n" + include + "\n\n", null);
                            } else {
                                doc.insertString(offset, "\n\n" + include + "\n", null);
                            }
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
    }

    private int getIncludeOffsetFromTokenSequence(TokenSequence<TokenId> ts) {
        if (!ts.moveNext()) {
            return 0;
        }
        int offset = ts.offset();
        if (offset != 0) {
            if (ts.token().id().equals(CppTokenId.PREPROCESSOR_DIRECTIVE)) {
                if (!ts.moveNext()) {
                    return 0;
                }
                offset = ts.offset();
                if (ts.token().id().equals(CppTokenId.PREPROCESSOR_DIRECTIVE)) {
                    if (!ts.moveNext()) {
                        return 0;
                    }
                    offset = ts.offset();
                }
            }
        } else {
            while (ts.token().id().equals(CppTokenId.WHITESPACE) || ts.token().id().equals(CppTokenId.NEW_LINE)) {
                if (ts.moveNext()) continue;
                return offset;
            }
            if (ts.token().id().equals(CppTokenId.BLOCK_COMMENT) || ts.token().id().equals(CppTokenId.DOXYGEN_COMMENT)) {
                if (!ts.moveNext()) {
                    return offset;
                }
                int firstCommentEndOffset = ts.offset();
                int newLineNumber = 0;
                while (ts.token().id().equals(CppTokenId.WHITESPACE) || ts.token().id().equals(CppTokenId.NEW_LINE)) {
                    if (ts.token().id().equals(CppTokenId.NEW_LINE)) {
                        ++newLineNumber;
                    }
                    if (ts.moveNext()) continue;
                    return offset;
                }
                if (ts.token().id().equals(CppTokenId.BLOCK_COMMENT) || ts.token().id().equals(CppTokenId.DOXYGEN_COMMENT)) {
                    return firstCommentEndOffset;
                }
                if (newLineNumber > 1) {
                    return firstCommentEndOffset;
                }
            }
        }
        return offset;
    }

    protected String getReplaceText() {
        return this.getItemText();
    }

    public int getSortPriority() {
        return this.priority;
    }

    public static class StringResultItem
    extends CsmResultItem {
        private String str;
        private static CsmPaintComponent.StringPaintComponent stringComponent = null;

        public StringResultItem(String str, int priotity) {
            super(null, priotity);
            this.str = str;
        }

        @Override
        public String getItemText() {
            return this.str;
        }

        @Override
        public Component getPaintComponent(boolean isSelected) {
            if (stringComponent == null) {
                stringComponent = this.createStringPaintComponent();
            }
            stringComponent.setSelected(isSelected);
            stringComponent.setString(this.str);
            return stringComponent;
        }

        @Override
        public Object getAssociatedObject() {
            return this.str;
        }

        protected CsmPaintComponent.StringPaintComponent createStringPaintComponent() {
            return new CsmPaintComponent.StringPaintComponent();
        }
    }

    public static class TypedefResultItem
    extends CsmResultItem {
        private CsmTypedef def;
        private int defDisplayOffset;
        private boolean displayFQN;
        private static CsmPaintComponent.TypedefPaintComponent defComponent = null;

        public TypedefResultItem(CsmTypedef def, boolean displayFQN, int priotity) {
            this(def, 0, displayFQN, priotity);
        }

        public TypedefResultItem(CsmTypedef def, int defDisplayOffset, boolean displayFQN, int priotity) {
            super((CsmObject)def, priotity);
            this.def = def;
            this.defDisplayOffset = defDisplayOffset;
            this.displayFQN = displayFQN;
        }

        protected String getName() {
            return this.def.getName().toString();
        }

        @Override
        protected String getReplaceText() {
            String text = this.getItemText();
            if (this.defDisplayOffset > 0 && this.defDisplayOffset < text.length()) {
                text = text.substring(this.defDisplayOffset);
            }
            return text;
        }

        @Override
        public String getItemText() {
            return this.displayFQN ? this.def.getQualifiedName().toString() : this.def.getName().toString();
        }

        protected CsmPaintComponent.TypedefPaintComponent createTypedefPaintComponent() {
            return new CsmPaintComponent.TypedefPaintComponent();
        }

        @Override
        public Component getPaintComponent(boolean isSelected) {
            if (defComponent == null) {
                defComponent = this.createTypedefPaintComponent();
            }
            defComponent.setSelected(isSelected);
            defComponent.setFormatTypedefName(this.getName());
            return defComponent;
        }
    }

    public static class ForwardEnumResultItem
    extends CsmResultItem {
        private CsmEnumForwardDeclaration enm;
        private int classDisplayOffset;
        private boolean displayFQN;
        private static CsmPaintComponent.EnumPaintComponent enumComponent = null;

        public ForwardEnumResultItem(CsmEnumForwardDeclaration cls, boolean displayFQN, int priotity) {
            this(cls, 0, displayFQN, priotity);
        }

        public ForwardEnumResultItem(CsmEnumForwardDeclaration enm, int classDisplayOffset, boolean displayFQN, int priotity) {
            super((CsmObject)enm, priotity);
            this.enm = enm;
            this.classDisplayOffset = classDisplayOffset;
            this.displayFQN = displayFQN;
        }

        protected String getName() {
            return this.enm.getName().toString();
        }

        @Override
        protected String getReplaceText() {
            String text = this.getItemText();
            if (this.classDisplayOffset > 0 && this.classDisplayOffset < text.length()) {
                text = text.substring(this.classDisplayOffset);
            }
            return text;
        }

        @Override
        public String getItemText() {
            return this.displayFQN ? this.enm.getQualifiedName().toString() : this.getName();
        }

        protected CsmPaintComponent.EnumPaintComponent createEnumPaintComponent() {
            return new CsmPaintComponent.EnumPaintComponent();
        }

        @Override
        public Component getPaintComponent(boolean isSelected) {
            if (enumComponent == null) {
                enumComponent = this.createEnumPaintComponent();
            }
            enumComponent.setSelected(isSelected);
            enumComponent.setFormatEnumName(this.getName());
            return enumComponent;
        }
    }

    public static class ForwardClassResultItem
    extends CsmResultItem {
        private CsmClassForwardDeclaration cls;
        private CsmDeclaration.Kind kind;
        private int classDisplayOffset;
        private boolean displayFQN;
        private static CsmPaintComponent.ClassPaintComponent clsComponent = null;
        private static CsmPaintComponent.StructPaintComponent structComponent = null;
        private static CsmPaintComponent.UnionPaintComponent unionComponent = null;

        public ForwardClassResultItem(CsmClassForwardDeclaration cls, boolean displayFQN, int priotity) {
            this(cls, 0, displayFQN, priotity);
        }

        public ForwardClassResultItem(CsmClassForwardDeclaration cls, int classDisplayOffset, boolean displayFQN, int priotity) {
            super((CsmObject)cls, priotity);
            this.cls = cls;
            CsmClass c = cls.getCsmClass();
            this.kind = c != null ? c.getKind() : CsmDeclaration.Kind.STRUCT;
            this.classDisplayOffset = classDisplayOffset;
            this.displayFQN = displayFQN;
        }

        protected String getName() {
            return this.cls.getName().toString();
        }

        @Override
        protected String getReplaceText() {
            String text = this.getItemText();
            if (this.classDisplayOffset > 0 && this.classDisplayOffset < text.length()) {
                text = text.substring(this.classDisplayOffset);
            }
            return text;
        }

        @Override
        public String getItemText() {
            return this.displayFQN ? this.cls.getQualifiedName().toString() : this.getName();
        }

        protected CsmPaintComponent.StructPaintComponent createStructPaintComponent() {
            return new CsmPaintComponent.StructPaintComponent();
        }

        protected CsmPaintComponent.UnionPaintComponent createUnionPaintComponent() {
            return new CsmPaintComponent.UnionPaintComponent();
        }

        protected CsmPaintComponent.ClassPaintComponent createClassPaintComponent() {
            return new CsmPaintComponent.ClassPaintComponent();
        }

        @Override
        public Component getPaintComponent(boolean isSelected) {
            if (this.kind == CsmDeclaration.Kind.STRUCT) {
                if (structComponent == null) {
                    structComponent = this.createStructPaintComponent();
                }
                structComponent.setSelected(isSelected);
                structComponent.setFormatClassName(this.getName());
                return structComponent;
            }
            if (this.kind == CsmDeclaration.Kind.UNION) {
                if (unionComponent == null) {
                    unionComponent = this.createUnionPaintComponent();
                }
                unionComponent.setSelected(isSelected);
                unionComponent.setFormatClassName(this.getName());
                return unionComponent;
            }
            assert (this.kind == CsmDeclaration.Kind.CLASS) : "must be class kind";
            if (clsComponent == null) {
                clsComponent = this.createClassPaintComponent();
            }
            clsComponent.setSelected(isSelected);
            clsComponent.setFormatClassName(this.getName());
            return clsComponent;
        }
    }

    public static class ClassResultItem
    extends CsmResultItem {
        private CsmClass cls;
        private CsmDeclaration.Kind kind;
        private int classDisplayOffset;
        private boolean displayFQN;
        private static CsmPaintComponent.ClassPaintComponent clsComponent = null;
        private static CsmPaintComponent.StructPaintComponent structComponent = null;
        private static CsmPaintComponent.UnionPaintComponent unionComponent = null;

        public ClassResultItem(CsmClass cls, boolean displayFQN, int priotity) {
            this(cls, 0, displayFQN, priotity);
        }

        public ClassResultItem(CsmClass cls, int classDisplayOffset, boolean displayFQN, int priotity) {
            super((CsmObject)cls, priotity);
            this.cls = cls;
            this.kind = cls.getKind();
            this.classDisplayOffset = classDisplayOffset;
            this.displayFQN = displayFQN;
        }

        protected String getName() {
            return CsmKindUtilities.isTemplate((CsmObject)this.cls) ? ((CsmTemplate)this.cls).getDisplayName().toString() : this.cls.getName().toString();
        }

        @Override
        protected String getReplaceText() {
            String text = this.getName();
            if (this.classDisplayOffset > 0 && this.classDisplayOffset < text.length()) {
                text = text.substring(this.classDisplayOffset);
            }
            return text;
        }

        @Override
        public String getItemText() {
            return this.displayFQN ? this.cls.getQualifiedName().toString() : this.getName();
        }

        protected CsmPaintComponent.StructPaintComponent createStructPaintComponent() {
            return new CsmPaintComponent.StructPaintComponent();
        }

        protected CsmPaintComponent.UnionPaintComponent createUnionPaintComponent() {
            return new CsmPaintComponent.UnionPaintComponent();
        }

        protected CsmPaintComponent.ClassPaintComponent createClassPaintComponent() {
            return new CsmPaintComponent.ClassPaintComponent();
        }

        @Override
        public Component getPaintComponent(boolean isSelected) {
            if (this.kind == CsmDeclaration.Kind.STRUCT) {
                if (structComponent == null) {
                    structComponent = this.createStructPaintComponent();
                }
                structComponent.setSelected(isSelected);
                structComponent.setFormatClassName(this.getName());
                return structComponent;
            }
            if (this.kind == CsmDeclaration.Kind.UNION) {
                if (unionComponent == null) {
                    unionComponent = this.createUnionPaintComponent();
                }
                unionComponent.setSelected(isSelected);
                unionComponent.setFormatClassName(this.getName());
                return unionComponent;
            }
            assert (this.kind == CsmDeclaration.Kind.CLASS) : "must be class kind";
            if (clsComponent == null) {
                clsComponent = this.createClassPaintComponent();
            }
            clsComponent.setSelected(isSelected);
            clsComponent.setFormatClassName(this.getName());
            return clsComponent;
        }
    }

    public static class EnumeratorResultItem
    extends CsmResultItem {
        private CsmEnumerator enmtr;
        private int enumDisplayOffset;
        private boolean displayFQN;
        private static CsmPaintComponent.EnumeratorPaintComponent enumtrComponent = null;

        public EnumeratorResultItem(CsmEnumerator enmtr, boolean displayFQN, int priotity) {
            this(enmtr, 0, displayFQN, priotity);
        }

        public EnumeratorResultItem(CsmEnumerator enmtr, int enumDisplayOffset, boolean displayFQN, int priotity) {
            super((CsmObject)enmtr, priotity);
            this.enmtr = enmtr;
            this.enumDisplayOffset = enumDisplayOffset;
            this.displayFQN = displayFQN;
        }

        protected String getName() {
            return this.enmtr.getName().toString();
        }

        @Override
        protected String getReplaceText() {
            String text = this.getItemText();
            if (this.enumDisplayOffset > 0 && this.enumDisplayOffset < text.length()) {
                text = text.substring(this.enumDisplayOffset);
            }
            return text;
        }

        @Override
        public String getItemText() {
            return (this.displayFQN ? this.enmtr.getEnumeration().getQualifiedName() + "::" : "") + this.enmtr.getName();
        }

        protected CsmPaintComponent.EnumeratorPaintComponent createPaintComponent() {
            return new CsmPaintComponent.EnumeratorPaintComponent();
        }

        @Override
        public Component getPaintComponent(boolean isSelected) {
            if (enumtrComponent == null) {
                enumtrComponent = this.createPaintComponent();
            }
            enumtrComponent.setSelected(isSelected);
            enumtrComponent.setFormatEnumeratorName(this.getName());
            return enumtrComponent;
        }
    }

    public static class EnumResultItem
    extends CsmResultItem {
        private CsmEnum enm;
        private int classDisplayOffset;
        private boolean displayFQN;
        private static CsmPaintComponent.EnumPaintComponent enumComponent = null;

        public EnumResultItem(CsmEnum enm, boolean displayFQN, int priotity) {
            this(enm, 0, displayFQN, priotity);
        }

        public EnumResultItem(CsmEnum enm, int classDisplayOffset, boolean displayFQN, int priotity) {
            super((CsmObject)enm, priotity);
            this.enm = enm;
            this.classDisplayOffset = classDisplayOffset;
            this.displayFQN = displayFQN;
        }

        protected String getName() {
            return this.enm.getName().toString();
        }

        @Override
        protected String getReplaceText() {
            String text = this.getItemText();
            if (this.classDisplayOffset > 0 && this.classDisplayOffset < text.length()) {
                text = text.substring(this.classDisplayOffset);
            }
            return text;
        }

        @Override
        public String getItemText() {
            return this.displayFQN ? this.enm.getQualifiedName().toString() : this.enm.getName().toString();
        }

        protected CsmPaintComponent.EnumPaintComponent createPaintComponent() {
            return new CsmPaintComponent.EnumPaintComponent();
        }

        @Override
        public Component getPaintComponent(boolean isSelected) {
            if (enumComponent == null) {
                enumComponent = this.createPaintComponent();
            }
            enumComponent.setSelected(isSelected);
            enumComponent.setFormatEnumName(this.getName());
            return enumComponent;
        }
    }

    public static class NamespaceResultItem
    extends CsmResultItem {
        private boolean displayFullNamespacePath;
        private CsmNamespace pkg;
        private CharSequence pkgName;
        private static CsmPaintComponent.NamespacePaintComponent pkgComponent;

        public NamespaceResultItem(CsmNamespace pkg, boolean displayFullNamespacePath, int priotity) {
            super((CsmObject)pkg, priotity);
            this.pkg = pkg;
            this.displayFullNamespacePath = displayFullNamespacePath;
            this.pkgName = pkg.getName();
        }

        @Override
        public String getItemText() {
            return this.displayFullNamespacePath ? this.pkg.getQualifiedName().toString() : this.pkg.getName().toString();
        }

        protected CsmPaintComponent.NamespacePaintComponent createPaintComponent() {
            return new CsmPaintComponent.NamespacePaintComponent();
        }

        @Override
        public Component getPaintComponent(boolean isSelected) {
            if (pkgComponent == null) {
                pkgComponent = this.createPaintComponent();
            }
            pkgComponent.setSelected(isSelected);
            pkgComponent.setNamespaceName(this.pkgName.toString());
            pkgComponent.setDisplayFullNamespacePath(this.displayFullNamespacePath);
            return pkgComponent;
        }
    }

    public static class NamespaceAliasResultItem
    extends CsmResultItem {
        private CharSequence aliasName;
        private static CsmPaintComponent.NamespaceAliasPaintComponent aliasComponent;

        public NamespaceAliasResultItem(CsmNamespaceAlias alias, boolean displayFullNamespacePath, int priotity) {
            super((CsmObject)alias, priotity);
            this.aliasName = alias.getAlias();
        }

        @Override
        public String getItemText() {
            return this.aliasName.toString();
        }

        protected CsmPaintComponent.NamespaceAliasPaintComponent createPaintComponent() {
            return new CsmPaintComponent.NamespaceAliasPaintComponent();
        }

        @Override
        public Component getPaintComponent(boolean isSelected) {
            if (aliasComponent == null) {
                aliasComponent = this.createPaintComponent();
            }
            aliasComponent.setSelected(isSelected);
            aliasComponent.setAliasName(this.aliasName.toString());
            return aliasComponent;
        }
    }

    public static class ConstructorResultItem
    extends CsmResultItem {
        private CsmFunction ctr;
        private CsmCompletionExpression substituteExp;
        private final boolean isDeclaration;
        private List<ParamStr> params = new ArrayList<ParamStr>();
        private List<ExceptionStr> excs = new ArrayList<ExceptionStr>();
        private int modifiers;
        private static CsmPaintComponent.ConstructorPaintComponent ctrComponent = null;
        private int activeParameterIndex = -1;
        private int varArgIndex = -1;
        private final CharSequence mtdName;

        public ConstructorResultItem(CsmFunction ctr, CsmCompletionExpression substituteExp, int priority, boolean isDeclaration, boolean instantiateTypes) {
            super((CsmObject)ctr, priority);
            this.ctr = ctr;
            this.substituteExp = substituteExp;
            this.isDeclaration = isDeclaration;
            this.modifiers = this.convertCsmModifiers((CsmObject)ctr);
            this.mtdName = CsmKindUtilities.isTemplate((CsmObject)ctr) ? ((CsmTemplate)ctr).getDisplayName() : ctr.getName();
            int i = 0;
            for (CsmParameter prm : ctr.getParameters()) {
                String paramValue;
                if (prm == null) continue;
                CsmType type = prm.getType();
                String string = paramValue = prm.getInitialValue() != null ? " = " + prm.getInitialValue().getText().toString() : "";
                if (type == null) {
                    assert (prm.isVarArgs()) : " non var arg " + prm + " of class " + prm.getClass().getName();
                    this.params.add(new ParamStr("", "", prm.getName().toString(), prm.getText().toString() + paramValue, true, LFCustoms.shiftColor((Color)KEYWORD_COLOR)));
                    this.varArgIndex = i;
                } else {
                    String typeName = ConstructorResultItem.getTypeName(type, instantiateTypes);
                    this.params.add(new ParamStr(typeName, typeName, prm.getName().toString(), prm.getText().toString() + paramValue, false, LFCustoms.getTextFgColor()));
                }
                ++i;
            }
        }

        public CsmCompletionExpression getExpression() {
            return this.substituteExp;
        }

        int getActiveParameterIndex() {
            return this.activeParameterIndex;
        }

        void setActiveParameterIndex(int activeParamIndex) {
            this.activeParameterIndex = activeParamIndex;
        }

        public int getModifiers() {
            return this.modifiers;
        }

        public String getName() {
            return this.mtdName.toString();
        }

        public List<ParamStr> getParams() {
            return this.params;
        }

        public List<ExceptionStr> getExceptions() {
            return this.excs;
        }

        public int getCurrentParamIndex() {
            int idx = 0;
            if (this.substituteExp != null && this.substituteExp.getExpID() == 10) {
                idx = this.substituteExp.getParameterCount() - 1;
            }
            if (this.varArgIndex > -1 && this.varArgIndex < idx) {
                idx = this.varArgIndex;
            }
            return idx;
        }

        public List<String> createParamsList() {
            ArrayList<String> ret = new ArrayList<String>();
            Iterator<ParamStr> it = this.getParams().iterator();
            while (it.hasNext()) {
                StringBuilder sb = new StringBuilder();
                ParamStr ps = it.next();
                if (ps.isVarArg()) {
                    sb.append(ps.getSimpleTypeName());
                    sb.append("...");
                } else {
                    sb.append(ps.getText());
                }
                if (it.hasNext()) {
                    sb.append(", ");
                }
                ret.add(sb.toString());
            }
            return ret;
        }

        @Override
        public boolean substituteText(final JTextComponent c, final int offset, final int origLen, boolean shift) {
            final boolean[] res = new boolean[]{true};
            final AtomicBoolean showTooltip = new AtomicBoolean();
            final BaseDocument doc = (BaseDocument)c.getDocument();
            final ConstructorResultItem thisItem = this;
            doc.runAtomic(new Runnable(){

                @Override
                public void run() {
                    String text = null;
                    boolean addParams = true;
                    int len = origLen;
                    switch (ConstructorResultItem.this.substituteExp != null ? ConstructorResultItem.this.substituteExp.getExpID() : -1) {
                        case 11: {
                            break;
                        }
                        case 10: {
                            boolean isVarArg;
                            int parmsCnt = ConstructorResultItem.this.params.size();
                            if (parmsCnt == 0) {
                                if (ConstructorResultItem.this.getActiveParameterIndex() != -1) break;
                                try {
                                    int fnwpos = LineDocumentUtils.getNextNonWhitespace((LineDocument)doc, (int)(offset + len));
                                    if (fnwpos > -1 && doc.getChars(fnwpos, 1)[0] == ')') {
                                        text = doc.getText(offset + len, fnwpos + 1 - offset - len);
                                        len = fnwpos + 1 - offset;
                                    }
                                }
                                catch (BadLocationException e) {
                                    // empty catch block
                                }
                                if (text != null) break;
                                text = ")";
                                break;
                            }
                            int activeParamIndex = ConstructorResultItem.this.getActiveParameterIndex();
                            if (activeParamIndex != -1) {
                                String paramName;
                                boolean substed = false;
                                if (activeParamIndex < parmsCnt && (paramName = ((ParamStr)ConstructorResultItem.this.params.get(activeParamIndex)).getName()) != null) {
                                    try {
                                        doc.insertString(c.getCaretPosition(), paramName, null);
                                        substed = true;
                                    }
                                    catch (BadLocationException e) {
                                        // empty catch block
                                    }
                                }
                                res[0] = substed;
                            }
                            int ind = ConstructorResultItem.this.substituteExp.getParameterCount() - 1;
                            boolean addSpace = CodeStyle.getDefault((Document)doc).spaceAfterComma();
                            try {
                                if (addSpace && (ind == 0 || offset > 0 && Character.isWhitespace(DocumentUtilities.getText((Document)doc, (int)(offset - 1), (int)1).charAt(0)))) {
                                    addSpace = false;
                                }
                            }
                            catch (BadLocationException e) {
                                // empty catch block
                            }
                            boolean bl = isVarArg = parmsCnt > 0 ? ((ParamStr)ConstructorResultItem.this.params.get(parmsCnt - 1)).isVarArg() : false;
                            if (ind >= parmsCnt && !isVarArg) break;
                            text = addSpace ? " " : "";
                            break;
                        }
                        default: {
                            int fnwpos;
                            text = ConstructorResultItem.this.getItemText();
                            boolean addSpace = CodeStyle.getDefault((Document)doc).spaceBeforeMethodCallParen();
                            boolean addClosingParen = false;
                            String mimeType = CsmCompletionUtils.getMimeType((Document)doc);
                            if (mimeType != null) {
                                Preferences prefs = (Preferences)MimeLookup.getLookup((String)mimeType).lookup(Preferences.class);
                                addClosingParen = prefs.getBoolean("pair-characters-completion", false);
                            }
                            if (addParams) {
                                boolean bl = addParams = !ConstructorResultItem.this.isFunctionAsPointer(c, text);
                            }
                            if (!addParams) break;
                            String paramsText = null;
                            try {
                                fnwpos = LineDocumentUtils.getNextNonWhitespace((LineDocument)doc, (int)(offset + len));
                                if (fnwpos > -1 && fnwpos <= LineDocumentUtils.getLineEnd((LineDocument)doc, (int)(offset + len)) && doc.getChars(fnwpos, 1)[0] == '(') {
                                    paramsText = doc.getText(offset + len, fnwpos + 1 - offset - len);
                                    if (addSpace && paramsText.length() < 2) {
                                        text = text + ' ';
                                    }
                                    len = fnwpos + 1 - offset;
                                    text = text + paramsText;
                                    thisItem.toAdd = null;
                                }
                            }
                            catch (BadLocationException e) {
                                // empty catch block
                            }
                            if (paramsText == null) {
                                if (addSpace) {
                                    text = text + ' ';
                                }
                                text = text + '(';
                                if (ConstructorResultItem.this.params.size() > 0) {
                                    ConstructorResultItem.this.selectionStartOffset = ConstructorResultItem.this.selectionEndOffset = text.length();
                                    showTooltip.set(true);
                                }
                                if (ConstructorResultItem.this.isDeclaration) {
                                    for (String obj : ConstructorResultItem.this.createParamsList()) {
                                        text = text + obj;
                                    }
                                }
                                if (!ConstructorResultItem.this.isDeclaration && !addClosingParen) break;
                                text = text + ")";
                                if (!ConstructorResultItem.this.isDeclaration || !CsmKindUtilities.isMethod((CsmObject)ConstructorResultItem.this.ctr) || !((CsmMethod)ConstructorResultItem.this.ctr).isConst()) break;
                                text = text + " const";
                                break;
                            }
                            try {
                                fnwpos = LineDocumentUtils.getNextNonWhitespace((LineDocument)doc, (int)(offset + len));
                                if (fnwpos <= -1 || doc.getChars(fnwpos, 1)[0] != ')') break;
                                paramsText = doc.getText(offset + len, fnwpos + 1 - offset - len);
                                len = fnwpos + 1 - offset;
                                if (ConstructorResultItem.this.params.size() > 0) {
                                    ConstructorResultItem.this.selectionStartOffset = ConstructorResultItem.this.selectionEndOffset = text.length();
                                }
                                text = text + paramsText;
                                break;
                            }
                            catch (BadLocationException e) {
                                // empty catch block
                            }
                        }
                    }
                    if (text != null) {
                        if (thisItem.toAdd != null && !thisItem.toAdd.equals("\n") && !"(".equals(thisItem.toAdd)) {
                            text = text + thisItem.toAdd;
                        }
                        try {
                            int index;
                            CharSequence textToReplace = DocumentUtilities.getText((Document)doc, (int)offset, (int)len);
                            if (CharSequenceUtilities.textEquals((CharSequence)text, (CharSequence)textToReplace)) {
                                c.setCaretPosition(offset + len);
                                res[0] = false;
                            }
                            int insertOffset = offset;
                            int removeLength = len;
                            String insertText = text;
                            if (!ConstructorResultItem.this.isDeclaration && ConstructorResultItem.this.getHint() == SubstitutionHint.DOT_TO_ARROW && doc.getChars(insertOffset - 1, 1)[0] == '.') {
                                --insertOffset;
                                ++removeLength;
                                insertText = "->" + insertText;
                                if (ConstructorResultItem.this.selectionStartOffset >= 0) {
                                    ConstructorResultItem.this.selectionStartOffset += 2;
                                    ConstructorResultItem.this.selectionEndOffset += 2;
                                }
                            }
                            doc.remove(insertOffset, removeLength);
                            doc.insertString(insertOffset, insertText, null);
                            if (ConstructorResultItem.this.isDeclaration) {
                                c.setCaretPosition(insertOffset + insertText.length());
                            } else if (ConstructorResultItem.this.selectionStartOffset >= 0) {
                                c.select(insertOffset + ConstructorResultItem.this.selectionStartOffset, insertOffset + ConstructorResultItem.this.selectionEndOffset);
                            } else if ("(".equals(thisItem.toAdd) && (index = insertText.lastIndexOf(41)) > -1) {
                                c.setCaretPosition(insertOffset + index);
                            }
                        }
                        catch (BadLocationException e) {
                            // empty catch block
                        }
                        res[0] = true;
                    } else {
                        res[0] = false;
                    }
                }
            });
            if (showTooltip.get()) {
                Completion completion = Completion.get();
                completion.hideCompletion();
                completion.hideDocumentation();
                completion.showToolTip();
            }
            return res[0];
        }

        protected boolean isFunctionAsPointer(JTextComponent c, String funName) {
            return false;
        }

        @Override
        public String getItemText() {
            return this.ctr.getName().toString();
        }

        protected CsmPaintComponent.ConstructorPaintComponent createPaintComponent() {
            return new CsmPaintComponent.ConstructorPaintComponent();
        }

        @Override
        public Component getPaintComponent(boolean isSelected) {
            if (ctrComponent == null) {
                ctrComponent = this.createPaintComponent();
            }
            ctrComponent.setName(this.getItemText());
            ctrComponent.setModifiers(this.getModifiers());
            ctrComponent.setParams(this.getParams());
            ctrComponent.setExceptions(this.getExceptions());
            ctrComponent.setSelected(isSelected);
            return ctrComponent;
        }
    }

    public static class MethodResultItem
    extends ConstructorResultItem {
        private static CsmPaintComponent.MethodPaintComponent mtdComponent = null;
        private static CsmPaintComponent.MethodPaintComponent globFunComponent = null;
        private CharSequence typeName;
        private Color typeColor;

        public MethodResultItem(CsmFunction mtd, CsmCompletionExpression substituteExp, int priotity, boolean isDeclaration, boolean instantiateTypes) {
            super(mtd, substituteExp, priotity, isDeclaration, instantiateTypes);
            CsmType returnType = mtd.getReturnType();
            if (returnType == null) {
                CndUtils.assertTrueInConsole((boolean)false, (String)("Function return type is null for " + mtd));
                this.typeName = "???";
                this.typeColor = LFCustoms.getTextFgColor();
            } else {
                this.typeName = CsmResultItem.getTypeName(returnType, instantiateTypes);
                this.typeColor = CsmResultItem.getTypeColor(returnType);
            }
        }

        public String getTypeName() {
            return this.typeName.toString();
        }

        public void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public Color getTypeColor() {
            return this.typeColor;
        }

        public void setTypeColor(Color typeColor) {
            this.typeColor = typeColor;
        }

        @Override
        protected CsmPaintComponent.ConstructorPaintComponent createPaintComponent() {
            return new CsmPaintComponent.MethodPaintComponent();
        }

        @Override
        public Component getPaintComponent(boolean isSelected) {
            CsmPaintComponent.MethodPaintComponent comp;
            assert (CsmKindUtilities.isCsmObject((Object)this.getAssociatedObject())) : "must be csm object";
            CsmObject mtd = (CsmObject)this.getAssociatedObject();
            if (CsmKindUtilities.isMethod((CsmObject)mtd)) {
                if (mtdComponent == null) {
                    mtdComponent = (CsmPaintComponent.MethodPaintComponent)this.createPaintComponent();
                }
                comp = mtdComponent;
            } else {
                assert (CsmKindUtilities.isGlobalFunction((CsmObject)mtd)) : "support only global fun and class methods";
                if (globFunComponent == null) {
                    globFunComponent = (CsmPaintComponent.MethodPaintComponent)this.createPaintComponent();
                }
                comp = globFunComponent;
            }
            comp.setName(this.getName());
            comp.setModifiers(this.getModifiers());
            comp.setTypeName(this.getTypeName());
            comp.setTypeColor(this.getTypeColor());
            comp.setParams(this.getParams());
            comp.setExceptions(this.getExceptions());
            comp.setSelected(isSelected);
            return comp;
        }
    }

    public static class GlobalFunctionResultItem
    extends MethodResultItem {
        public GlobalFunctionResultItem(CsmFunction mtd, CsmCompletionExpression substituteExp, int priotity, boolean isDeclaration, boolean instantiateTypes) {
            super(mtd, substituteExp, priotity, isDeclaration, instantiateTypes);
        }

        @Override
        protected CsmPaintComponent.ConstructorPaintComponent createPaintComponent() {
            return new CsmPaintComponent.GlobalFunctionPaintComponent();
        }

        @Override
        protected boolean isFunctionAsPointer(JTextComponent c, String funName) {
            return (funName.startsWith("endl") || funName.startsWith("ends") || funName.startsWith("flush") || funName.startsWith("getline") || funName.startsWith("ws")) && this.isAfterShiftOperator(c);
        }

        private boolean isAfterShiftOperator(JTextComponent c) {
            TokenSequence ts = CndLexerUtilities.getCppTokenSequence((JTextComponent)c, (int)0, (boolean)true, (boolean)false);
            ts.moveStart();
            if (!ts.moveNext()) {
                return false;
            }
            boolean result = false;
            while (ts.offset() < this.substituteOffset) {
                TokenId id = ts.token().id();
                if (id instanceof CppTokenId) {
                    block0 : switch ((CppTokenId)id) {
                        case LTLT: 
                        case GTGT: {
                            result = true;
                            break;
                        }
                        default: {
                            switch ((CppTokenId)id) {
                                case BLOCK_COMMENT: 
                                case DOXYGEN_COMMENT: 
                                case NEW_LINE: 
                                case LINE_COMMENT: 
                                case DOXYGEN_LINE_COMMENT: 
                                case WHITESPACE: 
                                case IDENTIFIER: 
                                case SCOPE: {
                                    break block0;
                                }
                            }
                            result = false;
                        }
                    }
                }
                if (ts.moveNext()) continue;
                return false;
            }
            return result;
        }
    }

    public static class FileLocalFunctionResultItem
    extends MethodResultItem {
        public FileLocalFunctionResultItem(CsmFunction mtd, CsmCompletionExpression substituteExp, int priotity, boolean isDeclaration, boolean instantiateTypes) {
            super(mtd, substituteExp, priotity, isDeclaration, instantiateTypes);
        }

        @Override
        protected CsmPaintComponent.ConstructorPaintComponent createPaintComponent() {
            return new CsmPaintComponent.FileLocalFunctionPaintComponent();
        }
    }

    public static abstract class VariableResultItem
    extends CsmResultItem {
        private CharSequence typeName;
        private Color typeColor;
        private CharSequence fldName;
        private int modifiers;
        private static CsmPaintComponent.FieldPaintComponent fieldComponent = null;
        private static CsmPaintComponent.FieldPaintComponent globVarComponent = null;
        private static CsmPaintComponent.FieldPaintComponent localVarComponent = null;
        private static CsmPaintComponent.FieldPaintComponent fileLocalVarComponent = null;

        public VariableResultItem(CsmVariable fld, int priotity) {
            super((CsmObject)fld, priotity);
            this.fldName = fld.getName();
            this.modifiers = this.convertCsmModifiers((CsmObject)fld);
            this.typeName = VariableResultItem.getTypeName(fld.getType(), false);
            this.typeColor = VariableResultItem.getTypeColor(fld.getType());
        }

        @Override
        public String getItemText() {
            return this.fldName.toString();
        }

        protected abstract CsmPaintComponent.FieldPaintComponent createPaintComponent();

        @Override
        public Component getPaintComponent(boolean isSelected) {
            CsmPaintComponent.FieldPaintComponent comp;
            assert (CsmKindUtilities.isCsmObject((Object)this.getAssociatedObject())) : "must be csm object";
            CsmObject var = (CsmObject)this.getAssociatedObject();
            if (CsmKindUtilities.isField((CsmObject)var)) {
                if (fieldComponent == null) {
                    fieldComponent = this.createPaintComponent();
                }
                comp = fieldComponent;
            } else if (CsmKindUtilities.isGlobalVariable((CsmObject)var)) {
                if (globVarComponent == null) {
                    globVarComponent = this.createPaintComponent();
                }
                comp = globVarComponent;
            } else if (CsmKindUtilities.isFileLocalVariable((CsmObject)var)) {
                if (fileLocalVarComponent == null) {
                    fileLocalVarComponent = this.createPaintComponent();
                }
                comp = fileLocalVarComponent;
            } else {
                assert (CsmKindUtilities.isLocalVariable((CsmObject)var)) : "support only global var, local var, file local var and class fields";
                if (localVarComponent == null) {
                    localVarComponent = this.createPaintComponent();
                }
                comp = localVarComponent;
            }
            comp.setTypeName(this.typeName.toString());
            comp.setName(this.fldName.toString());
            comp.setTypeColor(this.typeColor);
            comp.setModifiers(this.modifiers);
            comp.setSelected(isSelected);
            return comp;
        }
    }

    public static class LabelResultItem
    extends CsmResultItem {
        private CharSequence parName;
        private static CsmPaintComponent.LabelPaintComponent parPaintComp = null;

        public LabelResultItem(CsmLabel par, int priotity) {
            super((CsmObject)par, priotity);
            this.parName = par.getLabel();
        }

        private String getName() {
            return this.parName.toString();
        }

        @Override
        public String getItemText() {
            return this.getName();
        }

        protected CsmPaintComponent.LabelPaintComponent createPaintComponent() {
            return new CsmPaintComponent.LabelPaintComponent();
        }

        @Override
        public Component getPaintComponent(boolean isSelected) {
            if (parPaintComp == null) {
                parPaintComp = this.createPaintComponent();
            }
            parPaintComp.setName(this.getName());
            parPaintComp.setSelected(isSelected);
            return parPaintComp;
        }
    }

    public static class TemplateParameterResultItem
    extends CsmResultItem {
        private CharSequence parName;
        private static CsmPaintComponent.TemplateParameterPaintComponent parPaintComp = null;

        public TemplateParameterResultItem(CsmTemplateParameter par, int priotity) {
            super((CsmObject)par, priotity);
            this.parName = par.getName();
        }

        private String getName() {
            return this.parName.toString();
        }

        @Override
        public String getItemText() {
            return this.getName();
        }

        protected CsmPaintComponent.TemplateParameterPaintComponent createPaintComponent() {
            return new CsmPaintComponent.TemplateParameterPaintComponent();
        }

        @Override
        public Component getPaintComponent(boolean isSelected) {
            if (parPaintComp == null) {
                parPaintComp = this.createPaintComponent();
            }
            parPaintComp.setName(this.getName());
            parPaintComp.setSelected(isSelected);
            return parPaintComp;
        }
    }

    public static class MacroResultItem
    extends CsmResultItem {
        private CharSequence macName;
        private List<CharSequence> params;
        private static CsmPaintComponent.MacroPaintComponent macroPaintComp = null;

        public MacroResultItem(CsmMacro mac, int priotity) {
            super((CsmObject)mac, priotity);
            this.macName = mac.getName();
            this.params = mac.getParameters();
        }

        private String getName() {
            return this.macName.toString();
        }

        private List<CharSequence> getParams() {
            return this.params;
        }

        @Override
        public String getItemText() {
            return this.getName();
        }

        protected CsmPaintComponent.MacroPaintComponent createPaintComponent() {
            return new CsmPaintComponent.MacroPaintComponent();
        }

        @Override
        public Component getPaintComponent(boolean isSelected) {
            if (macroPaintComp == null) {
                macroPaintComp = this.createPaintComponent();
            }
            macroPaintComp.setName(this.getName());
            macroPaintComp.setParams(this.getParams());
            macroPaintComp.setSelected(isSelected);
            return macroPaintComp;
        }
    }

    public static class FieldResultItem
    extends VariableResultItem {
        public FieldResultItem(CsmField fld, int priotity) {
            super((CsmVariable)fld, priotity);
        }

        @Override
        protected CsmPaintComponent.FieldPaintComponent createPaintComponent() {
            return new CsmPaintComponent.FieldPaintComponent();
        }
    }

    public static class LocalVariableResultItem
    extends VariableResultItem {
        public LocalVariableResultItem(CsmVariable fld, int priotity) {
            super(fld, priotity);
        }

        @Override
        protected CsmPaintComponent.FieldPaintComponent createPaintComponent() {
            return new CsmPaintComponent.LocalVariablePaintComponent();
        }
    }

    public static class GlobalVariableResultItem
    extends VariableResultItem {
        public GlobalVariableResultItem(CsmVariable fld, int priotity) {
            super(fld, priotity);
        }

        @Override
        protected CsmPaintComponent.FieldPaintComponent createPaintComponent() {
            return new CsmPaintComponent.GlobalVariablePaintComponent();
        }
    }

    public static class FileLocalVariableResultItem
    extends VariableResultItem {
        public FileLocalVariableResultItem(CsmVariable fld, int priotity) {
            super(fld, priotity);
        }

        @Override
        protected CsmPaintComponent.FieldPaintComponent createPaintComponent() {
            return new CsmPaintComponent.FileLocalVariablePaintComponent();
        }
    }

    static enum SubstitutionHint {
        NONE,
        DOT_TO_ARROW,
        ARROW_TO_DOT;

    }
}

