/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.csm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmFunctionInstantiation;
import org.netbeans.modules.cnd.api.model.CsmFunctionPointerType;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmInitializerListContainer;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameter;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.deep.CsmCompoundStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmDeclarationStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmExpression;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.api.model.services.CsmCacheManager;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.completion.csm.CsmContext;
import org.netbeans.modules.cnd.completion.csm.CsmContextUtilities;
import org.netbeans.modules.cnd.completion.csm.CsmDeclarationResolver;
import org.netbeans.modules.cnd.completion.csm.CsmOffsetUtilities;
import org.netbeans.modules.cnd.completion.csm.CsmStatementResolver;
import org.netbeans.modules.cnd.completion.impl.xref.FileReferencesContext;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.utils.MutableObject;

public class CsmOffsetResolver {
    private CsmFile file;

    public CsmOffsetResolver() {
    }

    public CsmOffsetResolver(CsmFile file) {
        this.file = file;
    }

    public CsmFile getFile() {
        return this.file;
    }

    public void setFile(CsmFile file) {
        this.file = file;
    }

    public static CsmObject findObject(CsmFile file, int offset, FileReferencesContext fileReferncesContext) {
        assert (file != null) : "can't be null file in findObject";
        CsmObject last = (CsmObject)CsmCacheManager.get((Object)new CsmLastObjectKey(file, offset));
        if (last == null) {
            CsmContext context = new CsmContext(file, offset);
            last = CsmOffsetResolver.findObjectWithContext(file, offset, context, fileReferncesContext);
            last = CsmOffsetResolver.exploreTypeObject(context, last, offset);
            CsmCacheManager.put((Object)new CsmContextKey(file, offset), (Object)context);
            CsmCacheManager.put((Object)new CsmLastObjectKey(file, offset), (Object)last);
        }
        return last;
    }

    private static CsmObject findObjectWithContext(CsmFile file, int offset, CsmContext context, FileReferencesContext fileReferncesContext) {
        Collection params;
        CsmParameter param;
        List templateParams;
        CsmTemplateParameter templateParam;
        CsmFunction fun;
        CsmObject lastObj;
        assert (file != null) : "can't be null file in findObject";
        CsmObject last = null;
        if (context == null) {
            context = new CsmContext(file, offset);
        }
        last = lastObj = CsmDeclarationResolver.findInnerFileObject(file, offset, context, fileReferncesContext);
        if (CsmKindUtilities.isFunction((CsmObject)lastObj)) {
            CsmCompoundStatement body;
            CsmFunctionDefinition funDef;
            List templateParams2;
            CsmTemplateParameter templateParam2;
            fun = (CsmFunction)lastObj;
            CsmType retType = fun.getReturnType();
            if (!CsmOffsetUtilities.sameOffsets((CsmObject)fun, (CsmObject)retType) && CsmOffsetUtilities.isInObject((CsmObject)retType, offset)) {
                context.setLastObject((CsmObject)retType);
                return retType;
            }
            if (CsmKindUtilities.isTemplate((CsmObject)fun) && (templateParam2 = (CsmTemplateParameter)CsmOffsetUtilities.findObject(templateParams2 = ((CsmTemplate)fun).getTemplateParameters(), context, offset)) != null && !CsmOffsetUtilities.sameOffsets((CsmObject)fun, (CsmObject)templateParam2)) {
                CsmTemplateParameter innerTemplateParam;
                context.setLastObject((CsmObject)templateParam2);
                while (CsmKindUtilities.isTemplate((CsmObject)templateParam2) && (innerTemplateParam = (CsmTemplateParameter)CsmOffsetUtilities.findObject(templateParams2 = ((CsmTemplate)templateParam2).getTemplateParameters(), context, offset)) != null && !CsmOffsetUtilities.sameOffsets((CsmObject)templateParam2, (CsmObject)innerTemplateParam)) {
                    context.setLastObject((CsmObject)innerTemplateParam);
                    templateParam2 = innerTemplateParam;
                }
                return templateParam2;
            }
            Collection params2 = fun.getParameters();
            CsmParameter param2 = (CsmParameter)CsmOffsetUtilities.findObject(params2, context, offset);
            if (param2 != null && !CsmOffsetUtilities.sameOffsets((CsmObject)fun, (CsmObject)param2)) {
                CsmType type = param2.getType();
                if (CsmOffsetUtilities.isInObject((CsmObject)type, offset)) {
                    context.setLastObject((CsmObject)type);
                    return type;
                }
                MutableObject innerObj = new MutableObject();
                if (CsmOffsetResolver.findInExpression(param2.getInitialValue(), (CsmObject)param2, offset, context, (MutableObject<CsmObject>)innerObj)) {
                    return (CsmObject)innerObj.value;
                }
                context.setLastObject((CsmObject)param2);
                return param2;
            }
            if (CsmKindUtilities.isConstructor((CsmObject)lastObj)) {
                CsmInitializerListContainer ctor = (CsmInitializerListContainer)lastObj;
                for (CsmExpression izer : ctor.getInitializerList()) {
                    if (CsmOffsetUtilities.sameOffsets(lastObj, (CsmObject)izer) || !CsmOffsetUtilities.isInObject((CsmObject)izer, offset)) continue;
                    for (CsmStatement csmStatement : izer.getLambdas()) {
                        CsmObject found;
                        CsmDeclarationStatement lambda = (CsmDeclarationStatement)csmStatement;
                        if (CsmOffsetUtilities.sameOffsets(lastObj, (CsmObject)lambda) && lambda.getStartOffset() == lambda.getEndOffset() || !CsmOffsetUtilities.isInObject((CsmObject)lambda, offset) || !CsmStatementResolver.findInnerObject((CsmStatement)lambda, offset, context) || CsmOffsetUtilities.sameOffsets((CsmObject)lambda, found = context.getLastObject())) continue;
                        context.setLastObject(found);
                        return found;
                    }
                    context.setLastObject((CsmObject)izer);
                    return izer;
                }
            }
            if (CsmKindUtilities.isFunctionDefinition((CsmObject)lastObj) && (!CsmOffsetUtilities.sameOffsets((CsmObject)(funDef = (CsmFunctionDefinition)lastObj), (CsmObject)(body = funDef.getBody())) || body.getStartOffset() != body.getEndOffset()) && CsmOffsetUtilities.isInObject((CsmObject)body, offset)) {
                last = null;
                if (CsmStatementResolver.findInnerObject((CsmStatement)body, offset, context)) {
                    CsmObject found = context.getLastObject();
                    CsmScope lastScope = context.getLastScope();
                    if (!CsmOffsetUtilities.sameOffsets((CsmObject)body, found) && !CsmOffsetUtilities.sameOffsets((CsmObject)lastScope, found)) {
                        lastObj = last = found;
                    }
                }
            }
        }
        if (CsmKindUtilities.isClass((CsmObject)lastObj)) {
            CsmClass clazz = (CsmClass)lastObj;
            Collection inherits = clazz.getBaseClasses();
            CsmInheritance inh = (CsmInheritance)CsmOffsetUtilities.findObject(inherits, context, offset);
            if (inh != null && !CsmOffsetUtilities.sameOffsets((CsmObject)clazz, (CsmObject)inh)) {
                context.setLastObject((CsmObject)inh);
                last = inh;
            }
        } else if (CsmKindUtilities.isVariable((CsmObject)lastObj)) {
            CsmType type = ((CsmVariable)lastObj).getType();
            if (!CsmOffsetUtilities.sameOffsets(lastObj, (CsmObject)type) && CsmOffsetUtilities.isInObject((CsmObject)type, offset) && !CsmKindUtilities.isFunctionPointerType((CsmObject)type) && !CsmUtilities.isAutoType((CsmType)type)) {
                context.setLastObject((CsmObject)type);
                last = type;
            }
            MutableObject innerObj = new MutableObject();
            if (CsmOffsetResolver.findInExpression(((CsmVariable)lastObj).getInitialValue(), lastObj, offset, context, (MutableObject<CsmObject>)innerObj)) {
                lastObj = last = (CsmObject)innerObj.value;
            }
        } else if (CsmKindUtilities.isClassForwardDeclaration((CsmObject)lastObj) || CsmKindUtilities.isEnumForwardDeclaration((CsmObject)lastObj)) {
            if (CsmKindUtilities.isTemplate((CsmObject)lastObj) && (templateParam = (CsmTemplateParameter)CsmOffsetUtilities.findObject(templateParams = ((CsmTemplate)lastObj).getTemplateParameters(), context, offset)) != null && !CsmOffsetUtilities.sameOffsets(lastObj, (CsmObject)templateParam)) {
                context.setLastObject((CsmObject)templateParam);
                return templateParam;
            }
        } else if (CsmKindUtilities.isFriend((CsmObject)lastObj)) {
            if (CsmKindUtilities.isTemplate((CsmObject)lastObj) && (templateParam = (CsmTemplateParameter)CsmOffsetUtilities.findObject(templateParams = ((CsmTemplate)lastObj).getTemplateParameters(), context, offset)) != null && !CsmOffsetUtilities.sameOffsets(lastObj, (CsmObject)templateParam)) {
                context.setLastObject((CsmObject)templateParam);
                return templateParam;
            }
        } else if (CsmKindUtilities.isFunctionExplicitInstantiation((CsmObject)lastObj) && (param = (CsmParameter)CsmOffsetUtilities.findObject(params = (fun = (CsmFunctionInstantiation)lastObj).getParameters(), context, offset)) != null && !CsmOffsetUtilities.sameOffsets((CsmObject)fun, (CsmObject)param)) {
            CsmType type = param.getType();
            if (CsmOffsetUtilities.isInObject((CsmObject)type, offset)) {
                context.setLastObject((CsmObject)type);
                return type;
            }
            context.setLastObject((CsmObject)param);
            return param;
        }
        return last;
    }

    private static boolean findInExpression(CsmExpression initialValue, CsmObject lastObj, int offset, CsmContext context, MutableObject<CsmObject> result) {
        if (initialValue != null) {
            for (CsmStatement csmStatement : initialValue.getLambdas()) {
                CsmObject found;
                CsmDeclarationStatement lambda = (CsmDeclarationStatement)csmStatement;
                if (CsmOffsetUtilities.sameOffsets(lastObj, (CsmObject)lambda) && lambda.getStartOffset() == lambda.getEndOffset() || !CsmOffsetUtilities.isInObject((CsmObject)lambda, offset)) continue;
                result.value = null;
                if (CsmStatementResolver.findInnerObject((CsmStatement)lambda, offset, context) && !CsmOffsetUtilities.sameOffsets((CsmObject)lambda, found = context.getLastObject())) {
                    result.value = found;
                }
                return true;
            }
        }
        return false;
    }

    private static CsmObject exploreTypeObject(CsmContext context, CsmObject last, int offset) {
        CsmObject inner;
        if (CsmKindUtilities.isTypedefOrTypeAlias((CsmObject)last)) {
            CsmObject inner2;
            CsmType type = ((CsmTypedef)last).getType();
            if (CsmKindUtilities.isFunctionPointerType((CsmObject)type) && (inner2 = CsmOffsetResolver.updateAndFindInFunctionType(context, (CsmFunctionPointerType)type, offset)) != null) {
                last = inner2;
            }
        } else if (CsmKindUtilities.isVariable((CsmObject)last)) {
            CsmObject inner3;
            CsmType type = ((CsmVariable)last).getType();
            if (CsmKindUtilities.isFunctionPointerType((CsmObject)type) && (inner3 = CsmOffsetResolver.updateAndFindInFunctionType(context, (CsmFunctionPointerType)type, offset)) != null) {
                last = inner3;
            }
        } else if (CsmKindUtilities.isFunctionPointerType((CsmObject)last) && (inner = CsmOffsetResolver.updateAndFindInFunctionType(context, (CsmFunctionPointerType)last, offset)) != null) {
            last = inner;
        }
        return last;
    }

    private static CsmObject updateAndFindInFunctionType(CsmContext context, CsmFunctionPointerType funType, int offset) {
        if (CsmOffsetUtilities.isInObject((CsmObject)funType, offset)) {
            CsmContextUtilities.updateContext((CsmObject)funType, offset, context);
            Collection params = funType.getParameters();
            CsmParameter param = (CsmParameter)CsmOffsetUtilities.findObject(params, context, offset);
            if (param != null && !CsmOffsetUtilities.sameOffsets((CsmObject)funType, (CsmObject)param)) {
                CsmObject inner;
                CsmType type = param.getType();
                if (CsmKindUtilities.isFunctionPointerType((CsmObject)type) && (inner = CsmOffsetResolver.updateAndFindInFunctionType(context, (CsmFunctionPointerType)type, offset)) != null) {
                    return inner;
                }
                context.setLastObject((CsmObject)param);
                return param;
            }
        }
        return null;
    }

    public static CsmContext findContext(CsmFile file, int offset, FileReferencesContext fileReferncesContext) {
        CsmContext context = new CsmContext(file, offset);
        CsmOffsetResolver.findObjectWithContext(file, offset, context, fileReferncesContext);
        CsmOffsetResolver.exploreTypeObject(context, context.getLastObject(), offset);
        return context;
    }

    public static CsmContext findContextFromScope(CsmFile file, int offset, CsmScope contextScope) {
        CsmContext context = new CsmContext(file, offset);
        ArrayList<CsmScope> scopes = new ArrayList<CsmScope>();
        scopes.add(contextScope);
        while (CsmKindUtilities.isScopeElement((CsmObject)contextScope) && !CsmKindUtilities.isFile((CsmObject)contextScope)) {
            contextScope = ((CsmScopeElement)contextScope).getScope();
            scopes.add(0, contextScope);
        }
        for (CsmScope scope : scopes) {
            CsmContextUtilities.updateContext((CsmObject)scope, offset, context);
        }
        context.setLastObject((CsmObject)context.getLastScope());
        CsmOffsetResolver.exploreTypeObject(context, context.getLastObject(), offset);
        return context;
    }

    private static class CsmLastObjectKey
    extends AbstractResolvePointKey {
        public CsmLastObjectKey(CsmFile file, int offset) {
            super(file, offset);
        }
    }

    private static class CsmContextKey
    extends AbstractResolvePointKey {
        public CsmContextKey(CsmFile file, int offset) {
            super(file, offset);
        }
    }

    private static abstract class AbstractResolvePointKey {
        private final CsmFile file;
        private final int offset;

        public AbstractResolvePointKey(CsmFile file, int offset) {
            this.file = file;
            this.offset = offset;
        }

        public int hashCode() {
            int hash = 7;
            hash = 97 * hash + (this.file != null ? this.file.hashCode() : 0);
            hash = 97 * hash + this.offset;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AbstractResolvePointKey other = (AbstractResolvePointKey)obj;
            if (!(this.file == other.file || this.file != null && this.file.equals(other.file))) {
                return false;
            }
            return this.offset == other.offset;
        }
    }
}

