/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.requirejs.editor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.csl.api.CodeCompletionContext;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.javascript2.editor.api.lexer.JsTokenId;
import org.netbeans.modules.javascript2.editor.api.lexer.LexUtilities;
import org.netbeans.modules.javascript2.editor.spi.CompletionContext;
import org.netbeans.modules.javascript2.editor.spi.CompletionProvider;
import org.netbeans.modules.javascript2.requirejs.ConfigOption;
import org.netbeans.modules.javascript2.requirejs.RequireJsDataProvider;
import org.netbeans.modules.javascript2.requirejs.RequireJsPreferences;
import org.netbeans.modules.javascript2.requirejs.editor.EditorUtils;
import org.netbeans.modules.javascript2.requirejs.editor.FSCompletionItem;
import org.netbeans.modules.javascript2.requirejs.editor.FSCompletionUtils;
import org.netbeans.modules.javascript2.requirejs.editor.MappingCompletionItem;
import org.netbeans.modules.javascript2.requirejs.editor.RequireJsCompletionItem;
import org.netbeans.modules.javascript2.requirejs.editor.SimpleHandle;
import org.netbeans.modules.javascript2.requirejs.editor.index.RequireJsIndex;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class RequireJSCodeCompletion
implements CompletionProvider {
    private static String HTML_TEXT = "html";
    private static String CLIENT_TEXT = "client";

    /*
     * WARNING - void declaration
     */
    public List<CompletionProposal> complete(CodeCompletionContext ccContext, CompletionContext jsCompletionContext, String prefix) {
        int offset;
        Snapshot snapshot = ccContext.getParserResult().getSnapshot();
        EditorUtils.CodeCompletionContext context = EditorUtils.findContext(snapshot, offset = snapshot.getEmbeddedOffset(ccContext.getCaretOffset()));
        if (context == EditorUtils.CodeCompletionContext.CONFIG_PROPERTY_NAME) {
            ArrayList<CompletionProposal> result = new ArrayList<CompletionProposal>();
            Collection<String> names = RequireJsDataProvider.getDefault().getConfigurationOptions();
            for (String name : names) {
                if (!name.startsWith(prefix)) continue;
                ConfigOption option = null;
                try {
                    option = ConfigOption.getEnum(name);
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
                if (option != null) {
                    result.add(new RequireJsCompletionItem.PropertyNameCompletionItem(option.getName(), option.getType(), offset - prefix.length()));
                    continue;
                }
                result.add(new RequireJsCompletionItem.PropertyNameCompletionItem(name, ConfigOption.OptionType.UNKNOWN, offset - prefix.length()));
            }
            return result;
        }
        if (context == EditorUtils.CodeCompletionContext.CONFIG_BASE_URL_VALUE || context == EditorUtils.CodeCompletionContext.CONFIG_PATHS_VALUE || context == EditorUtils.CodeCompletionContext.REQUIRE_MODULE) {
            TokenSequence ts = LexUtilities.getJsTokenSequence((TokenHierarchy)snapshot.getTokenHierarchy(), (int)offset);
            if (ts == null) {
                return Collections.emptyList();
            }
            ts.move(offset);
            String writtenPath = prefix;
            boolean addExtensionInCC = false;
            if (ts.moveNext() && (ts.token().id() == JsTokenId.STRING_END || ts.token().id() == JsTokenId.STRING)) {
                if (ts.token().id() == JsTokenId.STRING_END) {
                    ts.movePrevious();
                }
                if (ts.token().id() == JsTokenId.STRING) {
                    String text = ts.token().text().toString();
                    writtenPath = text.substring(0, offset - ts.offset());
                }
            }
            if (writtenPath.startsWith("text!")) {
                addExtensionInCC = true;
            }
            writtenPath = FSCompletionUtils.removePlugin(writtenPath);
            FileObject fo = snapshot.getSource().getFileObject();
            Project project = FileOwnerQuery.getOwner((FileObject)fo);
            RequireJsIndex rIndex = null;
            if (fo != null && EditorUtils.isFileReference(snapshot, offset)) {
                FileObject fromMapping;
                ArrayList<Object> relativeTo = new ArrayList<Object>();
                Collection<String> usedFileInDefine = EditorUtils.getUsedFileInDefine(snapshot, offset);
                for (String path : usedFileInDefine) {
                    void var17_29;
                    FileObject fileObject = FSCompletionUtils.findMappedFileObject(path, fo);
                    String[] folders = path.split("/");
                    if (fileObject != null) {
                        void var17_26;
                        for (int i = 0; i < folders.length; ++i) {
                            FileObject fileObject2 = var17_26.getParent();
                        }
                        if (relativeTo.contains(var17_26)) continue;
                        relativeTo.add(var17_26);
                        continue;
                    }
                    if (project == null || folders.length != 1) continue;
                    FileObject fileObject3 = fo.getParent();
                    while (!var17_29.equals(project.getProjectDirectory())) {
                        Enumeration children = var17_29.getChildren(false);
                        while (children.hasMoreElements()) {
                            FileObject child = (FileObject)children.nextElement();
                            if (!child.getName().startsWith(folders[folders.length - 1]) || relativeTo.contains(var17_29)) continue;
                            relativeTo.add(var17_29);
                        }
                        FileObject fileObject4 = var17_29.getParent();
                    }
                }
                if (project != null) {
                    try {
                        rIndex = RequireJsIndex.get(project);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    if (!writtenPath.isEmpty() && writtenPath.indexOf(47) > -1) {
                        if (!writtenPath.startsWith("./")) {
                            String possiblePath = FSCompletionUtils.removePlugin(writtenPath.substring(0, writtenPath.lastIndexOf(47)));
                            FileObject parentFO = fo.getParent();
                            Object var17_31 = null;
                            while (!parentFO.equals(project.getProjectDirectory())) {
                                FileObject fileObject = parentFO.getFileObject(possiblePath);
                                if (fileObject != null && !relativeTo.contains(parentFO)) {
                                    relativeTo.add(parentFO);
                                }
                                parentFO = parentFO.getParent();
                            }
                        } else {
                            relativeTo.add(fo.getParent());
                        }
                    }
                }
                if (relativeTo.isEmpty()) {
                    Collection<Object> basePaths = new ArrayList();
                    if (rIndex != null) {
                        basePaths = rIndex.getBasePaths();
                        relativeTo.add(fo.getParent());
                        if (!basePaths.isEmpty()) {
                            for (String string : basePaths) {
                                FileObject findFO = FSCompletionUtils.findFileObject(fo, string, false);
                                if (findFO == null) continue;
                                relativeTo.add(findFO);
                            }
                        }
                    }
                }
                if (rIndex != null && project != null) {
                    Map<String, String> packages = rIndex.getPackages();
                    Collection<String> sourceRoots = rIndex.getSourceRoots();
                    if (packages != null && sourceRoots != null && writtenPath.contains("/")) {
                        String string = writtenPath.substring(0, writtenPath.indexOf(47));
                        for (String sr : sourceRoots) {
                            String modulePath = packages.get(string);
                            if (modulePath == null) continue;
                            List<String> pathParts = Arrays.asList(modulePath.split("/"));
                            int moduleIndex = pathParts.indexOf(string);
                            StringBuilder sb = new StringBuilder();
                            for (int i = 0; i < moduleIndex; ++i) {
                                sb.append(pathParts.get(i)).append('/');
                            }
                            FileObject targetFo = project.getProjectDirectory().getFileObject(sr + '/' + sb.toString());
                            if (relativeTo.contains(targetFo)) continue;
                            relativeTo.add(targetFo);
                        }
                    }
                }
                ArrayList<CompletionProposal> result = new ArrayList<CompletionProposal>();
                HashMap<String, FSCompletionItem> ccItems = new HashMap<String, FSCompletionItem>();
                try {
                    boolean bl = !this.isClientCode(project, fo);
                    List<CompletionProposal> tmpResult = FSCompletionUtils.computeRelativeItems(relativeTo, writtenPath, ccContext.getCaretOffset(), addExtensionInCC, bl, new FSCompletionUtils.JSIncludesFilter(fo));
                    this.handleFileNameDuplicityInCC(tmpResult, ccItems, result);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
                if (!(result.isEmpty() && ccItems.isEmpty() || writtenPath.isEmpty() || writtenPath.charAt(0) != '/' && !writtenPath.startsWith("./") && !writtenPath.startsWith("../"))) {
                    result.addAll(ccItems.values());
                    return result;
                }
                if (writtenPath.isEmpty() && project != null) {
                    FileObject fileObject = fo.getParent();
                    Collection sourceRoots = QuerySupport.findRoots((Project)project, null, Collections.emptyList(), Collections.emptyList());
                    FileObject topFolder = null;
                    if (!sourceRoots.isEmpty()) {
                        for (FileObject root : sourceRoots) {
                            if (!FileUtil.isParentOf((FileObject)root, (FileObject)fo)) continue;
                            topFolder = root;
                            break;
                        }
                    }
                    if (topFolder == null) {
                        topFolder = project.getProjectDirectory();
                    }
                    try {
                        void var17_42;
                        ArrayList<CompletionProposal> tmpResult = new ArrayList<CompletionProposal>();
                        while (FileUtil.isParentOf((FileObject)topFolder, (FileObject)var17_42)) {
                            tmpResult.add(new FSCompletionItem((FileObject)var17_42, writtenPath, addExtensionInCC, offset));
                            FileObject fileObject5 = var17_42.getParent();
                        }
                        this.handleFileNameDuplicityInCC(tmpResult, ccItems, result);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                String string = "";
                int index = writtenPath.lastIndexOf(47);
                if (index > -1) {
                    fromMapping = FSCompletionUtils.findMappedFileObject(writtenPath.substring(0, index), fo);
                    String string2 = writtenPath.substring(index + 1);
                } else {
                    fromMapping = FSCompletionUtils.findMappedFileObject(writtenPath, fo);
                }
                if (fromMapping != null) {
                    relativeTo.clear();
                    relativeTo.add(fromMapping);
                    try {
                        void var17_46;
                        List<CompletionProposal> newItems = FSCompletionUtils.computeRelativeItems(relativeTo, (String)var17_46, ccContext.getCaretOffset(), addExtensionInCC, false, new FSCompletionUtils.JSIncludesFilter(fo));
                        this.handleFileNameDuplicityInCC(newItems, ccItems, result);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                HashMap<String, String> mappings = new HashMap<String, String>();
                if (rIndex != null) {
                    mappings.putAll(rIndex.getPathMappings(writtenPath));
                }
                mappings.putAll(RequireJsPreferences.getMappings(project));
                for (String mapping : mappings.keySet()) {
                    if (!mapping.startsWith(writtenPath)) continue;
                    result.add(new MappingCompletionItem(mapping, FSCompletionUtils.findMappedFileObject(mapping, fo), ccContext.getCaretOffset() - writtenPath.length()));
                }
                if (rIndex != null && (writtenPath.isEmpty() || !writtenPath.contains("!") && !writtenPath.contains("/"))) {
                    Collection<String> usedPlugins = rIndex.getUsedPlugins();
                    for (String plugin : usedPlugins) {
                        if (!plugin.startsWith(prefix)) continue;
                        result.add(new RequireJsCompletionItem.PluginNameCompletionItem(plugin, ccContext.getCaretOffset() - prefix.length()));
                    }
                }
                result.addAll(ccItems.values());
                return result;
            }
        }
        return Collections.emptyList();
    }

    private void handleFileNameDuplicityInCC(List<CompletionProposal> toCheck, Map<String, FSCompletionItem> ccItems, List<CompletionProposal> finalResult) {
        for (CompletionProposal next : toCheck) {
            if (next instanceof FSCompletionItem) {
                FSCompletionItem fsCC = (FSCompletionItem)next;
                String key = fsCC.getFile().getNameExt();
                if (!ccItems.containsKey(key)) {
                    ccItems.put(key, fsCC);
                    continue;
                }
                ((FSCompletionItem.FSElementHandle)ccItems.get(key).getElement()).addRepresentedFile(fsCC.getFile());
                continue;
            }
            finalResult.add(next);
        }
    }

    public String getHelpDocumentation(ParserResult info, ElementHandle element) {
        if (element != null && element instanceof FSCompletionItem.FSElementHandle) {
            Set<FileObject> representedFiles = ((FSCompletionItem.FSElementHandle)element).getRepresentedFiles();
            StringBuilder sb = new StringBuilder();
            for (FileObject next : representedFiles) {
                sb.append(FSCompletionUtils.writeFilePathForDocWindow(next));
                sb.append("</br>");
            }
            return sb.toString();
        }
        if (element != null && element instanceof SimpleHandle.DocumentationHandle) {
            return ((SimpleHandle.DocumentationHandle)element).getDocumentation();
        }
        return null;
    }

    private boolean isClientCode(Project project, FileObject source) {
        boolean result = false;
        String path = source.getPath();
        if (project == null) {
            return true;
        }
        if (FileUtil.isParentOf((FileObject)project.getProjectDirectory(), (FileObject)source)) {
            path = path.substring(project.getProjectDirectory().getPath().length());
        }
        result = (path = path.toLowerCase()).contains(HTML_TEXT) || path.contains(CLIENT_TEXT);
        return result;
    }
}

