/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor;

import java.util.prefs.Preferences;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.html.editor.lib.api.HtmlSourceVersionController;
import org.netbeans.modules.html.editor.lib.api.HtmlVersion;
import org.netbeans.modules.html.editor.lib.api.SyntaxAnalyzerResult;
import org.openide.filesystems.FileObject;

public class ProjectDefaultHtmlSourceVersionController
implements HtmlSourceVersionController {
    public static final String HTML_VERSION_PUBLIC_ID_AUX_PROPERTY_NAME = "default-html-public-id";
    public static final String XHTML_VERSION_PUBLIC_ID_AUX_PROPERTY_NAME = "default-xhtml-public-id";

    public HtmlVersion getSourceCodeVersion(SyntaxAnalyzerResult analyzerResult, HtmlVersion detectedVersion) {
        if (detectedVersion != null) {
            return null;
        }
        FileObject file = analyzerResult.getSource().getSourceFileObject();
        if (file == null) {
            return null;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)file);
        if (project == null) {
            return null;
        }
        return ProjectDefaultHtmlSourceVersionController.findHtmlVersion(project, analyzerResult);
    }

    public static HtmlVersion getDefaultHtmlVersion(Project project, boolean xhtml) {
        return ProjectDefaultHtmlSourceVersionController.findHtmlVersion(project, null, xhtml);
    }

    private static HtmlVersion findHtmlVersion(Project project, SyntaxAnalyzerResult analyzerResult) {
        return ProjectDefaultHtmlSourceVersionController.findHtmlVersion(project, analyzerResult.getHtmlTagDefaultNamespace(), analyzerResult.mayBeXhtml());
    }

    private static HtmlVersion findHtmlVersion(Project project, String namespace, boolean xhtml) {
        Preferences prefs = ProjectUtils.getPreferences((Project)project, HtmlSourceVersionController.class, (boolean)true);
        String publicId = prefs.get(ProjectDefaultHtmlSourceVersionController.getPropertyKey(xhtml), null);
        if (publicId == null) {
            return null;
        }
        if (xhtml && publicId.equals(HtmlVersion.XHTML5.name())) {
            return HtmlVersion.XHTML5;
        }
        if (!xhtml && publicId.equals(HtmlVersion.HTML5.name())) {
            return HtmlVersion.HTML5;
        }
        try {
            return HtmlVersion.find((String)publicId, (String)namespace);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static void setDefaultHtmlVersion(Project project, HtmlVersion version, boolean xhtml) {
        Preferences prefs = ProjectUtils.getPreferences((Project)project, HtmlSourceVersionController.class, (boolean)true);
        String publicId = version.getPublicID();
        if (publicId == null) {
            publicId = version.name();
        }
        prefs.put(ProjectDefaultHtmlSourceVersionController.getPropertyKey(xhtml), publicId);
    }

    private static String getPropertyKey(boolean xhtml) {
        return xhtml ? XHTML_VERSION_PUBLIC_ID_AUX_PROPERTY_NAME : HTML_VERSION_PUBLIC_ID_AUX_PROPERTY_NAME;
    }
}

