/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic;

import org.clang.basic.SourceLocation;
import org.clang.basic.SourceRange;
import org.clank.support.Native;

public final class CharSourceRange
implements Native.NativePOD<CharSourceRange> {
    private int RangeB;
    private int RangeE;
    private boolean IsTokenRange;

    public CharSourceRange() {
        this.RangeB = SourceLocation.getInvalid();
        this.RangeE = SourceLocation.getInvalid();
        this.IsTokenRange = false;
    }

    public CharSourceRange(SourceRange R, boolean ITR) {
        this.RangeB = R.getRawBegin();
        this.RangeE = R.getRawEnd();
        this.IsTokenRange = ITR;
    }

    public CharSourceRange(int RangeB, int RangeE, boolean ITR) {
        this.RangeB = RangeB;
        this.RangeE = RangeE;
        this.IsTokenRange = ITR;
    }

    public static CharSourceRange getTokenRange(SourceRange R) {
        return new CharSourceRange(R, true);
    }

    public static CharSourceRange getCharRange(SourceRange R) {
        return new CharSourceRange(R, false);
    }

    public static CharSourceRange getTokenRange(SourceLocation B, SourceLocation E) {
        return CharSourceRange.getTokenRange(B.getRawEncodingUInt(), E.getRawEncodingUInt());
    }

    public static CharSourceRange getTokenRange(int B, int E) {
        return new CharSourceRange(B, E, true);
    }

    public static CharSourceRange getCharRange(SourceLocation B, SourceLocation E) {
        return CharSourceRange.getCharRange(B.getRawEncodingUInt(), E.getRawEncodingUInt());
    }

    public static CharSourceRange getCharRange(int B, int E) {
        return new CharSourceRange(B, E, false);
    }

    public boolean isTokenRange() {
        return this.IsTokenRange;
    }

    public boolean isCharRange() {
        return !this.IsTokenRange;
    }

    public SourceLocation getBegin() {
        return SourceLocation.getFromRawEncoding(this.RangeB);
    }

    public SourceLocation getEnd() {
        return SourceLocation.getFromRawEncoding(this.RangeE);
    }

    public int getRawBegin() {
        return this.RangeB;
    }

    public int getRawEnd() {
        return this.RangeE;
    }

    public SourceRange getAsRange() {
        return new SourceRange(this.RangeB, this.RangeE);
    }

    public void setBegin(SourceLocation b) {
        this.setBegin(b.getRawEncodingUInt());
    }

    public void setBegin(int b) {
        this.RangeB = b;
    }

    public void setEnd(SourceLocation e) {
        this.setEnd(e.getRawEncodingUInt());
    }

    public void setEnd(int e) {
        this.RangeE = e;
    }

    public boolean isValid() {
        return SourceRange.isValid(this.RangeB, this.RangeE);
    }

    public boolean isInvalid() {
        return !this.isValid();
    }

    public CharSourceRange(CharSourceRange $Prm0) {
        this.RangeB = $Prm0.RangeB;
        this.RangeE = $Prm0.RangeE;
        this.IsTokenRange = $Prm0.IsTokenRange;
    }

    public CharSourceRange $assign(CharSourceRange $Prm0) {
        this.RangeB = $Prm0.RangeB;
        this.RangeE = $Prm0.RangeE;
        this.IsTokenRange = $Prm0.IsTokenRange;
        return this;
    }

    public String toString() {
        return "CharSourceRange{Range=" + this.getAsRange() + ", IsTokenRange=" + this.IsTokenRange + '}';
    }

    public CharSourceRange clone() {
        return new CharSourceRange(this);
    }

    public boolean $noteq(CharSourceRange other) {
        return !this.$eq(other);
    }

    public boolean $eq(CharSourceRange other) {
        return this.IsTokenRange == other.IsTokenRange && this.RangeB == other.RangeB && this.RangeE == other.RangeE;
    }
}

