/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic;

import org.clang.basic.ClangGlobals;
import org.clang.basic.DenseMapInfoIntFileID;
import org.clang.basic.DiagnosticsEngine;
import org.clang.basic.ExternalSLocEntrySource;
import org.clang.basic.FileEntry;
import org.clang.basic.FileID;
import org.clang.basic.FileManager;
import org.clang.basic.FullSourceLoc;
import org.clang.basic.InBeforeInTUCacheEntry;
import org.clang.basic.LineEntry;
import org.clang.basic.LineTableInfo;
import org.clang.basic.PresumedLoc;
import org.clang.basic.SmallVectorSLocEntry;
import org.clang.basic.SourceLocation;
import org.clang.basic.SrcMgr;
import org.clang.basic.impl.SourceManagerStatics;
import org.clank.java.std;
import org.clank.java.std_ptr;
import org.clank.java.stdimpl.aliases.StdMapIntType;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.NativeType;
import org.clank.support.Unsigned;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.clank.support.aliases.int;
import org.clank.support.aliases.type;
import org.clank.support.aliases.uint;
import org.llvm.adt.DenseMapInfo;
import org.llvm.adt.DenseMapInfoIntIntPair;
import org.llvm.adt.Optional;
import org.llvm.adt.RefCountedBase;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.DenseMap;
import org.llvm.adt.aliases.DenseMapInfoInt;
import org.llvm.adt.aliases.DenseMapIntType;
import org.llvm.adt.aliases.DenseMapIterator;
import org.llvm.adt.aliases.DenseMapIteratorIntInt;
import org.llvm.adt.aliases.DenseMapIteratorIntType;
import org.llvm.adt.aliases.DenseSet;
import org.llvm.adt.aliases.SmallDenseMapIntInt;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.support.BumpPtrAllocator;
import org.llvm.support.MemoryBuffer;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;
import org.llvm.support.sys.fs;
import org.llvm.support.sys.path;

public final class SourceManager
extends RefCountedBase<SourceManager>
implements Destructors.ClassWithDestructor {
    private DiagnosticsEngine Diag;
    private FileManager FileMgr;
    private BumpPtrAllocator ContentCacheAlloc;
    private DenseMap<FileEntry, SrcMgr.ContentCache> FileInfos;
    private SmallVector<SrcMgr.ContentCache> AllContentCaches;
    private boolean OverridenFilesKeepOriginalName;
    private boolean UserFilesAreVolatile;
    private std_ptr.unique_ptr<OverriddenFilesInfoTy> OverriddenFilesInfo;
    private std.vector<SrcMgr.ContentCache> MemBufferInfos;
    public static final String SLOC_ENTY_VECTOR_REUSE_PROP = "clank.slocentry.vector.reuse";
    public static final boolean SLOC_ENTY_VECTOR_REUSE = Boolean.getBoolean(System.getProperty("clank.slocentry.vector.reuse", "false"));
    public static final int DEFAULT_LOCAL_SLOC_ENTRY_TABLE_CAPACITY = Integer.getInteger("clank.sm.local.size", 32768);
    private SmallVectorSLocEntry LocalSLocEntryTable;
    private static final int DEFAULT_LOADED_SLOC_ENTRY_TABLE_CAPACITY = 0;
    private SmallVectorSLocEntry LoadedSLocEntryTable;
    private long NextLocalOffset;
    private long CurrentLoadedOffset;
    private static long MaxLoadedOffset = 0x80000000L;
    private std.vectorBool SLocEntryLoaded;
    private ExternalSLocEntrySource ExternalSLocEntries;
    private int LastFileIDLookup;
    private int LastFileIDLookupLocalSlice;
    private int[] LastFileIDLookupLocalSliceArray;
    private int LastFileIDLookupLocalSLocEntryIndex;
    private int LastFileIDLookupLocalIndexInSlice;
    private int LastFileIDLookupLocalOffset;
    private static final boolean USE_LAST_MACRO_ID = Boolean.valueOf(System.getProperty("use.last.macro", "true"));
    private int LastMacroIDLookup;
    private int LastMacroIDLookupLocalSlice;
    private int[] LastMacroIDLookupLocalSliceArray;
    private int LastMacroIDLookupLocalSLocEntryIndex;
    private int LastMacroIDLookupLocalIndexInSlice;
    private int LastMacroIDLookupLocalOffset;
    private boolean LocalSLocTableIsSliced;
    private int LocalSliceMaskForIndex;
    private int LocalSliceSize;
    private int MaxIndexInLastLocalSlice;
    private int LocalMaxSliceIndex;
    private int local_sloc_entry_size;
    private boolean LoadedSLocTableIsSliced;
    private int LastFileIDLookupLoadedSlice;
    private int LastMacroIDLookupLoadedSlice;
    private LineTableInfo LineTable;
    private int LastLineNoFileIDQuery;
    private SrcMgr.ContentCache LastLineNoContentCache;
    private int LastLineNoFilePos;
    private int LastLineNoResult;
    private FileID MainFileID;
    private FileID PreambleFileID;
    private long NumLinearMacroScans;
    private long NumBinaryMacroProbes;
    private long NumLinearScans;
    private long NumBinaryProbes;
    private long NumLinearSliceScans;
    private long NumImmediateSliceScans;
    private long NumBinarySliceProbes;
    private DenseMapIntType<std.pairIntInt> IncludedLocMap;
    private InBeforeInTUCache IBTUCache;
    private InBeforeInTUCacheEntry IBTUCacheOverflow;
    private static final char.ptr INVALID_BUFFER_CHAR_PTR = NativePointer.$((String)"<<<<INVALID BUFFER>>>>");
    private static final StringRef INVALID_BUFFER_STRING_REF = new StringRef(INVALID_BUFFER_CHAR_PTR);
    private std_ptr.unique_ptr<MemoryBuffer> FakeBufferForRecovery;
    private std_ptr.unique_ptr<SrcMgr.ContentCache> FakeContentCacheForRecovery;
    private static final int FAKE_CONTENT_CACHE_INDEX = -1;
    private DenseMapIntType<std.mapIntType<SourceLocation>> MacroArgsCacheMap;
    private SmallVector<std.pair<std.string, FullSourceLoc>> StoredModuleBuildStack;
    private static boolean tracedEntryTables = false;
    public static final StringRef INVALID_BUFFER_DATA = new StringRef((CharSequence)"<<<<<INVALID SOURCE LOCATION>>>>>");
    private static final int LoadedIndexFlag = Integer.MIN_VALUE;
    private static final int LoadedIndexMask = Integer.MAX_VALUE;
    private final char.ptr.array $CharacterDataPtr = (char.ptr.array)NativePointer.create_reusable_char$ptr();
    private boolean $CharacterDataPtrInUse = false;
    private final int.ptr $OffsetPtr = NativePointer.create_int$ptr((int)0);
    private boolean $OffsetPtrInUse = false;

    private OverriddenFilesInfoTy getOverriddenFilesInfo() {
        if (this.OverriddenFilesInfo.$not()) {
            this.OverriddenFilesInfo.reset((Object)new OverriddenFilesInfoTy());
        }
        return (OverriddenFilesInfoTy)this.OverriddenFilesInfo.$star();
    }

    private InBeforeInTUCacheEntry getInBeforeInTUCache(int LFID, int RFID) {
        IsBeforeInTUCacheKey Key = new IsBeforeInTUCacheKey(LFID, RFID);
        if (this.IBTUCache.size() < Unnamed_enum.MagicCacheSize.getValue()) {
            return (InBeforeInTUCacheEntry)this.IBTUCache.$at((Object)Key);
        }
        DenseMapIterator I = this.IBTUCache.find((Object)Key);
        if (I.$noteq(this.IBTUCache.end())) {
            return (InBeforeInTUCacheEntry)I.$star().second;
        }
        return this.IBTUCacheOverflow;
    }

    private SourceManager(SourceManager $Prm0) {
        throw new UnsupportedOperationException("LLVM_DELETED_FUNCTION");
    }

    private void $assign(SourceManager $Prm0) {
        throw new UnsupportedOperationException("LLVM_DELETED_FUNCTION");
    }

    public SourceManager(DiagnosticsEngine Diag, FileManager FileMgr) {
        this(Diag, FileMgr, false);
    }

    public SourceManager(DiagnosticsEngine Diag, FileManager FileMgr, boolean UserFilesAreVolatile) {
        this.Diag = Diag;
        this.FileMgr = FileMgr;
        this.ContentCacheAlloc = new BumpPtrAllocator();
        this.FileInfos = new DenseMap(FileEntry.DenseMapInfo, null);
        this.AllContentCaches = new SmallVector(1024, null);
        this.OverridenFilesKeepOriginalName = true;
        this.UserFilesAreVolatile = UserFilesAreVolatile;
        this.OverriddenFilesInfo = new std_ptr.unique_ptr();
        this.MemBufferInfos = new std.vector((Object)null);
        this.SLocEntryLoaded = new std.vectorBool();
        this.ExternalSLocEntries = null;
        this.LastFileIDLookup = 0;
        this.LastFileIDLookupLocalSLocEntryIndex = 0;
        this.LastFileIDLookupLocalOffset = 0;
        this.LastMacroIDLookup = 0;
        this.LastMacroIDLookupLocalSLocEntryIndex = 0;
        this.LastMacroIDLookupLocalOffset = 0;
        this.LineTable = null;
        this.LastLineNoFileIDQuery = FileID.getInvalidID();
        this.MainFileID = new FileID();
        this.PreambleFileID = new FileID();
        this.NumLinearScans = 0L;
        this.NumBinaryProbes = 0L;
        this.NumLinearSliceScans = 0L;
        this.NumImmediateSliceScans = 0L;
        this.NumBinarySliceProbes = 0L;
        this.NumLinearMacroScans = 0L;
        this.NumBinaryMacroProbes = 0L;
        this.IncludedLocMap = new DenseMapIntType((DenseMapInfoInt)new DenseMapInfoIntFileID(), null);
        this.IBTUCache = new InBeforeInTUCache();
        this.IBTUCacheOverflow = new InBeforeInTUCacheEntry();
        this.FakeBufferForRecovery = new std_ptr.unique_ptr();
        this.FakeContentCacheForRecovery = new std_ptr.unique_ptr();
        this.MacroArgsCacheMap = new DenseMapIntType((DenseMapInfoInt)new DenseMapInfoIntFileID(), null);
        this.StoredModuleBuildStack = new SmallVector(2, (Object)new std.pair((Object)new std.string(), (Object)new FullSourceLoc()));
        this.initSLocTables();
        this.clearIDTables();
        Diag.setSourceManager(this);
    }

    public void $destroy() {
        if (this.LineTable != null) {
            this.LineTable.$destroy();
        }
        long e = this.MemBufferInfos.size();
        for (long i = 0L; i != e; ++i) {
            if (this.MemBufferInfos.$at(i) == null) continue;
            ((SrcMgr.ContentCache)this.MemBufferInfos.$at(i)).$destroy();
            this.ContentCacheAlloc.Deallocate(this.MemBufferInfos.$at(i));
        }
        DenseMapIterator I = this.FileInfos.begin();
        DenseMapIterator E = this.FileInfos.end();
        while (I.$noteq(E)) {
            if (I.$star().second != null) {
                ((SrcMgr.ContentCache)I.$star().second).$destroy();
                this.ContentCacheAlloc.Deallocate(I.$star().second);
            }
            I.$preInc();
        }
        this.AllContentCaches.clear();
        llvm.DeleteContainerSeconds(this.MacroArgsCacheMap);
        this.StoredModuleBuildStack.$destroy();
        this.MacroArgsCacheMap.$destroy();
        this.FakeContentCacheForRecovery.$destroy();
        this.FakeBufferForRecovery.$destroy();
        this.IBTUCache.$destroy();
        this.IncludedLocMap.$destroy();
        this.SLocEntryLoaded.$destroy();
        SmallVectorSLocEntry.$release(this.LoadedSLocEntryTable);
        this.LoadedSLocEntryTable = null;
        SmallVectorSLocEntry.$release(this.LocalSLocEntryTable);
        this.LocalSLocEntryTable = null;
        this.MemBufferInfos.$destroy();
        this.OverriddenFilesInfo.$destroy();
        this.FileInfos.$destroy();
        this.ContentCacheAlloc.$destroy();
    }

    private void initSLocTables() {
        this.LocalSLocEntryTable = SmallVectorSLocEntry.$create(DEFAULT_LOCAL_SLOC_ENTRY_TABLE_CAPACITY);
        this.LoadedSLocEntryTable = SmallVectorSLocEntry.$create(0);
        if ((NativeTrace.VERBOSE_MODE || NativeTrace.STATISTICS) && !tracedEntryTables) {
            tracedEntryTables = true;
            llvm.errs().$out((CharSequence)"Using LocalTable ").$out((CharSequence)this.LocalSLocEntryTable.getClass().getSimpleName()).$out((CharSequence)" with initial capacity ").$out((CharSequence)NativeTrace.formatNumber((long)(4 * this.LocalSLocEntryTable.capacity() / 1024))).$out((CharSequence)"K\n");
            llvm.errs().$out((CharSequence)"Using LoadedTable ").$out((CharSequence)this.LoadedSLocEntryTable.getClass().getSimpleName()).$out((CharSequence)" with initial capacity ").$out((CharSequence)NativeTrace.formatNumber((long)(4 * this.LoadedSLocEntryTable.capacity() / 1024))).$out((CharSequence)"K\n");
        }
    }

    public void clearIDTables() {
        this.MainFileID.$assign(FileID.getInvalidID());
        this.LocalSLocEntryTable.clear();
        this.LoadedSLocEntryTable.clear();
        this.SLocEntryLoaded.clear();
        this.LastLineNoFileIDQuery = FileID.getInvalidID();
        this.LastLineNoContentCache = null;
        this.LastFileIDLookup = 0;
        this.LastMacroIDLookup = 0;
        if (this.LineTable != null) {
            this.LineTable.clear();
        }
        this.NextLocalOffset = 0L;
        this.LastFileIDLookupLocalOffset = 0;
        this.LastFileIDLookupLocalSLocEntryIndex = 0;
        this.LastMacroIDLookupLocalOffset = 0;
        this.LastMacroIDLookupLocalSLocEntryIndex = 0;
        this.updateLocalSLocConstants();
        this.CurrentLoadedOffset = MaxLoadedOffset;
        this.LoadedSLocTableIsSliced = this.LoadedSLocEntryTable.isSlicedByOffsets();
        this.LastFileIDLookupLoadedSlice = 0;
        this.LastMacroIDLookupLoadedSlice = 0;
        this.createExpansionLoc(SourceLocation.getInvalid(), SourceLocation.getInvalid(), SourceLocation.getInvalid(), 1L);
    }

    private void updateLocalSLocConstants() {
        this.local_sloc_entry_size = this.LocalSLocEntryTable.size();
        this.LocalSLocTableIsSliced = this.LocalSLocEntryTable.isSlicedByOffsets();
        this.LastFileIDLookupLocalSliceArray = null;
        this.LastMacroIDLookupLocalSliceArray = null;
        if (this.LocalSLocTableIsSliced) {
            this.LocalMaxSliceIndex = this.LocalSLocEntryTable.$OffsetsMaxSliceIndex();
            this.LocalSliceSize = this.LocalSLocEntryTable.$OffsetsSliceSize();
            assert ((this.LocalSliceSize & this.LocalSliceSize - 1) == 0) : "must be power of 2 " + Integer.toBinaryString(this.LocalSliceSize);
            this.LocalSliceMaskForIndex = this.LocalSliceSize - 1;
            this.MaxIndexInLastLocalSlice = this.local_sloc_entry_size == 0 ? 0 : (this.local_sloc_entry_size - 1 & this.LocalSliceMaskForIndex) + 1;
            this.LastFileIDLookupLocalSlice = this.LastFileIDLookupLocalSLocEntryIndex / this.LocalSliceSize;
            this.LastFileIDLookupLocalIndexInSlice = this.LastFileIDLookupLocalSLocEntryIndex & this.LocalSliceMaskForIndex;
            this.LastFileIDLookupLocalSliceArray = this.LocalSLocEntryTable.$OffsetsSliceByIndex(this.LastFileIDLookupLocalSlice);
            assert (this.LastFileIDLookupLocalSLocEntryIndex == this.LastFileIDLookupLocalSlice * this.LocalSliceSize + this.LastFileIDLookupLocalIndexInSlice) : this.LastFileIDLookupLocalSLocEntryIndex + " vs. " + (this.LastFileIDLookupLocalSlice * this.LocalSliceSize + this.LastFileIDLookupLocalIndexInSlice);
            this.LastMacroIDLookupLocalSlice = this.LastMacroIDLookup / this.LocalSliceSize;
            this.LastMacroIDLookupLocalIndexInSlice = this.LastMacroIDLookupLocalSLocEntryIndex & this.LocalSliceMaskForIndex;
            this.LastMacroIDLookupLocalSliceArray = this.LocalSLocEntryTable.$OffsetsSliceByIndex(this.LastMacroIDLookupLocalSlice);
            assert (this.LastMacroIDLookupLocalSLocEntryIndex == this.LastMacroIDLookupLocalSlice * this.LocalSliceSize + this.LastMacroIDLookupLocalIndexInSlice) : this.LastMacroIDLookupLocalSLocEntryIndex + " vs. " + (this.LastMacroIDLookupLocalSlice * this.LocalSliceSize + this.LastMacroIDLookupLocalIndexInSlice);
        }
    }

    public DiagnosticsEngine getDiagnostics() {
        return this.Diag;
    }

    public FileManager getFileManager() {
        return this.FileMgr;
    }

    public void setOverridenFilesKeepOriginalName(boolean value) {
        this.OverridenFilesKeepOriginalName = value;
    }

    public boolean userFilesAreVolatile() {
        return this.UserFilesAreVolatile;
    }

    public ArrayRef<std.pair<std.string, FullSourceLoc>> getModuleBuildStack() {
        return new ArrayRef(this.StoredModuleBuildStack);
    }

    public void setModuleBuildStack(ArrayRef<std.pair<std.string, FullSourceLoc>> stack) {
        this.StoredModuleBuildStack.clear();
        this.StoredModuleBuildStack.append((type.iterator)stack.begin(), (type.iterator)stack.end());
    }

    public void pushModuleBuildStack(StringRef moduleName, FullSourceLoc importLoc) {
        this.StoredModuleBuildStack.push_back((Object)std.make_pair((Object)moduleName.str(), (Object)importLoc));
    }

    public FileID getMainFileID() {
        return this.MainFileID;
    }

    public void setMainFileID(FileID FID) {
        this.setMainFileID(FID.ID);
    }

    public void setMainFileID(int FID) {
        this.MainFileID.$assign(FID);
    }

    public void setPreambleFileID(FileID Preamble) {
        assert (this.PreambleFileID.isInvalid()) : "PreambleFileID already set!";
        this.PreambleFileID.$assign(Preamble);
    }

    public FileID getPreambleFileID() {
        return this.PreambleFileID;
    }

    public int createFileID(FileEntry SourceFile, SourceLocation IncludePos, SrcMgr.CharacteristicKind FileCharacter) {
        return this.createFileID(SourceFile, IncludePos.getRawEncodingUInt(), FileCharacter, 0, 0L);
    }

    public int createFileID(FileEntry SourceFile, SourceLocation IncludePos, SrcMgr.CharacteristicKind FileCharacter, int LoadedID) {
        return this.createFileID(SourceFile, IncludePos.getRawEncodingUInt(), FileCharacter, LoadedID, 0L);
    }

    public int createFileID(FileEntry SourceFile, SourceLocation IncludePos, SrcMgr.CharacteristicKind FileCharacter, int LoadedID, long LoadedOffset) {
        return this.createFileID(SourceFile, IncludePos.getRawEncodingUInt(), FileCharacter, LoadedID, LoadedOffset);
    }

    public int createFileID(FileEntry SourceFile, int IncludePos, SrcMgr.CharacteristicKind FileCharacter) {
        return this.createFileID(SourceFile, IncludePos, FileCharacter, 0, 0L);
    }

    public int createFileID(FileEntry SourceFile, int IncludePos, SrcMgr.CharacteristicKind FileCharacter, int LoadedID) {
        return this.createFileID(SourceFile, IncludePos, FileCharacter, LoadedID, 0L);
    }

    public int createFileID(FileEntry SourceFile, int IncludePos, SrcMgr.CharacteristicKind FileCharacter, int LoadedID, long LoadedOffset) {
        SrcMgr.ContentCache IR = this.getOrCreateContentCache(SourceFile, FileCharacter != SrcMgr.CharacteristicKind.C_User);
        assert (IR != null) : "getOrCreateContentCache() cannot return NULL";
        return this.createFileID(IR, IncludePos, FileCharacter, LoadedID, LoadedOffset);
    }

    public int createFileID(std_ptr.unique_ptr<MemoryBuffer> Buffer2) {
        return this.createFileID(Buffer2, SrcMgr.CharacteristicKind.C_User, 0, 0L, SourceLocation.getInvalid());
    }

    public int createFileID(std_ptr.unique_ptr<MemoryBuffer> Buffer2, SrcMgr.CharacteristicKind FileCharacter) {
        return this.createFileID(Buffer2, FileCharacter, 0, 0L, SourceLocation.getInvalid());
    }

    public int createFileID(std_ptr.unique_ptr<MemoryBuffer> Buffer2, SrcMgr.CharacteristicKind FileCharacter, int LoadedID) {
        return this.createFileID(Buffer2, FileCharacter, LoadedID, 0L, SourceLocation.getInvalid());
    }

    public int createFileID(std_ptr.unique_ptr<MemoryBuffer> Buffer2, SrcMgr.CharacteristicKind FileCharacter, int LoadedID, long LoadedOffset) {
        return this.createFileID(Buffer2, FileCharacter, LoadedID, LoadedOffset, SourceLocation.getInvalid());
    }

    public int createFileID(std_ptr.unique_ptr<MemoryBuffer> Buffer2, SrcMgr.CharacteristicKind FileCharacter, int LoadedID, long LoadedOffset, int IncludeLoc) {
        return this.createFileID(this.createMemBufferContentCache(Buffer2), IncludeLoc, FileCharacter, LoadedID, LoadedOffset);
    }

    public int createMacroArgExpansionLoc(int SpellingLoc, int ExpansionLoc, long TokLength) {
        return this.createExpansionLocImpl(SpellingLoc, ExpansionLoc, SourceLocation.getInvalid(), TokLength, 0L, 0L);
    }

    public int createExpansionLoc(SourceLocation SpellingLoc, SourceLocation ExpansionLocStart, SourceLocation ExpansionLocEnd, long TokLength) {
        return this.createExpansionLoc(SpellingLoc.getRawEncodingUInt(), ExpansionLocStart.getRawEncodingUInt(), ExpansionLocEnd.getRawEncodingUInt(), TokLength, 0, 0L);
    }

    public int createExpansionLoc(int SpellingLoc, int ExpansionLocStart, int ExpansionLocEnd, long TokLength) {
        return this.createExpansionLoc(SpellingLoc, ExpansionLocStart, ExpansionLocEnd, TokLength, 0, 0L);
    }

    public int createExpansionLoc(int SpellingLoc, int ExpansionLocStart, int ExpansionLocEnd, long TokLength, int LoadedID) {
        return this.createExpansionLoc(SpellingLoc, ExpansionLocStart, ExpansionLocEnd, TokLength, LoadedID, 0L);
    }

    public int createExpansionLoc(int SpellingLoc, int ExpansionLocStart, int ExpansionLocEnd, long TokLength, int LoadedID, long LoadedOffset) {
        return this.createExpansionLocImpl(SpellingLoc, ExpansionLocStart, ExpansionLocEnd, TokLength, LoadedID, LoadedOffset);
    }

    public MemoryBuffer getMemoryBufferForFile(FileEntry File2) {
        return this.getMemoryBufferForFile(File2, null);
    }

    public MemoryBuffer getMemoryBufferForFile(FileEntry File2, bool.ptr Invalid) {
        SrcMgr.ContentCache IR = this.getOrCreateContentCache(File2);
        assert (IR != null) : "getOrCreateContentCache() cannot return NULL";
        return IR.getBuffer(this.Diag, this, SourceLocation.getInvalid(), Invalid);
    }

    public void overrideFileContents(FileEntry SourceFile, std_ptr.unique_ptr<MemoryBuffer> Buffer2) {
        this.overrideFileContents(SourceFile, (MemoryBuffer)Buffer2.release(), false);
    }

    public void overrideFileContents(FileEntry SourceFile, MemoryBuffer Buffer2, boolean DoNotFree) {
        SrcMgr.ContentCache IR = this.getOrCreateContentCache(SourceFile);
        assert (IR != null) : "getOrCreateContentCache() cannot return NULL";
        IR.replaceBuffer(Buffer2, DoNotFree);
        IR.BufferOverridden = true;
        this.getOverriddenFilesInfo().OverriddenFilesWithBuffer.insert((Object)SourceFile);
    }

    public void overrideFileContents(FileEntry SourceFile, FileEntry NewFile) {
        assert (SourceFile.getSize() == NewFile.getSize()) : "Different sizes, use the FileManager to create a virtual file with the correct size";
        assert (!this.FileInfos.count((Object)SourceFile)) : "This function should be called at the initialization stage, before any parsing occurs.";
        this.getOverriddenFilesInfo().OverriddenFiles.FindAndConstruct((Object)SourceFile).second = NewFile;
    }

    public boolean isFileOverridden(FileEntry File2) {
        if (this.OverriddenFilesInfo.$boolean()) {
            if (((OverriddenFilesInfoTy)this.OverriddenFilesInfo.$arrow()).OverriddenFilesWithBuffer.count((Object)File2)) {
                return true;
            }
            if (((OverriddenFilesInfoTy)this.OverriddenFilesInfo.$arrow()).OverriddenFiles.find((Object)File2).$noteq(((OverriddenFilesInfoTy)this.OverriddenFilesInfo.$arrow()).OverriddenFiles.end())) {
                return true;
            }
        }
        return false;
    }

    public void disableFileContentsOverride(FileEntry File2) {
        if (!this.isFileOverridden(File2)) {
            return;
        }
        SrcMgr.ContentCache IR = this.getOrCreateContentCache(File2);
        IR.replaceBuffer(null);
        IR.ContentsEntry = IR.OrigEntry;
        assert (this.OverriddenFilesInfo.$boolean());
        ((OverriddenFilesInfoTy)this.OverriddenFilesInfo.$arrow()).OverriddenFiles.erase((Object)File2);
        ((OverriddenFilesInfoTy)this.OverriddenFilesInfo.$arrow()).OverriddenFilesWithBuffer.erase((Object)File2);
    }

    public MemoryBuffer getBuffer(FileID FID, SourceLocation Loc) {
        return this.getBuffer(FID.ID, Loc.getRawEncodingUInt(), (bool.ptr)null);
    }

    public MemoryBuffer getBuffer(FileID FID, SourceLocation Loc, bool.ptr Invalid) {
        return this.getBuffer(FID.ID, Loc.getRawEncodingUInt(), Invalid);
    }

    public MemoryBuffer getBuffer(int FID, int Loc) {
        return this.getBuffer(FID, Loc, (bool.ptr)null);
    }

    public MemoryBuffer getBuffer(int FID, int Loc, bool.ptr Invalid) {
        assert (Invalid == null) : "check out value for MemoryBuffer.isInvalid instead of passing Invalid";
        int SLocEntryIndex = this.getFileSLocEntryByID_LoadEntryIfAbsent(FID);
        if (SLocEntryIndex == 0) {
            if (Invalid != null) {
                Invalid.$set(true);
            }
            return this.getFakeBufferForRecovery();
        }
        MemoryBuffer Buf = this.$getContentCache(SLocEntryIndex).getBuffer(this.Diag, this, Loc, null);
        if (Invalid != null) {
            Invalid.$set(Buf.isInvalid());
        }
        return Buf;
    }

    public MemoryBuffer getBuffer(FileID FID) {
        return this.getBuffer(FID.ID, SourceLocation.getInvalid(), (bool.ptr)null);
    }

    public MemoryBuffer getBuffer(FileID FID, bool.ptr Invalid) {
        return this.getBuffer(FID.ID, SourceLocation.getInvalid(), Invalid);
    }

    public MemoryBuffer getBuffer(int FID) {
        return this.getBuffer(FID, SourceLocation.getInvalid(), (bool.ptr)null);
    }

    public MemoryBuffer getBuffer(int FID, bool.ptr Invalid) {
        return this.getBuffer(FID, SourceLocation.getInvalid(), Invalid);
    }

    public SrcMgr.ContentCache getContentCache(SrcMgr.SLocEntry SLoc) {
        return this.getContentCacheByCacheIndex(SLoc.getFile_ContentCacheIndex());
    }

    private SrcMgr.ContentCache getContentCacheByCacheIndex(int index) {
        if (index == -1) {
            assert (this.FakeContentCacheForRecovery != null) : "getFakeContentCacheForRecovery was not yet called?";
            return (SrcMgr.ContentCache)this.FakeContentCacheForRecovery.get();
        }
        return (SrcMgr.ContentCache)this.AllContentCaches.$at(index);
    }

    public FileEntry getFileEntryForID(FileID FID) {
        return this.getFileEntryForID(FID.ID);
    }

    public FileEntry getFileEntryForID(int FID) {
        int Entry2 = this.getFileSLocEntryByID_LoadEntryIfAbsent(FID);
        if (Entry2 == 0) {
            return null;
        }
        SrcMgr.ContentCache Content = this.$getContentCache(Entry2);
        if (Content == null) {
            return null;
        }
        return Content.OrigEntry;
    }

    public FileEntry getFileEntryForSLocEntry(SrcMgr.SLocEntry sloc) {
        SrcMgr.ContentCache Content = this.getContentCache(sloc);
        if (Content == null) {
            return null;
        }
        return Content.OrigEntry;
    }

    public StringRef getBufferData(FileID FID) {
        return this.getBufferData(FID.ID, (bool.ptr)null);
    }

    public StringRef getBufferData(FileID FID, bool.ptr Invalid) {
        return this.getBufferData(FID.ID, Invalid);
    }

    public StringRef getBufferData(int FID) {
        return this.getBufferData(FID, (bool.ptr)null);
    }

    public StringRef getBufferData(int FID, bool.ptr Invalid) {
        assert (Invalid == null) : "check out value for INVALID_BUFFER_DATA instead of passing Invalid";
        MemoryBuffer Buf = this.getBuffer(FID, SourceLocation.getInvalid(), Invalid);
        if (Invalid != null) {
            Invalid.$set(Buf.isInvalid());
        }
        return Buf.isInvalid() ? INVALID_BUFFER_DATA : Buf.getBuffer();
    }

    public long getNumCreatedFIDsForFileID(FileID FID) {
        int SLocEntryIndex = this.getFileSLocEntryByID_LoadEntryIfAbsent(FID.ID);
        if (SLocEntryIndex == 0) {
            return 0L;
        }
        return this.$getNumCreatedFIDs(SLocEntryIndex);
    }

    public void setNumCreatedFIDsForFileID(FileID FID, long NumFIDs) {
        this.setNumCreatedFIDsForFileID(FID.ID, NumFIDs);
    }

    public void setNumCreatedFIDsForFileID(int FID, long NumFIDs) {
        int SLocEntryIndex = this.getFileSLocEntryByID_LoadEntryIfAbsent(FID);
        if (SLocEntryIndex > 0) {
            assert (this.LocalSLocEntryTable.isFile_$at(SLocEntryIndex));
            this.LocalSLocEntryTable.$setNumCreatedFIDs(SLocEntryIndex, NumFIDs);
        } else if (SLocEntryIndex < 0) {
            assert (this.LoadedSLocEntryTable.isFile_$at(SLocEntryIndex &= Integer.MAX_VALUE));
            this.LoadedSLocEntryTable.$setNumCreatedFIDs(SLocEntryIndex, NumFIDs);
        }
    }

    public FileID getFileID(SourceLocation SpellingLoc) {
        return FileID.get(this.getFileID(SpellingLoc.getRawEncodingUInt()));
    }

    public int getFileID(int SpellingLoc) {
        int SLocOffset = SourceLocation.getOffset(SpellingLoc);
        if (this.isOffsetInFileID(this.LastFileIDLookup, SLocOffset)) {
            return this.LastFileIDLookup;
        }
        if (USE_LAST_MACRO_ID && this.isOffsetInFileID(this.LastMacroIDLookup, SLocOffset)) {
            return this.LastMacroIDLookup;
        }
        return this.getFileIDSlow(SLocOffset);
    }

    public StringRef getFilename(SourceLocation SpellingLoc) {
        FileEntry F = this.getFileEntryForID(this.getFileID(SpellingLoc));
        if (F != null) {
            return new StringRef(F.getName());
        }
        return new StringRef();
    }

    public SourceLocation getLocForStartOfFile(FileID FID) {
        return SourceLocation.getFromRawEncoding(this.getLocForStartOfFile(FID.ID));
    }

    public int getLocForStartOfFile(int FID) {
        int SLocEntryIndex = this.getFileSLocEntryByID_LoadEntryIfAbsent(FID);
        int FileOffset = SourceLocation.getInvalid();
        if (SLocEntryIndex != 0) {
            FileOffset = this.$getOffset(SLocEntryIndex);
        }
        return SourceLocation.getRawFileLoc(FileOffset);
    }

    public SourceLocation getLocForEndOfFile(FileID FID) {
        return SourceLocation.getFromRawEncoding(this.getLocForEndOfFile(FID.ID));
    }

    public int getLocForEndOfFile(int FID) {
        int Entry2 = this.getFileSLocEntryByID_LoadEntryIfAbsent(FID);
        if (Entry2 == 0) {
            return SourceLocation.getInvalid();
        }
        long FileOffset = this.$getOffset(Entry2);
        return SourceLocation.getRawFileLoc(FileOffset + (long)this.getFileIDSize(FID));
    }

    public SourceLocation getIncludeLoc(FileID FID) {
        return SourceLocation.getFromRawEncoding(this.getIncludeLoc(FID.ID));
    }

    public int getIncludeLoc(int FID) {
        int SLocEntryIndex = this.getFileSLocEntryByID_LoadEntryIfAbsent(FID);
        if (SLocEntryIndex == 0) {
            return 0;
        }
        return this.$getIncludeLoc(SLocEntryIndex);
    }

    public std.pair<SourceLocation, StringRef> getModuleImportLoc(SourceLocation Loc) {
        FileID FID = this.getFileID(Loc);
        if (FID.ID >= -1) {
            return new std.pair(std.make_pair((Object)new SourceLocation(), (Object)StringRef.EMPTY));
        }
        return this.ExternalSLocEntries.getModuleImportLoc(FID.ID);
    }

    public SourceLocation getExpansionLoc(SourceLocation Loc) {
        return SourceLocation.getFromRawEncoding(this.getExpansionLoc(Loc.getRawEncodingUInt()));
    }

    public int getExpansionLoc(int Loc) {
        if (SourceLocation.isFileID(Loc)) {
            return Loc;
        }
        return this.getExpansionLocSlowCase(Loc);
    }

    public SourceLocation getFileLoc(SourceLocation Loc) {
        return SourceLocation.getFromRawEncoding(this.getFileLoc(Loc.getRawEncodingUInt()));
    }

    public int getFileLoc(int Loc) {
        if (SourceLocation.isFileID(Loc)) {
            return Loc;
        }
        return this.getFileLocSlowCase(Loc);
    }

    public std.pair<SourceLocation, SourceLocation> getImmediateExpansionRange(SourceLocation Loc) {
        long pair2 = this.getImmediateExpansionRange(Loc.getRawEncodingUInt());
        return std.make_pair((Object)SourceLocation.getFromRawEncoding(std.$first_int((long)pair2)), (Object)SourceLocation.getFromRawEncoding(std.$second_int((long)pair2)));
    }

    public long getImmediateExpansionRange(int Loc) {
        return this.getImmediateExpansionRange_New(Loc);
    }

    private long getImmediateExpansionRange_New(int Loc) {
        assert (SourceLocation.isMacroID(Loc)) : "Not a macro expansion loc!";
        int SLocEntryIndex = this.getSLocEntryByID_LoadEntryIfAbsent(this.getFileID(Loc));
        return this.$getExpansionLocRange(SLocEntryIndex);
    }

    public long $getExpansionLocRange(int SLocEntryIndex) {
        if (SLocEntryIndex >= 0) {
            assert (this.LocalSLocEntryTable.isExpansion_$at(SLocEntryIndex));
            return this.LocalSLocEntryTable.$getRawExpansionLocRange(SLocEntryIndex);
        }
        assert (this.LoadedSLocEntryTable.isExpansion_$at(SLocEntryIndex));
        return this.LoadedSLocEntryTable.$getRawExpansionLocRange(SLocEntryIndex &= Integer.MAX_VALUE);
    }

    public boolean $isExpansion(int SLocEntryIndex) {
        if (SLocEntryIndex >= 0) {
            if (SLocEntryIndex == this.LastFileIDLookupLocalSLocEntryIndex) {
                assert (!this.LocalSLocEntryTable.isExpansion_$at(SLocEntryIndex)) : this.LocalSLocEntryTable.isExpansion_$at(SLocEntryIndex) + " for " + SLocEntryIndex;
                return false;
            }
            if (SLocEntryIndex == this.LastMacroIDLookupLocalSLocEntryIndex) {
                assert (this.LocalSLocEntryTable.isExpansion_$at(SLocEntryIndex)) : this.LocalSLocEntryTable.isExpansion_$at(SLocEntryIndex) + " for " + SLocEntryIndex;
                return true;
            }
            return this.LocalSLocEntryTable.isExpansion_$at(SLocEntryIndex);
        }
        return this.LoadedSLocEntryTable.isExpansion_$at(SLocEntryIndex &= Integer.MAX_VALUE);
    }

    public boolean $isFile(int SLocEntryIndex) {
        if (SLocEntryIndex >= 0) {
            if (SLocEntryIndex == this.LastFileIDLookupLocalSLocEntryIndex) {
                assert (this.LocalSLocEntryTable.isFile_$at(SLocEntryIndex)) : this.LocalSLocEntryTable.isFile_$at(SLocEntryIndex) + " for " + SLocEntryIndex;
                return true;
            }
            if (SLocEntryIndex == this.LastMacroIDLookupLocalSLocEntryIndex) {
                assert (!this.LocalSLocEntryTable.isFile_$at(SLocEntryIndex)) : this.LocalSLocEntryTable.isFile_$at(SLocEntryIndex) + " for " + SLocEntryIndex;
                return false;
            }
            return this.LocalSLocEntryTable.isFile_$at(SLocEntryIndex);
        }
        return this.LoadedSLocEntryTable.isFile_$at(SLocEntryIndex &= Integer.MAX_VALUE);
    }

    public int $getOffset(int SLocEntryIndex) {
        if (SLocEntryIndex >= 0) {
            if (SLocEntryIndex == this.LastFileIDLookupLocalSLocEntryIndex) {
                assert (this.LastFileIDLookupLocalOffset == this.LocalSLocEntryTable.offset_$at(SLocEntryIndex)) : this.LastFileIDLookupLocalOffset + " vs. " + this.LocalSLocEntryTable.offset_$at(SLocEntryIndex) + " for " + SLocEntryIndex;
                return this.LastFileIDLookupLocalOffset;
            }
            if (SLocEntryIndex == this.LastMacroIDLookupLocalSLocEntryIndex) {
                assert (this.LastMacroIDLookupLocalOffset == this.LocalSLocEntryTable.offset_$at(SLocEntryIndex)) : this.LastMacroIDLookupLocalOffset + " vs. " + this.LocalSLocEntryTable.offset_$at(SLocEntryIndex) + " for " + SLocEntryIndex;
                return this.LastMacroIDLookupLocalOffset;
            }
            return this.LocalSLocEntryTable.offset_$at(SLocEntryIndex);
        }
        return this.LoadedSLocEntryTable.offset_$at(SLocEntryIndex &= Integer.MAX_VALUE);
    }

    public int $getSpellingLoc(int SLocEntryIndex) {
        if (SLocEntryIndex >= 0) {
            return this.LocalSLocEntryTable.$getRawSpellingLoc(SLocEntryIndex);
        }
        return this.LoadedSLocEntryTable.$getRawSpellingLoc(SLocEntryIndex &= Integer.MAX_VALUE);
    }

    public int $getExpansionLocStart(int SLocEntryIndex) {
        if (SLocEntryIndex >= 0) {
            return this.LocalSLocEntryTable.$getRawExpansionLocStart(SLocEntryIndex);
        }
        return this.LoadedSLocEntryTable.$getRawExpansionLocStart(SLocEntryIndex &= Integer.MAX_VALUE);
    }

    public int $getExpansionLocEnd(int SLocEntryIndex) {
        if (SLocEntryIndex >= 0) {
            return this.LocalSLocEntryTable.$getRawExpansionLocEnd(SLocEntryIndex);
        }
        return this.LoadedSLocEntryTable.$getRawExpansionLocEnd(SLocEntryIndex &= Integer.MAX_VALUE);
    }

    public boolean $isMacroArgExpansion(int SLocEntryIndex) {
        if (SLocEntryIndex >= 0) {
            return this.LocalSLocEntryTable.$isMacroArgExpansion(SLocEntryIndex);
        }
        return this.LoadedSLocEntryTable.$isMacroArgExpansion(SLocEntryIndex &= Integer.MAX_VALUE);
    }

    public boolean $isMacroBodyExpansion(int SLocEntryIndex) {
        if (SLocEntryIndex >= 0) {
            return this.LocalSLocEntryTable.$isMacroBodyExpansion(SLocEntryIndex);
        }
        return this.LoadedSLocEntryTable.$isMacroBodyExpansion(SLocEntryIndex &= Integer.MAX_VALUE);
    }

    public boolean $isFunctionMacroExpansion(int SLocEntryIndex) {
        if (SLocEntryIndex >= 0) {
            return this.LocalSLocEntryTable.$isFunctionMacroExpansion(SLocEntryIndex);
        }
        return this.LoadedSLocEntryTable.$isFunctionMacroExpansion(SLocEntryIndex &= Integer.MAX_VALUE);
    }

    public int $getNumCreatedFIDs(int SLocEntryIndex) {
        if (SLocEntryIndex >= 0) {
            return this.LocalSLocEntryTable.$getNumCreatedFIDs(SLocEntryIndex);
        }
        return this.LoadedSLocEntryTable.$getNumCreatedFIDs(SLocEntryIndex &= Integer.MAX_VALUE);
    }

    public int $getIncludeLoc(int SLocEntryIndex) {
        if (SLocEntryIndex >= 0) {
            return this.LocalSLocEntryTable.$getRawIncludeLoc(SLocEntryIndex);
        }
        return this.LoadedSLocEntryTable.$getRawIncludeLoc(SLocEntryIndex &= Integer.MAX_VALUE);
    }

    public boolean $hasLineDirectives(int SLocEntryIndex) {
        if (SLocEntryIndex >= 0) {
            return this.LocalSLocEntryTable.$hasLineDirectives(SLocEntryIndex);
        }
        return this.LoadedSLocEntryTable.$hasLineDirectives(SLocEntryIndex &= Integer.MAX_VALUE);
    }

    public SrcMgr.SLocEntry $getSLocEntry(int SLocEntryIndex) {
        if (SLocEntryIndex >= 0) {
            return this.LocalSLocEntryTable.$at(SLocEntryIndex);
        }
        return this.LoadedSLocEntryTable.$at(SLocEntryIndex &= Integer.MAX_VALUE);
    }

    public SrcMgr.CharacteristicKind $getFileCharacteristic(int SLocEntryIndex) {
        if (SLocEntryIndex >= 0) {
            return this.LocalSLocEntryTable.$getFileCharacteristic(SLocEntryIndex);
        }
        return this.LoadedSLocEntryTable.$getFileCharacteristic(SLocEntryIndex &= Integer.MAX_VALUE);
    }

    public SrcMgr.ContentCache $getContentCache(int SLocEntryIndex) {
        int ContentCacheIndex = -1;
        if (SLocEntryIndex > 0) {
            ContentCacheIndex = this.LocalSLocEntryTable.$getContentCacheIndex(SLocEntryIndex);
        } else if (SLocEntryIndex < 0) {
            ContentCacheIndex = this.LoadedSLocEntryTable.$getContentCacheIndex(SLocEntryIndex &= Integer.MAX_VALUE);
        }
        return this.getContentCacheByCacheIndex(ContentCacheIndex);
    }

    public std.pair<SourceLocation, SourceLocation> getExpansionRange(SourceLocation Loc) {
        long rawExpansionRange = this.getExpansionRange(Loc.getRawEncodingUInt());
        return new std.pair((Object)SourceLocation.getFromRawEncoding(std.$first_int((long)rawExpansionRange)), (Object)SourceLocation.getFromRawEncoding(std.$second_int((long)rawExpansionRange)));
    }

    public long getExpansionRange(int Loc) {
        if (SourceLocation.isFileID(Loc)) {
            return std.wrap_int_int_pair((int)Loc, (int)Loc);
        }
        long Res = this.getImmediateExpansionRange(Loc);
        int First = std.$first_int((long)Res);
        int Second = std.$second_int((long)Res);
        while (!SourceLocation.isFileID(First)) {
            First = std.$first_int((long)this.getImmediateExpansionRange(First));
        }
        while (!SourceLocation.isFileID(Second)) {
            Second = std.$second_int((long)this.getImmediateExpansionRange(Second));
        }
        return std.wrap_int_int_pair((int)First, (int)Second);
    }

    public SourceLocation getSpellingLoc(SourceLocation Loc) {
        return SourceLocation.getFromRawEncoding(this.getSpellingLoc(Loc.getRawEncodingUInt()));
    }

    public int getSpellingLoc(int Loc) {
        if (SourceLocation.isFileID(Loc)) {
            return Loc;
        }
        return this.getSpellingLocSlowCase(Loc);
    }

    public SourceLocation getImmediateSpellingLoc(SourceLocation Loc) {
        return SourceLocation.getFromRawEncoding(this.getImmediateSpellingLoc(Loc.getRawEncodingUInt()));
    }

    public int getImmediateSpellingLoc(int Loc) {
        if (SourceLocation.isFileID(Loc)) {
            return Loc;
        }
        long LocInfo = this.getDecomposedLoc(Loc);
        int Expansion = this.getExpansionSLocEntryByID_LoadEntryIfAbsent(ClangGlobals.$first_FileID(LocInfo));
        Loc = this.$getSpellingLoc(Expansion);
        return SourceLocation.getRawLocWithOffset(Loc, ClangGlobals.$second_offset(LocInfo));
    }

    public std.pairTypeInt<FileID> getDecomposedLoc(SourceLocation Loc) {
        long decomposedLoc = this.getDecomposedLoc(Loc.getRawEncodingUInt());
        return new std.pairTypeInt((Object)FileID.get(ClangGlobals.$first_FileID(decomposedLoc)), ClangGlobals.$second_offset(decomposedLoc));
    }

    public long getDecomposedLoc(int Loc) {
        int FID = this.getFileID(Loc);
        int SLocEntryIndex = this.getSLocEntryByID_LoadEntryIfAbsent(FID);
        if (SLocEntryIndex == 0) {
            return std.wrap_int_uint_pair((int)FileID.getInvalidID(), (int)0);
        }
        return std.wrap_int_uint_pair((int)FID, (int)(SourceLocation.getOffset(Loc) - this.$getOffset(SLocEntryIndex)));
    }

    public std.pairTypeInt<FileID> getDecomposedExpansionLoc(SourceLocation Loc) {
        long decomposedLoc = this.getDecomposedExpansionLoc(Loc.getRawEncodingUInt());
        return new std.pairTypeInt((Object)FileID.get(ClangGlobals.$first_FileID(decomposedLoc)), std.$second_int((long)decomposedLoc));
    }

    public long getDecomposedExpansionLoc(int Loc) {
        int FID = this.getFileID(Loc);
        int E = this.getSLocEntryByID_LoadEntryIfAbsent(FID);
        if (E == 0) {
            return std.wrap_int_uint_pair((int)FileID.getInvalidID(), (int)0);
        }
        int Offset = SourceLocation.getOffset(Loc) - this.$getOffset(E);
        if (SourceLocation.isFileID(Loc)) {
            return std.wrap_int_uint_pair((int)FID, (int)Offset);
        }
        return this.getDecomposedExpansionLocSlowCase(E);
    }

    public std.pairTypeInt<FileID> getDecomposedSpellingLoc(SourceLocation Loc) {
        long decomposedLoc = this.getDecomposedSpellingLoc(Loc.getRawEncodingUInt());
        return new std.pairTypeInt((Object)FileID.get(ClangGlobals.$first_FileID(decomposedLoc)), std.$second_int((long)decomposedLoc));
    }

    public long getDecomposedSpellingLoc(int Loc) {
        int FID = this.getFileID(Loc);
        int SLocEntryIndex = this.getSLocEntryByID_LoadEntryIfAbsent(FID);
        if (SLocEntryIndex == 0) {
            return std.wrap_int_uint_pair((int)FileID.getInvalidID(), (int)0);
        }
        int Offset = SourceLocation.getOffset(Loc) - this.$getOffset(SLocEntryIndex);
        assert (Offset >= 0);
        if (SourceLocation.isFileID(Loc)) {
            return std.wrap_int_uint_pair((int)FID, (int)Offset);
        }
        return this.getDecomposedSpellingLocSlowCase(SLocEntryIndex, Offset);
    }

    public std.pairTypeInt<FileID> getDecomposedIncludedLoc(FileID FID) {
        long decomposedLoc = this.getDecomposedIncludedLoc(FID.ID);
        return new std.pairTypeInt((Object)FileID.get(ClangGlobals.$first_FileID(decomposedLoc)), std.$second_int((long)decomposedLoc));
    }

    public long getDecomposedIncludedLoc(int FID) {
        if (FileID.isInvalid(FID)) {
            return std.wrap_int_uint_pair((int)FileID.getInvalidID(), (int)0);
        }
        std.pairTypeBool InsertOp = this.IncludedLocMap.insert(std.make_pair_int_T((int)FID, (Object)new std.pairIntInt(FileID.getInvalidID(), 0)));
        std.pairIntInt DecompLoc = (std.pairIntInt)((DenseMapIteratorIntType)InsertOp.first).$star().second;
        if (!InsertOp.second) {
            return DecompLoc.$long();
        }
        int UpperLoc = SourceLocation.getInvalid();
        int SLocEntryIndex = this.getSLocEntryByID_LoadEntryIfAbsent(FID);
        if (SLocEntryIndex != 0) {
            UpperLoc = this.$isExpansion(SLocEntryIndex) ? this.$getExpansionLocStart(SLocEntryIndex) : this.$getIncludeLoc(SLocEntryIndex);
        }
        if (SourceLocation.isValid(UpperLoc)) {
            long decomposedLoc = this.getDecomposedLoc(UpperLoc);
            DecompLoc.$assign(decomposedLoc);
        }
        return DecompLoc.$long();
    }

    public int getFileOffset(SourceLocation SpellingLoc) {
        return ClangGlobals.$second_offset(this.getDecomposedLoc(SpellingLoc.getRawEncodingUInt()));
    }

    public boolean isMacroArgExpansion(SourceLocation Loc) {
        return this.isMacroArgExpansion(Loc.getRawEncodingUInt());
    }

    public boolean isMacroArgExpansion(int Loc) {
        if (!SourceLocation.isMacroID(Loc)) {
            return false;
        }
        int FID = this.getFileID(Loc);
        int Expansion = this.getExpansionSLocEntryByID_LoadEntryIfAbsent(FID);
        return this.$isMacroArgExpansion(Expansion);
    }

    public boolean isMacroBodyExpansion(SourceLocation Loc) {
        return this.isMacroBodyExpansion(Loc.getRawEncodingUInt());
    }

    public boolean isMacroBodyExpansion(int Loc) {
        if (!SourceLocation.isMacroID(Loc)) {
            return false;
        }
        int FID = this.getFileID(Loc);
        int Expansion = this.getExpansionSLocEntryByID_LoadEntryIfAbsent(FID);
        return this.$isMacroBodyExpansion(Expansion);
    }

    public boolean isAtStartOfImmediateMacroExpansion(SourceLocation Loc) {
        return this.isAtStartOfImmediateMacroExpansion(Loc, (SourceLocation)null);
    }

    public boolean isAtStartOfImmediateMacroExpansion(SourceLocation Loc, SourceLocation MacroBegin) {
        return this.isAtStartOfImmediateMacroExpansion(Loc.getRawEncodingUInt(), MacroBegin);
    }

    public boolean isAtStartOfImmediateMacroExpansion(int Loc) {
        return this.isAtStartOfImmediateMacroExpansion(Loc, (SourceLocation)null);
    }

    public boolean isAtStartOfImmediateMacroExpansion(int Loc, SourceLocation MacroBegin) {
        int PrevFID;
        assert (SourceLocation.isValid(Loc) && SourceLocation.isMacroID(Loc)) : "Expected a valid macro loc";
        long DecompLoc = this.getDecomposedLoc(Loc);
        if (ClangGlobals.$second_offset(DecompLoc) > 0) {
            return false;
        }
        int ExpInfo = this.getExpansionSLocEntryByID_LoadEntryIfAbsent(ClangGlobals.$first_FileID(DecompLoc));
        if (ExpInfo == 0) {
            return false;
        }
        int ExpLoc = this.$getExpansionLocStart(ExpInfo);
        if (this.$isMacroArgExpansion(ExpInfo) && !FileID.isInvalid(PrevFID = this.getPreviousFileID(ClangGlobals.$first_FileID(DecompLoc)))) {
            int PrevEntry = this.getSLocEntryByID_LoadEntryIfAbsent(PrevFID);
            if (PrevEntry == 0) {
                return false;
            }
            if (this.$isExpansion(PrevEntry) && ClangGlobals.$eq_SourceLocation(this.$getExpansionLocStart(PrevEntry), ExpLoc)) {
                return false;
            }
        }
        if (MacroBegin != null) {
            MacroBegin.$assign(ExpLoc);
        }
        return true;
    }

    public boolean isAtEndOfImmediateMacroExpansion(SourceLocation Loc) {
        return this.isAtEndOfImmediateMacroExpansion(Loc.getRawEncodingUInt(), (SourceLocation)null);
    }

    public boolean isAtEndOfImmediateMacroExpansion(SourceLocation Loc, SourceLocation MacroEnd) {
        return this.isAtEndOfImmediateMacroExpansion(Loc.getRawEncodingUInt(), MacroEnd);
    }

    public boolean isAtEndOfImmediateMacroExpansion(int Loc) {
        return this.isAtEndOfImmediateMacroExpansion(Loc, (SourceLocation)null);
    }

    public boolean isAtEndOfImmediateMacroExpansion(int Loc, SourceLocation MacroEnd) {
        int NextFID;
        assert (SourceLocation.isValid(Loc) && SourceLocation.isMacroID(Loc)) : "Expected a valid macro loc";
        int FID = this.getFileID(Loc);
        int NextLoc = SourceLocation.getRawLocWithOffset(Loc, 1);
        if (this.isInFileID(NextLoc, FID)) {
            return false;
        }
        int ExpInfo = this.getExpansionSLocEntryByID_LoadEntryIfAbsent(FID);
        if (ExpInfo == 0) {
            return false;
        }
        if (this.$isMacroArgExpansion(ExpInfo) && !FileID.isInvalid(NextFID = this.getNextFileID(FID))) {
            int NextEntry = this.getSLocEntryByID_LoadEntryIfAbsent(NextFID);
            if (NextEntry == 0) {
                return false;
            }
            if (this.$isExpansion(NextEntry) && ClangGlobals.$eq_SourceLocation(this.$getExpansionLocStart(NextEntry), this.$getExpansionLocStart(ExpInfo))) {
                return false;
            }
        }
        if (MacroEnd != null) {
            MacroEnd.$assign(this.$getExpansionLocEnd(ExpInfo));
        }
        return true;
    }

    public boolean isInSLocAddrSpace(int Loc, int Start, int Length, uint.ptr RelativeOffset) {
        assert (RelativeOffset == null) : "use pair wrapped in $second_int(long) instead of uint$ptr creation";
        long out = this.isInSLocAddrSpace(Loc, Start, Length);
        if (RelativeOffset != null) {
            RelativeOffset.$set(Unsigned.uint2long((int)std.$second_int((long)out)));
        }
        return std.$first_bool((long)out);
    }

    public long isInSLocAddrSpace(int Loc, int Start, int Length) {
        assert ((long)SourceLocation.getOffset(Start) < this.NextLocalOffset && (long)(SourceLocation.getOffset(Start) + Length) <= this.NextLocalOffset || (long)SourceLocation.getOffset(Start) >= this.CurrentLoadedOffset && (long)(SourceLocation.getOffset(Start) + Length) < MaxLoadedOffset) : "Chunk is not valid SLoc address space";
        int RelativeOffset = 0;
        int LocOffs = SourceLocation.getOffset(Loc);
        int BeginOffs = SourceLocation.getOffset(Start);
        int EndOffs = BeginOffs + Length;
        if (LocOffs >= BeginOffs && LocOffs < EndOffs) {
            RelativeOffset = LocOffs - BeginOffs;
            return std.wrap_bool_int_pair((boolean)true, (int)RelativeOffset);
        }
        return std.wrap_bool_int_pair((boolean)false, (int)RelativeOffset);
    }

    public boolean isInSameSLocAddrSpace(int LHS, int RHS, int.ptr RelativeOffset) {
        boolean RHSLoaded;
        int LHSOffs = SourceLocation.getOffset(LHS);
        int RHSOffs = SourceLocation.getOffset(RHS);
        boolean LHSLoaded = (long)LHSOffs >= this.CurrentLoadedOffset;
        boolean bl = RHSLoaded = (long)RHSOffs >= this.CurrentLoadedOffset;
        if (LHSLoaded == RHSLoaded) {
            if (RelativeOffset != null) {
                RelativeOffset.$set(RHSOffs - LHSOffs);
            }
            return true;
        }
        return false;
    }

    public char.ptr getCharacterData(SourceLocation SL) {
        return this.getCharacterData(SL.getRawEncodingUInt(), (bool.ptr)null);
    }

    public char.ptr getCharacterData(int SL) {
        return this.getCharacterData(SL, (bool.ptr)null);
    }

    public char.ptr getCharacterData(SourceLocation SL, bool.ptr Invalid) {
        return this.getCharacterData(SL.getRawEncodingUInt(), Invalid);
    }

    public char.ptr getCharacterData(int SL, bool.ptr Invalid) {
        long LocInfo = this.getDecomposedSpellingLoc(SL);
        MemoryBuffer Buffer2 = this.getBuffer(ClangGlobals.$first_FileID(LocInfo), SourceLocation.getInvalid());
        if (Invalid != null) {
            Invalid.$set(Buffer2.isInvalid());
        }
        int Offs = std.$second_int((long)LocInfo);
        return Buffer2.isInvalid() || Offs == 0 ? Buffer2.getBufferStart() : (char.ptr)Buffer2.getBufferStart().$add(Offs);
    }

    public char.ptr getCharacterData_ValidOnly(int SL, char.ptr DestPtr) {
        assert (DestPtr != null) : "forgot to call $DataPtr = SourceMgr.$CharacterDataPtr()? Don't forget to release then";
        long LocInfo = this.getDecomposedSpellingLoc(SL);
        MemoryBuffer Buffer2 = this.getBuffer(ClangGlobals.$first_FileID(LocInfo), SourceLocation.getInvalid());
        int Offs = std.$second_int((long)LocInfo);
        assert (Offs >= 0) : "\n" + Integer.toBinaryString(Offs) + " in\n" + Long.toBinaryString(LocInfo);
        if (Buffer2.isInvalid()) {
            return NativePointer.EMPTY;
        }
        char.ptr bufferStart = Buffer2.getBufferStart();
        if (Offs == 0) {
            return bufferStart;
        }
        DestPtr.$assign((Object)bufferStart);
        Native.$setIndex((char.ptr)DestPtr, (int)(bufferStart.$index() + Offs));
        return DestPtr;
    }

    public byte getCharacterData_FirstChar(int SL, bool.ptr Invalid) {
        long LocInfo = this.getDecomposedSpellingLoc(SL);
        MemoryBuffer Buffer2 = this.getBuffer(ClangGlobals.$first_FileID(LocInfo), SourceLocation.getInvalid());
        if (Invalid != null) {
            Invalid.$set(Buffer2.isInvalid());
        }
        long Offs = std.$second_uint((long)LocInfo);
        return Buffer2.isInvalid() ? std.string.TERM : Buffer2.getBufferStart().$at(Offs);
    }

    public int getColumnNumber(FileID FID, int FilePos) {
        return this.getColumnNumber(FID.ID, FilePos, (bool.ptr)null);
    }

    public int getColumnNumber(FileID FID, int FilePos, bool.ptr Invalid) {
        return this.getColumnNumber(FID.ID, FilePos, Invalid);
    }

    public int getColumnNumber(int FID, int FilePos) {
        return this.getColumnNumber(FID, FilePos, (bool.ptr)null);
    }

    public int getColumnNumber(int FID, int FilePos, bool.ptr Invalid) {
        int LineStart;
        bool.ptr MyInvalid = null;
        MemoryBuffer MemBuf = this.getBuffer(FID, MyInvalid);
        if (Invalid != null) {
            Invalid.$set(MemBuf.isInvalid());
        }
        if (MemBuf.isInvalid()) {
            return 1;
        }
        if (FilePos > MemBuf.getBufferSize()) {
            if (Invalid != null) {
                Invalid.$set(true);
            }
            return 1;
        }
        if (this.LastLineNoFileIDQuery == FID && this.LastLineNoContentCache.SourceLineCache != null && this.LastLineNoResult < this.LastLineNoContentCache.NumLines) {
            int[] SourceLineCache = this.LastLineNoContentCache.SourceLineCache;
            LineStart = SourceLineCache[this.LastLineNoResult - 1];
            int LineEnd = SourceLineCache[this.LastLineNoResult];
            if (FilePos >= LineStart && FilePos < LineEnd) {
                return FilePos - LineStart + 1;
            }
        }
        char.ptr Buf = MemBuf.getBufferStart();
        for (LineStart = FilePos; LineStart != 0 && Buf.$at(LineStart - 1) != NativePointer.$LF && Buf.$at(LineStart - 1) != NativePointer.$CR; --LineStart) {
        }
        return FilePos - LineStart + 1;
    }

    public int getSpellingColumnNumber(SourceLocation Loc) {
        return this.getSpellingColumnNumber(Loc, null);
    }

    public int getSpellingColumnNumber(SourceLocation Loc, bool.ptr Invalid) {
        if (SourceManagerStatics.isInvalid(Loc, Invalid)) {
            return 0;
        }
        long LocInfo = this.getDecomposedSpellingLoc(Loc.getRawEncodingUInt());
        return this.getColumnNumber(ClangGlobals.$first_FileID(LocInfo), std.$second_int((long)LocInfo), Invalid);
    }

    public int getExpansionColumnNumber(SourceLocation Loc) {
        return this.getExpansionColumnNumber(Loc, null);
    }

    public int getExpansionColumnNumber(SourceLocation Loc, bool.ptr Invalid) {
        if (SourceManagerStatics.isInvalid(Loc, Invalid)) {
            return 0;
        }
        long LocInfo = this.getDecomposedExpansionLoc(Loc.getRawEncodingUInt());
        return this.getColumnNumber(ClangGlobals.$first_FileID(LocInfo), std.$second_int((long)LocInfo), Invalid);
    }

    public long getPresumedColumnNumber(SourceLocation Loc) {
        return this.getPresumedColumnNumber(Loc, null);
    }

    public long getPresumedColumnNumber(SourceLocation Loc, bool.ptr Invalid) {
        if (SourceManagerStatics.isInvalid(Loc, Invalid)) {
            return 0L;
        }
        return this.getPresumedLoc(Loc).getColumn();
    }

    public int getLineNumber(FileID FID, int FilePos) {
        return this.getLineNumber(FID.ID, FilePos, (bool.ptr)null);
    }

    public int getLineNumber(FileID FID, int FilePos, bool.ptr Invalid) {
        return this.getLineNumber(FID.ID, FilePos, Invalid);
    }

    public int getLineNumber(int FID, int FilePos) {
        return this.getLineNumber(FID, FilePos, (bool.ptr)null);
    }

    public int getLineNumber(int FID, int FilePos, bool.ptr Invalid) {
        int SourceLineCache;
        SrcMgr.ContentCache Content;
        if (FileID.isInvalid(FID)) {
            if (Invalid != null) {
                Invalid.$set(true);
            }
            return 1;
        }
        if (this.LastLineNoFileIDQuery == FID) {
            Content = this.LastLineNoContentCache;
        } else {
            int Entry2 = this.getFileSLocEntryByID_LoadEntryIfAbsent(FID);
            if (Entry2 == 0) {
                if (Invalid != null) {
                    Invalid.$set(true);
                }
                return 1;
            }
            Content = this.$getContentCache(Entry2);
        }
        if (Content.SourceLineCache == null) {
            boolean MyInvalid = SourceManagerStatics.ComputeLineNumbers(this.Diag, Content, this.ContentCacheAlloc, this, null);
            if (Invalid != null) {
                Invalid.$set(MyInvalid);
            }
            if (MyInvalid) {
                return 1;
            }
        } else if (Invalid != null) {
            Invalid.$set(false);
        }
        int[] $SourceLineCache = Content.SourceLineCache;
        int SourceLineCacheStart = SourceLineCache = 0;
        int SourceLineCacheEnd = SourceLineCache + Content.NumLines;
        int QueriedFilePos = Unsigned.long2uint((long)FilePos) + 1;
        assert (QueriedFilePos >= 0) : "must be unsigned " + QueriedFilePos;
        if (this.LastLineNoFileIDQuery == FID) {
            if (QueriedFilePos >= this.LastLineNoFilePos) {
                assert ((SourceLineCache += this.LastLineNoResult - 1) >= 0) : "must be unsigned " + SourceLineCache;
                if (SourceLineCache + 5 < SourceLineCacheEnd) {
                    if ($SourceLineCache[SourceLineCache + 5] > QueriedFilePos) {
                        SourceLineCacheEnd = SourceLineCache + 5;
                    } else if (SourceLineCache + 10 < SourceLineCacheEnd) {
                        if ($SourceLineCache[SourceLineCache + 10] > QueriedFilePos) {
                            SourceLineCacheEnd = SourceLineCache + 10;
                        } else if (SourceLineCache + 20 < SourceLineCacheEnd && $SourceLineCache[SourceLineCache + 20] > QueriedFilePos) {
                            SourceLineCacheEnd = SourceLineCache + 20;
                        }
                    }
                }
            } else if (this.LastLineNoResult < Content.NumLines) {
                SourceLineCacheEnd = SourceLineCache + this.LastLineNoResult + 1;
            }
        }
        assert (SourceLineCacheEnd >= 0) : "must be unsigned " + SourceLineCacheEnd;
        int Pos = std.lower_bound_int((int[])$SourceLineCache, (int)SourceLineCache, (int)SourceLineCacheEnd, (int)QueriedFilePos);
        int LineNo = Pos - SourceLineCacheStart;
        this.LastLineNoFileIDQuery = FID;
        this.LastLineNoContentCache = Content;
        this.LastLineNoFilePos = QueriedFilePos;
        this.LastLineNoResult = LineNo;
        return LineNo;
    }

    public int getSpellingLineNumber(SourceLocation Loc) {
        return this.getSpellingLineNumber(Loc, null);
    }

    public int getSpellingLineNumber(SourceLocation Loc, bool.ptr Invalid) {
        if (SourceManagerStatics.isInvalid(Loc, Invalid)) {
            return 0;
        }
        long LocInfo = this.getDecomposedSpellingLoc(Loc.getRawEncodingUInt());
        return this.getLineNumber(ClangGlobals.$first_FileID(LocInfo), std.$second_int((long)LocInfo));
    }

    public long getExpansionLineNumber(SourceLocation Loc) {
        return this.getExpansionLineNumber(Loc, null);
    }

    public long getExpansionLineNumber(SourceLocation Loc, bool.ptr Invalid) {
        if (SourceManagerStatics.isInvalid(Loc, Invalid)) {
            return 0L;
        }
        long LocInfo = this.getDecomposedExpansionLoc(Loc.getRawEncodingUInt());
        return this.getLineNumber(ClangGlobals.$first_FileID(LocInfo), std.$second_int((long)LocInfo));
    }

    public long getPresumedLineNumber(SourceLocation Loc) {
        return this.getPresumedLineNumber(Loc, null);
    }

    public long getPresumedLineNumber(SourceLocation Loc, bool.ptr Invalid) {
        if (SourceManagerStatics.isInvalid(Loc, Invalid)) {
            return 0L;
        }
        return this.getPresumedLoc(Loc).getLine();
    }

    public char.ptr getBufferName(SourceLocation Loc) {
        return this.getBufferName(Loc.getRawEncodingUInt());
    }

    public char.ptr getBufferName(int Loc) {
        return this.getBufferName(Loc, (bool.ptr)null);
    }

    public char.ptr getBufferName(SourceLocation Loc, bool.ptr Invalid) {
        return this.getBufferName(Loc.getRawEncodingUInt(), Invalid);
    }

    public char.ptr getBufferName(int Loc, bool.ptr Invalid) {
        if (SourceManagerStatics.isInvalid(Loc, Invalid)) {
            return NativePointer.$((String)"<invalid loc>");
        }
        return this.getBuffer(this.getFileID(Loc), Invalid).getBufferIdentifier();
    }

    public SrcMgr.CharacteristicKind getFileCharacteristic(SourceLocation Loc) {
        return this.getFileCharacteristic(Loc.getRawEncodingUInt());
    }

    public SrcMgr.CharacteristicKind getFileCharacteristic(int Loc) {
        assert (!SourceLocation.isInvalid(Loc)) : "Can't get file characteristic of invalid loc!";
        long LocInfo = this.getDecomposedExpansionLoc(Loc);
        int SLocEntryIndex = this.getFileSLocEntryByID_LoadEntryIfAbsent(ClangGlobals.$first_FileID(LocInfo));
        if (SLocEntryIndex == 0) {
            return SrcMgr.CharacteristicKind.C_User;
        }
        if (!this.$hasLineDirectives(SLocEntryIndex)) {
            return this.$getFileCharacteristic(SLocEntryIndex);
        }
        assert (this.LineTable != null) : "Can't have linetable entries without a LineTable!";
        LineEntry Entry2 = this.LineTable.FindNearestLineEntry(ClangGlobals.$first_FileID(LocInfo), std.$second_uint((long)LocInfo));
        if (Entry2 == null) {
            return this.$getFileCharacteristic(SLocEntryIndex);
        }
        return Entry2.FileKind;
    }

    public PresumedLoc getPresumedLoc(SourceLocation Loc) {
        return this.getPresumedLoc(Loc.getRawEncodingUInt(), true);
    }

    public PresumedLoc getPresumedLoc(SourceLocation Loc, boolean UseLineDirectives) {
        return this.getPresumedLoc(Loc.getRawEncodingUInt(), UseLineDirectives);
    }

    public PresumedLoc getPresumedLoc(int Loc) {
        return this.getPresumedLoc(Loc, true);
    }

    public PresumedLoc getPresumedLoc(int Loc, boolean UseLineDirectives) {
        if (SourceLocation.isInvalid(Loc)) {
            return new PresumedLoc();
        }
        long LocInfo = this.getDecomposedExpansionLoc(Loc);
        int SLocEntryIndex = this.getFileSLocEntryByID_LoadEntryIfAbsent(ClangGlobals.$first_FileID(LocInfo));
        if (SLocEntryIndex == 0) {
            return new PresumedLoc();
        }
        SrcMgr.ContentCache C = this.$getContentCache(SLocEntryIndex);
        char.ptr Filename = C.OrigEntry != null ? C.OrigEntry.getName() : C.getBuffer(this.Diag, this).getBufferIdentifier();
        bool.ptr Invalid = NativePointer.create_bool$ptr((boolean)false);
        int LineNo = this.getLineNumber(ClangGlobals.$first_FileID(LocInfo), std.$second_int((long)LocInfo), Invalid);
        if (Invalid.$star()) {
            return new PresumedLoc();
        }
        int ColNo = this.getColumnNumber(ClangGlobals.$first_FileID(LocInfo), std.$second_int((long)LocInfo), Invalid);
        if (Invalid.$star()) {
            return new PresumedLoc();
        }
        int IncludeLoc = this.$getIncludeLoc(SLocEntryIndex);
        if (UseLineDirectives && this.$hasLineDirectives(SLocEntryIndex)) {
            assert (this.LineTable != null) : "Can't have linetable entries without a LineTable!";
            LineEntry Entry2 = this.LineTable.FindNearestLineEntry(ClangGlobals.$first_FileID(LocInfo), std.$second_uint((long)LocInfo));
            if (Entry2 != null) {
                if (Entry2.FilenameID != -1L) {
                    Filename = this.LineTable.getFilename(Entry2.FilenameID);
                }
                int MarkerLineNo = this.getLineNumber(ClangGlobals.$first_FileID(LocInfo), Entry2.FileOffset);
                LineNo = Entry2.LineNo + (LineNo - MarkerLineNo - 1);
                if (Entry2.IncludeOffset != 0) {
                    IncludeLoc = this.getLocForStartOfFile(ClangGlobals.$first_FileID(LocInfo));
                    IncludeLoc = SourceLocation.getRawLocWithOffset(IncludeLoc, Entry2.IncludeOffset);
                }
            }
        }
        return new PresumedLoc(Filename, LineNo, ColNo, IncludeLoc);
    }

    public boolean isInMainFile(SourceLocation Loc) {
        return this.isInMainFile(Loc.getRawEncodingUInt());
    }

    public boolean isInMainFile(int Loc) {
        LineEntry Entry2;
        if (SourceLocation.isInvalid(Loc)) {
            return false;
        }
        long LocInfo = this.getDecomposedExpansionLoc(Loc);
        int SLocEntryIndex = this.getFileSLocEntryByID_LoadEntryIfAbsent(ClangGlobals.$first_FileID(LocInfo));
        if (SLocEntryIndex == 0) {
            return false;
        }
        if (this.$hasLineDirectives(SLocEntryIndex) && (Entry2 = this.LineTable.FindNearestLineEntry(ClangGlobals.$first_FileID(LocInfo), std.$second_uint((long)LocInfo))) != null && Entry2.IncludeOffset != 0) {
            return false;
        }
        return SourceLocation.isInvalid(this.$getIncludeLoc(SLocEntryIndex));
    }

    public boolean isWrittenInSameFile(SourceLocation Loc1, SourceLocation Loc2) {
        return this.getFileID(Loc1).$eq(this.getFileID(Loc2));
    }

    public boolean isWrittenInMainFile(SourceLocation Loc) {
        return this.getFileID(Loc).$eq(this.getMainFileID());
    }

    public boolean isInSystemHeader(SourceLocation Loc) {
        return this.isInSystemHeader(Loc.getRawEncodingUInt());
    }

    public boolean isInSystemHeader(int Loc) {
        return this.getFileCharacteristic(Loc) != SrcMgr.CharacteristicKind.C_User;
    }

    public boolean isInExternCSystemHeader(SourceLocation Loc) {
        return this.isInExternCSystemHeader(Loc.getRawEncodingUInt());
    }

    public boolean isInExternCSystemHeader(int Loc) {
        return this.getFileCharacteristic(Loc) == SrcMgr.CharacteristicKind.C_ExternCSystem;
    }

    public boolean isInSystemMacro(SourceLocation loc) {
        return loc.isMacroID() && this.isInSystemHeader(this.getSpellingLoc(loc));
    }

    public int getFileIDSize(FileID FID) {
        return this.getFileIDSize(FID.ID);
    }

    public int getFileIDSize(int FID) {
        int Entry2 = this.getSLocEntryByID_LoadEntryIfAbsent(FID);
        if (Entry2 == 0) {
            return 0;
        }
        int ID2 = FID;
        long NextOffset = ID2 > 0 && ID2 + 1 == this.local_sloc_entry_size() ? this.getNextLocalOffset() : (ID2 + 1 == -1 ? MaxLoadedOffset : (long)this.$getOffset(this.getSLocEntryByID_LoadEntryIfAbsent(ID2 + 1)));
        return Unsigned.long2uint((long)(NextOffset - (long)this.$getOffset(Entry2) - 1L));
    }

    public boolean isInFileID(SourceLocation Loc, FileID FID) {
        return this.isInFileID(Loc.getRawEncodingUInt(), FID.ID, (int.ptr)null);
    }

    public boolean isInFileID(SourceLocation Loc, FileID FID, int.ptr RelativeOffset) {
        return this.isInFileID(Loc.getRawEncodingUInt(), FID.ID, RelativeOffset);
    }

    public boolean isInFileID(int Loc, int FID) {
        return this.isInFileID(Loc, FID, (int.ptr)null);
    }

    public boolean isInFileID(int Loc, int FID, int.ptr RelativeOffset) {
        int Offs = SourceLocation.getOffset(Loc);
        if (this.isOffsetInFileID(FID, Offs)) {
            if (RelativeOffset != null) {
                RelativeOffset.$set(Offs - this.$getOffset(this.getSLocEntryByID_LoadEntryIfAbsent(FID)));
            }
            return true;
        }
        return false;
    }

    public long getLineTableFilenameID(StringRef Name) {
        if (this.LineTable == null) {
            this.LineTable = new LineTableInfo();
        }
        return this.LineTable.getLineTableFilenameID(Name);
    }

    public void AddLineNote(SourceLocation Loc, int LineNo, long FilenameID) {
        this.AddLineNote(Loc.getRawEncodingUInt(), LineNo, FilenameID);
    }

    public void AddLineNote(int Loc, int LineNo, long FilenameID) {
        long LocInfo = this.getDecomposedExpansionLoc(Loc);
        if (!this.setFileHasLineDirective(ClangGlobals.$first_FileID(LocInfo))) {
            return;
        }
        if (this.LineTable == null) {
            this.LineTable = new LineTableInfo();
        }
        this.LineTable.AddLineNote(ClangGlobals.$first_FileID(LocInfo), std.$second_int((long)LocInfo), LineNo, FilenameID);
    }

    private boolean setFileHasLineDirective(int FID) {
        int SLocEntryIndex = this.getFileSLocEntryByID_LoadEntryIfAbsent(FID);
        boolean out = false;
        if (SLocEntryIndex > 0) {
            assert (this.LocalSLocEntryTable.isFile_$at(SLocEntryIndex));
            out = true;
            this.LocalSLocEntryTable.$setHasLineDirectives(SLocEntryIndex);
        } else if (SLocEntryIndex < 0) {
            assert (this.LoadedSLocEntryTable.isFile_$at(SLocEntryIndex &= Integer.MAX_VALUE));
            out = true;
            this.LoadedSLocEntryTable.$setHasLineDirectives(SLocEntryIndex);
        }
        return out;
    }

    public void AddLineNote(SourceLocation Loc, int LineNo, long FilenameID, boolean IsFileEntry, boolean IsFileExit, boolean IsSystemHeader, boolean IsExternCHeader) {
        this.AddLineNote(Loc.getRawEncodingUInt(), LineNo, FilenameID, IsFileEntry, IsFileExit, IsSystemHeader, IsExternCHeader);
    }

    public void AddLineNote(int Loc, int LineNo, long FilenameID, boolean IsFileEntry, boolean IsFileExit, boolean IsSystemHeader, boolean IsExternCHeader) {
        if (FilenameID == -1L) {
            assert (!(IsFileEntry || IsFileExit || IsSystemHeader || IsExternCHeader)) : "Can't set flags without setting the filename!";
            this.AddLineNote(Loc, LineNo, FilenameID);
            return;
        }
        long LocInfo = this.getDecomposedExpansionLoc(Loc);
        if (!this.setFileHasLineDirective(ClangGlobals.$first_FileID(LocInfo))) {
            return;
        }
        if (this.LineTable == null) {
            this.LineTable = new LineTableInfo();
        }
        SrcMgr.CharacteristicKind FileKind = IsExternCHeader ? SrcMgr.CharacteristicKind.C_ExternCSystem : (IsSystemHeader ? SrcMgr.CharacteristicKind.C_System : SrcMgr.CharacteristicKind.C_User);
        int EntryExit = 0;
        if (IsFileEntry) {
            EntryExit = 1;
        } else if (IsFileExit) {
            EntryExit = 2;
        }
        this.LineTable.AddLineNote(ClangGlobals.$first_FileID(LocInfo), std.$second_int((long)LocInfo), LineNo, FilenameID, EntryExit, FileKind);
    }

    public boolean hasLineTable() {
        return this.LineTable != null;
    }

    public LineTableInfo getLineTable() {
        if (this.LineTable == null) {
            this.LineTable = new LineTableInfo();
        }
        return this.LineTable;
    }

    public long getContentCacheSize() {
        return this.ContentCacheAlloc.getTotalMemory();
    }

    public MemoryBufferSizes getMemoryBufferSizes() {
        long malloc_bytes = 0L;
        long mmap_bytes = 0L;
        long e = this.MemBufferInfos.size();
        block4: for (long i = 0L; i != e; ++i) {
            long sized_mapped = ((SrcMgr.ContentCache)this.MemBufferInfos.$at(i)).getSizeBytesMapped();
            if (sized_mapped == 0L) continue;
            switch (((SrcMgr.ContentCache)this.MemBufferInfos.$at(i)).getMemoryBufferKind()) {
                case MemoryBuffer_MMap: {
                    mmap_bytes += sized_mapped;
                    continue block4;
                }
                case MemoryBuffer_Malloc: {
                    malloc_bytes += sized_mapped;
                }
            }
        }
        return new MemoryBufferSizes(malloc_bytes, mmap_bytes);
    }

    public long getDataStructureSizes() {
        long size = llvm.capacity_in_bytes(this.MemBufferInfos) + llvm.capacity_in_bytes((NativeType.SizeofCapable)this.LocalSLocEntryTable) + llvm.capacity_in_bytes((NativeType.SizeofCapable)this.LoadedSLocEntryTable) + llvm.capacity_in_bytes((NativeType.SizeofCapable)this.SLocEntryLoaded) + llvm.capacity_in_bytes(this.FileInfos);
        if (this.OverriddenFilesInfo.$boolean()) {
            size += llvm.capacity_in_bytes(((OverriddenFilesInfoTy)this.OverriddenFilesInfo.$arrow()).OverriddenFiles);
        }
        return size;
    }

    public SourceLocation translateFileLineCol(FileEntry SourceFile, long Line, long Col) {
        assert (SourceFile != null) : "Null source file!";
        assert (Line != 0L && Col != 0L) : "Line and column should start from 1!";
        FileID FirstFID = this.translateFile(SourceFile);
        return this.translateLineCol(FirstFID, Line, Col);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileID translateFile(FileEntry SourceFile) {
        Optional SourceFileUID = null;
        Optional SourceFileName = null;
        try {
            int I;
            Optional<fs.UniqueID> MainFileUID;
            assert (SourceFile != null) : "Null source file!";
            FileID FirstFID = new FileID();
            SourceFileUID = new Optional();
            SourceFileName = new Optional();
            if (!this.MainFileID.isInvalid()) {
                SrcMgr.ContentCache MainContentCache;
                int MainSLoc = this.getSLocEntryByID_LoadEntryIfAbsent(this.MainFileID.ID);
                if (MainSLoc == 0) {
                    FileID fileID = new FileID();
                    return fileID;
                }
                if (this.$isFile(MainSLoc) && (MainContentCache = this.$getContentCache(MainSLoc)) != null) {
                    if (MainContentCache.OrigEntry == SourceFile) {
                        FirstFID.$assign(this.MainFileID);
                    } else {
                        FileEntry MainFile = MainContentCache.OrigEntry;
                        SourceFileName.$assign((Object)path.filename((StringRef)new StringRef(SourceFile.getName())));
                        if (llvm.$eq_StringRef((StringRef)((StringRef)SourceFileName.$star()), (StringRef)path.filename((StringRef)new StringRef(MainFile.getName())))) {
                            SourceFileUID.$assign(SourceManagerStatics.getActualFileUID(SourceFile));
                            if (SourceFileUID.$boolean() && (MainFileUID = SourceManagerStatics.getActualFileUID(MainFile)).$boolean() && ((fs.UniqueID)SourceFileUID.$star()).$eq((fs.UniqueID)MainFileUID.$star())) {
                                FirstFID.$assign(this.MainFileID);
                                SourceFile = MainFile;
                            }
                        }
                    }
                }
            }
            if (FirstFID.isInvalid()) {
                int N = this.local_sloc_entry_size();
                for (I = 0; I != N; ++I) {
                    int SLoc = this.getLocalSLocEntry(I);
                    if (SLoc == 0) {
                        MainFileUID = new Optional<fs.UniqueID>();
                        return MainFileUID;
                    }
                    if (!this.$isFile(SLoc) || this.$getContentCache(SLoc) == null || this.$getContentCache((int)SLoc).OrigEntry != SourceFile) continue;
                    FirstFID.$assign(I);
                    break;
                }
                if (FirstFID.isInvalid()) {
                    N = this.loaded_sloc_entry_size();
                    for (I = 0; I != N; ++I) {
                        int SLoc = this.getLoadedSLocEntry(I);
                        if (!this.$isFile(SLoc) || this.$getContentCache(SLoc) == null || this.$getContentCache((int)SLoc).OrigEntry != SourceFile) continue;
                        FirstFID.$assign(-I - 2);
                        break;
                    }
                }
            }
            if (FirstFID.isInvalid() && (SourceFileName.$boolean() || SourceFileName.$assign((Object)path.filename((StringRef)new StringRef(SourceFile.getName()))).$boolean()) && (SourceFileUID.$boolean() || SourceFileUID.$assign(SourceManagerStatics.getActualFileUID(SourceFile)).$boolean())) {
                int N = this.local_sloc_entry_size();
                for (I = 0; I != N; ++I) {
                    Optional<fs.UniqueID> EntryUID;
                    FileEntry Entry2;
                    int IFileID = I;
                    int SLoc = this.getSLocEntryByID_LoadEntryIfAbsent(IFileID);
                    if (SLoc == 0) {
                        FileID fileID = new FileID();
                        return fileID;
                    }
                    if (!this.$isFile(SLoc)) continue;
                    SrcMgr.ContentCache FileContentCache = this.$getContentCache(SLoc);
                    FileEntry fileEntry = Entry2 = FileContentCache != null ? FileContentCache.OrigEntry : null;
                    if (Entry2 == null || !llvm.$eq_StringRef((StringRef)((StringRef)SourceFileName.$star()), (StringRef)path.filename((StringRef)new StringRef(Entry2.getName()))) || !(EntryUID = SourceManagerStatics.getActualFileUID(Entry2)).$boolean() || !((fs.UniqueID)SourceFileUID.$star()).$eq((fs.UniqueID)EntryUID.$star())) continue;
                    FirstFID.$assign(I);
                    SourceFile = Entry2;
                    break;
                }
            }
            FileID fileID = FirstFID;
            return fileID;
        }
        finally {
            if (SourceFileName != null) {
                SourceFileName.$destroy();
            }
            if (SourceFileUID != null) {
                SourceFileUID.$destroy();
            }
        }
    }

    public SourceLocation translateLineCol(FileID FID, long Line, long Col) {
        return SourceLocation.getFromRawEncoding(this.translateLineCol(FID.ID, Line, Col));
    }

    public int translateLineCol(int FID, long _Line, long Col) {
        long i;
        boolean MyInvalid;
        int Line = Unsigned.long2uint((long)_Line);
        assert (Line != 0) : "Passed a zero-based line";
        if (FileID.isInvalid(FID)) {
            return SourceLocation.getInvalid();
        }
        int Entry2 = this.getSLocEntryByID_LoadEntryIfAbsent(FID);
        if (Entry2 == 0) {
            return SourceLocation.getInvalid();
        }
        if (!this.$isFile(Entry2)) {
            return SourceLocation.getInvalid();
        }
        int FileLoc = SourceLocation.getRawFileLoc(this.$getOffset(Entry2));
        if (Line == 1 && Col == 1L) {
            return FileLoc;
        }
        SrcMgr.ContentCache Content = this.$getContentCache(Entry2);
        if (Content == null) {
            return SourceLocation.getInvalid();
        }
        if (Content.SourceLineCache == null && (MyInvalid = SourceManagerStatics.ComputeLineNumbers(this.Diag, Content, this.ContentCacheAlloc, this, null))) {
            return SourceLocation.getInvalid();
        }
        if (Line > Content.NumLines) {
            long Size = Content.getBuffer(this.Diag, this).getBufferSize();
            if (Size > 0L) {
                --Size;
            }
            return SourceLocation.getRawLocWithOffset(FileLoc, Size);
        }
        MemoryBuffer Buffer2 = Content.getBuffer(this.Diag, this);
        int FilePos = Content.SourceLineCache[Line - 1];
        char.ptr Buf = (char.ptr)Buffer2.getBufferStart().$add(FilePos);
        long BufLength = Buffer2.getBufferSize() - FilePos;
        if (BufLength == 0L) {
            return SourceLocation.getRawLocWithOffset(FileLoc, FilePos);
        }
        for (i = 0L; i < BufLength - 1L && i < Col - 1L && Buf.$at(i) != NativePointer.$LF && Buf.$at(i) != NativePointer.$CR; ++i) {
        }
        return SourceLocation.getRawLocWithOffset(FileLoc, (long)FilePos + i);
    }

    public SourceLocation getMacroArgExpandedLocation(SourceLocation Loc) {
        return SourceLocation.getFromRawEncoding(this.getMacroArgExpandedLocation(Loc.getRawEncodingUInt()));
    }

    public int getMacroArgExpandedLocation(int Loc) {
        if (SourceLocation.isInvalid(Loc) || !SourceLocation.isFileID(Loc)) {
            return Loc;
        }
        long decomposedLoc = this.getDecomposedLoc(Loc);
        int FID = ClangGlobals.$first_FileID(decomposedLoc);
        int Offset = ClangGlobals.$second_offset(decomposedLoc);
        if (FileID.isInvalid(FID)) {
            return Loc;
        }
        std.mapIntType MacroArgsCache = (std.mapIntType)this.MacroArgsCacheMap.$at(FID);
        if (MacroArgsCache == null) {
            MacroArgsCache = new std.mapIntType((Object)new SourceLocation());
            this.computeMacroArgsCache((std.mapIntType<SourceLocation>)MacroArgsCache, FID);
            this.MacroArgsCacheMap.FindAndConstruct((int)FID).second = MacroArgsCache;
        }
        assert (!MacroArgsCache.empty());
        StdMapIntType.iterator I = MacroArgsCache.upper_bound(Integer.valueOf(Offset));
        I.$preDec();
        long MacroArgBeginOffs = I.$arrow().first;
        SourceLocation MacroArgExpandedLoc = (SourceLocation)I.$arrow().second;
        if (MacroArgExpandedLoc.isValid()) {
            return MacroArgExpandedLoc.getRawLocWithOffset((long)Offset - MacroArgBeginOffs);
        }
        return Loc;
    }

    public boolean isBeforeInTranslationUnit(SourceLocation LHS, SourceLocation RHS) {
        return this.isBeforeInTranslationUnit(LHS.getRawEncodingUInt(), RHS.getRawEncodingUInt());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBeforeInTranslationUnit(int LHS, int RHS) {
        SmallDenseMapIntInt LChain = null;
        try {
            boolean RIsBuiltins;
            DenseMapIteratorIntInt I;
            assert (SourceLocation.isValid(LHS) && SourceLocation.isValid(RHS)) : "Passed invalid source location!";
            if (ClangGlobals.$eq_SourceLocation(LHS, RHS)) {
                boolean bl = false;
                return bl;
            }
            std.pairIntInt LOffs = new std.pairIntInt(this.getDecomposedLoc(LHS));
            std.pairIntInt ROffs = new std.pairIntInt(this.getDecomposedLoc(RHS));
            if (FileID.isInvalid(LOffs.first) || FileID.isInvalid(ROffs.first)) {
                boolean bl = FileID.isInvalid(LOffs.first) && !FileID.isInvalid(ROffs.first);
                return bl;
            }
            if (LOffs.first == ROffs.first) {
                boolean bl = LOffs.second < ROffs.second;
                return bl;
            }
            InBeforeInTUCacheEntry IsBeforeInTUCache = this.getInBeforeInTUCache(LOffs.first, ROffs.first);
            if (IsBeforeInTUCache.isCacheValid(LOffs.first, ROffs.first)) {
                boolean bl = IsBeforeInTUCache.getCachedResult(LOffs.second, ROffs.second);
                return bl;
            }
            IsBeforeInTUCache.setQueryFIDs(LOffs.first, ROffs.first, LOffs.first < ROffs.first);
            LChain = new SmallDenseMapIntInt((DenseMapInfoInt)new DenseMapInfoIntFileID(), 16L, 0);
            do {
                LChain.insert(LOffs);
            } while (LOffs.first != ROffs.first && !SourceManagerStatics.MoveUpIncludeHierarchy(LOffs, this));
            while ((I = LChain.find(ROffs.first)).$eq(LChain.end()) && !SourceManagerStatics.MoveUpIncludeHierarchy(ROffs, this)) {
            }
            if (I.$noteq(LChain.end())) {
                LOffs.$assign(I.$star());
            }
            if (LOffs.first == ROffs.first) {
                IsBeforeInTUCache.setCommonLoc(LOffs.first, LOffs.second, ROffs.second);
                boolean bl = IsBeforeInTUCache.getCachedResult(LOffs.second, ROffs.second);
                return bl;
            }
            IsBeforeInTUCache.clear();
            boolean LIsBuiltins = std.strcmp((CharSequence)"<built-in>", (char.ptr)this.getBuffer(LOffs.first).getBufferIdentifier()) == 0;
            boolean bl = RIsBuiltins = std.strcmp((CharSequence)"<built-in>", (char.ptr)this.getBuffer(ROffs.first).getBufferIdentifier()) == 0;
            if (LIsBuiltins != RIsBuiltins) {
                boolean bl2 = LIsBuiltins;
                return bl2;
            }
            assert (LIsBuiltins && RIsBuiltins) : "Non-built-in locations must be rooted in the main file [" + LOffs + "]\n[" + ROffs + "]";
            boolean bl3 = LOffs.first < ROffs.first;
            return bl3;
        }
        finally {
            if (LChain != null) {
                LChain.$destroy();
            }
        }
    }

    public boolean isBeforeInSLocAddrSpace(SourceLocation LHS, SourceLocation RHS) {
        return this.isBeforeInSLocAddrSpace(LHS, RHS.getOffset());
    }

    public boolean isBeforeInSLocAddrSpace(SourceLocation LHS, long RHS) {
        return this.isBeforeInSLocAddrSpace(LHS.getRawEncodingUInt(), RHS);
    }

    public boolean isBeforeInSLocAddrSpace(int LHS, long RHS) {
        boolean RHSLoaded;
        long LHSOffset = SourceLocation.getOffset(LHS);
        boolean LHSLoaded = LHSOffset >= this.CurrentLoadedOffset;
        boolean bl = RHSLoaded = RHS >= this.CurrentLoadedOffset;
        if (LHSLoaded == RHSLoaded) {
            return LHSOffset < RHS;
        }
        return LHSLoaded;
    }

    public DenseMapIterator<FileEntry, SrcMgr.ContentCache> fileinfo_begin() {
        return this.FileInfos.begin();
    }

    public DenseMapIterator<FileEntry, SrcMgr.ContentCache> fileinfo_end() {
        return this.FileInfos.end();
    }

    public boolean hasFileInfo(FileEntry File2) {
        return this.FileInfos.find((Object)File2).$noteq(this.FileInfos.end());
    }

    public void PrintStats() {
        this.PrintStats(llvm.errs());
    }

    public void PrintStats(raw_ostream OS) {
        OS.$out((CharSequence)"\n*** Source Manager Stats:\n");
        OS.$out((CharSequence)NativeTrace.formatNumber((long)this.FileInfos.size())).$out((CharSequence)" files mapped, ").$out((CharSequence)NativeTrace.formatNumber((long)this.MemBufferInfos.size())).$out((CharSequence)" mem buffers mapped.\n");
        OS.$out((CharSequence)NativeTrace.formatNumber((long)this.local_sloc_entry_size())).$out((CharSequence)" local SLocEntry's allocated (").$out((CharSequence)NativeTrace.formatNumber((long)llvm.capacity_in_bytes((NativeType.SizeofCapable)this.LocalSLocEntryTable))).$out((CharSequence)" bytes of capacity), ").$out((CharSequence)NativeTrace.formatNumber((long)this.NextLocalOffset)).$out((CharSequence)"B of Sloc address space used.\n");
        OS.$out((CharSequence)NativeTrace.formatNumber((long)this.LoadedSLocEntryTable.size())).$out((CharSequence)" loaded SLocEntries allocated, ").$out((CharSequence)NativeTrace.formatNumber((long)(MaxLoadedOffset - this.CurrentLoadedOffset))).$out((CharSequence)"B of Sloc address space used.\n");
        long NumLineNumsComputed = 0L;
        long NumFileBytesMapped = 0L;
        DenseMapIterator<FileEntry, SrcMgr.ContentCache> I = this.fileinfo_begin();
        DenseMapIterator<FileEntry, SrcMgr.ContentCache> E = this.fileinfo_end();
        while (I.$noteq(E)) {
            NumLineNumsComputed += ((SrcMgr.ContentCache)I.$star().second).SourceLineCache != null ? 1L : 0L;
            NumFileBytesMapped += ((SrcMgr.ContentCache)I.$star().second).getSizeBytesMapped();
            I.$preInc();
        }
        long NumMacroArgsComputed = this.MacroArgsCacheMap.size();
        OS.$out((CharSequence)NativeTrace.formatNumber((long)NumFileBytesMapped)).$out((CharSequence)" bytes of files mapped, ").$out((CharSequence)NativeTrace.formatNumber((long)NumLineNumsComputed)).$out((CharSequence)" files with line #'s computed, ").$out((CharSequence)NativeTrace.formatNumber((long)NumMacroArgsComputed)).$out((CharSequence)" files with macro args computed.\n");
        OS.$out((CharSequence)"FileID slow scans: ").$out((CharSequence)NativeTrace.formatNumber((long)(this.NumLinearScans + this.NumLinearMacroScans + this.NumBinaryProbes + this.NumBinaryMacroProbes))).$out((CharSequence)" total (").$out((CharSequence)NativeTrace.formatNumber((long)(this.NumLinearScans + this.NumLinearMacroScans))).$out((CharSequence)" linear, ").$out((CharSequence)NativeTrace.formatNumber((long)(this.NumBinaryProbes + this.NumBinaryMacroProbes))).$out((CharSequence)" binary).\n");
        OS.$out((CharSequence)"FileID scans: ").$out((CharSequence)NativeTrace.formatNumber((long)this.NumLinearScans)).$out((CharSequence)" linear, ").$out((CharSequence)NativeTrace.formatNumber((long)this.NumBinaryProbes)).$out((CharSequence)" binary.\n");
        OS.$out((CharSequence)"MacroID scans: ").$out((CharSequence)NativeTrace.formatNumber((long)this.NumLinearMacroScans)).$out((CharSequence)" linear, ").$out((CharSequence)NativeTrace.formatNumber((long)this.NumBinaryMacroProbes)).$out((CharSequence)" binary.\n");
        OS.$out((CharSequence)"FileID Slice scans: ").$out((CharSequence)NativeTrace.formatNumber((long)this.NumImmediateSliceScans)).$out((CharSequence)" immediate, ").$out((CharSequence)NativeTrace.formatNumber((long)this.NumLinearSliceScans)).$out((CharSequence)" linear, ").$out((CharSequence)NativeTrace.formatNumber((long)this.NumBinarySliceProbes)).$out((CharSequence)" binary.\n");
    }

    public int local_sloc_entry_size() {
        assert (this.LocalSLocEntryTable.size() == this.local_sloc_entry_size);
        return this.local_sloc_entry_size;
    }

    public int getLocalSLocEntry(int Index) {
        assert (Index < this.local_sloc_entry_size()) : "Invalid index";
        return Index;
    }

    public int loaded_sloc_entry_size() {
        return this.LoadedSLocEntryTable.size();
    }

    public int getLoadedSLocEntry(int Index) {
        assert (Index < this.LoadedSLocEntryTable.size()) : "Invalid index";
        if (!this.SLocEntryLoaded.$at(Index) && this.loadSLocEntry(Index)) {
            return 0;
        }
        return -Index;
    }

    public SrcMgr.SLocEntry getSLocEntry(FileID FID) {
        return this.getSLocEntry(FID.ID, (bool.ptr)null);
    }

    public SrcMgr.SLocEntry getSLocEntry(FileID FID, bool.ptr Invalid) {
        return this.getSLocEntry(FID.ID, Invalid);
    }

    public SrcMgr.SLocEntry getSLocEntry(int FID) {
        return this.getSLocEntry(FID, (bool.ptr)null);
    }

    public SrcMgr.SLocEntry getSLocEntry(int FID, bool.ptr Invalid) {
        if (FID == 0 || FID == -1) {
            if (Invalid != null) {
                Invalid.$set(true);
            }
            return this.LocalSLocEntryTable.$at(0);
        }
        assert (FID != -1) : "Using FileID sentinel value";
        int SLocEntryIndex = FID < 0 ? this.getLoadedSLocEntryByID(FID) : this.getLocalSLocEntry(FID);
        if (Invalid != null) {
            Invalid.$set(SLocEntryIndex == 0);
        }
        return this.$getSLocEntry(SLocEntryIndex);
    }

    public long getNextLocalOffset() {
        return this.NextLocalOffset;
    }

    public void setExternalSLocEntrySource(ExternalSLocEntrySource Source) {
        assert (this.LoadedSLocEntryTable.empty()) : "Invalidating existing loaded entries";
        this.ExternalSLocEntries = Source;
    }

    public std.pairIntUInt AllocateLoadedSLocEntries(int NumSLocEntries, long TotalSize) {
        assert (this.ExternalSLocEntries != null) : "Don't have an external sloc source";
        this.LoadedSLocEntryTable = this.LoadedSLocEntryTable.resize(this.LoadedSLocEntryTable.size() + NumSLocEntries);
        this.LoadedSLocTableIsSliced = this.LoadedSLocEntryTable.isSlicedByOffsets();
        this.SLocEntryLoaded.resize(this.LoadedSLocEntryTable.size(), false);
        this.CurrentLoadedOffset -= TotalSize;
        assert (this.CurrentLoadedOffset >= this.NextLocalOffset) : "Out of source locations";
        int ID2 = this.LoadedSLocEntryTable.size();
        return std.make_pair_int_uint((int)(-ID2 - 1), (long)this.CurrentLoadedOffset);
    }

    public boolean isLoadedSourceLocation(SourceLocation Loc) {
        return Loc.getOffset() >= this.CurrentLoadedOffset;
    }

    public boolean isLocalSourceLocation(SourceLocation Loc) {
        return Loc.getOffset() < this.NextLocalOffset;
    }

    public boolean isLoadedFileID(FileID FID) {
        assert (FID.ID != -1) : "Using FileID sentinel value";
        return FID.ID < 0;
    }

    public boolean isLocalFileID(FileID FID) {
        return !this.isLoadedFileID(FID);
    }

    public SourceLocation getImmediateMacroCallerLoc(SourceLocation Loc) {
        return SourceLocation.getFromRawEncoding(this.getImmediateMacroCallerLoc(Loc.getRawEncodingUInt()));
    }

    public int getImmediateMacroCallerLoc(int Loc) {
        if (!SourceLocation.isMacroID(Loc)) {
            return Loc;
        }
        if (this.isMacroArgExpansion(Loc)) {
            return this.getImmediateSpellingLoc(Loc);
        }
        return std.$first_int((long)this.getImmediateExpansionRange(Loc));
    }

    private MemoryBuffer getFakeBufferForRecovery() {
        if (!this.FakeBufferForRecovery.$boolean()) {
            this.FakeBufferForRecovery.$assignRvalue(MemoryBuffer.getMemBuffer((StringRef)INVALID_BUFFER_STRING_REF));
            ((MemoryBuffer)this.FakeBufferForRecovery.get()).setInvalid();
        }
        return (MemoryBuffer)this.FakeBufferForRecovery.get();
    }

    private SrcMgr.ContentCache getFakeContentCacheForRecovery() {
        if (!this.FakeContentCacheForRecovery.$boolean()) {
            this.FakeContentCacheForRecovery.$assignRvalue(llvm.make_unique((Object)new SrcMgr.ContentCache(0)));
            ((SrcMgr.ContentCache)this.FakeContentCacheForRecovery.$arrow()).replaceBuffer(this.getFakeBufferForRecovery(), true);
        }
        return (SrcMgr.ContentCache)this.FakeContentCacheForRecovery.get();
    }

    private boolean loadSLocEntry(int Index) {
        assert (!this.SLocEntryLoaded.$at(Index));
        boolean Error2 = false;
        if (this.ExternalSLocEntries.ReadSLocEntry(-(Index + 2))) {
            Error2 = true;
            if (!this.SLocEntryLoaded.$at(Index)) {
                this.LoadedSLocEntryTable.$setFile(Index, 0L, SourceLocation.getInvalid(), this.getFakeContentCacheForRecovery(), SrcMgr.CharacteristicKind.C_User);
            }
        }
        return Error2;
    }

    public int getSLocEntryByID_LoadEntryIfAbsent(int FID) {
        if (FID == 0 || FID == -1) {
            return 0;
        }
        assert (FID != -1) : "Using FileID sentinel value";
        if (FID > 0) {
            return FID;
        }
        int TableIdx = -FID - 2;
        assert (TableIdx < this.LoadedSLocEntryTable.size()) : "Invalid index";
        if (!this.SLocEntryLoaded.$at(TableIdx) && this.loadSLocEntry(TableIdx)) {
            return 0;
        }
        return TableIdx | Integer.MIN_VALUE;
    }

    public int getFileSLocEntryByID_LoadEntryIfAbsent(int FID) {
        if (FID == 0 || FID == -1) {
            return 0;
        }
        assert (FID != -1) : "Using FileID sentinel value";
        if (FID > 0) {
            return this.LocalSLocEntryTable.isFile_$at(FID) ? FID : 0;
        }
        int TableIdx = -FID - 2;
        assert (TableIdx < this.LoadedSLocEntryTable.size()) : "Invalid index";
        if (!this.SLocEntryLoaded.$at(TableIdx) && this.loadSLocEntry(TableIdx)) {
            return 0;
        }
        return this.LoadedSLocEntryTable.isFile_$at(TableIdx) ? TableIdx | Integer.MIN_VALUE : 0;
    }

    public int getExpansionSLocEntryByID_LoadEntryIfAbsent(int FID) {
        if (FID == 0 || FID == -1) {
            return 0;
        }
        assert (FID != -1) : "Using FileID sentinel value";
        if (FID > 0) {
            return this.LocalSLocEntryTable.isExpansion_$at(FID) ? FID : 0;
        }
        int TableIdx = -FID - 2;
        assert (TableIdx < this.LoadedSLocEntryTable.size()) : "Invalid index";
        if (!this.SLocEntryLoaded.$at(TableIdx) && this.loadSLocEntry(TableIdx)) {
            return 0;
        }
        return this.LoadedSLocEntryTable.isExpansion_$at(TableIdx) ? TableIdx | Integer.MIN_VALUE : 0;
    }

    private int getLoadedSLocEntryByID(int ID2) {
        return this.getLoadedSLocEntry(-ID2 - 2);
    }

    private int createExpansionLocImpl(int SpellingLoc, int ExpansionLocStart, int ExpansionLocEnd, long TokLength, long LoadedID, long LoadedOffset) {
        if (LoadedID < 0L) {
            assert (LoadedID != -1L) : "Loading sentinel FileID";
            int Index = (int)(-LoadedID) - 2;
            assert (Index < this.LoadedSLocEntryTable.size()) : "FileID out of range";
            assert (!this.SLocEntryLoaded.$at(Index)) : "FileID already loaded";
            this.LoadedSLocEntryTable.$setExpansion(Index, LoadedOffset, SpellingLoc, ExpansionLocStart, ExpansionLocEnd);
            this.SLocEntryLoaded.$set(Index, true);
            return SourceLocation.getRawMacroLoc(LoadedOffset);
        }
        this.LastMacroIDLookup = this.LastMacroIDLookupLocalSLocEntryIndex = this.LocalSLocEntryTable.size();
        this.LastMacroIDLookupLocalOffset = Unsigned.long2uint((long)this.NextLocalOffset);
        this.LocalSLocEntryTable = this.LocalSLocEntryTable.push_back_Expansion(this.NextLocalOffset, SpellingLoc, ExpansionLocStart, ExpansionLocEnd);
        this.updateLocalSLocConstants();
        assert (this.NextLocalOffset + TokLength + 1L > this.NextLocalOffset && this.NextLocalOffset + TokLength + 1L <= this.CurrentLoadedOffset) : "Ran out of source locations!";
        this.NextLocalOffset += TokLength + 1L;
        return SourceLocation.getRawMacroLoc(this.NextLocalOffset - (TokLength + 1L));
    }

    private boolean isOffsetInFileID(int ID2, int SLocOffset) {
        if (ID2 >= -1) {
            if (this.LocalSLocTableIsSliced) {
                return this.isOffsetInFileIDLocalFromSlicedOffsets(ID2, SLocOffset);
            }
            return this.isOffsetInFileIDLocalFromRawOffsets(ID2, SLocOffset);
        }
        assert (ID2 < 0);
        long EntryOffset = this.$getOffset(this.getLoadedSLocEntryByID(ID2));
        if ((long)SLocOffset < EntryOffset) {
            return false;
        }
        if (ID2 == -2) {
            return true;
        }
        int NextID = ID2 + 1;
        assert (NextID < 0);
        return SLocOffset < this.$getOffset(this.getLoadedSLocEntryByID(NextID));
    }

    private boolean isOffsetInFileIDLocalFromRawOffsets(int ID2, int SLocOffset) {
        int EntryOffset;
        assert (ID2 == -1 || ID2 < this.local_sloc_entry_size()) : "Invalid index";
        int n = EntryOffset = ID2 == -1 ? this.LocalSLocEntryTable.offset_$at(0) : this.LocalSLocEntryTable.offset_$at(ID2);
        if (SLocOffset < EntryOffset) {
            return false;
        }
        int NextID = ID2 + 1;
        assert (NextID <= this.local_sloc_entry_size()) : "Invalid index";
        if (NextID == this.local_sloc_entry_size()) {
            return (long)SLocOffset < this.NextLocalOffset;
        }
        return SLocOffset < this.LocalSLocEntryTable.offset_$at(NextID);
    }

    private boolean isOffsetInFileIDLocalFromSlicedOffsets(int ID2, int SLocOffset) {
        int EntryOffset;
        int index;
        int[] offsets;
        int slice;
        assert (this.LocalSLocTableIsSliced);
        assert (ID2 == -1 || ID2 < this.local_sloc_entry_size()) : "Invalid index";
        if (ID2 == this.LastFileIDLookupLocalSLocEntryIndex) {
            slice = this.LastFileIDLookupLocalSlice;
            offsets = this.LastFileIDLookupLocalSliceArray;
            index = this.LastFileIDLookupLocalIndexInSlice;
            EntryOffset = this.LastFileIDLookupLocalOffset;
            assert (EntryOffset == offsets[index]) : EntryOffset + " vs. " + offsets[index];
        } else if (ID2 == this.LastMacroIDLookupLocalSLocEntryIndex) {
            slice = this.LastMacroIDLookupLocalSlice;
            offsets = this.LastMacroIDLookupLocalSliceArray;
            index = this.LastMacroIDLookupLocalIndexInSlice;
            EntryOffset = this.LastMacroIDLookupLocalOffset;
            assert (EntryOffset == SrcMgr.SLocEntry.toOffset(offsets[index])) : EntryOffset + " vs. " + SrcMgr.SLocEntry.toOffset(offsets[index]);
        } else if (ID2 == -1) {
            slice = 0;
            offsets = this.LocalSLocEntryTable.$OffsetsSliceByIndex(0);
            index = 0;
            EntryOffset = 0;
            assert (EntryOffset == SrcMgr.SLocEntry.toOffset(offsets[index]));
        } else {
            slice = ID2 / this.LocalSliceSize;
            index = ID2 & this.LocalSliceMaskForIndex;
            offsets = slice == this.LastFileIDLookupLocalSlice ? this.LastFileIDLookupLocalSliceArray : (slice == this.LastMacroIDLookupLocalSlice ? this.LastMacroIDLookupLocalSliceArray : this.LocalSLocEntryTable.$OffsetsSliceByIndex(slice));
            EntryOffset = SrcMgr.SLocEntry.toOffset(offsets[index]);
        }
        if (SLocOffset < EntryOffset) {
            return false;
        }
        int NextID = ID2 + 1;
        assert (NextID <= this.local_sloc_entry_size()) : "Invalid index";
        if (NextID == this.local_sloc_entry_size()) {
            return (long)SLocOffset < this.NextLocalOffset;
        }
        int nextEntryOffset = ++index < this.LocalSliceSize ? offsets[index] : this.LocalSLocEntryTable.$OffsetsSliceByIndex(slice + 1)[0];
        nextEntryOffset = SrcMgr.SLocEntry.toOffset(nextEntryOffset);
        return SLocOffset < nextEntryOffset;
    }

    private int getPreviousFileID(int FID) {
        if (FileID.isInvalid(FID)) {
            return FileID.getInvalidID();
        }
        int ID2 = FID;
        if (ID2 == -1) {
            return FileID.getInvalidID();
        }
        if (ID2 > 0 ? ID2 - 1 == 0 : -(ID2 - 1) - 2 >= this.LoadedSLocEntryTable.size()) {
            return FileID.getInvalidID();
        }
        return ID2 - 1;
    }

    private int getNextFileID(int FID) {
        if (FileID.isInvalid(FID)) {
            return FileID.getInvalidID();
        }
        int ID2 = FID;
        if (ID2 > 0 ? ID2 + 1 >= this.local_sloc_entry_size() : ID2 + 1 >= -1) {
            return FileID.getInvalidID();
        }
        return ID2 + 1;
    }

    private int createFileID(SrcMgr.ContentCache File2, int IncludePos, SrcMgr.CharacteristicKind FileCharacter, int LoadedID, long LoadedOffset) {
        if (LoadedID < 0) {
            assert (LoadedID != -1) : "Loading sentinel FileID";
            int Index = -LoadedID - 2;
            assert (Index < this.LoadedSLocEntryTable.size()) : "FileID out of range";
            assert (!this.SLocEntryLoaded.$at(Index)) : "FileID already loaded";
            this.LoadedSLocEntryTable.$setFile(Index, LoadedOffset, IncludePos, File2, FileCharacter);
            this.SLocEntryLoaded.$set(Index, true);
            return LoadedID;
        }
        this.LastFileIDLookup = this.LastFileIDLookupLocalSLocEntryIndex = this.LocalSLocEntryTable.size();
        this.LastFileIDLookupLocalOffset = Unsigned.long2uint((long)this.NextLocalOffset);
        this.LocalSLocEntryTable = this.LocalSLocEntryTable.push_back_File(this.NextLocalOffset, IncludePos, File2, FileCharacter);
        long FileSize = File2.getSize();
        assert (this.NextLocalOffset + FileSize + 1L > this.NextLocalOffset && this.NextLocalOffset + FileSize + 1L <= this.CurrentLoadedOffset) : "Ran out of source locations!";
        this.NextLocalOffset += FileSize + 1L;
        this.updateLocalSLocConstants();
        int FID = this.LastFileIDLookup;
        return FID;
    }

    private SrcMgr.ContentCache getOrCreateContentCache(FileEntry FileEnt) {
        return this.getOrCreateContentCache(FileEnt, false);
    }

    private SrcMgr.ContentCache getOrCreateContentCache(FileEntry FileEnt, boolean isSystemFile) {
        DenseMapIterator overI;
        assert (FileEnt != null) : "Didn't specify a file entry to use?";
        assert (this.FileInfos.size() + this.MemBufferInfos.size() == this.AllContentCaches.size()) : this.FileInfos.size() + " + " + this.MemBufferInfos.size() + " vs. " + this.AllContentCaches.size();
        std.pair Entry2 = this.FileInfos.FindAndConstruct((Object)FileEnt);
        if (Entry2.second != null) {
            assert (this.getContentCacheByCacheIndex(((SrcMgr.ContentCache)Entry2.second).$index()) == Entry2.second);
            return (SrcMgr.ContentCache)Entry2.second;
        }
        int NextContentCacheIndex = this.AllContentCaches.size();
        Entry2.second = this.OverriddenFilesInfo.$boolean() ? ((overI = ((OverriddenFilesInfoTy)this.OverriddenFilesInfo.$arrow()).OverriddenFiles.find((Object)FileEnt)).$eq(((OverriddenFilesInfoTy)this.OverriddenFilesInfo.$arrow()).OverriddenFiles.end()) ? new SrcMgr.ContentCache(NextContentCacheIndex, FileEnt) : new SrcMgr.ContentCache(NextContentCacheIndex, this.OverridenFilesKeepOriginalName ? FileEnt : (FileEntry)overI.$star().second, (FileEntry)overI.$star().second)) : new SrcMgr.ContentCache(NextContentCacheIndex, FileEnt);
        this.AllContentCaches.push_back(Entry2.second);
        ((SrcMgr.ContentCache)Entry2.second).IsSystemFile = isSystemFile;
        assert (this.getContentCacheByCacheIndex(((SrcMgr.ContentCache)Entry2.second).$index()) == Entry2.second);
        assert (this.FileInfos.size() + this.MemBufferInfos.size() == this.AllContentCaches.size()) : this.FileInfos.size() + " + " + this.MemBufferInfos.size() + " vs. " + this.AllContentCaches.size();
        return (SrcMgr.ContentCache)Entry2.second;
    }

    private SrcMgr.ContentCache createMemBufferContentCache(std_ptr.unique_ptr<MemoryBuffer> Buffer2) {
        assert (this.FileInfos.size() + this.MemBufferInfos.size() == this.AllContentCaches.size()) : this.FileInfos.size() + " + " + this.MemBufferInfos.size() + " vs. " + this.AllContentCaches.size();
        int NextMemoryBufferContextCacheIndex = this.AllContentCaches.size();
        SrcMgr.ContentCache Entry2 = new SrcMgr.ContentCache(NextMemoryBufferContextCacheIndex);
        this.MemBufferInfos.push_back((Object)Entry2);
        this.AllContentCaches.push_back((Object)Entry2);
        Entry2.setBuffer(Buffer2);
        assert (this.getContentCacheByCacheIndex(Entry2.$index()) == Entry2);
        assert (this.FileInfos.size() + this.MemBufferInfos.size() == this.AllContentCaches.size()) : this.FileInfos.size() + " + " + this.MemBufferInfos.size() + " vs. " + this.AllContentCaches.size();
        return Entry2;
    }

    private int getFileIDSlow(int SLocOffset) {
        if (SLocOffset == 0) {
            return FileID.getInvalidID();
        }
        if ((long)SLocOffset < this.NextLocalOffset) {
            return this.getFileIDLocal(SLocOffset);
        }
        return this.getFileIDLoaded(SLocOffset);
    }

    private int getFileIDLocal(int SLocOffset) {
        if (this.LocalSLocTableIsSliced) {
            return this.getFileIDLocalFromSlicedOffsets(SLocOffset);
        }
        return this.getFileIDLocalFromRawOffsets(SLocOffset);
    }

    private int getFileIDLocalFromRawOffsets(int SLocOffset) {
        int I;
        assert ((long)SLocOffset < this.NextLocalOffset) : "Bad function choice";
        assert (SLocOffset >= 0) : "Must be non negative";
        int SLocTableSize = this.local_sloc_entry_size();
        if (this.LastFileIDLookup < 0 || this.LastFileIDLookupLocalOffset < SLocOffset) {
            if (!USE_LAST_MACRO_ID || this.LastMacroIDLookup < 0 || this.LastMacroIDLookupLocalOffset < SLocOffset) {
                I = SLocTableSize;
            } else {
                assert (this.LastMacroIDLookup == this.LastMacroIDLookupLocalSLocEntryIndex) : this.LastMacroIDLookup + " vs. " + this.LastMacroIDLookupLocalSLocEntryIndex;
                assert (this.LastMacroIDLookupLocalOffset == this.LocalSLocEntryTable.offset_$at(this.LastMacroIDLookupLocalSLocEntryIndex));
                I = this.LastMacroIDLookupLocalSLocEntryIndex;
            }
        } else {
            assert (this.LastFileIDLookup == this.LastFileIDLookupLocalSLocEntryIndex) : this.LastFileIDLookup + " vs " + this.LastFileIDLookupLocalSLocEntryIndex;
            assert (this.LastFileIDLookupLocalOffset == this.LocalSLocEntryTable.offset_$at(this.LastFileIDLookupLocalSLocEntryIndex));
            I = USE_LAST_MACRO_ID && this.LastMacroIDLookupLocalOffset < this.LastFileIDLookupLocalOffset && SLocOffset < this.LastMacroIDLookupLocalOffset ? this.LastMacroIDLookupLocalSLocEntryIndex : this.LastFileIDLookupLocalSLocEntryIndex;
        }
        int NumProbes = 0;
        do {
            int Raw_Offset_at_I;
            int Offset_at_I;
            if ((Offset_at_I = SrcMgr.SLocEntry.toOffset(Raw_Offset_at_I = this.LocalSLocEntryTable.rawOffset_$at(--I))) > SLocOffset) continue;
            int Res = I;
            if (SrcMgr.SLocEntry.isNotExpansion(Raw_Offset_at_I)) {
                this.updateLastIDForFileLookup(true, Res, Offset_at_I, 0, null, I);
                this.NumLinearScans += (long)(NumProbes + 1);
            } else {
                this.updateLastIDForMacroLookup(true, Res, Offset_at_I, 0, null, I);
                this.NumLinearMacroScans += (long)(NumProbes + 1);
            }
            return Res;
        } while (++NumProbes != 8);
        int GreaterIndex = I;
        int LessIndex = 0;
        NumProbes = 0;
        while (true) {
            int MiddleIndex = (GreaterIndex - LessIndex) / 2 + LessIndex;
            int Raw_Offset_at_Mid = this.LocalSLocEntryTable.rawOffset_$at(MiddleIndex);
            int Offset_at_Mid = SrcMgr.SLocEntry.toOffset(Raw_Offset_at_Mid);
            ++NumProbes;
            if (Offset_at_Mid > SLocOffset) {
                GreaterIndex = MiddleIndex;
                continue;
            }
            int FID = MiddleIndex + 1;
            int nextOffset = FID == SLocTableSize ? (int)this.NextLocalOffset : this.LocalSLocEntryTable.offset_$at(FID);
            if (SLocOffset < nextOffset) {
                int Res = MiddleIndex;
                if (SrcMgr.SLocEntry.isNotExpansion(Raw_Offset_at_Mid)) {
                    this.updateLastIDForFileLookup(true, Res, Offset_at_Mid, 0, null, MiddleIndex);
                    this.NumBinaryProbes += (long)NumProbes;
                } else {
                    this.updateLastIDForMacroLookup(true, Res, Offset_at_Mid, 0, null, MiddleIndex);
                    this.NumBinaryMacroProbes += (long)NumProbes;
                }
                return Res;
            }
            LessIndex = MiddleIndex;
        }
    }

    private int getFileIDLocal_UseZeroSlice(int SLocOffset) {
        int I;
        assert ((long)SLocOffset < this.NextLocalOffset) : "Bad function choice";
        assert (SLocOffset >= 0) : "Must be non negative";
        int SLocTableSize = this.local_sloc_entry_size();
        if (this.LastFileIDLookup < 0) {
            I = SLocTableSize;
        } else {
            int offset_$at = this.LocalSLocEntryTable.offset_$at(this.LastFileIDLookup);
            assert (offset_$at != SLocOffset) : "they can not be equal, see getFileID impl";
            I = offset_$at < SLocOffset ? SLocTableSize : this.LastFileIDLookup;
        }
        int[] offsets = this.LocalSLocEntryTable.$OffsetsSliceByIndex(0);
        return this.lookupIndexInOffsetsRangeArrayImpl(SLocOffset, offsets, I, 0, SLocTableSize, 0, true);
    }

    private int getFileIDLocalFromSlicedOffsets(int SLocOffset) {
        int[] $OffsetsSlice;
        int I;
        int Slice_for_I;
        assert (this.LocalSLocTableIsSliced);
        assert ((long)SLocOffset < this.NextLocalOffset) : "Bad function choice";
        assert (SLocOffset >= 0) : "Must be non negative";
        assert (this.LastFileIDLookupLocalSliceArray == this.LocalSLocEntryTable.$OffsetsSliceByIndex(this.LastFileIDLookupLocalSlice));
        assert (this.LastMacroIDLookupLocalSliceArray == this.LocalSLocEntryTable.$OffsetsSliceByIndex(this.LastMacroIDLookupLocalSlice));
        int MaxSlicesIndex = this.LocalMaxSliceIndex;
        assert (this.LocalSLocEntryTable.$OffsetsMaxSliceIndex() == MaxSlicesIndex);
        int sliceSize = this.LocalSliceSize;
        int IndexInSliceMask = this.LocalSliceMaskForIndex;
        assert (this.LastFileIDLookupLocalSliceArray.length == sliceSize);
        int MaxIndex = this.MaxIndexInLastLocalSlice;
        assert (MaxIndex == (this.local_sloc_entry_size - 1 & this.LocalSliceMaskForIndex) + 1);
        if (this.LastFileIDLookup < 0) {
            Slice_for_I = MaxSlicesIndex;
            I = MaxIndex;
            $OffsetsSlice = this.LocalSLocEntryTable.$OffsetsSliceByIndex(Slice_for_I);
        } else {
            assert (this.LastFileIDLookupLocalOffset == this.LastFileIDLookupLocalSliceArray[this.LastFileIDLookupLocalIndexInSlice]);
            assert (this.LastFileIDLookupLocalOffset != SLocOffset) : SLocOffset + " must be checked before getFileIDSlow ";
            assert (this.LastMacroIDLookupLocalOffset != SLocOffset) : SLocOffset + " must be checked before getFileIDSlow ";
            assert (this.LastFileIDLookupLocalOffset == SrcMgr.SLocEntry.toOffset(this.LastFileIDLookupLocalOffset)) : "FileID has te same offset as the raw value";
            if (this.LastFileIDLookupLocalOffset < SLocOffset) {
                if (!USE_LAST_MACRO_ID || this.LastMacroIDLookup < 0 || this.LastMacroIDLookupLocalOffset < SLocOffset) {
                    I = MaxIndex;
                    Slice_for_I = MaxSlicesIndex;
                    $OffsetsSlice = this.LocalSLocEntryTable.$OffsetsSliceByIndex(Slice_for_I);
                } else {
                    Slice_for_I = this.LastMacroIDLookupLocalSlice;
                    I = this.LastMacroIDLookupLocalIndexInSlice;
                    $OffsetsSlice = this.LastMacroIDLookupLocalSliceArray;
                    if (Slice_for_I < MaxSlicesIndex) {
                        MaxIndex = sliceSize;
                    }
                }
            } else {
                if (USE_LAST_MACRO_ID && this.LastMacroIDLookupLocalOffset < this.LastFileIDLookupLocalOffset && SLocOffset < this.LastMacroIDLookupLocalOffset) {
                    Slice_for_I = this.LastMacroIDLookupLocalSlice;
                    I = this.LastMacroIDLookupLocalIndexInSlice;
                    $OffsetsSlice = this.LastMacroIDLookupLocalSliceArray;
                } else {
                    $OffsetsSlice = this.LastFileIDLookupLocalSliceArray;
                    I = this.LastFileIDLookupLocalIndexInSlice;
                    Slice_for_I = this.LastFileIDLookupLocalSlice;
                }
                if (Slice_for_I < MaxSlicesIndex) {
                    MaxIndex = sliceSize;
                }
            }
        }
        int SliceStartAbsoluteIndex = 0;
        assert ((I & IndexInSliceMask) == I || I == sliceSize) : I + " vs " + sliceSize;
        if (Slice_for_I > 0) {
            int NumProbes = 0;
            boolean found = false;
            while (true) {
                if (SrcMgr.SLocEntry.toOffset($OffsetsSlice[0]) <= SLocOffset) {
                    SliceStartAbsoluteIndex = Slice_for_I * sliceSize;
                    if (NumProbes == 0) {
                        ++this.NumImmediateSliceScans;
                    } else {
                        this.NumLinearSliceScans += (long)(NumProbes + 1);
                    }
                    found = true;
                    break;
                }
                if (NumProbes++ == 8) break;
                assert (Slice_for_I > 0);
                assert (Slice_for_I <= MaxSlicesIndex);
                $OffsetsSlice = this.LocalSLocEntryTable.$OffsetsSliceByIndex(--Slice_for_I);
                I = sliceSize;
                MaxIndex = sliceSize;
            }
            if (!found) {
                int GreaterSliceIndex = Slice_for_I;
                int LessSliceIndex = 0;
                NumProbes = 0;
                while (true) {
                    assert (GreaterSliceIndex >= 0);
                    assert (LessSliceIndex >= 0);
                    assert (GreaterSliceIndex >= LessSliceIndex);
                    assert (GreaterSliceIndex < MaxSlicesIndex) : GreaterSliceIndex + " vs. " + MaxSlicesIndex;
                    Slice_for_I = (GreaterSliceIndex - LessSliceIndex) / 2 + LessSliceIndex;
                    $OffsetsSlice = this.LocalSLocEntryTable.$OffsetsSliceByIndex(Slice_for_I);
                    int FirstOffset_At_MidSlice = SrcMgr.SLocEntry.toOffset($OffsetsSlice[0]);
                    ++NumProbes;
                    if (FirstOffset_At_MidSlice > SLocOffset) {
                        GreaterSliceIndex = Slice_for_I;
                        continue;
                    }
                    int NextSlice = Slice_for_I + 1;
                    int nextOffset = NextSlice == MaxSlicesIndex ? (int)this.NextLocalOffset : SrcMgr.SLocEntry.toOffset(this.LocalSLocEntryTable.$OffsetsSliceByIndex(NextSlice)[0]);
                    if (SLocOffset < nextOffset) {
                        SliceStartAbsoluteIndex = Slice_for_I * sliceSize;
                        this.NumBinarySliceProbes += (long)NumProbes;
                        break;
                    }
                    LessSliceIndex = Slice_for_I;
                }
                assert (I == sliceSize) : I + " vs. " + sliceSize;
                assert (MaxIndex == sliceSize) : MaxIndex + " vs. " + sliceSize;
            }
        }
        return this.lookupIndexInOffsetsRangeArrayImpl(SLocOffset, $OffsetsSlice, I, Slice_for_I, MaxIndex, SliceStartAbsoluteIndex, true);
    }

    private int lookupIndexInOffsetsRangeArrayImpl(int SLocOffset, int[] offsets, int I, int Slice_for_I, int MaxIndex, int SliceStartAbsoluteIndex, boolean forLocalTable) {
        assert (SrcMgr.SLocEntry.toOffset(offsets[0]) <= SLocOffset);
        assert (MaxIndex <= offsets.length);
        int NumProbes = 0;
        do {
            int Raw_Offset_at_I;
            int Offset_at_I;
            assert (I > 0);
            assert (I <= MaxIndex);
            if ((Offset_at_I = SrcMgr.SLocEntry.toOffset(Raw_Offset_at_I = offsets[--I])) > SLocOffset) continue;
            int Res = I + SliceStartAbsoluteIndex;
            if (SrcMgr.SLocEntry.isNotExpansion(Raw_Offset_at_I)) {
                this.updateLastIDForFileLookup(forLocalTable, Res, Offset_at_I, Slice_for_I, offsets, I);
                this.NumLinearScans += (long)(NumProbes + 1);
            } else {
                this.updateLastIDForMacroLookup(forLocalTable, Res, Offset_at_I, Slice_for_I, offsets, I);
                this.NumLinearMacroScans += (long)(NumProbes + 1);
            }
            return Res;
        } while (++NumProbes != 8);
        int GreaterIndex = I;
        int LessIndex = 0;
        NumProbes = 0;
        while (true) {
            assert (GreaterIndex >= 0);
            assert (LessIndex >= 0);
            assert (GreaterIndex >= LessIndex);
            assert (GreaterIndex < MaxIndex) : GreaterIndex + " vs. " + MaxIndex;
            int MiddleIndex = (GreaterIndex - LessIndex) / 2 + LessIndex;
            int Raw_Offset_at_Mid = offsets[MiddleIndex];
            int Offset_at_Mid = SrcMgr.SLocEntry.toOffset(Raw_Offset_at_Mid);
            ++NumProbes;
            if (Offset_at_Mid > SLocOffset) {
                GreaterIndex = MiddleIndex;
                continue;
            }
            int FID = MiddleIndex + 1;
            int nextOffset = FID == MaxIndex ? (int)this.NextLocalOffset : SrcMgr.SLocEntry.toOffset(offsets[FID]);
            if (SLocOffset < nextOffset) {
                int Res = MiddleIndex + SliceStartAbsoluteIndex;
                if (SrcMgr.SLocEntry.isNotExpansion(Raw_Offset_at_Mid)) {
                    this.updateLastIDForFileLookup(forLocalTable, Res, Offset_at_Mid, Slice_for_I, offsets, MiddleIndex);
                    this.NumBinaryProbes += (long)NumProbes;
                } else {
                    this.updateLastIDForMacroLookup(forLocalTable, Res, Offset_at_Mid, Slice_for_I, offsets, MiddleIndex);
                    this.NumBinaryMacroProbes += (long)NumProbes;
                }
                return Res;
            }
            LessIndex = MiddleIndex;
        }
    }

    private void updateLastIDForFileLookup(boolean LocalTable, int lastFileID, int lastFileIDOffset, int Slice, int[] sliceArray, int IndexInSlice) {
        this.LastFileIDLookup = lastFileID;
        if (LocalTable) {
            this.LastFileIDLookupLocalSLocEntryIndex = lastFileID;
            this.LastFileIDLookupLocalOffset = lastFileIDOffset;
            this.LastFileIDLookupLocalSlice = Slice;
            this.LastFileIDLookupLocalSliceArray = sliceArray;
            this.LastFileIDLookupLocalIndexInSlice = IndexInSlice;
        } else {
            this.LastFileIDLookupLoadedSlice = Slice;
        }
    }

    private void updateLastIDForMacroLookup(boolean LocalTable, int lastMacroID, int lastMacroIDOffset, int Slice, int[] sliceArray, int IndexInSlice) {
        this.LastMacroIDLookup = lastMacroID;
        if (LocalTable) {
            this.LastMacroIDLookupLocalSLocEntryIndex = lastMacroID;
            this.LastMacroIDLookupLocalOffset = lastMacroIDOffset;
            this.LastMacroIDLookupLocalSlice = Slice;
            this.LastMacroIDLookupLocalSliceArray = sliceArray;
            this.LastMacroIDLookupLocalIndexInSlice = IndexInSlice;
        } else {
            this.LastMacroIDLookupLoadedSlice = Slice;
        }
    }

    private int getFileIDLoaded(int SLocOffset) {
        if ((long)SLocOffset < this.CurrentLoadedOffset) {
            NativeTrace.assertTrueInConsole((boolean)false, (String)"Invalid SLocOffset or bad function choice ", (Object)SLocOffset);
            return FileID.getInvalidID();
        }
        int LastID = this.LastFileIDLookup;
        int I = LastID >= 0 || this.$getOffset(this.getLoadedSLocEntryByID(LastID)) < SLocOffset ? 0 : -LastID - 2 + 1;
        int NumProbes = 0;
        while (NumProbes < 8) {
            int E = this.getLoadedSLocEntry(I);
            int Offset_at_I = this.$getOffset(E);
            if (Offset_at_I <= SLocOffset) {
                int Res = -I - 2;
                if (this.$isFile(E)) {
                    this.updateLastIDForFileLookup(false, Res, Offset_at_I, 0, null, I);
                    this.NumLinearScans += (long)(NumProbes + 1);
                } else {
                    this.updateLastIDForMacroLookup(false, Res, Offset_at_I, 0, null, I);
                    this.NumLinearMacroScans += (long)(NumProbes + 1);
                }
                assert (Res + 2 == E);
                return Res;
            }
            ++NumProbes;
            ++I;
        }
        int GreaterIndex = I;
        int LessIndex = this.LoadedSLocEntryTable.size();
        NumProbes = 0;
        while (true) {
            ++NumProbes;
            int MiddleIndex = (LessIndex - GreaterIndex) / 2 + GreaterIndex;
            int E = this.getLoadedSLocEntry(MiddleIndex);
            int Offset_at_I = this.$getOffset(E);
            if (Offset_at_I == 0) {
                return FileID.getInvalidID();
            }
            ++NumProbes;
            if (Offset_at_I > SLocOffset) {
                if (GreaterIndex == MiddleIndex) {
                    assert (false) : "binary search missed the entry";
                    return FileID.getInvalidID();
                }
                GreaterIndex = MiddleIndex;
                continue;
            }
            int Index = -MiddleIndex - 2;
            if (this.isOffsetInFileID(Index, SLocOffset)) {
                int Res = Index;
                if (this.$isFile(E)) {
                    this.updateLastIDForFileLookup(false, Res, Offset_at_I, 0, null, MiddleIndex);
                    this.NumLinearScans += (long)(NumProbes + 1);
                } else {
                    this.updateLastIDForMacroLookup(false, Res, Offset_at_I, 0, null, MiddleIndex);
                    this.NumLinearMacroScans += (long)(NumProbes + 1);
                }
                assert (Res + 2 == E);
                return Res;
            }
            if (LessIndex == MiddleIndex) {
                assert (false) : "binary search missed the entry";
                return FileID.getInvalidID();
            }
            LessIndex = MiddleIndex;
        }
    }

    private int getExpansionLocSlowCase(int Loc) {
        int ExpInfo;
        while (SourceLocation.isMacroID(Loc = this.$getExpansionLocStart(ExpInfo = this.getExpansionSLocEntryByID_LoadEntryIfAbsent(this.getFileID(Loc))))) {
        }
        return Loc;
    }

    private int getSpellingLocSlowCase(int Loc) {
        int Offs;
        do {
            assert (SourceLocation.isMacroID(Loc)) : "Not a macro " + SourceLocation.getFromRawEncoding(Loc);
            int SLocOffset = SourceLocation.getOffset(Loc);
            assert (!this.isOffsetInFileID(this.LastFileIDLookup, SLocOffset)) : "how macro Loc could it be in file? " + this.LastFileIDLookup + ": " + SourceLocation.getFromRawEncoding(Loc);
            int FID = this.isOffsetInFileID(this.LastMacroIDLookup, SLocOffset) ? this.LastMacroIDLookup : this.getFileIDSlow(SLocOffset);
            int Expansion = this.getSLocEntryByID_LoadEntryIfAbsent(FID);
            assert (Expansion != 0);
            assert (this.$isExpansion(Expansion));
            Offs = SLocOffset - this.$getOffset(Expansion);
            Loc = this.$getSpellingLoc(Expansion);
        } while (SourceLocation.isMacroID(Loc = SourceLocation.getRawLocWithOffset(Loc, Offs)));
        return Loc;
    }

    private int getFileLocSlowCase(int Loc) {
        while (SourceLocation.isMacroID(Loc = this.isMacroArgExpansion(Loc) ? this.getImmediateSpellingLoc(Loc) : std.$first_int((long)this.getImmediateExpansionRange(Loc)))) {
        }
        return Loc;
    }

    private long getDecomposedExpansionLocSlowCase(int E) {
        int Offset;
        int FID = FileID.getInvalidID();
        int Loc = SourceLocation.getInvalid();
        do {
            Loc = this.$getExpansionLocStart(E);
            FID = this.getFileID(Loc);
            E = this.getSLocEntryByID_LoadEntryIfAbsent(FID);
            Offset = SourceLocation.getOffset(Loc) - this.$getOffset(E);
        } while (SourceLocation.isMacroID(Loc));
        return std.wrap_int_uint_pair((int)FID, (int)Offset);
    }

    private long getDecomposedSpellingLocSlowCase(int SLocEntryIndex, int Offset) {
        int FID = FileID.getInvalidID();
        int Loc = SourceLocation.getInvalid();
        do {
            Loc = this.$getSpellingLoc(SLocEntryIndex);
            Loc = SourceLocation.getRawLocWithOffset(Loc, Offset);
            FID = this.getFileID(Loc);
            SLocEntryIndex = this.getSLocEntryByID_LoadEntryIfAbsent(FID);
            Offset = SourceLocation.getOffset(Loc) - this.$getOffset(SLocEntryIndex);
            assert (Offset >= 0);
        } while (!SourceLocation.isFileID(Loc));
        return std.wrap_int_uint_pair((int)FID, (int)Offset);
    }

    private void computeMacroArgsCache(std.mapIntType<SourceLocation> CachePtr, int FID) {
        assert (!FileID.isInvalid(FID));
        assert (CachePtr.empty());
        std.mapIntType<SourceLocation> MacroArgsCache = CachePtr;
        MacroArgsCache.insert(std.make_pair_int_T((int)0, (Object)new SourceLocation()));
        int ID2 = FID;
        while (!(++ID2 > 0 ? ID2 >= this.local_sloc_entry_size() : ID2 == -1)) {
            int SLocEntryIndex = this.getSLocEntryByID_LoadEntryIfAbsent(ID2);
            if (SLocEntryIndex == 0) {
                return;
            }
            if (this.$isFile(SLocEntryIndex)) {
                int IncludeLoc = this.$getIncludeLoc(SLocEntryIndex);
                if (SourceLocation.isInvalid(IncludeLoc)) continue;
                if (!this.isInFileID(IncludeLoc, FID)) {
                    return;
                }
                int NumCreatedFIDs = this.$getNumCreatedFIDs(SLocEntryIndex);
                if (NumCreatedFIDs == 0) continue;
                ID2 += NumCreatedFIDs - 1;
                continue;
            }
            int ExpansionLocStart = this.$getExpansionLocStart(SLocEntryIndex);
            if (SourceLocation.isFileID(ExpansionLocStart) && !this.isInFileID(ExpansionLocStart, FID)) {
                return;
            }
            if (!this.$isMacroArgExpansion(SLocEntryIndex)) continue;
            this.associateFileChunkWithMacroArgExp(MacroArgsCache, FID, this.$getSpellingLoc(SLocEntryIndex), SourceLocation.getRawMacroLoc(this.$getOffset(SLocEntryIndex)), this.getFileIDSize(ID2));
        }
        return;
    }

    private void associateFileChunkWithMacroArgExp(std.mapIntType<SourceLocation> MacroArgsCache, int FID, int SpellLoc, int ExpansionLoc, int ExpansionLength) {
        if (!SourceLocation.isFileID(SpellLoc)) {
            long SpellBeginOffs = SourceLocation.getOffset(SpellLoc);
            long SpellEndOffs = SpellBeginOffs + (long)ExpansionLength;
            long decomposedLoc = this.getDecomposedLoc(SpellLoc);
            int SpellFID = ClangGlobals.$first_FileID(decomposedLoc);
            int SpellRelativeOffs = ClangGlobals.$second_offset(decomposedLoc);
            while (true) {
                int Entry2 = this.getSLocEntryByID_LoadEntryIfAbsent(SpellFID);
                int SpellFIDBeginOffs = this.$getOffset(Entry2);
                int SpellFIDSize = this.getFileIDSize(SpellFID);
                int SpellFIDEndOffs = SpellFIDBeginOffs + SpellFIDSize;
                int Info2 = Entry2;
                if (this.$isMacroArgExpansion(Info2)) {
                    int CurrSpellLength = (long)SpellFIDEndOffs < SpellEndOffs ? SpellFIDSize - SpellRelativeOffs : ExpansionLength;
                    this.associateFileChunkWithMacroArgExp(MacroArgsCache, FID, SourceLocation.getRawLocWithOffset(this.$getSpellingLoc(Info2), SpellRelativeOffs), ExpansionLoc, CurrSpellLength);
                }
                if ((long)SpellFIDEndOffs >= SpellEndOffs) {
                    return;
                }
                long advance = SpellFIDSize - SpellRelativeOffs + 1;
                ExpansionLoc = SourceLocation.getRawLocWithOffset(ExpansionLoc, advance);
                ExpansionLength = (int)((long)ExpansionLength - advance);
                ++SpellFID;
                SpellRelativeOffs = 0;
            }
        }
        assert (SourceLocation.isFileID(SpellLoc));
        int.ptr BeginOffsRef = NativePointer.create_int$ptr();
        if (!this.isInFileID(SpellLoc, FID, BeginOffsRef)) {
            return;
        }
        int BeginOffs = BeginOffsRef.$star();
        int EndOffs = BeginOffs + ExpansionLength;
        StdMapIntType.iterator I = MacroArgsCache.upper_bound(Integer.valueOf(EndOffs));
        I.$preDec();
        SourceLocation EndOffsMappedLoc = (SourceLocation)I.$arrow().second;
        ((SourceLocation)MacroArgsCache.ref$at(Integer.valueOf(BeginOffs)).$deref()).$assign(ExpansionLoc);
        ((SourceLocation)MacroArgsCache.ref$at(Integer.valueOf(EndOffs)).$deref()).$assign(EndOffsMappedLoc);
    }

    public char.ptr.array $CharacterDataPtr() {
        assert (!this.$CharacterDataPtrInUse);
        if (!$assertionsDisabled) {
            this.$CharacterDataPtrInUse = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return this.$CharacterDataPtr;
    }

    public void $releaseCharacterDataPtr(char.ptr.array Ptr) {
        assert (Ptr == this.$CharacterDataPtr);
        assert (this.$CharacterDataPtrInUse);
        if (!$assertionsDisabled) {
            this.$CharacterDataPtrInUse = false;
            if (!false) {
                // empty if block
            }
        }
        NativePointer.clear_char$ptr$array((char.ptr.array)Ptr);
    }

    public int.ptr $getOffsetPtr() {
        assert (!this.$OffsetPtrInUse);
        if (!$assertionsDisabled) {
            this.$OffsetPtrInUse = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return this.$OffsetPtr;
    }

    public void $releaseOffsetPtr(int.ptr Ptr) {
        assert (Ptr == this.$OffsetPtr);
        assert (this.$OffsetPtrInUse);
        if (!$assertionsDisabled) {
            this.$OffsetPtrInUse = false;
            if (!false) {
                // empty if block
            }
        }
    }

    public static class MemoryBufferSizes {
        public long malloc_bytes;
        public long mmap_bytes;

        public MemoryBufferSizes(long malloc_bytes, long mmap_bytes) {
            this.malloc_bytes = malloc_bytes;
            this.mmap_bytes = mmap_bytes;
        }

        public MemoryBufferSizes(MemoryBufferSizes $Prm0) {
            this.malloc_bytes = $Prm0.malloc_bytes;
            this.mmap_bytes = $Prm0.mmap_bytes;
        }
    }

    public static final class Unnamed_enum
    extends Enum<Unnamed_enum> {
        public static final /* enum */ Unnamed_enum MagicCacheSize = new Unnamed_enum(300);
        private final int value;
        private static final /* synthetic */ Unnamed_enum[] $VALUES;

        public static Unnamed_enum[] values() {
            return (Unnamed_enum[])$VALUES.clone();
        }

        public static Unnamed_enum valueOf(String name) {
            return Enum.valueOf(Unnamed_enum.class, name);
        }

        public static Unnamed_enum valueOf(int val) {
            Unnamed_enum out;
            Unnamed_enum unnamed_enum = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private Unnamed_enum(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new Unnamed_enum[]{MagicCacheSize};
        }

        private static final class Values {
            private static final Unnamed_enum[] VALUES;
            private static final Unnamed_enum[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (Unnamed_enum kind : Unnamed_enum.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new Unnamed_enum[min < 0 ? 1 - min : 0];
                VALUES = new Unnamed_enum[max >= 0 ? 1 + max : 0];
                for (Unnamed_enum kind : Unnamed_enum.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((Unnamed_enum)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((Unnamed_enum)kind).value] = kind;
                }
            }
        }
    }

    public final class InBeforeInTUCache
    extends DenseMap<IsBeforeInTUCacheKey, InBeforeInTUCacheEntry> {
        public InBeforeInTUCache() {
            super((DenseMapInfo)new DenseMapInfoIsBeforeInTUCacheKey(), (Object)new InBeforeInTUCacheEntry());
        }
    }

    private static final class DenseMapInfoIsBeforeInTUCacheKey
    implements DenseMapInfo<IsBeforeInTUCacheKey> {
        private final DenseMapInfoIntIntPair delegate = new DenseMapInfoIntIntPair((DenseMapInfoInt)new DenseMapInfoIntFileID(), (DenseMapInfoInt)new DenseMapInfoIntFileID());
        private static final IsBeforeInTUCacheKey emptyKey = new IsBeforeInTUCacheKey();
        private static final IsBeforeInTUCacheKey tombstoneKey = new IsBeforeInTUCacheKey();

        private DenseMapInfoIsBeforeInTUCacheKey() {
        }

        public IsBeforeInTUCacheKey getEmptyKey() {
            return emptyKey;
        }

        public IsBeforeInTUCacheKey getTombstoneKey() {
            return tombstoneKey;
        }

        public long getHashValue(Object Val) {
            if (Val == emptyKey) {
                return -1L;
            }
            if (Val == tombstoneKey) {
                return -2L;
            }
            return this.delegate.getHashValue(Val);
        }

        public boolean isEqual(Object LHS, Object RHS) {
            if (LHS == emptyKey || RHS == emptyKey) {
                return LHS == emptyKey && RHS == emptyKey;
            }
            if (LHS == tombstoneKey || RHS == tombstoneKey) {
                return LHS == tombstoneKey && RHS == tombstoneKey;
            }
            return this.delegate.isEqual(LHS, RHS);
        }

        public boolean isKeyPointerLike() {
            return true;
        }
    }

    private static final class IsBeforeInTUCacheKey
    extends std.pairIntInt {
        public IsBeforeInTUCacheKey() {
        }

        private IsBeforeInTUCacheKey(int LFID, int RFID) {
            super(LFID, RFID);
        }

        public std.pairIntInt clone() {
            return new IsBeforeInTUCacheKey(this.first, this.second);
        }
    }

    private static class OverriddenFilesInfoTy
    implements Destructors.ClassWithDestructor {
        public DenseMap<FileEntry, FileEntry> OverriddenFiles = new DenseMap(FileEntry.DenseMapInfo, null);
        public DenseSet<FileEntry> OverriddenFilesWithBuffer = new DenseSet(FileEntry.DenseMapInfo);

        public void $destroy() {
        }
    }
}

