/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic;

import org.clang.basic.CharSourceRange;
import org.clang.basic.Diagnostic;
import org.clang.basic.DiagnosticsEngine;
import org.clang.basic.FixItHint;
import org.clang.basic.FullSourceLoc;
import org.clank.java.std;
import org.clank.java.stdimpl.aliases.StdVector;
import org.clank.support.Destructors;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.support.llvm;

public class StoredDiagnostic
implements Destructors.ClassWithDestructor {
    private int ID;
    private DiagnosticsEngine.Level Level;
    private FullSourceLoc Loc;
    private std.string Message;
    private std.vector<CharSourceRange> Ranges;
    private std.vector<FixItHint> FixIts;

    public StoredDiagnostic() {
        this.Loc = new FullSourceLoc();
        this.Message = new std.string();
        this.Ranges = new std.vector((Object)new CharSourceRange());
        this.FixIts = new std.vector((Object)new FixItHint());
    }

    public StoredDiagnostic(DiagnosticsEngine.Level Level2, Diagnostic Info2) {
        long I;
        this.ID = Info2.getID();
        this.Level = Level2;
        this.Loc = new FullSourceLoc();
        this.Message = new std.string();
        this.Ranges = new std.vector((Object)new CharSourceRange());
        this.FixIts = new std.vector((Object)new FixItHint());
        assert (Info2.getLocation().isInvalid() || Info2.hasSourceManager()) : "Valid source location without setting a source manager for diagnostic";
        if (Info2.getLocation().isValid()) {
            this.Loc.$assign(new FullSourceLoc(Info2.getLocation(), Info2.getSourceManager()));
        }
        SmallString Message = new SmallString(64);
        Info2.FormatDiagnostic(Message);
        this.Message.assign((char.iterator)Message.begin(), (char.iterator)Message.end());
        this.Ranges.reserve(Info2.getNumRanges());
        long N = Info2.getNumRanges();
        for (I = 0L; I != N; ++I) {
            this.Ranges.push_back((Object)Info2.getRange(I));
        }
        this.FixIts.reserve(Info2.getNumFixItHints());
        N = Info2.getNumFixItHints();
        for (I = 0L; I != N; ++I) {
            this.FixIts.push_back((Object)Info2.getFixItHint(I));
        }
    }

    public StoredDiagnostic(DiagnosticsEngine.Level Level2, int ID2, StringRef Message) {
        this.ID = ID2;
        this.Level = Level2;
        this.Loc = new FullSourceLoc();
        this.Message = new std.string(Message.$basic_string());
        this.Ranges = new std.vector((Object)new CharSourceRange());
        this.FixIts = new std.vector((Object)new FixItHint());
    }

    public StoredDiagnostic(DiagnosticsEngine.Level Level2, int ID2, StringRef Message, FullSourceLoc Loc, ArrayRef<CharSourceRange> Ranges, ArrayRef<FixItHint> FixIts) {
        this.ID = ID2;
        this.Level = Level2;
        this.Loc = new FullSourceLoc(Loc);
        this.Message = new std.string(Message.$basic_string());
        this.Ranges = new std.vector((type.iterator)Ranges.begin(), (type.iterator)Ranges.end(), (Object)new CharSourceRange());
        this.FixIts = new std.vector((type.iterator)FixIts.begin(), (type.iterator)FixIts.end(), (Object)new FixItHint());
    }

    public void $destroy() {
    }

    public boolean $boolean() {
        return this.Message.size() > 0;
    }

    public int getID() {
        return this.ID;
    }

    public DiagnosticsEngine.Level getLevel() {
        return this.Level;
    }

    public FullSourceLoc getLocation() {
        return this.Loc;
    }

    public StringRef getMessage() {
        return new StringRef(this.Message);
    }

    public void setLocation(FullSourceLoc Loc) {
        this.Loc.$assign(Loc);
    }

    public StdVector.iterator<CharSourceRange> range_begin() {
        return this.Ranges.begin();
    }

    public StdVector.iterator<CharSourceRange> range_end() {
        return this.Ranges.end();
    }

    public int range_size() {
        return this.Ranges.size();
    }

    public ArrayRef<CharSourceRange> getRanges() {
        return llvm.makeArrayRef(this.Ranges);
    }

    public StdVector.iterator<FixItHint> fixit_begin() {
        return this.FixIts.begin();
    }

    public StdVector.iterator<FixItHint> fixit_end() {
        return this.FixIts.end();
    }

    public int fixit_size() {
        return this.FixIts.size();
    }

    public ArrayRef<FixItHint> getFixIts() {
        return llvm.makeArrayRef(this.FixIts);
    }
}

