/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.tools.JavaFileObject;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.preprocessorbridge.spi.JavaFileFilterImplementation;
import org.netbeans.modules.java.source.parsing.Archive;
import org.netbeans.modules.java.source.util.Iterators;
import org.openide.util.Parameters;

abstract class ProxyArchive
implements Archive {
    private final Archive[] delegates;

    private ProxyArchive(@NonNull Archive[] delegates) {
        Parameters.notNull((CharSequence)"delegates", (Object)delegates);
        this.delegates = delegates;
    }

    public abstract Iterable<JavaFileObject> getFiles(String var1, ClassPath.Entry var2, Set<JavaFileObject.Kind> var3, JavaFileFilterImplementation var4) throws IOException;

    public JavaFileObject getFile(String name) throws IOException {
        for (Archive delegate : this.delegates) {
            JavaFileObject jfo = delegate.getFile(name);
            if (jfo == null) continue;
            return jfo;
        }
        return null;
    }

    public void clear() {
        for (Archive delegate : this.delegates) {
            delegate.clear();
        }
    }

    public JavaFileObject create(String relativeName, JavaFileFilterImplementation filter) throws UnsupportedOperationException {
        for (Archive delegate : this.delegates) {
            try {
                return delegate.create(relativeName, filter);
            }
            catch (UnsupportedOperationException e) {
            }
        }
        throw new UnsupportedOperationException("Create operation s not supported by delegates");
    }

    @NonNull
    static ProxyArchive createComposite(Archive ... delegates) {
        return new Composite(delegates);
    }

    @NonNull
    static ProxyArchive createAdditionalPackages(Archive ... delegates) {
        return new AddPkgs(delegates);
    }

    @NonNull
    private static Archive[] getDelegates(@NonNull ProxyArchive pa) {
        return pa.delegates;
    }

    private static boolean isEmpty(@NonNull Iterable<? extends JavaFileObject> it) {
        if (it instanceof Collection) {
            return ((Collection)it).isEmpty();
        }
        return !it.iterator().hasNext();
    }

    private static final class AddPkgs
    extends ProxyArchive {
        AddPkgs(@NonNull Archive[] delegates) {
            super(delegates);
        }

        @Override
        @NonNull
        public Iterable<JavaFileObject> getFiles(@NonNull String folderName, @NullAllowed ClassPath.Entry entry, @NonNull Set<JavaFileObject.Kind> kinds, @NullAllowed JavaFileFilterImplementation filter) throws IOException {
            for (Archive delegate : ProxyArchive.getDelegates((ProxyArchive)this)) {
                Iterable it = delegate.getFiles(folderName, entry, kinds, filter);
                if (ProxyArchive.isEmpty(it)) continue;
                return it;
            }
            return Collections.emptyList();
        }
    }

    private static final class Composite
    extends ProxyArchive {
        Composite(@NonNull Archive[] delegates) {
            super(delegates);
        }

        @Override
        @NonNull
        public Iterable<JavaFileObject> getFiles(@NonNull String folderName, @NullAllowed ClassPath.Entry entry, @NonNull Set<JavaFileObject.Kind> kinds, @NullAllowed JavaFileFilterImplementation filter) throws IOException {
            ArrayList<Iterable> collector = new ArrayList<Iterable>();
            for (Archive delegate : ProxyArchive.getDelegates((ProxyArchive)this)) {
                Iterable it = delegate.getFiles(folderName, entry, kinds, filter);
                if (ProxyArchive.isEmpty(it)) continue;
                collector.add(it);
            }
            return Iterators.chained(collector);
        }
    }
}

