/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.WeakListeners;

final class ClassLoaderSupport
extends URLClassLoader
implements FileChangeListener,
PropertyChangeListener {
    private static final PermissionCollection allPermission = new Permissions();
    private final ClassPath classPath;
    private final FileChangeListener listener;
    private final PropertyChangeListener propListener;
    private final Object lock = new Object();
    private final Map<FileObject, Boolean> emittedFileObjects = new HashMap<FileObject, Boolean>();
    private boolean detachedFromCp;

    static ClassLoader create(ClassPath cp) {
        return ClassLoaderSupport.create(cp, ClassLoader.getSystemClassLoader());
    }

    static ClassLoader create(ClassPath cp, ClassLoader parentClassLoader) {
        return new ClassLoaderSupport(cp, parentClassLoader);
    }

    private ClassLoaderSupport(ClassPath cp, ClassLoader parentClassLoader) {
        super(ClassLoaderSupport.getRootURLs(cp), parentClassLoader);
        this.classPath = cp;
        this.listener = FileUtil.weakFileChangeListener((FileChangeListener)this, null);
        this.propListener = WeakListeners.propertyChange((PropertyChangeListener)this, null);
        cp.addPropertyChangeListener(this.propListener);
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        String resName;
        FileObject fo;
        Class<?> c = super.findClass(name);
        if (c != null && (fo = this.classPath.findResource(resName = name.replace('.', '/') + ".class")) != null) {
            this.addFileChangeListener(fo);
        }
        return c;
    }

    @Override
    public URL findResource(String name) {
        FileObject fo;
        URL url = super.findResource(name);
        if (url != null && (fo = this.classPath.findResource(name)) != null) {
            this.addFileChangeListener(fo);
        }
        return url;
    }

    @Override
    @NonNull
    protected PermissionCollection getPermissions(CodeSource codesource) {
        return allPermission;
    }

    private void test(FileObject fo) {
        this.classPath.resetClassLoader(this);
        this.removeAllListeners();
    }

    private void reset() {
        this.classPath.resetClassLoader(this);
        this.removeAllListeners();
    }

    private void testRemove(FileObject fo) {
        this.removeFileChangeListener(fo);
    }

    public void fileFolderCreated(FileEvent fe) {
        this.testRemove(fe.getFile());
    }

    public void fileDataCreated(FileEvent fe) {
        this.testRemove(fe.getFile());
    }

    public void fileChanged(FileEvent fe) {
        this.test(fe.getFile());
    }

    public void fileDeleted(FileEvent fe) {
        this.test(fe.getFile());
    }

    public void fileRenamed(FileRenameEvent fe) {
        this.test(fe.getFile());
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
        this.testRemove(fe.getFile());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("roots".equals(evt.getPropertyName())) {
            this.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFileChangeListener(FileObject fo) {
        boolean add;
        Object object = this.lock;
        synchronized (object) {
            if (this.detachedFromCp) {
                return;
            }
            add = this.emittedFileObjects.put(fo, Boolean.FALSE) == null;
        }
        if (add) {
            fo.addFileChangeListener(this.listener);
            object = this.lock;
            synchronized (object) {
                if (!this.detachedFromCp) {
                    assert (this.emittedFileObjects.get(fo) == Boolean.FALSE);
                    this.emittedFileObjects.put(fo, Boolean.TRUE);
                } else {
                    this.emittedFileObjects.remove(fo);
                    add = false;
                }
            }
            if (!add) {
                fo.removeFileChangeListener(this.listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFileChangeListener(FileObject fo) {
        boolean remove;
        Object object = this.lock;
        synchronized (object) {
            remove = this.emittedFileObjects.remove(fo) == Boolean.TRUE;
        }
        if (remove) {
            fo.removeFileChangeListener(this.listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllListeners() {
        Map.Entry[] removeListenerFrom;
        Object object = this.lock;
        synchronized (object) {
            this.detachedFromCp = true;
            if (this.emittedFileObjects.isEmpty()) {
                return;
            }
            removeListenerFrom = this.emittedFileObjects.entrySet().toArray(new Map.Entry[this.emittedFileObjects.size()]);
            this.emittedFileObjects.clear();
        }
        for (Map.Entry e : removeListenerFrom) {
            if (e.getValue() != Boolean.TRUE) continue;
            ((FileObject)e.getKey()).removeFileChangeListener(this.listener);
        }
    }

    @NonNull
    private static URL[] getRootURLs(@NonNull ClassPath cp) {
        List<ClassPath.Entry> entries = cp.entries();
        ArrayDeque<URL> res = new ArrayDeque<URL>(entries.size());
        for (ClassPath.Entry e : entries) {
            res.offer(e.getURL());
        }
        return res.toArray(new URL[res.size()]);
    }

    static {
        allPermission.add(new AllPermission());
        allPermission.setReadOnly();
    }
}

